/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.map.Map;
import org.oscim.renderer.BufferObject;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.NativeBufferPool;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.TextureItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRenderer {
    public static float COORD_SCALE = 0.0f;
    public static final int MAX_INDICES = 3072;
    public static final int MAX_QUADS = 512;
    public static long frametime;
    static final Logger log;
    private static NativeBufferPool mBufferPool;
    private static float[] mClearColor;
    private static int mQuadIndicesID;
    private static int mQuadVerticesID;
    private static boolean rerender;
    private final Map mMap;
    private boolean mNewSurface;
    private final GLViewport mViewport;
    private float viewPortScale = 1.0f;

    static {
        log = LoggerFactory.getLogger(MapRenderer.class);
        COORD_SCALE = 8.0f;
    }

    public MapRenderer(Map map) {
        this.mMap = map;
        this.mViewport = new GLViewport();
        mBufferPool = new NativeBufferPool();
        BufferObject.clear();
        MapRenderer.setBackgroundColor(-12303292);
    }

    public static void animate() {
        rerender = true;
    }

    public static void bindQuadIndicesVBO() {
        GLState.bindElementBuffer(mQuadIndicesID);
    }

    public static void bindQuadVertexVBO(int n) {
        if (n >= 0) {
            GLState.bindVertexBuffer(mQuadVerticesID);
            GLState.enableVertexArrays(n, -1);
            GLAdapter.gl.vertexAttribPointer(n, 2, 5126, false, 0, 0);
        }
    }

    private void draw() {
        GLState.setClearColor(mClearColor);
        GLAdapter.gl.depthMask(true);
        GLAdapter.gl.stencilMask(255);
        GLAdapter.gl.clear(17664);
        LayerRenderer[] layerRendererArray = GLAdapter.gl;
        int n = 0;
        layerRendererArray.depthMask(false);
        GLAdapter.gl.stencilMask(0);
        GLState.test(false, false);
        GLState.blend(false);
        GLState.bindTex2D(-1);
        GLState.useProgram(-1);
        GLState.bindElementBuffer(-1);
        GLState.bindVertexBuffer(-1);
        this.mViewport.setFrom(this.mMap);
        if (this.viewPortScale != 1.0f) {
            layerRendererArray = this.mViewport.mvp;
            float f = this.viewPortScale;
            layerRendererArray.setScale(f, f, 1.0f);
            this.mViewport.viewproj.multiplyLhs(this.mViewport.mvp);
            this.mViewport.proj.multiplyLhs(this.mViewport.mvp);
        }
        layerRendererArray = this.mMap.layers().getLayerRenderer();
        int n2 = layerRendererArray.length;
        while (n < n2) {
            LayerRenderer layerRenderer = layerRendererArray[n];
            if (!layerRenderer.isInitialized) {
                layerRenderer.setup();
                layerRenderer.isInitialized = true;
            }
            layerRenderer.update(this.mViewport);
            if (layerRenderer.isReady) {
                layerRenderer.render(this.mViewport);
            }
            ++n;
        }
        if (GLUtils.checkGlOutOfMemory("finish")) {
            BufferObject.checkBufferUsage(true);
        }
    }

    public static FloatBuffer getFloatBuffer(int n) {
        return mBufferPool.getFloatBuffer(n);
    }

    public static IntBuffer getIntBuffer(int n) {
        return mBufferPool.getIntBuffer(n);
    }

    public static ShortBuffer getShortBuffer(int n) {
        return mBufferPool.getShortBuffer(n);
    }

    public static void setBackgroundColor(int n) {
        mClearColor = GLUtils.colorToFloat(n);
    }

    public void onDrawFrame() {
        frametime = System.currentTimeMillis();
        rerender = false;
        this.mMap.beginFrame();
        this.draw();
        this.mMap.doneFrame(rerender);
        mBufferPool.releaseBuffers();
        TextureItem.disposeTextures();
    }

    public void onSurfaceChanged(int n, int n2) {
        if (n > 0 && n2 > 0) {
            GLAdapter.gl.viewport(0, 0, n, n2);
            GLAdapter.gl.clearStencil(0);
            GLAdapter.gl.disable(2884);
            GLAdapter.gl.blendFunc(1, 771);
            GLAdapter.gl.frontFace(2304);
            GLAdapter.gl.cullFace(1029);
            if (!this.mNewSurface) {
                this.mMap.updateMap(false);
                return;
            }
            this.mNewSurface = false;
            int[] nArray = GLUtils.glGenBuffers(2);
            mQuadIndicesID = nArray[0];
            Object object = new short[3072];
            n2 = 0;
            n = 0;
            while (n2 < 3072) {
                object[n2 + 0] = (short)(n + 0);
                short s = (short)(n + 1);
                object[n2 + 1] = s;
                short s2 = (short)(n + 2);
                object[n2 + 2] = s2;
                object[n2 + 3] = s2;
                object[n2 + 4] = s;
                object[n2 + 5] = (short)(n + 3);
                n2 += 6;
                n += 4;
            }
            ShortBuffer shortBuffer = MapRenderer.getShortBuffer(3072);
            shortBuffer.put((short[])object);
            shortBuffer.flip();
            GLState.bindElementBuffer(mQuadIndicesID);
            GLAdapter.gl.bufferData(34963, 6144, shortBuffer, 35044);
            GLState.bindElementBuffer(0);
            object = MapRenderer.getFloatBuffer(8);
            ((FloatBuffer)object).put(new float[]{-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f});
            ((FloatBuffer)object).flip();
            mQuadVerticesID = n = nArray[1];
            GLState.bindVertexBuffer(n);
            GLAdapter.gl.bufferData(34962, 32, (Buffer)object, 35044);
            GLState.bindVertexBuffer(0);
            GLState.init();
            this.mMap.updateMap(true);
        }
    }

    public void onSurfaceCreated() {
        String string2 = GLAdapter.gl.getString(7936);
        String string3 = GLAdapter.gl.getString(7937);
        String string4 = GLAdapter.gl.getString(7938);
        Logger logger = log;
        logger.debug("{}/{}/{}", string2, string3, string4);
        if (string3 != null && string3.startsWith("Adreno (TM) 3")) {
            logger.debug("==> not using glBufferSubData");
            GLAdapter.NO_BUFFER_SUB_DATA = true;
        }
        GLState.init();
        BufferObject.init(200);
        RenderBuckets.initRenderer();
        this.mNewSurface = true;
    }

    public void setViewPortScale(float f) {
        this.viewPortScale = f;
    }
}

