/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.Pool;

public class NativeBufferPool
extends Pool<BufferItem> {
    private BufferItem mUsedBuffers;

    @Override
    protected BufferItem createItem() {
        return null;
    }

    public BufferItem get(int n) {
        BufferItem bufferItem = (BufferItem)this.mPool;
        if (bufferItem == null) {
            bufferItem = new BufferItem();
        } else {
            this.mPool = bufferItem.next;
            bufferItem.next = null;
        }
        if (bufferItem.size < n) {
            bufferItem.growBuffer(n);
        }
        this.mUsedBuffers = Inlist.push(this.mUsedBuffers, bufferItem);
        return bufferItem;
    }

    public FloatBuffer getFloatBuffer(int n) {
        BufferItem bufferItem = this.get(n * 4);
        if (bufferItem.fBuffer == null) {
            bufferItem.byteBuffer.clear();
            bufferItem.fBuffer = bufferItem.byteBuffer.asFloatBuffer();
        } else {
            bufferItem.fBuffer.clear();
        }
        bufferItem.fBuffer.clear();
        return bufferItem.fBuffer;
    }

    public IntBuffer getIntBuffer(int n) {
        BufferItem bufferItem = this.get(n * 4);
        if (bufferItem.iBuffer == null) {
            bufferItem.byteBuffer.clear();
            bufferItem.iBuffer = bufferItem.byteBuffer.asIntBuffer();
        } else {
            bufferItem.iBuffer.clear();
        }
        return bufferItem.iBuffer;
    }

    public ShortBuffer getShortBuffer(int n) {
        BufferItem bufferItem = this.get(n * 2);
        if (bufferItem.sBuffer == null) {
            bufferItem.byteBuffer.clear();
            bufferItem.sBuffer = bufferItem.byteBuffer.asShortBuffer();
        } else {
            bufferItem.sBuffer.clear();
        }
        return bufferItem.sBuffer;
    }

    public void releaseBuffers() {
        this.mUsedBuffers = this.releaseAll(this.mUsedBuffers);
    }

    static final class BufferItem
    extends Inlist<BufferItem> {
        ByteBuffer byteBuffer;
        FloatBuffer fBuffer;
        IntBuffer iBuffer;
        ShortBuffer sBuffer;
        int size;

        BufferItem() {
        }

        void growBuffer(int n) {
            int n2 = n;
            if (n < 32768) {
                n2 = 32768;
            }
            this.byteBuffer = ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
            this.size = n2;
            this.sBuffer = null;
            this.iBuffer = null;
            this.fBuffer = null;
        }
    }
}

