/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.IntBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffscreenRenderer
extends LayerRenderer {
    static final Logger log = LoggerFactory.getLogger(OffscreenRenderer.class);
    int fb;
    boolean initialized;
    private float[] mClearColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    LayerRenderer mRenderer;
    private Shader mShader;
    public final Mode mode;
    int renderDepth;
    int renderTex;
    int texH = -1;
    int texW = -1;
    private boolean useDepthTexture = false;

    public OffscreenRenderer(Mode mode, LayerRenderer layerRenderer) {
        this.mode = mode;
        if (mode == Mode.SSAO || mode == Mode.SSAO_FXAA) {
            this.useDepthTexture = true;
        }
        this.setRenderer(layerRenderer);
    }

    public void begin() {
        GLAdapter.gl.bindFramebuffer(36160, this.fb);
        GLAdapter.gl.depthMask(true);
        GLAdapter.gl.clear(256);
    }

    public void enable(boolean bl) {
        if (bl) {
            GLAdapter.gl.bindFramebuffer(36160, this.fb);
        } else {
            GLAdapter.gl.bindFramebuffer(36160, 0);
        }
    }

    @Override
    public void render(GLViewport gLViewport) {
        GLAdapter.gl.bindFramebuffer(36160, this.fb);
        GLAdapter.gl.viewport(0, 0, this.texW, this.texH);
        GLAdapter.gl.depthMask(true);
        GLState.setClearColor(this.mClearColor);
        GLAdapter.gl.clear(16640);
        this.mRenderer.render(gLViewport);
        GLAdapter.gl.bindFramebuffer(36160, 0);
        this.mShader.useProgram();
        if (this.useDepthTexture) {
            GLAdapter.gl.activeTexture(33985);
            GLState.bindTex2D(this.renderDepth);
            GLAdapter.gl.uniform1i(this.mShader.uTexDepth, 1);
            GLAdapter.gl.activeTexture(33984);
        }
        GLState.bindTex2D(this.renderTex);
        GLAdapter.gl.uniform1i(this.mShader.uTexColor, 0);
        MapRenderer.bindQuadVertexVBO(this.mShader.aPos);
        GLAdapter.gl.uniform2f(this.mShader.uPixel, (float)(1.0 / (double)this.texW * 0.5), (float)(1.0 / (double)this.texH * 0.5));
        GLState.test(false, false);
        GLState.blend(true);
        GLAdapter.gl.drawArrays(5, 0, 4);
        GLUtils.checkGlError("....");
    }

    public void setRenderer(LayerRenderer layerRenderer) {
        this.mRenderer = layerRenderer;
    }

    @Override
    public boolean setup() {
        this.mRenderer.setup();
        return super.setup();
    }

    protected boolean setupFBO(GLViewport object) {
        int n;
        Comparable<IntBuffer> comparable = MapRenderer.getIntBuffer(1);
        this.texW = (int)((GLViewport)object).getWidth();
        this.texH = (int)((GLViewport)object).getHeight();
        GLAdapter.gl.genFramebuffers(1, (IntBuffer)comparable);
        this.fb = ((IntBuffer)comparable).get(0);
        ((IntBuffer)comparable).clear();
        GLAdapter.gl.genTextures(1, (IntBuffer)comparable);
        this.renderTex = ((IntBuffer)comparable).get(0);
        GLUtils.checkGlError("0");
        GLAdapter.gl.bindFramebuffer(36160, this.fb);
        GLAdapter.gl.bindTexture(3553, this.renderTex);
        GLUtils.setTextureParameter(9729, 9729, 33071, 33071);
        GLAdapter.gl.texImage2D(3553, 0, 6408, this.texW, this.texH, 0, 6408, 5121, null);
        GLAdapter.gl.framebufferTexture2D(36160, 36064, 3553, this.renderTex, 0);
        GLUtils.checkGlError("1");
        if (this.useDepthTexture) {
            ((IntBuffer)comparable).clear();
            GLAdapter.gl.genTextures(1, (IntBuffer)comparable);
            this.renderDepth = ((IntBuffer)comparable).get(0);
            GLAdapter.gl.bindTexture(3553, this.renderDepth);
            GLUtils.setTextureParameter(9728, 9728, 33071, 33071);
            GLAdapter.gl.texImage2D(3553, 0, 6402, this.texW, this.texH, 0, 6402, 5123, null);
            GLAdapter.gl.framebufferTexture2D(36160, 36096, 3553, this.renderDepth, 0);
        } else {
            ((IntBuffer)comparable).clear();
            GLAdapter.gl.genRenderbuffers(1, (IntBuffer)comparable);
            n = ((IntBuffer)comparable).get(0);
            GLAdapter.gl.bindRenderbuffer(36161, n);
            GLAdapter.gl.renderbufferStorage(36161, 33189, this.texW, this.texH);
            GLAdapter.gl.framebufferRenderbuffer(36160, 36096, 36161, n);
        }
        GLUtils.checkGlError("2");
        n = GLAdapter.gl.checkFramebufferStatus(36160);
        GLAdapter.gl.bindFramebuffer(36160, 0);
        GLAdapter.gl.bindTexture(3553, 0);
        if (n != 36053) {
            object = log;
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("invalid framebuffer! ");
            ((StringBuilder)comparable).append(n);
            object.debug(((StringBuilder)comparable).toString());
            return false;
        }
        return true;
    }

    @Override
    public void update(GLViewport gLViewport) {
        if ((float)this.texW != gLViewport.getWidth() || (float)this.texH != gLViewport.getHeight()) {
            this.setupFBO(gLViewport);
            int n = 1.$SwitchMap$org$oscim$renderer$OffscreenRenderer$Mode[this.mode.ordinal()];
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n == 4) {
                            this.mShader = new Shader("post_bypass");
                        }
                    } else {
                        this.mShader = new Shader("post_combined");
                    }
                } else {
                    this.mShader = new Shader("post_ssao");
                }
            } else {
                this.mShader = new Shader("post_fxaa");
            }
        }
        this.mRenderer.update(gLViewport);
        this.setReady(this.mRenderer.isReady());
    }

    public static final class Mode
    extends Enum<Mode> {
        private static final /* synthetic */ Mode[] $VALUES;
        public static final /* enum */ Mode BYPASS;
        public static final /* enum */ Mode FXAA;
        public static final /* enum */ Mode SSAO;
        public static final /* enum */ Mode SSAO_FXAA;

        static {
            Mode mode;
            Mode mode2;
            Mode mode3;
            Mode mode4;
            FXAA = mode4 = new Mode();
            SSAO = mode3 = new Mode();
            SSAO_FXAA = mode2 = new Mode();
            BYPASS = mode = new Mode();
            $VALUES = new Mode[]{mode4, mode3, mode2, mode};
        }

        public static Mode valueOf(String string2) {
            return Enum.valueOf(Mode.class, string2);
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }
    }

    static class Shader
    extends GLShader {
        int aPos;
        int uPixel;
        int uTexColor;
        int uTexDepth;

        Shader(String string2) {
            if (!this.create(string2)) {
                return;
            }
            this.aPos = this.getAttrib("a_pos");
            this.uTexColor = this.getUniform("u_texColor");
            this.uTexDepth = this.getUniform("u_tex");
            this.uPixel = this.getUniform("u_pixel");
        }
    }
}

