/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.atlas;

import java.util.HashMap;
import java.util.Map;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextureAtlas
extends Inlist<TextureAtlas> {
    static final Logger log = LoggerFactory.getLogger(TextureAtlas.class);
    final int mHeight;
    private Rect mRects;
    private HashMap<Object, TextureRegion> mRegions;
    public Slot mSlots;
    int mUsed;
    final int mWidth;
    public TextureItem texture;

    public TextureAtlas(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mSlots = new Slot(1, 1, n - 2);
    }

    public TextureAtlas(Bitmap object) {
        this.texture = object = new TextureItem((Bitmap)object);
        this.mWidth = ((TextureItem)object).width;
        this.mHeight = this.texture.height;
        this.mRegions = new HashMap();
    }

    public static TextureAtlas create(int n, int n2, int n3) {
        if (n3 != 1 && n3 != 3 && n3 != 4) {
            throw new IllegalArgumentException("invalid depth");
        }
        return new TextureAtlas(n, n2);
    }

    public void addTextureRegion(Object object, Rect rect) {
        this.mRegions.put(object, new TextureRegion(this.texture, rect));
    }

    public void clear() {
        this.mRects = null;
        this.mSlots = new Slot(1, 1, this.mWidth - 2);
    }

    public Rect getRegion(int n, int n2) {
        int n3;
        Rect rect = new Rect(0, 0, n, n2);
        Slot slot = this.mSlots;
        int n4 = Integer.MAX_VALUE;
        Slot slot2 = null;
        int n5 = Integer.MAX_VALUE;
        while (slot != null) {
            Slot slot3;
            int n6;
            block12: {
                int n7;
                int n8;
                block14: {
                    block13: {
                        block11: {
                            if (slot.x + n <= this.mWidth - 1) break block11;
                            n6 = n4;
                            n3 = n5;
                            slot3 = slot2;
                            break block12;
                        }
                        n3 = slot.y;
                        n6 = n;
                        slot3 = slot;
                        while (true) {
                            n8 = n3;
                            if (n6 <= 0) break;
                            n8 = n3;
                            if (slot3.y > n3) {
                                n8 = slot3.y;
                            }
                            if (n8 + n2 > this.mHeight - 1) {
                                n8 = -1;
                                break;
                            }
                            n6 -= slot3.w;
                            slot3 = (Slot)slot3.next;
                            n3 = n8;
                        }
                        if (n8 >= 0) break block13;
                        n6 = n4;
                        n3 = n5;
                        slot3 = slot2;
                        break block12;
                    }
                    n7 = n8 + n2;
                    if (n7 < n4) break block14;
                    n6 = n4;
                    n3 = n5;
                    slot3 = slot2;
                    if (n7 != n4) break block12;
                    n6 = n4;
                    n3 = n5;
                    slot3 = slot2;
                    if (slot.w >= n5) break block12;
                }
                n3 = slot.w;
                rect.x = slot.x;
                rect.y = n8;
                slot3 = slot;
                n6 = n7;
            }
            slot = (Slot)slot.next;
            n4 = n6;
            n5 = n3;
            slot2 = slot3;
        }
        if (slot2 == null) {
            return null;
        }
        slot = new Slot(rect.x, rect.y + n2, n);
        this.mSlots = Inlist.prependRelative(this.mSlots, slot, slot2);
        while (slot.next != null) {
            slot2 = (Slot)slot.next;
            n3 = slot.x + slot.w - slot2.x;
            if (n3 <= 0) break;
            slot2.x += n3;
            slot2.w -= n3;
            if (slot2.w > 0) break;
            slot.next = slot2.next;
        }
        slot = this.mSlots;
        while (slot.next != null) {
            slot2 = (Slot)slot.next;
            if (slot.y == slot2.y) {
                slot.w += slot2.w;
                slot.next = slot2.next;
                continue;
            }
            slot = slot2;
        }
        this.mUsed += n * n2;
        this.mRects = Inlist.push(this.mRects, rect);
        return rect;
    }

    public Map<Object, TextureRegion> getRegions() {
        return this.mRegions;
    }

    public TextureRegion getTextureRegion(Object object) {
        return this.mRegions.get(object);
    }

    public static class Rect
    extends Inlist<Rect> {
        public int h;
        public int w;
        public int x;
        public int y;

        public Rect(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.x);
            stringBuilder.append(":");
            stringBuilder.append(this.y);
            stringBuilder.append(" ");
            stringBuilder.append(this.w);
            stringBuilder.append("x");
            stringBuilder.append(this.h);
            return stringBuilder.toString();
        }
    }

    public static class Slot
    extends Inlist<Slot> {
        public int w;
        public int x;
        public int y;

        public Slot(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.w = n3;
        }
    }
}

