/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.renderer.bucket.TextureItem;

public class BitmapBucket
extends TextureBucket {
    private Bitmap mBitmap;
    private int mHeight;
    private final boolean mReuseBitmap;
    private final short[] mVertices;
    private int mWidth;

    public BitmapBucket(boolean bl) {
        super((byte)7);
        this.mReuseBitmap = bl;
        this.mVertices = new short[24];
        this.numVertices = 4;
    }

    private void setVertices(ShortBuffer shortBuffer) {
        short[] sArray = this.mVertices;
        short s = (short)((float)this.mWidth * MapRenderer.COORD_SCALE);
        short s2 = (short)((float)this.mHeight * MapRenderer.COORD_SCALE);
        sArray[0] = (short)0;
        sArray[1] = (short)0;
        sArray[2] = (short)-1;
        sArray[3] = (short)-1;
        sArray[4] = (short)0;
        sArray[5] = (short)0;
        sArray[6] = (short)0;
        sArray[7] = s2;
        sArray[8] = (short)-1;
        sArray[9] = (short)-1;
        sArray[10] = (short)0;
        sArray[11] = (short)1;
        sArray[12] = s;
        sArray[13] = (short)0;
        sArray[14] = (short)-1;
        sArray[15] = (short)-1;
        sArray[16] = (short)1;
        sArray[17] = (short)0;
        sArray[18] = s;
        sArray[19] = s2;
        sArray[20] = (short)-1;
        sArray[21] = (short)-1;
        sArray[22] = (short)1;
        sArray[23] = (short)1;
        this.vertexOffset = shortBuffer.position() * 2;
        shortBuffer.put(sArray);
    }

    @Override
    protected void clear() {
        super.clear();
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            return;
        }
        if (!this.mReuseBitmap) {
            bitmap.recycle();
        }
        this.mBitmap = null;
    }

    @Override
    protected void compile(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        if (this.mBitmap == null) {
            return;
        }
        this.setVertices(shortBuffer);
        this.textures.upload();
        if (!this.mReuseBitmap) {
            this.mBitmap.recycle();
            this.mBitmap = null;
            this.textures.bitmap = null;
        }
    }

    public void setBitmap(Bitmap bitmap, int n, int n2) {
        this.setBitmap(bitmap, n, n2, null);
    }

    public void setBitmap(Bitmap bitmap, int n, int n2, TextureItem.TexturePool texturePool) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mBitmap = bitmap;
        if (this.textures == null) {
            this.textures = texturePool == null ? new TextureItem(this.mBitmap) : texturePool.get(this.mBitmap);
        }
        this.textures.indices = 6;
    }

    public static final class Renderer {
        public static final int INDICES_PER_SPRITE = 6;
        static final int SHORTS_PER_VERTICE = 6;
        static final int VERTICES_PER_SPRITE = 4;
        static Shader shader;

        public static RenderBucket draw(RenderBucket renderBucket, GLViewport object, float f, float f2) {
            GLState.blend(true);
            Shader shader = Renderer.shader;
            shader.useProgram();
            TextureBucket textureBucket = (TextureBucket)renderBucket;
            GLAdapter.gl.uniform1f(shader.uAlpha, f2);
            ((GLViewport)object).mvp.setAsUniform(shader.uMVP);
            MapRenderer.bindQuadIndicesVBO();
            object = textureBucket.textures;
            while (object != null) {
                ((TextureItem)object).bind();
                for (int i = 0; i < ((TextureItem)object).indices; i += 3072) {
                    int n;
                    int n2 = (((TextureItem)object).offset + i) * 8 + textureBucket.vertexOffset;
                    GLAdapter.gl.vertexAttribPointer(shader.aPos, 2, 5122, false, 12, n2);
                    GLAdapter.gl.vertexAttribPointer(shader.aTexCoord, 2, 5122, false, 12, n2 + 8);
                    n2 = n = ((TextureItem)object).indices - i;
                    if (n > 3072) {
                        n2 = 3072;
                    }
                    GLAdapter.gl.drawElements(4, n2, 5123, 0);
                }
                object = (TextureItem)((TextureItem)object).next;
            }
            return (RenderBucket)renderBucket.next;
        }

        static void init() {
            shader = new Shader("texture_alpha");
        }
    }

    static class Shader
    extends GLShader {
        int aPos;
        int aTexCoord;
        int uAlpha;
        int uMVP;

        Shader(String string2) {
            if (!this.create(string2)) {
                return;
            }
            this.uMVP = this.getUniform("u_mvp");
            this.uAlpha = this.getUniform("u_alpha");
            this.aPos = this.getAttrib("vertex");
            this.aTexCoord = this.getAttrib("tex_coord");
        }

        @Override
        public boolean useProgram() {
            if (super.useProgram()) {
                GLState.enableVertexArrays(this.aPos, this.aTexCoord);
                return true;
            }
            return false;
        }
    }
}

