/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.backend.GLAdapter;
import org.oscim.core.GeometryBuffer;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.theme.styles.CircleStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircleBucket
extends RenderBucket {
    private static final Logger log = LoggerFactory.getLogger(CircleBucket.class);
    public CircleStyle circle;

    public CircleBucket(int n) {
        super((byte)8, true, GLAdapter.CIRCLE_QUADS);
        this.level = n;
    }

    public void addCircle(GeometryBuffer object) {
        if (!((GeometryBuffer)object).isPoint()) {
            log.error("Circle style applied to non-point geometry");
            return;
        }
        float f = ((GeometryBuffer)object).getPointX(0);
        float f2 = ((GeometryBuffer)object).getPointY(0);
        if (GLAdapter.CIRCLE_QUADS) {
            this.vertexItems.add((short)((this.circle.radius + f) * MapRenderer.COORD_SCALE), (short)((f2 - this.circle.radius) * MapRenderer.COORD_SCALE));
            int n = this.numVertices;
            this.numVertices = n + 1;
            this.vertexItems.add((short)((f - this.circle.radius) * MapRenderer.COORD_SCALE), (short)((f2 - this.circle.radius) * MapRenderer.COORD_SCALE));
            int n2 = this.numVertices;
            this.numVertices = n2 + 1;
            this.vertexItems.add((short)((f - this.circle.radius) * MapRenderer.COORD_SCALE), (short)((this.circle.radius + f2) * MapRenderer.COORD_SCALE));
            int n3 = this.numVertices;
            this.numVertices = n3 + 1;
            this.vertexItems.add((short)((f + this.circle.radius) * MapRenderer.COORD_SCALE), (short)((f2 + this.circle.radius) * MapRenderer.COORD_SCALE));
            int n4 = this.numVertices;
            this.numVertices = n4 + 1;
            object = this.indiceItems;
            short s = (short)n;
            ((VertexData)object).add(s);
            ++this.numIndices;
            this.indiceItems.add((short)n2);
            ++this.numIndices;
            object = this.indiceItems;
            short s2 = (short)n3;
            ((VertexData)object).add(s2);
            ++this.numIndices;
            this.indiceItems.add(s2);
            ++this.numIndices;
            this.indiceItems.add((short)n4);
            ++this.numIndices;
            this.indiceItems.add(s);
            ++this.numIndices;
        } else {
            this.vertexItems.add((short)(f * MapRenderer.COORD_SCALE), (short)(f2 * MapRenderer.COORD_SCALE));
            object = this.indiceItems;
            int n = this.numVertices;
            this.numVertices = n + 1;
            ((VertexData)object).add((short)n);
            ++this.numIndices;
        }
    }

    public static class Renderer {
        static Shader shader;

        public static RenderBucket draw(RenderBucket renderBucket, GLViewport object) {
            GLState.blend(true);
            Shader shader = Renderer.shader;
            shader.set((GLViewport)object);
            while (renderBucket != null && renderBucket.type == 8) {
                object = (CircleBucket)renderBucket;
                CircleStyle circleStyle = ((CircleBucket)object).circle.current();
                GLUtils.setColor(shader.uFill, circleStyle.fillColor, 1.0f);
                GLAdapter.gl.uniform1f(shader.uRadius, circleStyle.radius);
                GLUtils.setColor(shader.uStroke, circleStyle.strokeColor, 1.0f);
                GLAdapter.gl.uniform1f(shader.uWidth, circleStyle.strokeWidth);
                GLAdapter.gl.vertexAttribPointer(shader.aPos, 2, 5122, false, 0, ((CircleBucket)object).vertexOffset);
                if (GLAdapter.CIRCLE_QUADS) {
                    GLAdapter.gl.drawElements(4, ((CircleBucket)object).numIndices, 5123, ((CircleBucket)object).indiceOffset);
                } else {
                    GLAdapter.gl.drawElements(0, ((CircleBucket)object).numIndices, 5123, ((CircleBucket)object).indiceOffset);
                }
                renderBucket = (RenderBucket)renderBucket.next;
            }
            return renderBucket;
        }

        static boolean init() {
            String string2 = GLAdapter.CIRCLE_QUADS ? "circle_quad" : "circle_point";
            shader = new Shader(string2);
            return true;
        }

        public static class Shader
        extends GLShader {
            int aPos;
            int uFill;
            int uMVP;
            int uRadius;
            int uStroke;
            int uWidth;

            Shader(String string2) {
                String string3;
                if (!GLAdapter.CIRCLE_QUADS && !GLAdapter.GDX_WEBGL_QUIRKS) {
                    GLAdapter.gl.enable(34370);
                }
                String string4 = string3 = null;
                if (!GLAdapter.CIRCLE_QUADS) {
                    string4 = string3;
                    if (GLAdapter.GDX_DESKTOP_QUIRKS) {
                        string4 = "120";
                    }
                }
                if (!this.createVersioned(string2, string4)) {
                    return;
                }
                this.uMVP = this.getUniform("u_mvp");
                this.uFill = this.getUniform("u_fill");
                this.uRadius = this.getUniform("u_radius");
                this.uStroke = this.getUniform("u_stroke");
                this.uWidth = this.getUniform("u_width");
                this.aPos = this.getAttrib("a_pos");
            }

            public void set(GLViewport gLViewport) {
                this.useProgram();
                GLState.enableVertexArrays(this.aPos, -1);
                gLViewport.mvp.setAsUniform(this.uMVP);
            }
        }
    }
}

