/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.backend.canvas.Color;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.Tile;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.utils.FastMath;
import org.oscim.utils.KeyMap;
import org.oscim.utils.Tessellator;
import org.oscim.utils.geom.LineClipper;
import org.oscim.utils.pool.Pool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtrusionBucket
extends RenderBucket {
    private static final int IND_MESH = 4;
    private static final int IND_OUTLINE = 3;
    private static final int IND_ROOF = 2;
    static final Logger log = LoggerFactory.getLogger(ExtrusionBucket.class);
    static Pool<KeyMap<Vertex>> vertexMapPool;
    static Pool<Vertex> vertexPool;
    private final int color;
    private final float[] colors;
    public int[] idx;
    private LineClipper mClipper;
    private final float mGroundResolution;
    private VertexData[] mIndices;
    private KeyMap<Vertex> mVertexMap;
    public int[] off;

    static {
        vertexPool = new Pool<Vertex>(){

            @Override
            protected Vertex createItem() {
                return new Vertex();
            }
        };
        vertexMapPool = new Pool<KeyMap<Vertex>>(){

            @Override
            protected KeyMap<Vertex> createItem() {
                return new KeyMap<Vertex>(2048);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtrusionBucket(int n, float f, int n2) {
        super((byte)4, true, false);
        this.idx = new int[]{0, 0, 0, 0, 0};
        this.off = new int[]{0, 0, 0, 0, 0};
        this.level = n;
        this.color = n2;
        float f2 = Color.aToFloat(n2);
        Object[] objectArray = new float[4];
        this.colors = objectArray;
        objectArray[0] = Color.rToFloat(n2) * f2;
        objectArray[1] = Color.gToFloat(n2) * f2;
        objectArray[2] = Color.bToFloat(n2) * f2;
        objectArray[3] = f2;
        this.mGroundResolution = f;
        objectArray = new VertexData[5];
        this.mIndices = (VertexData[])objectArray;
        objectArray[4] = (float)new VertexData();
        Pool<Vertex> pool = vertexPool;
        synchronized (pool) {
            this.mVertexMap = vertexMapPool.get();
            return;
        }
    }

    public ExtrusionBucket(int n, float f, float[] fArray) {
        int n2 = 0;
        super((byte)4, true, false);
        this.idx = new int[]{0, 0, 0, 0, 0};
        this.off = new int[]{0, 0, 0, 0, 0};
        this.level = n;
        this.colors = fArray;
        this.color = 0;
        this.mGroundResolution = f;
        this.mIndices = new VertexData[5];
        for (n = n2; n <= 4; ++n) {
            this.mIndices[n] = new VertexData();
        }
        this.mClipper = new LineClipper(0.0f, 0.0f, Tile.SIZE, Tile.SIZE);
    }

    private void addMeshIndex(Vertex vertex, boolean bl) {
        if (bl) {
            this.vertexItems.add(vertex.x, vertex.y, vertex.z, vertex.n);
        }
        this.mIndices[4].add((short)vertex.id);
        ++this.numIndices;
    }

    private void addRoof(int n, GeometryBuffer object, int n2, int n3) {
        int[] nArray = ((GeometryBuffer)object).index;
        object = ((GeometryBuffer)object).points;
        int n4 = nArray.length;
        int n5 = 0;
        int n6 = 0;
        for (int i = n2; i < n4 && nArray[i] > 0; ++i) {
            n5 += nArray[i];
            ++n6;
        }
        this.numIndices += Tessellator.tessellate((float[])object, n3, n5, nArray, n2, n6, n + 1, this.mIndices[2]);
    }

    private void addRoofSimple(int n, int n2) {
        short s = (short)(n + 1);
        VertexData vertexData = this.mIndices[2];
        n2 -= 4;
        for (n = 0; n < n2; n += 2) {
            int n3 = s + n;
            vertexData.add(s, (short)(n3 + 2), (short)(n3 + 4));
        }
        this.numIndices += n2 / 2 * 3;
    }

    private boolean extrudeOutline(float[] fArray, int n, int s, float f, float f2, boolean bl) {
        short s2 = s;
        short s3 = s2 % 4 != 0 ? (short)1 : 0;
        short s4 = s3 != 0 ? (short)2 : 0;
        int n2 = s4 + s2;
        s4 = n + s2;
        float f3 = fArray[s4 - 2];
        float f4 = fArray[s4 - 1];
        int n3 = n + 0;
        float f5 = fArray[n3];
        int n4 = n + 1;
        float f6 = fArray[n4];
        f3 = f5 - f3;
        f4 = f6 - f4;
        short s5 = (short)((f3 / (float)Math.sqrt(f3 * f3 + f4 * f4) + 1.0f) * 127.0f);
        short s6 = (short)f2;
        short s7 = (short)f;
        int n5 = this.numVertices;
        LineClipper lineClipper = this.mClipper;
        f = (int)f5;
        lineClipper.clipStart(f, (int)f6);
        short s8 = n2 + 2;
        short s9 = s5;
        short s10 = 0;
        short s11 = 0;
        short s12 = 0;
        s4 = 0;
        short s13 = s3;
        short s14 = s2;
        for (short i = 2; i < s8; i += 2) {
            short s15;
            block21: {
                block20: {
                    block19: {
                        if (i >= s14) break block19;
                        s3 = n + i;
                        f2 = fArray[s3 + 0];
                        f = fArray[s3 + 1];
                        break block20;
                    }
                    if (i != s14) break block21;
                    f2 = fArray[n3];
                    f = fArray[n4];
                }
                float f7 = f2 - f5;
                float f8 = f - f6;
                short s16 = (short)((f7 / (float)Math.sqrt(f7 * f7 + f8 * f8) + 1.0f) * 127.0f);
                s3 = s11 == 0 ? s9 | s16 << 8 : s9 << 8 | s16;
                s15 = s3;
                this.vertexItems.add((short)(f5 * MapRenderer.COORD_SCALE), (short)(f6 * MapRenderer.COORD_SCALE), s7, s15);
                this.vertexItems.add((short)(f5 * MapRenderer.COORD_SCALE), (short)(f6 * MapRenderer.COORD_SCALE), s6, s15);
                if (bl) {
                    s2 = f3 < 0.0f ? (short)1 : -1;
                    s9 = f7 < 0.0f ? (short)1 : -1;
                    s3 = s12;
                    if (s2 != s9) {
                        s3 = s12 + 1;
                    }
                    s12 = f4 < 0.0f ? (short)1 : -1;
                    s9 = f8 < 0.0f ? (short)1 : -1;
                    s2 = s4;
                    if (s12 != s9) {
                        s2 = s4 + 1;
                    }
                    if (s3 > 2 || s2 > 2) {
                        bl = false;
                    }
                    if ((f4 = f3 * f8 - f4 * f8) > 0.0f) {
                        if (s10 == -1) {
                            bl = false;
                        }
                        s4 = 1;
                    } else if (f4 < 0.0f) {
                        if (s10 == 1) {
                            bl = false;
                        }
                        s4 = -1;
                    } else {
                        s4 = s10;
                    }
                } else {
                    s2 = s4;
                    s3 = s12;
                    s4 = s10;
                }
                if (this.mClipper.clipNext((int)f2, (int)f) == 0) {
                    s12 = (s11 + 1) % 2;
                } else {
                    short s17 = (short)(i - 2 + n5);
                    short s18 = (short)(s17 + 1);
                    s9 = (short)(s18 + 1);
                    s10 = (short)(s9 + 1);
                    s12 = s;
                    short s19 = s9;
                    s15 = s10;
                    if (s13 == 0) {
                        s19 = s9;
                        s15 = s10;
                        if (i == s12) {
                            s9 = (short)(s9 - s12);
                            s15 = s12 = (short)((short)(s10 - s12));
                            s19 = s9;
                        }
                    }
                    this.mIndices[s11].add(s17, s19, s18);
                    this.mIndices[s11].add(s18, s19, s15);
                    this.numIndices += 6;
                    s12 = (s11 + 1) % 2;
                    this.mIndices[3].add(s18, s15);
                    this.numIndices += 2;
                }
                s14 = s;
                f3 = f7;
                f4 = f8;
                s9 = s16;
                s10 = s4;
                f5 = f2;
                f6 = f;
                s11 = s12;
                s12 = s3;
                s4 = s2;
                continue;
            }
            s15 = (short)(s9 | s5 << 8);
            this.vertexItems.add((short)(MapRenderer.COORD_SCALE * f5), (short)(MapRenderer.COORD_SCALE * f6), s7, s15);
            this.vertexItems.add((short)(f5 * MapRenderer.COORD_SCALE), (short)(f6 * MapRenderer.COORD_SCALE), s6, s15);
            break;
        }
        this.numVertices += n2;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addMesh(GeometryBuffer object) {
        if (!((GeometryBuffer)object).isTris()) {
            return;
        }
        int[] nArray = ((GeometryBuffer)object).index;
        float[] fArray = ((GeometryBuffer)object).points;
        int n = this.numVertices;
        Pool<Vertex> pool = vertexPool;
        // MONITORENTER : pool
        object = vertexPool.get();
        double d = MapRenderer.COORD_SCALE * (float)Tile.SIZE / 4096.0f;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2 && nArray[n3] >= 0 && n < 65536) {
            int n4 = n3 + 1;
            n3 = nArray[n3] * 3;
            int n5 = n4 + 1;
            int n6 = nArray[n4] * 3;
            n4 = nArray[n5] * 3;
            float f = fArray[n3 + 0];
            float f2 = fArray[n3 + 1];
            float f3 = fArray[n3 + 2];
            float f4 = fArray[n6 + 0];
            float f5 = fArray[n6 + 1];
            float f6 = fArray[n6 + 2];
            float f7 = fArray[n4 + 0];
            float f8 = fArray[n4 + 1];
            float f9 = fArray[n4 + 2];
            float f10 = f4 - f;
            float f11 = f5 - f2;
            float f12 = f6 - f3;
            float f13 = f7 - f;
            float f14 = f8 - f2;
            float f15 = f9 - f3;
            float f16 = f11 * f15 - f12 * f14;
            f15 = f12 * f13 - f15 * f10;
            f10 = f10 * f14 - f11 * f13;
            double d2 = Math.sqrt(f16 * f16 + f15 * f15 + f10 * f10);
            double d3 = Math.sqrt((double)f10 / d2 * 8.0 + 8.0);
            n3 = (int)((double)f16 / d2 / d3 * 128.0);
            short s = (short)(FastMath.clamp(n3 + 127, 0, 255) | FastMath.clamp((int)((double)f15 / d2 / d3 * 128.0) + 127, 0, 255) << 8);
            Object object2 = object;
            if (object == null) {
                object2 = vertexPool.get();
            }
            ((Vertex)object2).set((short)((double)f * d), (short)((double)f2 * d), (short)((double)f3 * d), s);
            ExtrusionBucket extrusionBucket = this;
            object = extrusionBucket.mVertexMap.put((Vertex)object2, false);
            if (object == null) {
                n3 = n + 1;
                ((Vertex)object2).id = n;
                extrusionBucket.addMeshIndex((Vertex)object2, true);
                object = vertexPool.get();
                n = n3;
            } else {
                extrusionBucket.addMeshIndex((Vertex)object, false);
                object = object2;
            }
            ((Vertex)object).set((short)((double)f4 * d), (short)((double)f5 * d), (short)((double)f6 * d), s);
            object2 = extrusionBucket.mVertexMap.put((Vertex)object, false);
            if (object2 == null) {
                ((Vertex)object).id = n++;
                extrusionBucket.addMeshIndex((Vertex)object, true);
                object = vertexPool.get();
            } else {
                extrusionBucket.addMeshIndex((Vertex)object2, false);
            }
            ((Vertex)object).set((short)((double)f7 * d), (short)((double)f8 * d), (short)((double)f9 * d), s);
            object2 = extrusionBucket.mVertexMap.put((Vertex)object, false);
            if (object2 == null) {
                n3 = n + 1;
                ((Vertex)object).id = n;
                extrusionBucket.addMeshIndex((Vertex)object, true);
                object = vertexPool.get();
                n = n3;
            } else {
                extrusionBucket.addMeshIndex((Vertex)object2, false);
            }
            n3 = n5 + 1;
        }
        vertexPool.release((Vertex)object);
        // MONITOREXIT : pool
        this.numVertices = n;
    }

    public void addPoly(GeometryBuffer geometryBuffer, float f, float f2) {
        int n;
        int[] nArray = geometryBuffer.index;
        float[] fArray = geometryBuffer.points;
        float f3 = this.mGroundResolution;
        f = f * 0.1f / f3;
        f3 = 0.1f * f2 / f3;
        int n2 = this.numVertices;
        int n3 = nArray.length;
        boolean bl = true;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        while (n5 < n3 && (n = nArray[n5]) >= 0) {
            if (n == 0) {
                n2 = this.numVertices;
                bl = true;
                bl2 = false;
            } else {
                f2 = fArray[n4];
                int n6 = n4 + n;
                if (f2 == fArray[n6 - 2] && fArray[n4 + 1] == fArray[n6 - 1]) {
                    n6 = n - 2;
                    Logger logger = log;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("explicit closed poly ");
                    stringBuilder.append(n6);
                    logger.debug(stringBuilder.toString());
                } else {
                    n6 = n;
                }
                if (n6 >= 6) {
                    if (bl && n5 < n3 - 1 && nArray[n5 + 1] > 0) {
                        bl = false;
                    }
                    boolean bl3 = this.extrudeOutline(fArray, n4, n6, f3, f, bl);
                    if (bl && (bl3 || n6 <= 8)) {
                        this.addRoofSimple(n2, n6);
                    } else if (!bl2) {
                        this.addRoof(n2, geometryBuffer, n5, n4);
                        bl2 = true;
                    }
                }
            }
            ++n5;
            n4 += n;
        }
    }

    @Override
    public void clear() {
        this.mClipper = null;
        this.releaseVertexPool();
        if (this.mIndices != null) {
            for (int i = 0; i <= 4; ++i) {
                VertexData[] vertexDataArray = this.mIndices;
                if (vertexDataArray[i] == null) continue;
                vertexDataArray[i].dispose();
            }
            this.mIndices = null;
            this.vertexItems.dispose();
        }
    }

    @Override
    public void compile(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        if (this.numVertices == 0) {
            return;
        }
        int n = this.indiceOffset = shortBuffer2.position();
        for (int i = 0; i <= 4; ++i) {
            VertexData[] vertexDataArray = this.mIndices;
            int n2 = n;
            if (vertexDataArray[i] != null) {
                this.idx[i] = vertexDataArray[i].compile(shortBuffer2);
                this.off[i] = n * 2;
                n2 = n + this.idx[i];
            }
            n = n2;
        }
        this.vertexOffset = shortBuffer.position() * 2;
        this.vertexItems.compile(shortBuffer);
        this.clear();
    }

    public int getColor() {
        return this.color;
    }

    public float[] getColors() {
        return this.colors;
    }

    @Override
    public ExtrusionBucket next() {
        return (ExtrusionBucket)this.next;
    }

    @Override
    protected void prepare() {
        this.mClipper = null;
        this.releaseVertexPool();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void releaseVertexPool() {
        if (this.mVertexMap == null) {
            return;
        }
        Pool<Vertex> pool = vertexPool;
        synchronized (pool) {
            vertexPool.releaseAll(this.mVertexMap.releaseItems());
            this.mVertexMap = vertexMapPool.release(this.mVertexMap);
            return;
        }
    }

    static class Vertex
    extends KeyMap.HashItem {
        int id;
        short n;
        short x;
        short y;
        short z;

        Vertex() {
        }

        public boolean equals(Object object) {
            object = (Vertex)object;
            boolean bl = this.x == ((Vertex)object).x && this.y == ((Vertex)object).y && this.z == ((Vertex)object).z && this.n == ((Vertex)object).n;
            return bl;
        }

        public int hashCode() {
            return ((this.x << 16 | this.y) ^ (this.n << 16 | this.z)) * 31 + 7;
        }

        public Vertex set(short s, short s2, short s3, short s4) {
            this.x = s;
            this.y = s2;
            this.z = s3;
            this.n = s4;
            return this;
        }
    }
}

