/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.core.GeometryBuffer;
import org.oscim.layers.tile.MapTile;
import org.oscim.renderer.BufferObject;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.ExtrusionBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtrusionBuckets
extends MapTile.TileData {
    static final Logger log = LoggerFactory.getLogger(ExtrusionBuckets.class);
    public long animTime;
    public ExtrusionBucket buckets;
    public boolean compiled;
    public BufferObject ibo;
    public BufferObject vbo;
    public final double x;
    public final double y;
    public final int zoomLevel;

    public ExtrusionBuckets(MapTile mapTile) {
        this.zoomLevel = mapTile.zoomLevel;
        this.x = mapTile.x;
        this.y = mapTile.y;
    }

    public void addMeshElement(GeometryBuffer geometryBuffer, float f, int n) {
        ExtrusionBucket extrusionBucket;
        for (extrusionBucket = this.buckets; extrusionBucket != null; extrusionBucket = extrusionBucket.next()) {
            if (extrusionBucket.getColor() != n) continue;
            extrusionBucket.addMesh(geometryBuffer);
            return;
        }
        extrusionBucket = new ExtrusionBucket(0, f, n);
        this.buckets = extrusionBucket = Inlist.push(this.buckets, extrusionBucket);
        extrusionBucket.addMesh(geometryBuffer);
    }

    public void addPolyElement(GeometryBuffer geometryBuffer, float f, float[] object, int n, int n2) {
        for (ExtrusionBucket extrusionBucket = this.buckets; extrusionBucket != null; extrusionBucket = extrusionBucket.next()) {
            if (extrusionBucket.getColors() != object) continue;
            extrusionBucket.addPoly(geometryBuffer, n, n2);
            return;
        }
        object = new ExtrusionBucket(0, f, (float[])object);
        object = (ExtrusionBucket)Inlist.push(this.buckets, object);
        this.buckets = object;
        ((ExtrusionBucket)object).addPoly(geometryBuffer, n, n2);
    }

    public ExtrusionBucket buckets() {
        return this.buckets;
    }

    public boolean compile() {
        Inlist inlist = this.buckets;
        if (inlist == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (inlist != null) {
            n += ((ExtrusionBucket)inlist).numIndices;
            n2 += ((ExtrusionBucket)inlist).numVertices;
            inlist = ((ExtrusionBucket)inlist).next();
        }
        if (n == 0) {
            return false;
        }
        int n3 = n2 * 4;
        ShortBuffer shortBuffer = MapRenderer.getShortBuffer(n3);
        ShortBuffer shortBuffer2 = MapRenderer.getShortBuffer(n);
        for (inlist = this.buckets; inlist != null; inlist = ((ExtrusionBucket)inlist).next()) {
            ((ExtrusionBucket)inlist).compile(shortBuffer, shortBuffer2);
        }
        int n4 = n * 2;
        if (shortBuffer2.position() != n) {
            n4 = shortBuffer2.position();
            log.error("invalid indice size: {} {}", (Object)n, (Object)n4);
            n4 *= 2;
        }
        inlist = BufferObject.get(34963, n4);
        this.ibo = inlist;
        ((BufferObject)inlist).loadBufferData(shortBuffer2.flip(), n4);
        n = n3 * 2;
        if (shortBuffer.position() != n3) {
            n = shortBuffer.position();
            log.error("invalid vertex size: {} {}", (Object)n2, (Object)n);
            n *= 2;
        }
        inlist = BufferObject.get(34962, n);
        this.vbo = inlist;
        ((BufferObject)inlist).loadBufferData(shortBuffer.flip(), n);
        this.compiled = true;
        return true;
    }

    @Override
    protected void dispose() {
        this.resetBuckets(null);
        if (this.compiled) {
            this.ibo = BufferObject.release(this.ibo);
            this.vbo = BufferObject.release(this.vbo);
        }
    }

    public void prepare() {
        RenderBucket renderBucket = this.buckets;
        while (renderBucket != null) {
            ((RenderBucket)renderBucket).prepare();
            renderBucket = (RenderBucket)renderBucket.next;
        }
    }

    public void resetBuckets(ExtrusionBucket extrusionBucket) {
        RenderBucket renderBucket = this.buckets;
        while (renderBucket != null) {
            ((RenderBucket)renderBucket).clear();
            renderBucket = (RenderBucket)renderBucket.next;
        }
        this.buckets = extrusionBucket;
    }
}

