/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.backend.GLAdapter;
import org.oscim.core.GeometryBuffer;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.theme.styles.LineStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HairLineBucket
extends RenderBucket {
    static final Logger log = LoggerFactory.getLogger(HairLineBucket.class);
    public LineStyle line;

    public HairLineBucket(int n) {
        super((byte)5, true, false);
        this.level = n;
    }

    public void addLine(GeometryBuffer geometryBuffer) {
        short s = (short)this.numVertices;
        float[] fArray = geometryBuffer.points;
        boolean bl = geometryBuffer.isPoly();
        int n = geometryBuffer.index.length;
        int n2 = 0;
        short s2 = s;
        for (int i = 0; i < n && (s = geometryBuffer.index[i]) >= 0; ++i) {
            block6: {
                if (!(s < 4 || bl && s < 6)) {
                    int n3 = s + n2;
                    VertexData vertexData = this.vertexItems;
                    s = n2 + 1;
                    short s3 = (short)(fArray[n2] * MapRenderer.COORD_SCALE);
                    n2 = s + 1;
                    vertexData.add(s3, (short)(fArray[s] * MapRenderer.COORD_SCALE));
                    vertexData = this.indiceItems;
                    s = (short)(s2 + 1);
                    vertexData.add(s2);
                    ++this.numIndices;
                    s3 = s;
                    while (n2 < n3) {
                        vertexData = this.vertexItems;
                        s = n2 + 1;
                        short s4 = (short)(fArray[n2] * MapRenderer.COORD_SCALE);
                        n2 = s + 1;
                        vertexData.add(s4, (short)(fArray[s] * MapRenderer.COORD_SCALE));
                        this.indiceItems.add(s3);
                        ++this.numIndices;
                        if (n2 == n3) {
                            if (bl) {
                                this.indiceItems.add(s3);
                                ++this.numIndices;
                                this.indiceItems.add(s2);
                                ++this.numIndices;
                            }
                            s = (short)(s3 + 1);
                            break block6;
                        }
                        vertexData = this.indiceItems;
                        s = (short)(s3 + 1);
                        vertexData.add(s3);
                        ++this.numIndices;
                        s3 = s;
                    }
                    s = s3;
                } else {
                    n2 += s;
                    s = s2;
                }
            }
            s2 = s;
        }
        this.numVertices = s2;
    }

    public static class Renderer {
        static Shader shader;

        public static RenderBucket draw(RenderBucket renderBucket, GLViewport object) {
            GLState.blend(true);
            Shader shader = Renderer.shader;
            shader.set((GLViewport)object);
            while (renderBucket != null && renderBucket.type == 5) {
                object = (HairLineBucket)renderBucket;
                LineStyle lineStyle = ((HairLineBucket)object).line.current();
                GLUtils.setColor(shader.uColor, lineStyle.color, 1.0f);
                GLAdapter.gl.vertexAttribPointer(shader.aPos, 2, 5122, false, 0, ((HairLineBucket)object).vertexOffset);
                GLAdapter.gl.drawElements(1, ((HairLineBucket)object).numIndices, 5123, ((HairLineBucket)object).indiceOffset);
                renderBucket = (RenderBucket)renderBucket.next;
            }
            return renderBucket;
        }

        static boolean init() {
            shader = new Shader("hairline");
            return true;
        }

        public static class Shader
        extends GLShader {
            int aPos;
            int uColor;
            int uMVP;
            int uScreen;
            int uWidth;

            Shader(String string2) {
                if (!this.create(string2)) {
                    return;
                }
                this.uMVP = this.getUniform("u_mvp");
                this.uColor = this.getUniform("u_color");
                this.uWidth = this.getUniform("u_width");
                this.uScreen = this.getUniform("u_screen");
                this.aPos = this.getAttrib("a_pos");
            }

            public void set(GLViewport gLViewport) {
                this.useProgram();
                GLState.enableVertexArrays(this.aPos, -1);
                gLViewport.mvp.setAsUniform(this.uMVP);
                GLAdapter.gl.uniform2f(this.uScreen, gLViewport.getWidth() / 2.0f, gLViewport.getHeight() / 2.0f);
                GLAdapter.gl.uniform1f(this.uWidth, 1.5f);
                GLAdapter.gl.lineWidth(2.0f);
            }
        }
    }
}

