/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.backend.GLAdapter;
import org.oscim.backend.canvas.Paint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MercatorProjection;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.theme.styles.LineStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineBucket
extends RenderBucket {
    private static final float BEVEL_MIN = 0.5f;
    private static final int DIR_MASK = -4;
    public static final float DIR_SCALE = 2048.0f;
    private static final float MIN_DIST = 0.125f;
    static final Logger log = LoggerFactory.getLogger(LineBucket.class);
    public float heightOffset;
    public LineStyle line;
    private float mMinDist = 0.125f;
    public LineBucket outlines;
    public boolean roundCap;
    public float scale = 1.0f;
    private int tmax;
    private int tmin = Integer.MIN_VALUE;

    LineBucket(byte by, boolean bl, boolean bl2) {
        super(by, bl, bl2);
        this.tmax = Integer.MAX_VALUE;
    }

    public LineBucket(int n) {
        super((byte)0, false, false);
        this.tmax = Integer.MAX_VALUE;
        this.level = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addLine(VertexData vertexData, float[] object, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        short s;
        int n4;
        int n5 = this.numVertices;
        int n6 = bl ? 6 : 2;
        int n7 = bl3 ? 2 : 0;
        this.numVertices = n5 + (n2 + n6 + n7);
        n5 = n + 1;
        Object object2 = object[n];
        n7 = n5 + 1;
        Object object3 = object[n5];
        n6 = n7 + 1;
        Object object4 = object[n7];
        n7 = n6 + 1;
        Object object5 = object[n6];
        Object object6 = object4 - object2;
        Object object7 = object5 - object3;
        double d = (float)Math.sqrt((double)(object6 * object6 + object7 * object7));
        object6 = (float)((double)object6 / d);
        object7 = (float)((double)object7 / d);
        reference var19_18 = -object7;
        short s2 = (short)(MapRenderer.COORD_SCALE * object2);
        short s3 = (short)(MapRenderer.COORD_SCALE * object3);
        n6 = this.tmin;
        n6 = !(object2 < (float)n6 || object2 > (float)(n4 = this.tmax) || object3 < (float)n6 || object3 > (float)n4) ? 0 : 1;
        if (bl && n6 == 0) {
            n4 = (int)((var19_18 - object6) * 2048.0f);
            n6 = (int)((object6 - object7) * 2048.0f);
            s = (short)(n4 & 0xFFFFFFFC | 0);
            n3 = n6 & 0xFFFFFFFC | 2;
            vertexData.add(s2, s3, s, (short)n3);
            vertexData.add(s2, s3, s, (short)n3);
            n4 = (int)(-(var19_18 + object6) * 2048.0f);
            n6 = (int)(-(object6 + object7) * 2048.0f);
            vertexData.add(s2, s3, (short)(n4 & 0xFFFFFFFC | 2), (short)(n6 & 0xFFFFFFFC | 2));
            n6 = (int)(var19_18 * 2048.0f);
            n4 = (int)(object6 * 2048.0f);
            vertexData.add(s2, s3, (short)(n6 & 0xFFFFFFFC | 0), (short)(n4 & 0xFFFFFFFC | 1));
            vertexData.add(s2, s3, (short)(-n6 & 0xFFFFFFFC | 2), (short)(-n4 & 0xFFFFFFFC | 1));
        } else {
            if (!bl && !bl2) {
                object3 = 0.0f;
                object2 = 0.0f;
            } else if (bl) {
                object3 = (double)object6 * 0.5;
                object2 = (double)object7 * 0.5;
            } else {
                object3 = object6;
                object2 = object7;
            }
            if (bl) {
                this.numVertices -= 2;
            }
            n4 = (int)((var19_18 - object3) * 2048.0f);
            n6 = (int)((object6 - object2) * 2048.0f);
            s = (short)(n4 & 0xFFFFFFFC | 0);
            n3 = (short)(n6 & 0xFFFFFFFC | 1);
            vertexData.add(s2, s3, s, (short)n3);
            vertexData.add(s2, s3, s, (short)n3);
            n4 = (int)(-(var19_18 + object3) * 2048.0f);
            n6 = (int)(-(object2 + object6) * 2048.0f);
            vertexData.add(s2, s3, (short)(n4 & 0xFFFFFFFC | 2), (short)(n6 & 0xFFFFFFFC | 1));
        }
        object2 = object6 * -1.0f;
        object3 = object7 * -1.0f;
        n6 = n + n2;
        n2 = n7;
        while (true) {
            Object object8;
            if (n2 < n6) {
                n7 = n2 + 1;
                object7 = object[n2];
                n2 = n7 + 1;
                object6 = object[n7];
            } else {
                if (!bl3 || n2 >= n6 + 2) break;
                object7 = object[n];
                object6 = object[n5];
                n2 += 2;
            }
            Object object9 = object7 - object4;
            var19_18 = object6 - object5;
            d = Math.sqrt((double)(object9 * object9 + var19_18 * var19_18));
            if (d < (double)this.mMinDist) {
                this.numVertices -= 2;
                continue;
            }
            float f = (float)((double)var19_18 / d);
            if ((d = (double)((object9 = (Object)((double)object9 / d)) * object2 + f * object3)) > 0.65) {
                this.numVertices += 2;
                if (d > 0.999) {
                    object8 = object3 + f;
                    var19_18 = object2 + object9;
                    d = (double)(object9 * object8 - f * var19_18);
                    if (d < 0.1 && d > -0.1) {
                        var19_18 = (reference)(-f);
                    } else {
                        var19_18 = (reference)((double)var19_18 / d);
                        object9 = (double)object8 / d;
                    }
                    f = (float)(object4 + (var19_18 *= 0.5f));
                    object8 = object5 + (object9 *= 0.5f);
                    object9 = object5 - object9;
                    var19_18 = object4 - var19_18;
                    object5 = f;
                    object4 = object8;
                } else {
                    var19_18 = object4 + object9 * 0.5f;
                    object9 = object5 + f * 0.5f;
                    object8 = object2 * 0.5f + object4;
                    f = (float)(object3 * 0.5f + object5);
                    object4 = object9;
                    object5 = var19_18;
                    object9 = f;
                    var19_18 = object8;
                }
                f = (float)(object5 - var19_18);
                object8 = object4 - object9;
                d = Math.sqrt(f * f + object8 * object8);
                f = (float)((double)f / d);
                object8 = (double)object8 / d;
                this.addVertex(vertexData, (float)var19_18, (float)object9, (float)object2, (float)object3, f, (float)object8);
                var19_18 = (reference)(-f);
                object2 = -object8;
                object9 = object7 - object5;
                object3 = object6 - object4;
                d = Math.sqrt((double)(object9 * object9 + object3 * object3));
                object9 = (double)object9 / d;
                object3 = (double)object3 / d;
                object8 = object4;
                object4 = object5;
                object5 = object8;
            } else {
                var19_18 = object3;
                object8 = object2;
                object3 = f;
                object2 = var19_18;
                var19_18 = object8;
            }
            this.addVertex(vertexData, (float)object4, (float)object5, (float)var19_18, (float)object2, (float)object9, (float)object3);
            object2 = -object9;
            object3 = -object3;
            object4 = object7;
            object5 = object6;
        }
        object6 = -object2;
        n2 = this.tmin;
        n = !(object4 < (float)n2 || object4 > (float)(n = this.tmax) || object5 < (float)n2 || object5 > (float)n) ? 0 : 1;
        s3 = (short)(object4 * MapRenderer.COORD_SCALE);
        s2 = (short)(object5 * MapRenderer.COORD_SCALE);
        if (bl && n == 0) {
            n2 = (int)(object3 * 2048.0f);
            n = (int)(object6 * 2048.0f);
            s = (short)(n2 & 0xFFFFFFFC | 0);
            n3 = (short)(n & 0xFFFFFFFC | 1);
            object = vertexData;
            ((VertexData)object).add(s3, s2, s, (short)n3);
            ((VertexData)object).add(s3, s2, (short)(-n2 & 0xFFFFFFFC | 2), (short)(-n & 0xFFFFFFFC | 1));
            n2 = (int)((object3 - object2) * 2048.0f);
            n = (int)((object6 - object3) * 2048.0f);
            ((VertexData)object).add(s3, s2, (short)(n2 & 0xFFFFFFFC | 0), (short)(n & 0xFFFFFFFC | 0));
            n2 = (int)(-(object2 + object3) * 2048.0f);
            n = (int)(-(object6 + object3) * 2048.0f);
            n2 = (short)(n2 & 0xFFFFFFFC | 2);
            n = n & 0xFFFFFFFC | 0;
            n3 = n2;
        } else {
            if (!bl && !bl2) {
                object2 = 0.0f;
                object7 = 0.0f;
            } else if (bl) {
                object2 = (double)object2 * 0.5;
                object7 = (float)((double)object3 * 0.5);
            } else {
                object7 = object3;
            }
            if (bl) {
                this.numVertices -= 2;
            }
            n = (int)((object3 - object2) * 2048.0f);
            n2 = (int)((object6 - object7) * 2048.0f);
            vertexData.add(s3, s2, (short)(n & 0xFFFFFFFC | 0), (short)(n2 & 0xFFFFFFFC | 1));
            n2 = (int)(-(object3 + object2) * 2048.0f);
            n = (int)(-(object6 + object7) * 2048.0f);
            n2 = (short)(n2 & 0xFFFFFFFC | 2);
            n = n & 0xFFFFFFFC | 1;
            n3 = n2;
        }
        s = (short)n;
        vertexData.add(s3, s2, (short)n3, s);
        vertexData.add(s3, s2, (short)n3, s);
    }

    private void addVertex(VertexData vertexData, float f, float f2, float f3, float f4, float f5, float f6) {
        double d = (f4 += f6) * f5 - (f3 += f5) * f6;
        if (d < 0.01 && d > -0.01) {
            f3 = -f6;
        } else {
            f3 = (float)((double)f3 / d);
            f5 = (float)((double)f4 / d);
        }
        short s = (short)(f * MapRenderer.COORD_SCALE);
        short s2 = (short)(f2 * MapRenderer.COORD_SCALE);
        int n = (int)(f3 * 2048.0f);
        int n2 = (int)(f5 * 2048.0f);
        vertexData.add(s, s2, (short)(n & 0xFFFFFFFC | 0), (short)(n2 & 0xFFFFFFFC | 1));
        vertexData.add(s, s2, (short)(-n & 0xFFFFFFFC | 2), (short)(-n2 & 0xFFFFFFFC | 1));
    }

    public void addLine(GeometryBuffer geometryBuffer) {
        if (geometryBuffer.isPoly()) {
            this.addLine(geometryBuffer.points, geometryBuffer.index, -1, true);
        } else if (geometryBuffer.isLine()) {
            this.addLine(geometryBuffer.points, geometryBuffer.index, -1, false);
        } else {
            log.debug("geometry must be LINE or POLYGON");
        }
    }

    public void addLine(float[] fArray, int n, boolean bl) {
        if (n >= 4) {
            this.addLine(fArray, null, n, bl);
        }
    }

    /*
     * Unable to fully structure code
     */
    void addLine(float[] var1_1, int[] var2_2, int var3_3, boolean var4_4) {
        block17: {
            var5_5 = this.line.cap;
            var6_6 = Paint.Cap.ROUND;
            var7_7 = 0;
            if (var5_5 != var6_6) break block17;
            var8_8 = true;
            ** GOTO lbl13
        }
        if (this.line.cap == Paint.Cap.SQUARE) {
            var8_8 = false;
            var9_9 = true;
        } else {
            var8_8 = false;
lbl13:
            // 2 sources

            var9_9 = false;
        }
        if (var8_8 && var2_2 != null) {
            var10_10 = var2_2.length;
            var11_11 = 0;
            var12_12 = 0;
            while (var11_11 < var10_10 && var2_2[var11_11] >= 0) {
                if (var12_12 > 400) {
                    var8_8 = false;
                    break;
                }
                ++var11_11;
                ++var12_12;
            }
        }
        this.roundCap = var8_8;
        if (var2_2 == null) {
            if (var3_3 <= 0) {
                var3_3 = var1_1.length;
            }
            var11_11 = 1;
        } else {
            var11_11 = var2_2.length;
            var3_3 = 0;
        }
        var10_10 = 0;
        while (var10_10 < var11_11) {
            if (var2_2 != null) {
                var3_3 = var2_2[var10_10];
            }
            if (var3_3 < 0) break;
            if (var3_3 < 4) {
                var12_12 = var3_3;
            } else if (var3_3 == 4 && var1_1[var7_7] == var1_1[var7_7 + 2] && var1_1[var7_7 + 1] == var1_1[var7_7 + 3]) {
                var12_12 = var3_3;
            } else {
                var12_12 = var3_3;
                if (var3_3 == 6) {
                    var12_12 = var3_3;
                    if (var1_1[var7_7] == var1_1[var7_7 + 4]) {
                        var12_12 = var3_3;
                        if (var1_1[var7_7 + 1] == var1_1[var7_7 + 5]) {
                            var12_12 = var3_3 - 2;
                        }
                    }
                }
                this.addLine(this.vertexItems, var1_1, var7_7, var12_12, var8_8, var9_9, var4_4);
            }
            ++var10_10;
            var7_7 += var3_3;
            var3_3 = var12_12;
        }
    }

    public void addOutline(LineBucket lineBucket) {
        LineBucket lineBucket2 = this.outlines;
        while (lineBucket2 != null) {
            if (lineBucket == lineBucket2) {
                return;
            }
            lineBucket2 = lineBucket2.outlines;
        }
        lineBucket.outlines = this.outlines;
        this.outlines = lineBucket;
    }

    public void setDropDistance(float f) {
        this.mMinDist = Math.max(f, 0.125f);
    }

    public void setExtents(int n, int n2) {
        this.tmin = n;
        this.tmax = n2;
    }

    public static final class Renderer {
        private static final int CAP_BUTT = 1;
        private static final int CAP_ROUND = 2;
        private static final int CAP_THIN = 0;
        private static final float COORD_SCALE_BY_DIR_SCALE = MapRenderer.COORD_SCALE / 2048.0f;
        private static final int SHADER_FLAT = 1;
        private static final int SHADER_PROJ = 0;
        public static int mTexID;
        private static Shader[] shaders;

        static {
            shaders = new Shader[]{null, null};
        }

        /*
         * Enabled aggressive block sorting
         */
        public static RenderBucket draw(RenderBucket renderBucket, GLViewport gLViewport, float f, RenderBuckets object) {
            Object object2 = gLViewport;
            int n = ((GLViewport)object2).pos.tilt < 1.0f ? 1 : 0;
            Object object3 = shaders[n];
            ((Shader)object3).useProgram();
            GLState.blend(true);
            if (!GLAdapter.GDX_DESKTOP_QUIRKS) {
                GLState.bindTex2D(mTexID);
            }
            int n2 = ((Shader)object3).uFade;
            int n3 = ((Shader)object3).uMode;
            int n4 = ((Shader)object3).uColor;
            int n5 = ((Shader)object3).uWidth;
            int n6 = ((Shader)object3).uHeight;
            GLAdapter.gl.vertexAttribPointer(((Shader)object3).aPos, 4, 5122, false, 0, ((RenderBuckets)object).offset[0]);
            ((GLViewport)object2).mvp.setAsUniform(((Shader)object3).uMVP);
            double d = f;
            double d2 = Math.sqrt(d);
            double d3 = n == 0 ? 1.0E-4 : 1.5 / d;
            object = GLAdapter.gl;
            float f2 = (float)d3;
            object.uniform1f(n2, f2);
            object = GLAdapter.gl;
            float f3 = 0.0f;
            object.uniform1f(n3, f3);
            GLAdapter.gl.uniform1f(n6, 0.0f);
            float f4 = 0.0f;
            int n7 = 0;
            int n8 = 0;
            while (true) {
                int n9;
                block29: {
                    int n10;
                    double d4;
                    float f5;
                    block30: {
                        block25: {
                            block27: {
                                float f6;
                                block28: {
                                    block26: {
                                        object = gLViewport;
                                        if (renderBucket == null || renderBucket.type != 0) break block25;
                                        object3 = (LineBucket)renderBucket;
                                        object2 = ((LineBucket)object3).line.current();
                                        f6 = ((LineStyle)object2).heightOffset;
                                        f5 = f3;
                                        if (f6 != ((LineBucket)object3).heightOffset) {
                                            ((LineBucket)object3).heightOffset = ((LineStyle)object2).heightOffset;
                                        }
                                        if (((LineBucket)object3).heightOffset != f4) {
                                            f4 = ((LineBucket)object3).heightOffset;
                                            GLAdapter.gl.uniform1f(n6, f4 / MercatorProjection.groundResolution(((GLViewport)object).pos));
                                        }
                                        if (((LineStyle)object2).fadeScale >= ((GLViewport)object).pos.zoomLevel) break block26;
                                        GLUtils.setColor(n4, ((LineStyle)object2).color, 1.0f);
                                        break block27;
                                    }
                                    if (((LineStyle)object2).fadeScale <= ((GLViewport)object).pos.zoomLevel) break block28;
                                    n9 = n8;
                                    f3 = f5;
                                    break block29;
                                }
                                d4 = d > 1.2 ? d : 1.2;
                                f6 = (float)d4;
                                GLUtils.setColor(n4, ((LineStyle)object2).color, f6 - 1.0f);
                            }
                            n9 = n8;
                            if (n == 0) {
                                n9 = n8;
                                if (n8 != 0) {
                                    n9 = n8;
                                    if (((LineStyle)object2).blur == 0.0f) {
                                        GLAdapter.gl.uniform1f(n2, f2);
                                        n9 = 0;
                                    }
                                }
                            }
                            if (((LineStyle)object2).outline) break block30;
                            d4 = ((LineStyle)object2).fixed ? (double)(Math.max(((LineStyle)object2).width, 1.0f) / f) : (double)(((LineBucket)object3).scale * ((LineStyle)object2).width) / d2;
                            GLAdapter.gl.uniform1f(n5, (float)((double)COORD_SCALE_BY_DIR_SCALE * d4));
                            if (((LineStyle)object2).blur > 0.0f) {
                                GLAdapter.gl.uniform1f(n2, ((LineStyle)object2).blur);
                                n8 = 1;
                            } else {
                                n8 = n9;
                                if (n == 1) {
                                    GLAdapter.gl.uniform1f(n2, (float)(d3 / d4));
                                    n8 = n9;
                                }
                            }
                            if ((double)((LineBucket)object3).scale < 1.5) {
                                if (n7 != 0) {
                                    GLAdapter.gl.uniform1f(n3, f5);
                                    n7 = 0;
                                }
                            } else {
                                n9 = n7;
                                n10 = n3;
                                if (((LineBucket)object3).roundCap) {
                                    if (n9 != 2) {
                                        GLAdapter.gl.uniform1f(n10, 2);
                                        n7 = 2;
                                    }
                                } else if (n9 != 1) {
                                    GLAdapter.gl.uniform1f(n10, 1.0f);
                                    n7 = 1;
                                }
                            }
                            GLAdapter.gl.drawArrays(5, renderBucket.vertexOffset, renderBucket.numVertices);
                            n9 = n8;
                            break block29;
                        }
                        return renderBucket;
                    }
                    n10 = n2;
                    int n11 = n3;
                    f3 = f5;
                    object = ((LineBucket)object3).outlines;
                    while (true) {
                        f5 = f;
                        if (object == null) break;
                        LineStyle lineStyle = ((LineBucket)object).line.current();
                        d4 = lineStyle.fixed ? (double)(Math.max(lineStyle.width, 1.0f) / f5) : (double)(((LineBucket)object).scale * lineStyle.width) / d2;
                        double d5 = ((LineStyle)object2).fixed ? (double)(((LineStyle)object2).width / f5) : (double)(((LineBucket)object3).scale * ((LineStyle)object2).width) / d2;
                        GLAdapter.gl.uniform1f(n5, (float)((double)COORD_SCALE_BY_DIR_SCALE * (d4 += d5)));
                        if (((LineStyle)object2).blur > 0.0f) {
                            GLAdapter.gl.uniform1f(n10, ((LineStyle)object2).blur);
                            n8 = 1;
                        } else {
                            n8 = n9;
                            if (n == 1) {
                                GLAdapter.gl.uniform1f(n10, (float)(d3 / d4));
                                n8 = n9;
                            }
                        }
                        if (((LineBucket)object).roundCap) {
                            n9 = n7;
                            if (n7 != 2) {
                                GLAdapter.gl.uniform1f(n11, 2);
                                n9 = 2;
                            }
                        } else {
                            n9 = n7;
                            if (n7 != 1) {
                                GLAdapter.gl.uniform1f(n11, 1.0f);
                                n9 = 1;
                            }
                        }
                        GLAdapter.gl.drawArrays(5, ((LineBucket)object).vertexOffset, ((LineBucket)object).numVertices);
                        object = ((LineBucket)object).outlines;
                        n7 = n9;
                        n9 = n8;
                    }
                }
                renderBucket = (RenderBucket)renderBucket.next;
                n8 = n9;
            }
        }

        static boolean init() {
            Renderer.shaders[0] = new Shader("line_aa_proj");
            Renderer.shaders[1] = new Shader("line_aa");
            byte[] byArray = new byte[16384];
            for (int i = 0; i < 128; ++i) {
                float f = i * i;
                for (int j = 0; j < 128; ++j) {
                    int n;
                    int n2 = n = (int)(Math.sqrt((float)(j * j) + f) * 2.0);
                    if (n > 255) {
                        n2 = 255;
                    }
                    byArray[j * 128 + i] = (byte)n2;
                }
            }
            mTexID = GLUtils.loadTexture(byArray, 128, 128, 6406, 9728, 9728, 33648, 33648);
            return true;
        }
    }

    static class Shader
    extends GLShader {
        int aPos;
        int uColor;
        int uFade;
        int uHeight;
        int uMVP;
        int uMode;
        int uWidth;

        Shader(String string2) {
            if (!this.create(string2)) {
                return;
            }
            this.uMVP = this.getUniform("u_mvp");
            this.uFade = this.getUniform("u_fade");
            this.uWidth = this.getUniform("u_width");
            this.uColor = this.getUniform("u_color");
            this.uMode = this.getUniform("u_mode");
            this.uHeight = this.getUniform("u_height");
            this.aPos = this.getAttrib("a_pos");
        }

        @Override
        public boolean useProgram() {
            if (super.useProgram()) {
                GLState.enableVertexArrays(this.aPos, -1);
                return true;
            }
            return false;
        }
    }
}

