/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.oscim.backend.GL;
import org.oscim.backend.GLAdapter;
import org.oscim.core.GeometryBuffer;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.theme.styles.LineStyle;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LineTexBucket
extends LineBucket {
    static final Logger log = LoggerFactory.getLogger(LineTexBucket.class);
    public int evenQuads;
    private boolean evenSegment = true;
    public int oddQuads;

    LineTexBucket(int n) {
        super((byte)1, false, true);
        this.level = n;
        this.evenSegment = true;
    }

    @Override
    public void addLine(GeometryBuffer geometryBuffer) {
        this.addLine(geometryBuffer.points, geometryBuffer.index, -1, false);
    }

    @Override
    void addLine(float[] fArray, int[] nArray, int n, boolean bl) {
        int n2;
        int[] nArray2 = nArray;
        if (this.vertexItems.empty()) {
            this.numVertices = 1;
        }
        VertexData vertexData = this.vertexItems;
        if (!this.evenSegment) {
            vertexData.seek(-12);
        }
        if (nArray2 == null) {
            n2 = 1;
        } else {
            n2 = nArray2.length;
            n = 0;
        }
        int n3 = 0;
        int n4 = 0;
        while (true) {
            nArray2 = nArray;
            if (n4 >= n2) break;
            if (nArray2 != null) {
                n = nArray2[n4];
            }
            if (n < 0) break;
            if (n < 4) {
                n3 += n;
            } else {
                int n5 = n3 + n;
                int n6 = n3 + 1;
                float f = fArray[n3] * MapRenderer.COORD_SCALE;
                n3 = n6 + 1;
                float f2 = fArray[n6] * MapRenderer.COORD_SCALE;
                float f3 = this.line.randomOffset ? (f * f + f2 * f2) % 80.0f : 0.0f;
                while (n3 < n5) {
                    n6 = n3 + 1;
                    float f4 = fArray[n3];
                    f4 = MapRenderer.COORD_SCALE * f4;
                    float f5 = fArray[n6];
                    f5 = MapRenderer.COORD_SCALE * f5;
                    float f6 = f4 - f;
                    float f7 = f5 - f2;
                    double d = Math.sqrt(f6 * f6 + f7 * f7);
                    short s = (short)((double)(-f7) / d * 2048.0);
                    short s2 = (short)((double)f6 / d * 2048.0);
                    vertexData.add((short)f, (short)f2, s, s2, (short)f3, (short)0);
                    f3 = (float)((double)f3 + d);
                    vertexData.seek(6);
                    vertexData.add((short)f4, (short)f5, s, s2, (short)f3, (short)0);
                    if (this.evenSegment) {
                        vertexData.seek(-12);
                        this.evenSegment = false;
                        this.numVertices += 3;
                        ++this.evenQuads;
                    } else {
                        this.evenSegment = true;
                        ++this.numVertices;
                        ++this.oddQuads;
                    }
                    f = f4;
                    f2 = f5;
                    n3 = n6 + 1;
                }
            }
            ++n4;
        }
        if (!this.evenSegment) {
            vertexData.seek(12);
        }
    }

    @Override
    protected void clear() {
        this.evenSegment = true;
        this.evenQuads = 0;
        this.oddQuads = 0;
        super.clear();
    }

    @Override
    protected void compile(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        this.compileVertexItems(shortBuffer);
        shortBuffer.position(shortBuffer.position() + 6);
    }

    public static final class Renderer {
        private static final float COORD_SCALE_BY_DIR_SCALE = MapRenderer.COORD_SCALE / 2048.0f;
        private static final int LEN_OFFSET = 8;
        private static final int STRIDE = 12;
        private static int mVertexFlipID;
        private static Shader shader;

        public static RenderBucket draw(RenderBucket renderBucket, GLViewport object, float f, RenderBuckets object2) {
            GLState.blend(true);
            shader.useProgram();
            GLState.enableVertexArrays(-1, -1);
            int n = Renderer.shader.aLen0;
            int n2 = Renderer.shader.aLen1;
            int n3 = Renderer.shader.aPos0;
            int n4 = Renderer.shader.aPos1;
            int n5 = Renderer.shader.aFlip;
            GLAdapter.gl.enableVertexAttribArray(n3);
            GLAdapter.gl.enableVertexAttribArray(n4);
            GLAdapter.gl.enableVertexAttribArray(n);
            GLAdapter.gl.enableVertexAttribArray(n2);
            GLAdapter.gl.enableVertexAttribArray(n5);
            ((GLViewport)object).mvp.setAsUniform(Renderer.shader.uMVP);
            MapRenderer.bindQuadIndicesVBO();
            GLState.bindVertexBuffer(mVertexFlipID);
            GLAdapter.gl.vertexAttribPointer(Renderer.shader.aFlip, 1, 5120, false, 0, 0);
            ((RenderBuckets)object2).vbo.bind();
            f = (float)((GLViewport)object).pos.getZoomScale() / f;
            while (renderBucket != null && renderBucket.type == 1) {
                int n6;
                int n7;
                int n8;
                int n9;
                float f2;
                object = (LineTexBucket)renderBucket;
                object2 = ((LineTexBucket)object).line.current();
                GL gL = GLAdapter.gl;
                int n10 = Renderer.shader.uMode;
                if (((LineStyle)object2).dashArray != null) {
                    f2 = 2.0f;
                } else {
                    n9 = ((LineStyle)object2).texture != null ? 1 : 0;
                    f2 = n9;
                }
                gL.uniform1f(n10, f2);
                if (((LineStyle)object2).texture != null) {
                    ((LineStyle)object2).texture.bind();
                }
                GLUtils.setColor(Renderer.shader.uColor, ((LineStyle)object2).stippleColor, 1.0f);
                GLUtils.setColor(Renderer.shader.uBgColor, ((LineStyle)object2).color, 1.0f);
                if (f >= 1.0f) {
                    n9 = (int)((float)((LineStyle)object2).stipple * f / (float)((LineStyle)object2).stipple);
                    f2 = (float)((LineStyle)object2).stipple / (float)(n9 + 1);
                } else {
                    n9 = (int)((float)((LineStyle)object2).stipple / f / (float)((LineStyle)object2).stipple);
                    f2 = ((LineStyle)object2).stipple * n9;
                }
                GLAdapter.gl.uniform1f(Renderer.shader.uPatternScale, MapRenderer.COORD_SCALE * f2);
                GLAdapter.gl.uniform1f(Renderer.shader.uPatternWidth, ((LineStyle)object2).stippleWidth);
                GLAdapter.gl.uniform1f(Renderer.shader.uWidth, ((LineTexBucket)object).scale * ((LineStyle)object2).width / f * COORD_SCALE_BY_DIR_SCALE);
                n9 = ((LineTexBucket)object).evenQuads * 6;
                n10 = 0;
                while (true) {
                    n8 = 3072;
                    if (n10 >= n9) break;
                    n7 = n9 - n10;
                    if (n7 <= 3072) {
                        n8 = n7;
                    }
                    n7 = renderBucket.vertexOffset + n10 * 8 - 12;
                    object2 = GLAdapter.gl;
                    n6 = n7 + 12;
                    object2.vertexAttribPointer(n3, 4, 5122, false, 12, n6);
                    GLAdapter.gl.vertexAttribPointer(n, 2, 5122, false, 12, n6 + 8);
                    object2 = GLAdapter.gl;
                    object2.vertexAttribPointer(n4, 4, 5122, false, 12, n7);
                    GLAdapter.gl.vertexAttribPointer(n2, 2, 5122, false, 12, n7 + 8);
                    GLAdapter.gl.drawElements(4, n8, 5123, 0);
                    n10 += 3072;
                }
                n10 = ((LineTexBucket)object).oddQuads * 6;
                for (n9 = 0; n9 < n10; n9 += 3072) {
                    n8 = n10 - n9;
                    if (n8 > 3072) {
                        n8 = 3072;
                    }
                    n6 = renderBucket.vertexOffset + n9 * 8 - 12;
                    object = GLAdapter.gl;
                    n7 = n6 + 24;
                    object.vertexAttribPointer(n3, 4, 5122, false, 12, n7);
                    GLAdapter.gl.vertexAttribPointer(n, 2, 5122, false, 12, n7 + 8);
                    object = GLAdapter.gl;
                    n7 = n6 + 12;
                    object.vertexAttribPointer(n4, 4, 5122, false, 12, n7);
                    GLAdapter.gl.vertexAttribPointer(n2, 2, 5122, false, 12, n7 + 8);
                    GLAdapter.gl.drawElements(4, n8, 5123, 0);
                }
                renderBucket = (RenderBucket)renderBucket.next;
            }
            GLAdapter.gl.disableVertexAttribArray(n3);
            GLAdapter.gl.disableVertexAttribArray(n4);
            GLAdapter.gl.disableVertexAttribArray(n);
            GLAdapter.gl.disableVertexAttribArray(n2);
            GLAdapter.gl.disableVertexAttribArray(n5);
            return renderBucket;
        }

        public static void init() {
            shader = new Shader("linetex_layer_tex");
            mVertexFlipID = GLUtils.glGenBuffers(1)[0];
            byte[] byArray = new byte[2048];
            for (int i = 0; i < 2048; ++i) {
                byArray[i] = (byte)(i % 2);
            }
            Buffer buffer = ByteBuffer.allocateDirect(2048).order(ByteOrder.nativeOrder());
            buffer.put(byArray);
            buffer.flip();
            buffer = buffer.asShortBuffer();
            GLState.bindVertexBuffer(mVertexFlipID);
            GLAdapter.gl.bufferData(34962, 2048, buffer, 35044);
            GLState.bindVertexBuffer(0);
        }

        public static int loadStippleTexture(byte[] byArray) {
            int n;
            int n2 = byArray.length;
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                n3 += byArray[n];
            }
            byte[] byArray2 = new byte[n3];
            int n4 = byArray.length;
            boolean bl = true;
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                int n5 = byArray[n];
                float f = n5;
                for (int i = 0; i < n5; ++i) {
                    float f2 = Math.abs((float)i / (f - 1.0f) - 0.5f);
                    f2 = bl ? (1.0f - f2) * 255.0f : (f2 *= 255.0f);
                    byArray2[n2 + i] = FastMath.clampToByte((int)f2);
                }
                bl ^= true;
                n2 += n5;
            }
            return GLUtils.loadTexture(byArray2, n3, 1, 6406, 9729, 9729, 10497, 10497);
        }
    }

    static class Shader
    extends GLShader {
        int aFlip;
        int aLen0;
        int aLen1;
        int aPos0;
        int aPos1;
        int uBgColor;
        int uColor;
        int uMVP;
        int uMode;
        int uPatternScale;
        int uPatternWidth;
        int uWidth;

        Shader(String string2) {
            if (!this.create(string2)) {
                return;
            }
            this.uMVP = this.getUniform("u_mvp");
            this.uColor = this.getUniform("u_color");
            this.uWidth = this.getUniform("u_width");
            this.uBgColor = this.getUniform("u_bgcolor");
            this.uMode = this.getUniform("u_mode");
            this.uPatternWidth = this.getUniform("u_pwidth");
            this.uPatternScale = this.getUniform("u_pscale");
            this.aPos0 = this.getAttrib("a_pos0");
            this.aPos1 = this.getAttrib("a_pos1");
            this.aLen0 = this.getAttrib("a_len0");
            this.aLen1 = this.getAttrib("a_len1");
            this.aFlip = this.getAttrib("a_flip");
        }
    }
}

