/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.backend.GLAdapter;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.utils.TessJNI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshBucket
extends RenderBucket {
    static final boolean dbgRender = false;
    static final Logger log = LoggerFactory.getLogger(MeshBucket.class);
    public AreaStyle area;
    public float heightOffset;
    private int numPoints;
    private TessJNI tess;

    public MeshBucket(int n) {
        super((byte)3, true, false);
        this.level = n;
    }

    public void addConvexMesh(GeometryBuffer geometryBuffer) {
        short s = (short)this.numVertices;
        if (this.numVertices >= 65536) {
            return;
        }
        this.vertexItems.add(geometryBuffer.points[0] * MapRenderer.COORD_SCALE, geometryBuffer.points[1] * MapRenderer.COORD_SCALE);
        this.vertexItems.add(geometryBuffer.points[2] * MapRenderer.COORD_SCALE, geometryBuffer.points[3] * MapRenderer.COORD_SCALE);
        short s2 = (short)(s + 1);
        this.numVertices += 2;
        short s3 = s2;
        for (int i = 4; i < geometryBuffer.index[0]; i += 2) {
            this.vertexItems.add(geometryBuffer.points[i + 0] * MapRenderer.COORD_SCALE, geometryBuffer.points[i + 1] * MapRenderer.COORD_SCALE);
            VertexData vertexData = this.indiceItems;
            short s4 = (short)(s3 + 1);
            vertexData.add(s, s3, s4);
            ++this.numVertices;
            this.numIndices += 3;
            s3 = s2 = s4;
        }
    }

    public void addMesh(GeometryBuffer geometryBuffer) {
        this.numPoints += geometryBuffer.pointNextPos;
        if (this.tess == null) {
            this.tess = new TessJNI(8);
        }
        this.tess.addContour2D(geometryBuffer.index, geometryBuffer.points);
    }

    @Override
    protected void prepare() {
        int n;
        int n2;
        Object object = this.tess;
        if (object == null) {
            return;
        }
        if (this.numPoints == 0) {
            ((TessJNI)object).dispose();
            return;
        }
        if (!((TessJNI)object).tesselate()) {
            this.tess.dispose();
            log.error("error in tessellation {}", (Object)this.numPoints);
            return;
        }
        int n3 = this.tess.getElementCount() * 3;
        int n4 = this.indiceItems.countSize();
        while (true) {
            n2 = 360;
            if (n4 >= n3) break;
            n = n3 - n4;
            if (n <= 360) {
                n2 = n;
            }
            object = this.indiceItems.obtainChunk();
            this.tess.getElements(((VertexData.Chunk)object).vertices, n4, n2);
            n4 += n2;
            this.indiceItems.releaseChunk(n2);
        }
        int n5 = this.tess.getVertexCount() * 2;
        for (n4 = 0; n4 < n5; n4 += n2) {
            n2 = n = n5 - n4;
            if (n > 360) {
                n2 = 360;
            }
            object = this.vertexItems.obtainChunk();
            this.tess.getVertices(((VertexData.Chunk)object).vertices, n4, n2, MapRenderer.COORD_SCALE);
            this.vertexItems.releaseChunk(n2);
        }
        this.numIndices += n3;
        this.numVertices += n5 >> 1;
        this.tess.dispose();
    }

    public static class Renderer {
        private static final int OPAQUE = -16777216;
        static Shader shader;

        public static RenderBucket draw(RenderBucket renderBucket, GLViewport gLViewport) {
            GLState.blend(true);
            Shader shader = Renderer.shader;
            shader.useProgram();
            GLState.enableVertexArrays(shader.aPos, -1);
            gLViewport.mvp.setAsUniform(shader.uMVP);
            Object object = GLAdapter.gl;
            int n = shader.uHeight;
            float f = 0.0f;
            object.uniform1f(n, 0.0f);
            while (renderBucket != null && renderBucket.type == 3) {
                object = (MeshBucket)renderBucket;
                AreaStyle areaStyle = ((MeshBucket)object).area.current();
                if (areaStyle.heightOffset != ((MeshBucket)object).heightOffset) {
                    ((MeshBucket)object).heightOffset = areaStyle.heightOffset;
                }
                float f2 = f;
                if (((MeshBucket)object).heightOffset != f) {
                    f2 = ((MeshBucket)object).heightOffset;
                    GLAdapter.gl.uniform1f(shader.uHeight, f2 / MercatorProjection.groundResolution(gLViewport.pos));
                }
                if (((MeshBucket)object).area == null) {
                    GLUtils.setColor(shader.uColor, -16776961, 0.4f);
                } else {
                    Renderer.setColor(areaStyle, shader, gLViewport.pos);
                }
                GLAdapter.gl.vertexAttribPointer(shader.aPos, 2, 5122, false, 0, ((MeshBucket)object).vertexOffset);
                GLAdapter.gl.drawElements(4, ((MeshBucket)object).numIndices, 5123, ((MeshBucket)object).indiceOffset);
                renderBucket = (RenderBucket)renderBucket.next;
                f = f2;
            }
            return renderBucket;
        }

        static boolean init() {
            shader = new Shader("mesh_layer_2D");
            return true;
        }

        static void setColor(AreaStyle areaStyle, Shader shader, MapPosition mapPosition) {
            float f = areaStyle.getFade(mapPosition.scale);
            float f2 = areaStyle.getBlend(mapPosition.scale);
            boolean bl = true;
            if (f < 1.0f) {
                GLState.blend(true);
                GLUtils.setColor(shader.uColor, areaStyle.color, f);
            } else if (f2 > 0.0f) {
                if (f2 == 1.0f) {
                    GLUtils.setColor(shader.uColor, areaStyle.blendColor, 1.0f);
                } else {
                    GLUtils.setColorBlend(shader.uColor, areaStyle.color, areaStyle.blendColor, f2);
                }
            } else {
                if ((areaStyle.color & 0xFF000000) == -16777216) {
                    bl = false;
                }
                GLState.blend(bl);
                GLUtils.setColor(shader.uColor, areaStyle.color, 1.0f);
            }
        }

        static class Shader
        extends GLShader {
            int aPos;
            int uColor;
            int uHeight;
            int uMVP;

            Shader(String string2) {
                if (!this.create(string2)) {
                    return;
                }
                this.uMVP = this.getUniform("u_mvp");
                this.uColor = this.getUniform("u_color");
                this.uHeight = this.getUniform("u_height");
                this.aPos = this.getAttrib("a_pos");
            }
        }
    }
}

