/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.backend.canvas.Color;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapPosition;
import org.oscim.core.Tile;
import org.oscim.renderer.GLMatrix;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.HairLineBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.utils.ArrayUtils;
import org.oscim.utils.FastMath;
import org.oscim.utils.geom.LineClipper;
import org.oscim.utils.math.Interpolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PolygonBucket
extends RenderBucket {
    public static final int CLIP_DEPTH = 2;
    public static final int CLIP_STENCIL = 1;
    public static final int CLIP_TEST_DEPTH = 3;
    public static boolean enableTexture;
    static final Logger log;
    public AreaStyle area;
    final float[] bbox = new float[8];
    float xmax = -32768.0f;
    float xmin = 32767.0f;
    float ymax = -32768.0f;
    float ymin = 32767.0f;

    static {
        log = LoggerFactory.getLogger(PolygonBucket.class);
        enableTexture = true;
    }

    PolygonBucket(int n) {
        super((byte)2, true, false);
        this.level = n;
    }

    public void addPolygon(GeometryBuffer geometryBuffer) {
        this.addPolygon(geometryBuffer.points, geometryBuffer.index);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addPolygon(float[] fArray, int[] nArray) {
        short s = (short)((float)(Tile.SIZE >> 1) * MapRenderer.COORD_SCALE);
        boolean bl = this.area.strokeWidth > 0.0f;
        int n = nArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = nArray[n2];
            if (n4 < 0) {
                return;
            }
            if (n4 >= 6) {
                this.vertexItems.add(s, s);
                ++this.numVertices;
                int n5 = n3;
                for (int i = 0; i < n4; i += 2) {
                    int n6 = n5 + 1;
                    float f = fArray[n5] * MapRenderer.COORD_SCALE;
                    float f2 = fArray[n6] * MapRenderer.COORD_SCALE;
                    this.xmax = Math.max(this.xmax, f);
                    this.xmin = Math.min(this.xmin, f);
                    this.ymax = Math.max(this.ymax, f2);
                    this.ymin = Math.min(this.ymin, f2);
                    if (bl) {
                        this.indiceItems.add((short)this.numVertices);
                        ++this.numIndices;
                    }
                    this.vertexItems.add((short)f, (short)f2);
                    ++this.numVertices;
                    if (bl) {
                        this.indiceItems.add((short)this.numVertices);
                        ++this.numIndices;
                    }
                    n5 = n6 + 1;
                }
                this.vertexItems.add((short)(fArray[n3 + 0] * MapRenderer.COORD_SCALE), (short)(fArray[n3 + 1] * MapRenderer.COORD_SCALE));
                ++this.numVertices;
            }
            n3 += n4;
            ++n2;
        }
    }

    @Override
    protected void compile(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        if (this.area.strokeWidth == 0.0f) {
            this.compileVertexItems(shortBuffer);
        } else {
            super.compile(shortBuffer, shortBuffer2);
        }
    }

    @Override
    protected void prepare() {
        ArrayUtils.setBox2D(this.bbox, this.xmin, this.ymin, this.xmax, this.ymax);
    }

    public static final class Renderer {
        public static final int CLIP_BIT = 128;
        private static final int STENCIL_BITS = 8;
        private static PolygonBucket[] mAreaLayer;
        static float[] mBBox;
        private static boolean mClear;
        private static int mCount;
        static LineClipper mScreenClip;
        private static Shader polyShader;
        private static Shader texShader;

        static {
            mBBox = new float[8];
            mScreenClip = new LineClipper(-1.0f, -1.0f, 1.0f, 1.0f);
        }

        private Renderer() {
        }

        static void clearStencilRegion() {
            mCount = 0;
            mClear = false;
            GLAdapter.gl.colorMask(false, false, false, false);
            GLAdapter.gl.stencilMask(255);
            GLAdapter.gl.stencilFunc(514, 128, 128);
            GLAdapter.gl.stencilOp(7680, 7680, 7681);
            GLAdapter.gl.drawArrays(5, 0, 4);
        }

        public static void clip(GLMatrix gLMatrix, int n) {
            Renderer.setShader(polyShader, gLMatrix, true);
            Renderer.drawStencilRegion(n);
            GLAdapter.gl.stencilMask(0);
            GLAdapter.gl.colorMask(true, true, true, true);
        }

        /*
         * Unable to fully structure code
         */
        public static RenderBucket draw(RenderBucket var0, GLViewport var1_1, float var2_2, boolean var3_3) {
            GLState.test(false, true);
            Renderer.setShader(Renderer.polyShader, var1_1.mvp, var3_3);
            var4_4 = var1_1.pos.zoomLevel;
            var5_5 = Renderer.mCount;
            GLAdapter.gl.colorMask(false, false, false, false);
            GLAdapter.gl.stencilOp(7680, 7680, 5386);
            var6_6 = Renderer.mBBox;
            var7_7 = var5_5;
            var8_8 = false;
            var9_9 = 0;
            while (var0 != null && var0.type == 2) {
                var10_10 = (PolygonBucket)var0;
                var11_11 = var10_10.area.current();
                if (var11_11.fadeScale > 0 && var11_11.fadeScale > var4_4) ** GOTO lbl-1000
                if ((double)var2_2 > 0.5) {
                    var1_1.mvp.prj2D(var10_10.bbox, 0, var6_6, 0, 4);
                    var12_12 = 0;
                    var13_13 = 0;
                    while (true) {
                        var14_14 = var13_13;
                        if (var12_12 >= 8) break;
                        var14_14 = Renderer.mScreenClip.outcode(var6_6[var12_12], var6_6[var12_12 + 1]);
                        if (var14_14 == 0) {
                            var14_14 = 0;
                            break;
                        }
                        var13_13 |= var14_14;
                        var12_12 += 2;
                    }
                    if (var14_14 != 0 && var14_14 != 15) {
                        Renderer.mScreenClip.clipStart(var6_6[6], var6_6[7]);
                        var12_12 = 0;
                        for (var13_13 = 0; var13_13 < 8 && var12_12 == 0; var13_13 += 2) {
                            var12_12 = Renderer.mScreenClip.clipNext(var6_6[var13_13], var6_6[var13_13 + 1]);
                        }
                        ** if (var12_12 != 0) goto lbl-1000
                    }
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    var13_13 = var9_9;
                    ** GOTO lbl73
                }
lbl-1000:
                // 2 sources

                {
                    if (Renderer.mClear) {
                        Renderer.clearStencilRegion();
                        GLAdapter.gl.stencilOp(7680, 7680, 5386);
                        var5_5 = 0;
                        var7_7 = 0;
                    }
                    Renderer.mAreaLayer[var7_7] = var10_10;
                    var12_12 = var7_7 + 1;
                    var7_7 = 1 << var7_7;
                    if (var11_11.hasAlpha(var4_4)) {
                        GLAdapter.gl.stencilMask(var7_7);
                        var7_7 = (byte)(var9_9 | var7_7);
                    } else {
                        var7_7 = (byte)(var9_9 | var7_7);
                        GLAdapter.gl.stencilMask(var7_7);
                    }
                    var13_13 = var7_7;
                    GLAdapter.gl.drawArrays(6, var0.vertexOffset, var0.numVertices);
                    if (var12_12 == 7) {
                        Renderer.fillPolygons(var1_1, var5_5, var12_12, var1_1.pos, var2_2);
                        Renderer.mClear = true;
                        if (var0.next != null && ((RenderBucket)var0.next).type == 2) {
                            Renderer.setShader(Renderer.polyShader, var1_1.mvp, false);
                            var5_5 = 0;
                            var7_7 = 0;
                            var8_8 = true;
                            var13_13 = 0;
                        } else {
                            var5_5 = 0;
                            var7_7 = 0;
                            var8_8 = true;
                        }
                    } else {
                        var7_7 = var12_12;
                    }
                }
lbl73:
                // 4 sources

                var0 = (RenderBucket)var0.next;
                var9_9 = var13_13;
            }
            if (var7_7 > 0) {
                Renderer.fillPolygons(var1_1, var5_5, var7_7, var1_1.pos, var2_2);
                var8_8 = true;
            }
            if (!var8_8) {
                GLAdapter.gl.colorMask(true, true, true, true);
                GLAdapter.gl.stencilMask(0);
            }
            Renderer.mCount = var7_7;
            return var0;
        }

        public static void drawOver(GLMatrix gLMatrix, int n, float f) {
            Renderer.setShader(polyShader, gLMatrix, true);
            if (n == 0) {
                GLAdapter.gl.colorMask(false, false, false, false);
            } else {
                GLUtils.setColor(Renderer.polyShader.uColor, n, f);
                GLState.blend(true);
            }
            GLAdapter.gl.stencilFunc(514, 128, 128);
            GLAdapter.gl.stencilMask(255);
            GLState.test(false, true);
            GLAdapter.gl.stencilOp(7680, 7680, 0);
            GLAdapter.gl.drawArrays(5, 0, 4);
            if (n == 0) {
                GLAdapter.gl.colorMask(true, true, true, true);
            }
        }

        static void drawStencilRegion(int n) {
            mCount = 0;
            mClear = false;
            GLAdapter.gl.colorMask(false, false, false, false);
            GLAdapter.gl.stencilMask(255);
            if (n == 2) {
                GLState.test(true, true);
                GLAdapter.gl.depthMask(true);
            } else {
                GLState.test(false, true);
            }
            GLAdapter.gl.stencilFunc(519, 128, 0);
            GLAdapter.gl.stencilOp(7680, 7680, 7681);
            GLAdapter.gl.drawArrays(5, 0, 4);
            if (n == 2) {
                GLAdapter.gl.depthMask(false);
                GLState.test(false, true);
            }
            GLAdapter.gl.stencilFunc(514, 128, 128);
        }

        private static void fillPolygons(GLViewport gLViewport, int n, int n2, MapPosition mapPosition, float f) {
            GLAdapter.gl.colorMask(true, true, true, true);
            GLAdapter.gl.stencilMask(0);
            while (n < n2) {
                float f2;
                float f3;
                Shader shader;
                PolygonBucket polygonBucket = mAreaLayer[n];
                AreaStyle areaStyle = polygonBucket.area.current();
                if (enableTexture && areaStyle.texture != null) {
                    shader = Renderer.setShader(texShader, gLViewport.mvp, false);
                    f3 = FastMath.clamp(Tile.SIZE / areaStyle.texture.width >> 1, 1, Tile.SIZE);
                    f2 = FastMath.clamp((float)mapPosition.getZoomScale() - 1.0f, 0.0f, 1.0f);
                    f2 = Interpolation.exp5.apply(f2);
                    GLAdapter.gl.uniform2f(shader.uScale, f2, f / f3);
                    areaStyle.texture.bind();
                } else {
                    shader = Renderer.setShader(polyShader, gLViewport.mvp, false);
                }
                f2 = areaStyle.getFade(mapPosition.scale);
                f3 = areaStyle.getBlend(mapPosition.scale);
                boolean bl = shader == texShader || (double)f2 < 1.0;
                if ((double)f2 < 1.0) {
                    GLUtils.setColor(shader.uColor, areaStyle.color, f2);
                } else if (f3 > 0.0f) {
                    if (f3 == 1.0f) {
                        GLUtils.setColor(shader.uColor, areaStyle.blendColor, 1.0f);
                    } else {
                        GLUtils.setColorBlend(shader.uColor, areaStyle.color, areaStyle.blendColor, f3);
                    }
                } else {
                    bl |= Color.isOpaque(areaStyle.color) ^ true;
                    GLUtils.setColor(shader.uColor, areaStyle.color, f2);
                }
                GLState.blend(bl);
                GLAdapter.gl.stencilFunc(514, 255, 1 << n | 0x80);
                GLAdapter.gl.drawArrays(5, 0, 4);
                if (!(areaStyle.strokeWidth <= 0.0f)) {
                    GLAdapter.gl.stencilFunc(514, 128, 128);
                    GLState.blend(true);
                    HairLineBucket.Renderer.shader.set(gLViewport);
                    GLUtils.setColor(HairLineBucket.Renderer.shader.uColor, polygonBucket.area.strokeColor, 1.0f);
                    GLAdapter.gl.vertexAttribPointer(HairLineBucket.Renderer.shader.aPos, 2, 5122, false, 0, polygonBucket.vertexOffset << 2);
                    GLAdapter.gl.uniform1f(HairLineBucket.Renderer.shader.uWidth, areaStyle.strokeWidth);
                    GLAdapter.gl.drawElements(1, polygonBucket.numIndices, 5123, polygonBucket.indiceOffset);
                    GLAdapter.gl.lineWidth(1.0f);
                }
                ++n;
            }
        }

        static boolean init() {
            polyShader = new Shader("base_shader");
            texShader = new Shader("polygon_layer_tex");
            mAreaLayer = new PolygonBucket[8];
            return true;
        }

        private static Shader setShader(Shader shader, GLMatrix gLMatrix, boolean bl) {
            if (shader.useProgram() || bl) {
                GLState.enableVertexArrays(shader.aPos, -1);
                GLAdapter.gl.vertexAttribPointer(shader.aPos, 2, 5122, false, 0, 0);
                gLMatrix.setAsUniform(shader.uMVP);
            }
            return shader;
        }
    }

    static class Shader
    extends GLShader {
        int aPos;
        int uColor;
        int uMVP;
        int uScale;

        Shader(String string2) {
            if (!this.create(string2)) {
                return;
            }
            this.uMVP = this.getUniform("u_mvp");
            this.aPos = this.getAttrib("a_pos");
            this.uColor = this.getUniform("u_color");
            if ("polygon_layer_tex".equals(string2)) {
                this.uScale = this.getUniform("u_scale");
            }
        }
    }
}

