/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.utils.pool.Inlist;

public abstract class RenderBucket
extends Inlist<RenderBucket> {
    public static final byte BITMAP = 7;
    public static final byte CIRCLE = 8;
    static final VertexData EMPTY = new VertexData();
    public static final byte EXTRUSION = 4;
    public static final byte HAIRLINE = 5;
    public static final byte LINE = 0;
    public static final byte MESH = 3;
    public static final byte POLYGON = 2;
    public static final byte SYMBOL = 6;
    public static final byte TEXLINE = 1;
    protected final VertexData indiceItems;
    protected int indiceOffset;
    int level;
    protected int numIndices;
    protected int numVertices;
    final boolean quads;
    public final byte type;
    protected final VertexData vertexItems;
    protected int vertexOffset;

    protected RenderBucket(byte by, boolean bl, boolean bl2) {
        this.type = by;
        this.vertexItems = new VertexData();
        this.indiceItems = bl ? new VertexData() : EMPTY;
        this.quads = bl2;
    }

    protected void clear() {
        this.vertexItems.dispose();
        this.indiceItems.dispose();
        this.numVertices = 0;
        this.numIndices = 0;
    }

    protected void compile(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        this.compileVertexItems(shortBuffer);
        if (shortBuffer2 != null) {
            this.compileIndicesItems(shortBuffer2);
        }
    }

    protected void compileIndicesItems(ShortBuffer shortBuffer) {
        VertexData vertexData = this.indiceItems;
        if (vertexData != null && !vertexData.empty()) {
            this.indiceOffset = shortBuffer.position() * 2;
            this.indiceItems.compile(shortBuffer);
        }
    }

    protected void compileVertexItems(ShortBuffer shortBuffer) {
        this.vertexOffset = shortBuffer.position() * 2;
        this.vertexItems.compile(shortBuffer);
    }

    public int getIndiceOffset() {
        return this.indiceOffset;
    }

    public int getVertexOffset() {
        return this.vertexOffset;
    }

    protected void prepare() {
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setVertexOffset(int n) {
        this.vertexOffset = n;
    }
}

