/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.Buffer;
import java.nio.ShortBuffer;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.renderer.BufferObject;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.BitmapBucket;
import org.oscim.renderer.bucket.CircleBucket;
import org.oscim.renderer.bucket.HairLineBucket;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.LineTexBucket;
import org.oscim.renderer.bucket.MeshBucket;
import org.oscim.renderer.bucket.PolygonBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.CircleStyle;
import org.oscim.theme.styles.LineStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderBuckets
extends MapTile.TileData {
    private static final int SHORT_BYTES = 2;
    public static final int[] VERTEX_SHORT_CNT;
    private static short[] fillCoords;
    static final Logger log;
    private RenderBucket buckets;
    public BufferObject ibo;
    private RenderBucket mCurBucket;
    public int[] offset = new int[]{0, 0};
    public BufferObject vbo;

    static {
        log = LoggerFactory.getLogger(RenderBuckets.class);
        VERTEX_SHORT_CNT = new int[]{4, 6, 2, 2, 4, 2, 6, 6, 2};
        short s = (short)((float)Tile.SIZE * MapRenderer.COORD_SCALE);
        fillCoords = new short[]{0, s, s, s, 0, 0, s, 0};
    }

    private int countIboSize() {
        RenderBucket renderBucket = this.buckets;
        int n = 0;
        while (renderBucket != null) {
            n += renderBucket.numIndices;
            renderBucket = (RenderBucket)renderBucket.next;
        }
        return n;
    }

    private int countVboSize() {
        RenderBucket renderBucket = this.buckets;
        int n = 0;
        while (renderBucket != null) {
            n += renderBucket.numVertices * VERTEX_SHORT_CNT[renderBucket.type];
            renderBucket = (RenderBucket)renderBucket.next;
        }
        return n;
    }

    private RenderBucket getBucket(int n, int n2) {
        RenderBucket renderBucket;
        RenderBucket renderBucket2;
        RenderBucket renderBucket3;
        block25: {
            renderBucket3 = this.mCurBucket;
            if (renderBucket3 != null && renderBucket3.level == n) {
                renderBucket3 = this.mCurBucket;
                if (renderBucket3.type == n2) {
                    return renderBucket3;
                }
                log.error("BUG wrong bucket {} {} on level {}", (int)renderBucket3.type, n2, n);
                throw new IllegalArgumentException();
            }
            renderBucket2 = this.buckets;
            Object var5_5 = null;
            if (renderBucket2 != null && renderBucket2.level <= n) {
                renderBucket = this.mCurBucket;
                renderBucket3 = renderBucket2;
                if (renderBucket != null) {
                    renderBucket3 = renderBucket2;
                    if (n > renderBucket.level) {
                        renderBucket3 = this.mCurBucket;
                    }
                }
                while (true) {
                    if (renderBucket3.level == n) {
                        renderBucket2 = renderBucket3;
                        renderBucket = renderBucket3;
                        break block25;
                    }
                    renderBucket = renderBucket3;
                    renderBucket2 = var5_5;
                    if (renderBucket3.next == null) break block25;
                    if (((RenderBucket)renderBucket3.next).level > n) {
                        renderBucket = renderBucket3;
                        renderBucket2 = var5_5;
                        break block25;
                    }
                    renderBucket3 = (RenderBucket)renderBucket3.next;
                }
            }
            renderBucket = null;
            renderBucket2 = var5_5;
        }
        renderBucket3 = renderBucket2;
        if (renderBucket2 == null) {
            if (n2 == 0) {
                renderBucket3 = new LineBucket(n);
            } else if (n2 == 2) {
                renderBucket3 = new PolygonBucket(n);
            } else if (n2 == 1) {
                renderBucket3 = new LineTexBucket(n);
            } else if (n2 == 3) {
                renderBucket3 = new MeshBucket(n);
            } else if (n2 == 5) {
                renderBucket3 = new HairLineBucket(n);
            } else {
                renderBucket3 = renderBucket2;
                if (n2 == 8) {
                    renderBucket3 = new CircleBucket(n);
                }
            }
            if (renderBucket3 != null) {
                if (renderBucket == null) {
                    renderBucket3.next = this.buckets;
                    this.buckets = renderBucket3;
                } else {
                    renderBucket3.next = renderBucket.next;
                    renderBucket.next = renderBucket3;
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
        if (renderBucket3.type == n2) {
            this.mCurBucket = renderBucket3;
            return renderBucket3;
        }
        log.error("BUG wrong bucket {} {} on level {}", (int)renderBucket3.type, n2, n);
        throw new IllegalArgumentException();
    }

    public static void initRenderer() {
        LineBucket.Renderer.init();
        LineTexBucket.Renderer.init();
        PolygonBucket.Renderer.init();
        TextureBucket.Renderer.init();
        BitmapBucket.Renderer.init();
        MeshBucket.Renderer.init();
        HairLineBucket.Renderer.init();
        CircleBucket.Renderer.init();
    }

    public CircleBucket addCircleBucket(int n, CircleStyle circleStyle) {
        CircleBucket circleBucket = (CircleBucket)this.getBucket(n, 8);
        if (circleBucket == null) {
            return null;
        }
        circleBucket.circle = circleStyle;
        return circleBucket;
    }

    public HairLineBucket addHairLineBucket(int n, LineStyle lineStyle) {
        HairLineBucket hairLineBucket = this.getHairLineBucket(n);
        if (hairLineBucket == null) {
            return null;
        }
        hairLineBucket.line = lineStyle;
        return hairLineBucket;
    }

    public LineBucket addLineBucket(int n, LineStyle lineStyle) {
        LineBucket lineBucket = (LineBucket)this.getBucket(n, 0);
        if (lineBucket == null) {
            return null;
        }
        lineBucket.scale = 1.0f;
        lineBucket.line = lineStyle;
        return lineBucket;
    }

    public MeshBucket addMeshBucket(int n, AreaStyle areaStyle) {
        MeshBucket meshBucket = (MeshBucket)this.getBucket(n, 3);
        if (meshBucket == null) {
            return null;
        }
        meshBucket.area = areaStyle;
        return meshBucket;
    }

    public PolygonBucket addPolygonBucket(int n, AreaStyle areaStyle) {
        PolygonBucket polygonBucket = (PolygonBucket)this.getBucket(n, 2);
        if (polygonBucket == null) {
            return null;
        }
        polygonBucket.area = areaStyle;
        return polygonBucket;
    }

    public void bind() {
        BufferObject bufferObject = this.vbo;
        if (bufferObject != null) {
            bufferObject.bind();
        }
        if ((bufferObject = this.ibo) != null) {
            bufferObject.bind();
        }
    }

    public void clear() {
        this.set(null);
        this.mCurBucket = null;
        this.vbo = BufferObject.release(this.vbo);
        this.ibo = BufferObject.release(this.ibo);
    }

    public void clearBuckets() {
        RenderBucket renderBucket = this.buckets;
        while (renderBucket != null) {
            renderBucket.clear();
            renderBucket = (RenderBucket)renderBucket.next;
        }
        this.mCurBucket = null;
    }

    public boolean compile(boolean bl) {
        int n = this.countVboSize();
        if (n <= 0) {
            this.vbo = BufferObject.release(this.vbo);
            this.ibo = BufferObject.release(this.ibo);
            return false;
        }
        int n2 = n;
        if (bl) {
            n2 = n + 8;
        }
        Object object = MapRenderer.getShortBuffer(n2);
        if (bl) {
            ((ShortBuffer)object).put(fillCoords, 0, 8);
        }
        Object object2 = null;
        int n3 = this.countIboSize();
        if (n3 > 0) {
            object2 = MapRenderer.getShortBuffer(n3);
        }
        n = bl ? 4 : 0;
        Object object3 = this.buckets;
        int n4 = n;
        while (object3 != null) {
            n = n4;
            if (((RenderBucket)object3).type == 2) {
                ((RenderBucket)object3).compile((ShortBuffer)object, (ShortBuffer)object2);
                ((RenderBucket)object3).vertexOffset = n4;
                n = n4 + ((RenderBucket)object3).numVertices;
            }
            object3 = (RenderBucket)((RenderBucket)object3).next;
            n4 = n;
        }
        this.offset[0] = ((Buffer)object).position() * 2;
        object3 = this.buckets;
        n4 = 0;
        while (object3 != null) {
            n = n4;
            if (((RenderBucket)object3).type == 0) {
                ((RenderBucket)object3).compile((ShortBuffer)object, (ShortBuffer)object2);
                ((RenderBucket)object3).vertexOffset = n4;
                n = n4 + ((RenderBucket)object3).numVertices;
            }
            object3 = (RenderBucket)((RenderBucket)object3).next;
            n4 = n;
        }
        object3 = this.buckets;
        while (object3 != null) {
            if (((RenderBucket)object3).type != 0 && ((RenderBucket)object3).type != 2) {
                ((RenderBucket)object3).compile((ShortBuffer)object, (ShortBuffer)object2);
            }
            object3 = (RenderBucket)((RenderBucket)object3).next;
        }
        if (n2 != ((Buffer)object).position()) {
            object2 = log;
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("wrong vertex buffer size:  new size: ");
            ((StringBuilder)object3).append(n2);
            ((StringBuilder)object3).append(" buffer pos: ");
            ((StringBuilder)object3).append(((Buffer)object).position());
            ((StringBuilder)object3).append(" buffer limit: ");
            ((StringBuilder)object3).append(((Buffer)object).limit());
            ((StringBuilder)object3).append(" buffer fill: ");
            ((StringBuilder)object3).append(((Buffer)object).remaining());
            object2.debug(((StringBuilder)object3).toString());
            return false;
        }
        if (n3 > 0 && n3 != ((Buffer)object2).position()) {
            object = log;
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("wrong indice buffer size:  new size: ");
            ((StringBuilder)object3).append(n3);
            ((StringBuilder)object3).append(" buffer pos: ");
            ((StringBuilder)object3).append(((Buffer)object2).position());
            ((StringBuilder)object3).append(" buffer limit: ");
            ((StringBuilder)object3).append(((Buffer)object2).limit());
            ((StringBuilder)object3).append(" buffer fill: ");
            ((StringBuilder)object3).append(((Buffer)object2).remaining());
            object.debug(((StringBuilder)object3).toString());
            return false;
        }
        if (this.vbo == null) {
            this.vbo = BufferObject.get(34962, n2);
        }
        this.vbo.loadBufferData(((ShortBuffer)object).flip(), n2 * 2);
        if (n3 > 0) {
            if (this.ibo == null) {
                this.ibo = BufferObject.get(34963, n3);
            }
            this.ibo.loadBufferData(((ShortBuffer)object2).flip(), n3 * 2);
        }
        return true;
    }

    @Override
    protected void dispose() {
        this.clear();
    }

    public RenderBucket get() {
        return this.buckets;
    }

    public CircleBucket getCircleBucket(int n) {
        return (CircleBucket)this.getBucket(n, 8);
    }

    public HairLineBucket getHairLineBucket(int n) {
        return (HairLineBucket)this.getBucket(n, 5);
    }

    public LineBucket getLineBucket(int n) {
        return (LineBucket)this.getBucket(n, 0);
    }

    public LineTexBucket getLineTexBucket(int n) {
        return (LineTexBucket)this.getBucket(n, 1);
    }

    public MeshBucket getMeshBucket(int n) {
        return (MeshBucket)this.getBucket(n, 3);
    }

    public PolygonBucket getPolygonBucket(int n) {
        return (PolygonBucket)this.getBucket(n, 2);
    }

    public void prepare() {
        RenderBucket renderBucket = this.buckets;
        while (renderBucket != null) {
            renderBucket.prepare();
            renderBucket = (RenderBucket)renderBucket.next;
        }
    }

    public void set(RenderBucket renderBucket) {
        RenderBucket renderBucket2 = this.buckets;
        while (renderBucket2 != null) {
            renderBucket2.clear();
            renderBucket2 = (RenderBucket)renderBucket2.next;
        }
        this.buckets = renderBucket;
    }

    public void setFrom(RenderBuckets renderBuckets) {
        if (renderBuckets != this) {
            this.set(renderBuckets.buckets);
            this.mCurBucket = null;
            renderBuckets.buckets = null;
            renderBuckets.mCurBucket = null;
            return;
        }
        throw new IllegalArgumentException("Cannot set from oneself!");
    }
}

