/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.Buffer;
import java.nio.ShortBuffer;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.GLMatrix;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SymbolBucket
extends TextureBucket {
    private static final int LBIT_MASK = -2;
    private static final int VERTICES_PER_SPRITE = 4;
    static final Logger log = LoggerFactory.getLogger(SymbolBucket.class);
    private Inlist.List<SymbolItem> mSymbols = new Inlist.List();
    private final float[] points = new float[8];
    private TextureItem prevTextures;
    private final GLMatrix rotationMatrix = new GLMatrix();
    private final GLMatrix translateMatrix = new GLMatrix();

    public SymbolBucket() {
        super((byte)6);
        this.fixed = true;
    }

    private TextureItem getTexture(Bitmap bitmap) {
        TextureItem textureItem = this.prevTextures;
        while (textureItem != null) {
            if (textureItem.bitmap == bitmap) {
                this.prevTextures = Inlist.remove(this.prevTextures, textureItem);
                this.textures = Inlist.appendItem(this.textures, textureItem);
                textureItem.offset = 0;
                textureItem.indices = 0;
                return textureItem;
            }
            textureItem = (TextureItem)textureItem.next;
        }
        return null;
    }

    public void addSymbol(SymbolItem symbolItem) {
        this.numVertices += 4;
        for (SymbolItem symbolItem2 : this.mSymbols) {
            if (symbolItem2.bitmap != symbolItem.bitmap) continue;
            symbolItem.next = symbolItem2.next;
            symbolItem2.next = symbolItem;
            return;
        }
        this.mSymbols.push(symbolItem);
    }

    @Override
    public void clear() {
        super.clear();
        this.clearItems();
    }

    public void clearItems() {
        SymbolItem.pool.releaseAll(this.mSymbols.clear());
    }

    @Override
    protected void compile(ShortBuffer object, ShortBuffer object2) {
        this.vertexOffset = ((Buffer)object).position() * 2;
        this.prevTextures = this.textures;
        this.textures = null;
        Object object3 = this.mSymbols.head();
        Object object4 = object2 = null;
        int n = 0;
        while (object3 != null) {
            block24: {
                int n2;
                int n3;
                short s;
                short s2;
                Object object5;
                Object object6;
                block23: {
                    block20: {
                        block22: {
                            block21: {
                                if (((SymbolItem)object3).texRegion == null) break block20;
                                if (((SymbolItem)object3).texRegion.texture.id == -1) {
                                    ((SymbolItem)object3).texRegion.texture.upload();
                                }
                                if (this.textures == null || object2 == null) break block21;
                                object6 = object2;
                                object5 = object4;
                                if (((TextureItem)object2).id == ((SymbolItem)object3).texRegion.texture.id) break block22;
                            }
                            s2 = object4 != null ? ((TextureItem)object4).offset + ((TextureItem)object4).indices : (short)0;
                            object5 = TextureItem.clone(((SymbolItem)object3).texRegion.texture);
                            ((TextureItem)object5).offset = s2;
                            this.textures = (TextureItem)Inlist.appendItem(this.textures, object5);
                            object6 = object5;
                        }
                        object2 = ((SymbolItem)object3).texRegion.rect;
                        s2 = ((TextureAtlas.Rect)object2).x;
                        s = ((TextureAtlas.Rect)object2).y;
                        n3 = ((TextureAtlas.Rect)object2).w;
                        n2 = ((TextureAtlas.Rect)object2).h;
                        object4 = object6;
                        break block23;
                    }
                    if (((SymbolItem)object3).bitmap == null) break block24;
                    object5 = object4 = this.getTexture(((SymbolItem)object3).bitmap);
                    if (object4 == null) {
                        object5 = new TextureItem(((SymbolItem)object3).bitmap);
                        this.textures = (TextureItem)Inlist.appendItem(this.textures, object5);
                        ((TextureItem)object5).offset = n;
                        ((TextureItem)object5).indices = 0;
                    }
                    n3 = ((TextureItem)object5).width;
                    n2 = ((TextureItem)object5).height;
                    s2 = 0;
                    s = 0;
                    object4 = object2;
                }
                short s3 = (short)(MapRenderer.COORD_SCALE * (float)s2);
                short s4 = (short)(MapRenderer.COORD_SCALE * (float)s);
                short s5 = (short)(MapRenderer.COORD_SCALE * (float)(s2 + n3));
                short s6 = (short)(MapRenderer.COORD_SCALE * (float)(s + n2));
                object6 = null;
                object2 = object3;
                short s7 = 0;
                short s8 = 0;
                s = 0;
                s2 = 0;
                short s9 = s4;
                SymbolItem symbolItem = object3;
                while (object2 != null) {
                    float f;
                    float f2;
                    float f3;
                    float f4;
                    float f5;
                    if (((SymbolItem)object2).rotation == 0.0f) {
                        short s10;
                        short s11;
                        short s12;
                        short s13;
                        if (symbolItem.bitmap != null && symbolItem.bitmap != ((SymbolItem)object2).bitmap || symbolItem.texRegion != null && symbolItem.texRegion != ((SymbolItem)object2).texRegion) break;
                        if (object2 != symbolItem && ((SymbolItem)object2).offset == object6) {
                            object3 = object6;
                            s13 = s8;
                            s12 = s7;
                            s11 = s;
                            s10 = s2;
                        } else {
                            object3 = ((SymbolItem)object2).offset;
                            if (((SymbolItem)object2).offset == null) {
                                f5 = (float)n3 / 2.0f;
                                f4 = (float)n2 / 2.0f;
                                f3 = MapRenderer.COORD_SCALE;
                                s7 = (short)(-f5 * f3);
                                s = (short)(f5 * MapRenderer.COORD_SCALE);
                                s2 = (short)(MapRenderer.COORD_SCALE * f4);
                                f5 = MapRenderer.COORD_SCALE;
                                s8 = (short)(-f4 * f5);
                                s13 = s2;
                                s12 = s7;
                                s11 = s8;
                                s10 = s;
                            } else {
                                f5 = ((SymbolItem)object2).offset.x;
                                f4 = n3;
                                f3 = f5 * f4;
                                f2 = ((SymbolItem)object2).offset.y;
                                f5 = n2;
                                f = MapRenderer.COORD_SCALE;
                                s = (short)(-f3 * f);
                                s2 = (short)(MapRenderer.COORD_SCALE * (f4 - f3));
                                s7 = (short)(MapRenderer.COORD_SCALE * (f5 - (f2 *= f5)));
                                s8 = (short)(MapRenderer.COORD_SCALE * -f2);
                                s10 = s2;
                                s11 = s8;
                                s12 = s;
                                s13 = s7;
                            }
                        }
                        short s14 = (short)((int)(MapRenderer.COORD_SCALE * ((SymbolItem)object2).x) & 0xFFFFFFFE | ((SymbolItem)object2).billboard);
                        short s15 = (short)(MapRenderer.COORD_SCALE * ((SymbolItem)object2).y);
                        this.vertexItems.add(s14, s15, s12, s13, s3, s6);
                        this.vertexItems.add(s14, s15, s12, s11, s3, s9);
                        this.vertexItems.add(s14, s15, s10, s13, s5, s6);
                        object6 = this.vertexItems;
                        ((VertexData)object6).add(s14, s15, s10, s11, s5, s9);
                        s8 = s13;
                        s7 = s12;
                        s2 = s10;
                        object6 = object3;
                        s = s11;
                    } else {
                        short s16;
                        object3 = object2;
                        if (symbolItem.bitmap != null && symbolItem.bitmap != ((SymbolItem)object3).bitmap && symbolItem.rotation != ((SymbolItem)object3).rotation || symbolItem.texRegion != null && symbolItem.texRegion != ((SymbolItem)object3).texRegion && symbolItem.rotation != ((SymbolItem)object3).rotation) break;
                        if (((SymbolItem)object3).offset == null) {
                            s16 = 0;
                            s4 = 0;
                        } else {
                            f4 = n3;
                            s16 = (short)((f4 / 2.0f - ((SymbolItem)object3).offset.x * f4) * MapRenderer.COORD_SCALE);
                            f4 = n2;
                            s4 = (short)((f4 / 2.0f - ((SymbolItem)object3).offset.y * f4) * MapRenderer.COORD_SCALE);
                        }
                        f5 = (float)n3 / 2.0f;
                        f2 = (float)n2 / 2.0f;
                        f4 = MapRenderer.COORD_SCALE * -f5;
                        f5 = MapRenderer.COORD_SCALE * f5;
                        f3 = MapRenderer.COORD_SCALE * f2;
                        f2 = MapRenderer.COORD_SCALE * -f2;
                        Object object7 = this.points;
                        object7[0] = f4;
                        object7[1] = f3;
                        object7[2] = f4;
                        object7[3] = f2;
                        object7[6] = f5;
                        object7[7] = f2;
                        object7[4] = f5;
                        object7[5] = f3;
                        if (((SymbolItem)object3).rotation != 0.0f) {
                            this.rotationMatrix.setRotation(((SymbolItem)object3).rotation, 0.0f, 0.0f, 1.0f);
                            this.rotationMatrix.prj2D(this.points, 0, 4);
                        }
                        s16 = (short)(((int)(MapRenderer.COORD_SCALE * ((SymbolItem)object3).x) & 0xFFFFFFFE | ((SymbolItem)object3).billboard) + s16);
                        s4 = (short)(MapRenderer.COORD_SCALE * ((SymbolItem)object3).y + (float)s4);
                        object3 = this.vertexItems;
                        f3 = s16;
                        f4 = s4;
                        object7 = this.points;
                        f2 = object7[0];
                        float f6 = object7[1];
                        f = s3;
                        f5 = s6;
                        ((VertexData)object3).add(f3, f4, f2, f6, f, f5);
                        object7 = this.vertexItems;
                        object3 = this.points;
                        f6 = (float)object3[2];
                        Object object8 = object3[3];
                        f2 = s9;
                        object7.add(f3, f4, f6, (float)object8, f, f2);
                        object3 = this.vertexItems;
                        object7 = this.points;
                        f6 = object7[4];
                        f = object7[5];
                        object8 = (float)s5;
                        ((VertexData)object3).add(f3, f4, f6, f, (float)object8, f5);
                        object3 = this.vertexItems;
                        object7 = this.points;
                        ((VertexData)object3).add(f3, f4, object7[6], object7[7], (float)object8, f2);
                    }
                    ((TextureItem)object5).indices += 6;
                    object2 = (SymbolItem)((SymbolItem)object2).next;
                    s9 = s4 = s9;
                }
                s2 = ((TextureItem)object5).indices;
                object3 = object2;
                object2 = object4;
                n += s2;
                object4 = object5;
                continue;
            }
            log.debug("Bad SymbolItem");
        }
        this.vertexItems.compile((ShortBuffer)object);
        for (object = this.prevTextures; object != null; object = ((TextureItem)object).dispose()) {
        }
        this.prevTextures = null;
    }

    public void pushSymbol(SymbolItem symbolItem) {
        this.numVertices += 4;
        this.mSymbols.push(symbolItem);
    }
}

