/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Canvas;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.renderer.bucket.TextureBucket;
import org.oscim.renderer.bucket.TextureItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextBucket
extends TextureBucket {
    protected static final int LBIT_MASK = -2;
    static final Logger log = LoggerFactory.getLogger(TextBucket.class);
    protected static int mFontPadX = 1;
    public TextItem labels;
    protected final Canvas mCanvas = CanvasAdapter.newCanvas();

    public TextBucket() {
        super((byte)6);
        this.fixed = true;
        this.level = -1;
    }

    protected void addItem(TextItem textItem, float f, float f2, float f3, float f4) {
        short s;
        short s2;
        short s3;
        short s4;
        short s5;
        short s6;
        short s7;
        short s8;
        short s9 = (short)(MapRenderer.COORD_SCALE * f3);
        short s10 = (short)(MapRenderer.COORD_SCALE * f4);
        short s11 = (short)(MapRenderer.COORD_SCALE * (f3 + f));
        short s12 = (short)(MapRenderer.COORD_SCALE * (f4 + f2));
        f3 = f / 2.0f;
        f2 /= 2.0f;
        if (textItem.text.caption) {
            short s13;
            short s14;
            short s15 = (short)(MapRenderer.COORD_SCALE * -f3);
            short s16 = (short)(MapRenderer.COORD_SCALE * f3);
            short s17 = (short)(MapRenderer.COORD_SCALE * (textItem.text.dy + f2));
            short s18 = s14 = (short)(MapRenderer.COORD_SCALE * (textItem.text.dy - f2));
            short s19 = s16;
            short s20 = s17;
            s8 = s13 = s15;
            s7 = s17;
            s6 = s15;
            s5 = s14;
            s4 = s16;
            s3 = s20;
            s2 = s19;
            s = s18;
        } else {
            f4 = textItem.x1 - textItem.x2;
            f = textItem.y1 - textItem.y2;
            float f5 = (float)Math.sqrt(f4 * f4 + f * f);
            f4 /= f5;
            f5 = f / f5;
            f = -f5 * f2;
            f2 *= f4;
            f4 *= f3;
            f3 = f5 * f3;
            short s21 = (short)(MapRenderer.COORD_SCALE * (f4 - f));
            short s22 = (short)(MapRenderer.COORD_SCALE * (f3 - f2));
            float f6 = MapRenderer.COORD_SCALE;
            f5 = -f4;
            short s23 = (short)(f6 * (f5 - f));
            float f7 = MapRenderer.COORD_SCALE;
            f6 = -f3;
            short s24 = (short)(f7 * (f6 - f2));
            short s25 = (short)((f5 + f) * MapRenderer.COORD_SCALE);
            short s26 = (short)((f6 + f2) * MapRenderer.COORD_SCALE);
            short s27 = (short)((f4 + f) * MapRenderer.COORD_SCALE);
            short s28 = (short)(MapRenderer.COORD_SCALE * (f3 + f2));
            s = s26;
            s2 = s25;
            s3 = s24;
            s4 = s23;
            s5 = s28;
            s6 = s27;
            s7 = s22;
            s8 = s21;
        }
        short s29 = (short)((int)(MapRenderer.COORD_SCALE * textItem.x) & 0xFFFFFFFE | textItem.text.caption);
        short s30 = (short)(MapRenderer.COORD_SCALE * textItem.y);
        this.vertexItems.add(s29, s30, s8, s7, s9, s12);
        this.vertexItems.add(s29, s30, s6, s5, s9, s10);
        this.vertexItems.add(s29, s30, s4, s3, s11, s12);
        this.vertexItems.add(s29, s30, s2, s, s11, s10);
    }

    public void addText(TextItem textItem) {
        TextItem textItem2 = this.labels;
        while (textItem2 != null) {
            if (textItem.text == textItem2.text) {
                while (textItem2.next != null && textItem.text == ((TextItem)textItem2.next).text && textItem.label != textItem2.label && !textItem.label.equals(textItem2.label)) {
                    textItem2 = (TextItem)textItem2.next;
                }
                if (textItem.label != textItem2.label && textItem.label.equals(textItem2.label)) {
                    textItem.label = textItem2.label;
                }
                textItem.next = textItem2.next;
                textItem2.next = textItem;
                return;
            }
            textItem2 = (TextItem)textItem2.next;
        }
        textItem.next = this.labels;
        this.labels = textItem;
    }

    @Override
    public void clear() {
        super.clear();
        this.clearLabels();
    }

    public void clearLabels() {
        this.labels = TextItem.pool.releaseAll(this.labels);
    }

    public TextItem getLabels() {
        return this.labels;
    }

    @Override
    public void prepare() {
        TextureItem textureItem;
        this.textures = textureItem = pool.get();
        this.mCanvas.setBitmap(textureItem.bitmap);
        TextItem textItem = this.labels;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        while (textItem != null) {
            int n4;
            float f3;
            float f4;
            float f5;
            block8: {
                block9: {
                    block6: {
                        block7: {
                            f5 = textItem.width + (float)(mFontPadX * 2);
                            f3 = f4 = (float)((int)textItem.text.fontHeight) + 0.5f;
                            if (f4 > 256.0f) {
                                f3 = 256.0f;
                            }
                            n4 = n3;
                            if (f3 > (float)n3) {
                                n4 = (int)f3;
                            }
                            if (!(f + f5 > 1024.0f)) break block6;
                            f2 += (float)n4;
                            n3 = (int)(0.5f + f3);
                            if (!(f2 + f3 > 256.0f)) break block7;
                            textureItem.offset = n;
                            textureItem.indices = n2 - n;
                            textureItem.next = pool.get();
                            textureItem = (TextureItem)textureItem.next;
                            this.mCanvas.setBitmap(textureItem.bitmap);
                            n = (int)f3;
                            n3 = n2;
                            f = 0.0f;
                            f2 = 0.0f;
                            break block8;
                        }
                        f = 0.0f;
                        break block9;
                    }
                    n3 = n4;
                }
                n4 = n;
                n = n3;
                n3 = n4;
            }
            f4 = textItem.text.fontDescent;
            this.mCanvas.drawText(textItem.label, f, f2 + f3 - f4, textItem.text.paint, textItem.text.stroke);
            if (f5 > 1024.0f) {
                f5 = 1024.0f;
            }
            while (textItem != null) {
                this.addItem(textItem, f5, f3, f, f2);
                n2 += 6;
                this.numVertices += 4;
                if (textItem.next != null && ((TextItem)textItem.next).text == textItem.text && ((TextItem)textItem.next).label == textItem.label) {
                    textItem = (TextItem)textItem.next;
                    continue;
                }
                textItem = (TextItem)textItem.next;
                break;
            }
            f += f5;
            n4 = n3;
            n3 = n;
            n = n4;
        }
        textureItem.offset = n;
        textureItem.indices = n2 - n;
    }

    public void setLabels(TextItem textItem) {
        this.labels = textItem;
    }
}

