/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.theme.styles.TextStyle;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.SyncPool;

public class TextItem
extends Inlist<TextItem> {
    private static final int MAX_POOL = 250;
    public static final SyncPool<TextItem> pool = new SyncPool<TextItem>(250){

        @Override
        protected boolean clearItem(TextItem textItem) {
            textItem.label = null;
            textItem.text = null;
            return true;
        }

        @Override
        protected TextItem createItem() {
            return new TextItem();
        }
    };
    public byte edges;
    public String label;
    public short length;
    public TextStyle text;
    public float width;
    public float x;
    public float x1;
    public float x2;
    public float y;
    public float y1;
    public float y2;

    public static TextItem copy(TextItem textItem) {
        TextItem textItem2 = pool.get();
        textItem2.x = textItem.x;
        textItem2.y = textItem.y;
        textItem2.x1 = textItem.x1;
        textItem2.y1 = textItem.y1;
        textItem2.x2 = textItem.x2;
        textItem2.y2 = textItem.y2;
        return textItem2;
    }

    public TextItem set(float f, float f2, String string2, TextStyle textStyle) {
        this.x = f;
        this.y = f2;
        this.label = string2;
        this.text = textStyle;
        this.x1 = 0.0f;
        this.y1 = 0.0f;
        this.x2 = 1.0f;
        this.y2 = 0.0f;
        this.width = textStyle.paint.measureText(string2);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.x);
        stringBuilder.append(" ");
        stringBuilder.append(this.y);
        stringBuilder.append(" ");
        stringBuilder.append(this.label);
        return stringBuilder.toString();
    }
}

