/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.backend.GL;
import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.TextureItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextureBucket
extends RenderBucket {
    public static final int INDICES_PER_SPRITE = 6;
    static final int POOL_FILL = 4;
    static final int SHORTS_PER_VERTICE = 6;
    public static final int TEXTURE_HEIGHT = 256;
    public static final int TEXTURE_WIDTH = 1024;
    static final int VERTICES_PER_SPRITE = 4;
    static final Logger log = LoggerFactory.getLogger(TextureBucket.class);
    public static final TextureItem.TexturePool pool = new TextureItem.TexturePool(4, 1024, 256, false);
    static Shader shader;
    public boolean fixed;
    public TextureItem textures;

    public TextureBucket(byte by) {
        super(by, false, true);
    }

    @Override
    protected void clear() {
        TextureItem textureItem;
        while ((textureItem = this.textures) != null) {
            this.textures = textureItem.dispose();
        }
        super.clear();
    }

    @Override
    protected void compile(ShortBuffer shortBuffer, ShortBuffer object) {
        object = this.textures;
        while (object != null) {
            ((TextureItem)object).upload();
            object = (TextureItem)((TextureItem)object).next;
        }
        this.compileVertexItems(shortBuffer);
    }

    public TextureItem getTextures() {
        return this.textures;
    }

    public void render(int n, int n2) {
        GLAdapter.gl.vertexAttribPointer(TextureBucket.shader.aPos, 4, 5122, false, 12, n);
        GLAdapter.gl.vertexAttribPointer(TextureBucket.shader.aTexCoord, 2, 5122, false, 12, n + 8);
        GLAdapter.gl.drawElements(4, n2, 5123, 0);
    }

    public static final class Renderer {
        public static RenderBucket draw(RenderBucket renderBucket, GLViewport object, float f) {
            GLState.test(false, false);
            GLState.blend(true);
            shader.useProgram();
            TextureBucket textureBucket = (TextureBucket)renderBucket;
            GL gL = GLAdapter.gl;
            int n = TextureBucket.shader.uScale;
            f = textureBucket.fixed ? 1.0f / f : 1.0f;
            gL.uniform1f(n, f);
            GLAdapter.gl.uniform1f(TextureBucket.shader.uCoordScale, MapRenderer.COORD_SCALE);
            ((GLViewport)object).proj.setAsUniform(TextureBucket.shader.uProj);
            ((GLViewport)object).mvp.setAsUniform(TextureBucket.shader.uMV);
            MapRenderer.bindQuadIndicesVBO();
            object = textureBucket.textures;
            while (object != null) {
                GLAdapter.gl.uniform2f(TextureBucket.shader.uTexSize, 1.0f / ((float)((TextureItem)object).width * MapRenderer.COORD_SCALE), 1.0f / ((float)((TextureItem)object).height * MapRenderer.COORD_SCALE));
                ((TextureItem)object).bind();
                for (n = 0; n < ((TextureItem)object).indices; n += 3072) {
                    int n2;
                    int n3 = ((TextureItem)object).offset;
                    int n4 = textureBucket.vertexOffset;
                    int n5 = n2 = ((TextureItem)object).indices - n;
                    if (n2 > 3072) {
                        n5 = 3072;
                    }
                    textureBucket.render((n3 + n) * 8 + n4, n5);
                }
                object = (TextureItem)((TextureItem)object).next;
            }
            return (RenderBucket)renderBucket.next;
        }

        static void init() {
            shader = new Shader();
            pool.init(0);
        }
    }

    static class Shader
    extends GLShader {
        int aPos;
        int aTexCoord;
        int uCoordScale;
        int uMV;
        int uProj;
        int uScale;
        int uTexSize;

        Shader() {
            if (!this.create("texture_layer")) {
                return;
            }
            this.uMV = this.getUniform("u_mv");
            this.uProj = this.getUniform("u_proj");
            this.uScale = this.getUniform("u_scale");
            this.uCoordScale = this.getUniform("u_coord_scale");
            this.uTexSize = this.getUniform("u_div");
            this.aPos = this.getAttrib("vertex");
            this.aTexCoord = this.getAttrib("tex_coord");
        }

        @Override
        public boolean useProgram() {
            if (super.useProgram()) {
                GLState.enableVertexArrays(this.aPos, this.aTexCoord);
                return true;
            }
            return false;
        }
    }
}

