/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.GLAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.SyncPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextureItem
extends Inlist<TextureItem> {
    static final TexturePool NOPOOL;
    static final boolean dbg = false;
    static final ArrayList<Integer> disposedTextures;
    static final Logger log;
    public Bitmap bitmap;
    public final int height;
    int id;
    public int indices;
    boolean loaded;
    public boolean mipmap;
    public int offset;
    final TexturePool pool;
    private TextureItem ref;
    public final boolean repeat;
    private int used = 0;
    public final int width;

    static {
        log = LoggerFactory.getLogger(TextureItem.class);
        NOPOOL = new TexturePool(0);
        disposedTextures = new ArrayList();
    }

    public TextureItem(Bitmap bitmap) {
        this(bitmap, false);
    }

    public TextureItem(Bitmap bitmap, boolean bl) {
        this(NOPOOL, -1, bitmap.getWidth(), bitmap.getHeight(), bl);
        this.bitmap = bitmap;
    }

    private TextureItem(TexturePool texturePool, int n) {
        this(texturePool, n, texturePool.mWidth, texturePool.mHeight, false);
    }

    private TextureItem(TexturePool texturePool, int n, int n2, int n3, boolean bl) {
        this.id = n;
        this.width = n2;
        this.height = n3;
        this.pool = texturePool;
        this.repeat = bl;
    }

    static /* synthetic */ int access$410(TextureItem textureItem) {
        int n = textureItem.used;
        textureItem.used = n - 1;
        return n;
    }

    public static TextureItem clone(TextureItem textureItem) {
        TextureItem textureItem2;
        TextureItem textureItem3 = new TextureItem(NOPOOL, textureItem.id, textureItem.width, textureItem.height, textureItem.repeat);
        textureItem3.id = textureItem.id;
        TextureItem textureItem4 = textureItem2 = textureItem.ref;
        if (textureItem2 == null) {
            textureItem4 = textureItem;
        }
        textureItem3.ref = textureItem4;
        textureItem3.loaded = textureItem.loaded;
        ++textureItem4.used;
        return textureItem3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void disposeTextures() {
        ArrayList<Integer> arrayList = disposedTextures;
        synchronized (arrayList) {
            int n = arrayList.size();
            if (n > 0) {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = disposedTextures.get(i);
                }
                disposedTextures.clear();
                GLUtils.glDeleteTextures(n, nArray);
            }
            return;
        }
    }

    public void bind() {
        if (this.loaded) {
            GLState.bindTex2D(this.id);
        } else {
            this.upload();
        }
    }

    @CheckReturnValue
    public TextureItem dispose() {
        TextureItem textureItem = (TextureItem)this.next;
        this.next = null;
        this.pool.release(this);
        return textureItem;
    }

    public void upload() {
        if (this.loaded) {
            return;
        }
        TextureItem textureItem = this.ref;
        if (textureItem == null) {
            this.pool.uploadTexture(this);
        } else {
            textureItem.upload();
            this.id = this.ref.id;
        }
        this.loaded = true;
    }

    public static class TexturePool
    extends SyncPool<TextureItem> {
        private final ArrayList<Bitmap> mBitmaps = new ArrayList(10);
        private final int mHeight;
        private final boolean mMipmaps;
        protected int mTexCnt = 0;
        private final boolean mUseBitmapPool;
        private final int mWidth;

        public TexturePool(int n) {
            super(n);
            this.mWidth = 0;
            this.mHeight = 0;
            this.mUseBitmapPool = false;
            this.mMipmaps = false;
        }

        public TexturePool(int n, int n2, int n3, boolean bl) {
            super(n);
            this.mWidth = n2;
            this.mHeight = n3;
            this.mUseBitmapPool = true;
            this.mMipmaps = bl;
        }

        private void uploadTexture(TextureItem textureItem) {
            if (textureItem.bitmap != null) {
                if (textureItem.id < 0) {
                    textureItem.id = GLUtils.glGenTextures(1)[0];
                    textureItem.mipmap |= this.mMipmaps;
                    this.initTexture(textureItem);
                    ++this.mTexCnt;
                    textureItem.bitmap.uploadToTexture(false);
                } else {
                    GLState.bindTex2D(textureItem.id);
                    textureItem.bitmap.uploadToTexture(true);
                }
                if (textureItem.mipmap) {
                    GLAdapter.gl.generateMipmap(3553);
                }
                if (this.mUseBitmapPool) {
                    this.releaseBitmap(textureItem);
                }
                return;
            }
            throw new RuntimeException("Missing bitmap for texture");
        }

        @Override
        protected boolean clearItem(TextureItem textureItem) {
            int n = textureItem.used;
            boolean bl = false;
            if (n > 0) {
                return false;
            }
            if (textureItem.ref != null) {
                if (textureItem.ref.used == 0) {
                    textureItem.ref.dispose();
                    return false;
                }
                TextureItem.access$410(textureItem.ref);
                return false;
            }
            textureItem.loaded = false;
            if (this.mUseBitmapPool) {
                this.releaseBitmap(textureItem);
            }
            if (textureItem.id >= 0) {
                bl = true;
            }
            return bl;
        }

        @Override
        protected TextureItem createItem() {
            return new TextureItem(this, -1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void freeItem(TextureItem textureItem) {
            if (textureItem.ref != null) return;
            if (textureItem.used != 0) return;
            if (textureItem.id < 0) return;
            --this.mTexCnt;
            ArrayList<Integer> arrayList = disposedTextures;
            synchronized (arrayList) {
                disposedTextures.add(textureItem.id);
                textureItem.id = -1;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public TextureItem get() {
            synchronized (this) {
                TextureItem textureItem = (TextureItem)super.get();
                boolean bl = this.mUseBitmapPool;
                if (!bl) {
                    return textureItem;
                }
                ArrayList<Bitmap> arrayList = this.mBitmaps;
                synchronized (arrayList) {
                    int n = this.mBitmaps.size();
                    if (n == 0) {
                        textureItem.bitmap = CanvasAdapter.newBitmap(this.mWidth, this.mHeight, 0);
                    } else {
                        textureItem.bitmap = this.mBitmaps.remove(n - 1);
                        textureItem.bitmap.eraseColor(0);
                    }
                    return textureItem;
                }
            }
        }

        public TextureItem get(Bitmap bitmap) {
            synchronized (this) {
                TextureItem textureItem = (TextureItem)super.get();
                textureItem.bitmap = bitmap;
                return textureItem;
            }
        }

        protected void initTexture(TextureItem textureItem) {
            GLState.bindTex2D(textureItem.id);
            if (textureItem.mipmap) {
                GLAdapter.gl.texParameterf(3553, 10241, 9987.0f);
            } else {
                GLAdapter.gl.texParameterf(3553, 10241, 9729.0f);
            }
            GLAdapter.gl.texParameterf(3553, 10240, 9729.0f);
            if (textureItem.repeat) {
                GLAdapter.gl.texParameterf(3553, 10242, 10497.0f);
                GLAdapter.gl.texParameterf(3553, 10243, 10497.0f);
            } else {
                GLAdapter.gl.texParameterf(3553, 10242, 33071.0f);
                GLAdapter.gl.texParameterf(3553, 10243, 33071.0f);
            }
        }

        @Override
        public TextureItem releaseAll(TextureItem textureItem) {
            throw new RuntimeException("use TextureItem.dispose()");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void releaseBitmap(TextureItem textureItem) {
            if (textureItem.bitmap == null) {
                return;
            }
            ArrayList<Bitmap> arrayList = this.mBitmaps;
            synchronized (arrayList) {
                this.mBitmaps.add(textureItem.bitmap);
                textureItem.bitmap = null;
                return;
            }
        }
    }
}

