/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.utils.FastMath;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.SyncPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexData
extends Inlist.List<Chunk> {
    private static final int MAX_POOL = 500;
    public static final int SIZE = 360;
    static final Logger log = LoggerFactory.getLogger(VertexData.class);
    private static final Pool pool = new Pool();
    private Chunk cur;
    private int used = 360;
    private short[] vertices;

    private void getNext() {
        block4: {
            block3: {
                Chunk chunk;
                block2: {
                    chunk = this.cur;
                    if (chunk != null) break block2;
                    this.cur = chunk = (Chunk)pool.get();
                    this.push(chunk);
                    break block3;
                }
                if (chunk.next != null) break block4;
                this.cur.used = 360;
                this.cur.next = pool.get();
                this.cur = (Chunk)this.cur.next;
            }
            this.vertices = this.cur.vertices;
            this.used = 0;
            return;
        }
        throw new IllegalStateException("seeeked...");
    }

    static final short toShort(float f) {
        return (short)FastMath.clamp(f, -32768.0f, 32767.0f);
    }

    public void add(float f, float f2) {
        this.add(VertexData.toShort(f), VertexData.toShort(f2));
    }

    public void add(float f, float f2, float f3) {
        this.add(VertexData.toShort(f), VertexData.toShort(f2), VertexData.toShort(f3));
    }

    public void add(float f, float f2, float f3, float f4) {
        this.add(VertexData.toShort(f), VertexData.toShort(f2), VertexData.toShort(f3), VertexData.toShort(f4));
    }

    public void add(float f, float f2, float f3, float f4, float f5, float f6) {
        this.add(VertexData.toShort(f), VertexData.toShort(f2), VertexData.toShort(f3), VertexData.toShort(f4), VertexData.toShort(f5), VertexData.toShort(f6));
    }

    public void add(short s) {
        if (this.used == 360) {
            this.getNext();
        }
        short[] sArray = this.vertices;
        int n = this.used;
        this.used = n + 1;
        sArray[n] = s;
    }

    public void add(short s, short s2) {
        if (this.used == 360) {
            this.getNext();
        }
        short[] sArray = this.vertices;
        int n = this.used;
        sArray[n + 0] = s;
        sArray[n + 1] = s2;
        this.used = n + 2;
    }

    public void add(short s, short s2, short s3) {
        if (this.used == 360) {
            this.getNext();
        }
        short[] sArray = this.vertices;
        int n = this.used;
        sArray[n + 0] = s;
        sArray[n + 1] = s2;
        sArray[n + 2] = s3;
        this.used = n + 3;
    }

    public void add(short s, short s2, short s3, short s4) {
        if (this.used == 360) {
            this.getNext();
        }
        short[] sArray = this.vertices;
        int n = this.used;
        sArray[n + 0] = s;
        sArray[n + 1] = s2;
        sArray[n + 2] = s3;
        sArray[n + 3] = s4;
        this.used = n + 4;
    }

    public void add(short s, short s2, short s3, short s4, short s5, short s6) {
        if (this.used == 360) {
            this.getNext();
        }
        short[] sArray = this.vertices;
        int n = this.used;
        sArray[n + 0] = s;
        sArray[n + 1] = s2;
        sArray[n + 2] = s3;
        sArray[n + 3] = s4;
        sArray[n + 4] = s5;
        sArray[n + 5] = s6;
        this.used = n + 6;
    }

    @Override
    public Chunk clear() {
        Chunk chunk = this.cur;
        if (chunk == null) {
            return null;
        }
        chunk.used = this.used;
        this.used = 360;
        this.cur = null;
        this.vertices = null;
        return (Chunk)super.clear();
    }

    public int compile(ShortBuffer shortBuffer) {
        Chunk chunk = this.cur;
        if (chunk == null) {
            return 0;
        }
        chunk.used = this.used;
        chunk = (Chunk)this.head();
        int n = 0;
        while (chunk != null) {
            n += chunk.used;
            shortBuffer.put(chunk.vertices, 0, chunk.used);
            chunk = (Chunk)chunk.next;
        }
        this.dispose();
        return n;
    }

    public int countSize() {
        Inlist inlist = this.cur;
        int n = 0;
        if (inlist == null) {
            return 0;
        }
        inlist.used = this.used;
        inlist = this.head();
        while (inlist != null) {
            n += inlist.used;
            inlist = inlist.next;
        }
        return n;
    }

    public void dispose() {
        pool.releaseAll(super.clear());
        this.used = 360;
        this.cur = null;
        this.vertices = null;
    }

    public boolean empty() {
        boolean bl = this.cur == null;
        return bl;
    }

    public Chunk obtainChunk() {
        if (this.used == 360) {
            this.getNext();
        }
        this.cur.used = this.used;
        return this.cur;
    }

    public void releaseChunk() {
        this.used = this.cur.used;
    }

    public void releaseChunk(int n) {
        this.cur.used = n;
        this.used = n;
    }

    public void seek(int n) {
        int n2;
        this.used = n2 = this.used + n;
        this.cur.used = n2;
        n2 = this.used;
        if (n2 <= 360 && n2 >= 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("seeked too far: ");
        stringBuilder.append(n);
        stringBuilder.append("/");
        stringBuilder.append(this.used);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public static class Chunk
    extends Inlist<Chunk> {
        public int used;
        public final short[] vertices = new short[360];
    }

    private static class Pool
    extends SyncPool<Chunk> {
        public Pool() {
            super(500);
        }

        @Override
        protected boolean clearItem(Chunk chunk) {
            chunk.used = 0;
            return true;
        }

        @Override
        protected Chunk createItem() {
            return new Chunk();
        }
    }
}

