/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.scalebar;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;
import org.oscim.map.Map;
import org.oscim.scalebar.DistanceUnitAdapter;
import org.oscim.scalebar.ImperialUnitAdapter;
import org.oscim.scalebar.MapScaleBar;

public class DefaultMapScaleBar
extends MapScaleBar {
    private static final int BITMAP_HEIGHT = 40;
    private static final int BITMAP_WIDTH = 120;
    private static final int DEFAULT_HORIZONTAL_MARGIN = 5;
    private static final int DEFAULT_VERTICAL_MARGIN = 0;
    private static final int SCALE_BAR_MARGIN = 10;
    private static final float STROKE_EXTERNAL = 4.0f;
    private static final float STROKE_INTERNAL = 2.0f;
    private static final int TEXT_MARGIN = 1;
    private final Paint paintScaleBar;
    private final Paint paintScaleBarStroke;
    private final Paint paintScaleText;
    private final Paint paintScaleTextStroke;
    private final float scale;
    private ScaleBarMode scaleBarMode;
    private DistanceUnitAdapter secondaryDistanceUnitAdapter;

    public DefaultMapScaleBar(Map map) {
        this(map, CanvasAdapter.getScale());
    }

    public DefaultMapScaleBar(Map map, float f) {
        super(map, (int)(120.0f * f), (int)(40.0f * f));
        this.setMarginHorizontal((int)(5.0f * f));
        this.setMarginVertical((int)(f * 0.0f));
        this.scale = f;
        this.scaleBarMode = ScaleBarMode.BOTH;
        this.secondaryDistanceUnitAdapter = ImperialUnitAdapter.INSTANCE;
        this.paintScaleBar = this.createScaleBarPaint(-16777216, 2.0f, Paint.Style.FILL);
        this.paintScaleBarStroke = this.createScaleBarPaint(-1, 4.0f, Paint.Style.STROKE);
        this.paintScaleText = this.createTextPaint(-16777216, 0.0f, Paint.Style.FILL);
        this.paintScaleTextStroke = this.createTextPaint(-1, 2.0f, Paint.Style.STROKE);
    }

    private Paint createScaleBarPaint(int n, float f, Paint.Style style2) {
        Paint paint = CanvasAdapter.newPaint();
        paint.setColor(n);
        paint.setStrokeWidth(f * this.scale);
        paint.setStyle(style2);
        paint.setStrokeCap(Paint.Cap.SQUARE);
        return paint;
    }

    private Paint createTextPaint(int n, float f, Paint.Style style2) {
        Paint paint = CanvasAdapter.newPaint();
        paint.setColor(n);
        paint.setStrokeWidth(f * this.scale);
        paint.setStyle(style2);
        paint.setTypeface(Paint.FontFamily.DEFAULT, Paint.FontStyle.BOLD);
        paint.setTextSize(this.scale * 12.0f);
        return paint;
    }

    private void drawScaleBar(Canvas canvas, int n, int n2, Paint paint, float f) {
        int n3 = Math.max(n, n2);
        switch (1.$SwitchMap$org$oscim$scalebar$MapScaleBar$ScaleBarPosition[this.scaleBarPosition.ordinal()]) {
            default: {
                break;
            }
            case 6: {
                if (n2 == 0) {
                    float f2 = canvas.getWidth();
                    float f3 = f * 4.0f * 0.5f;
                    float f4 = n3;
                    f2 = Math.round(f2 - f3 - f4);
                    canvas.drawLine(f2, Math.round(f *= 10.0f), Math.round((float)canvas.getWidth() - f3), Math.round(f), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - f3), Math.round(f), Math.round((float)canvas.getWidth() - f3), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - f3 - f4), Math.round(f), Math.round((float)canvas.getWidth() - f3 - f4), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    break;
                }
                float f5 = canvas.getWidth();
                float f6 = 4.0f * f * 0.5f;
                canvas.drawLine(Math.round(f5 - f6), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - f6 - (float)n3), Math.round((float)canvas.getHeight() * 0.5f), paint);
                f5 = Math.round((float)canvas.getWidth() - f6);
                canvas.drawLine(f5, Math.round(f *= 10.0f), Math.round((float)canvas.getWidth() - f6), Math.round((float)canvas.getHeight() - f), paint);
                f5 = canvas.getWidth();
                float f7 = n;
                canvas.drawLine(Math.round(f5 - f6 - f7), Math.round(f), Math.round((float)canvas.getWidth() - f6 - f7), Math.round((float)canvas.getHeight() * 0.5f), paint);
                f5 = canvas.getWidth();
                f7 = n2;
                canvas.drawLine(Math.round(f5 - f6 - f7), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - f6 - f7), Math.round((float)canvas.getHeight() - f), paint);
                break;
            }
            case 5: {
                if (n2 == 0) {
                    float f8 = f * 4.0f * 0.5f;
                    float f9 = Math.round(f8);
                    float f10 = f * 10.0f;
                    float f11 = Math.round(f10);
                    f = (float)n3 + f8;
                    canvas.drawLine(f9, f11, Math.round(f), Math.round(f10), paint);
                    canvas.drawLine(Math.round(f8), Math.round(f10), Math.round(f8), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    canvas.drawLine(Math.round(f), Math.round(f10), Math.round(f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    break;
                }
                float f12 = f * 4.0f * 0.5f;
                canvas.drawLine(Math.round(f12), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)n3 + f12), Math.round((float)canvas.getHeight() * 0.5f), paint);
                float f13 = Math.round(f12);
                canvas.drawLine(f13, Math.round(f *= 10.0f), Math.round(f12), Math.round((float)canvas.getHeight() - f), paint);
                f13 = (float)n + f12;
                canvas.drawLine(Math.round(f13), Math.round(f), Math.round(f13), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(f12 += (float)n2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(f12), Math.round((float)canvas.getHeight() - f), paint);
                break;
            }
            case 4: {
                if (n2 == 0) {
                    float f14 = Math.round((float)(canvas.getWidth() - n3) * 0.5f);
                    canvas.drawLine(f14, Math.round(f *= 10.0f), Math.round((float)(canvas.getWidth() + n3) * 0.5f), Math.round(f), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() - n3) * 0.5f), Math.round(f), Math.round((float)(canvas.getWidth() - n3) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() + n3) * 0.5f), Math.round(f), Math.round((float)(canvas.getWidth() + n3) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    break;
                }
                float f15 = f * 4.0f * 0.5f;
                canvas.drawLine(Math.round(f15), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)n3 + f15), Math.round((float)canvas.getHeight() * 0.5f), paint);
                float f16 = Math.round(f15);
                canvas.drawLine(f16, Math.round(f *= 10.0f), Math.round(f15), Math.round((float)canvas.getHeight() - f), paint);
                f16 = (float)n + f15;
                canvas.drawLine(Math.round(f16), Math.round(f), Math.round(f16), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(f15 += (float)n2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(f15), Math.round((float)canvas.getHeight() - f), paint);
                break;
            }
            case 3: {
                if (n2 == 0) {
                    float f17 = canvas.getWidth();
                    float f18 = f * 4.0f * 0.5f;
                    float f19 = n3;
                    f17 = Math.round(f17 - f18 - f19);
                    float f20 = canvas.getHeight();
                    canvas.drawLine(f17, Math.round(f20 - (f *= 10.0f)), Math.round((float)canvas.getWidth() - f18), Math.round((float)canvas.getHeight() - f), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - f18), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - f18), Math.round((float)canvas.getHeight() - f), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - f18 - f19), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - f18 - f19), Math.round((float)canvas.getHeight() - f), paint);
                    break;
                }
                float f21 = canvas.getWidth();
                float f22 = 4.0f * f * 0.5f;
                canvas.drawLine(Math.round(f21 - f22), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - f22 - (float)n3), Math.round((float)canvas.getHeight() * 0.5f), paint);
                f21 = Math.round((float)canvas.getWidth() - f22);
                canvas.drawLine(f21, Math.round(f *= 10.0f), Math.round((float)canvas.getWidth() - f22), Math.round((float)canvas.getHeight() - f), paint);
                float f23 = canvas.getWidth();
                f21 = n;
                canvas.drawLine(Math.round(f23 - f22 - f21), Math.round(f), Math.round((float)canvas.getWidth() - f22 - f21), Math.round((float)canvas.getHeight() * 0.5f), paint);
                f23 = canvas.getWidth();
                f21 = n2;
                canvas.drawLine(Math.round(f23 - f22 - f21), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - f22 - f21), Math.round((float)canvas.getHeight() - f), paint);
                break;
            }
            case 2: {
                if (n2 == 0) {
                    float f24 = f * 4.0f * 0.5f;
                    float f25 = Math.round(f24);
                    float f26 = canvas.getHeight();
                    float f27 = Math.round(f26 - (f *= 10.0f));
                    f26 = (float)n3 + f24;
                    canvas.drawLine(f25, f27, Math.round(f26), Math.round((float)canvas.getHeight() - f), paint);
                    canvas.drawLine(Math.round(f24), Math.round((float)canvas.getHeight() * 0.5f), Math.round(f24), Math.round((float)canvas.getHeight() - f), paint);
                    canvas.drawLine(Math.round(f26), Math.round((float)canvas.getHeight() * 0.5f), Math.round(f26), Math.round((float)canvas.getHeight() - f), paint);
                    break;
                }
                float f28 = f * 4.0f * 0.5f;
                canvas.drawLine(Math.round(f28), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)n3 + f28), Math.round((float)canvas.getHeight() * 0.5f), paint);
                float f29 = Math.round(f28);
                canvas.drawLine(f29, Math.round(f *= 10.0f), Math.round(f28), Math.round((float)canvas.getHeight() - f), paint);
                f29 = (float)n + f28;
                canvas.drawLine(Math.round(f29), Math.round(f), Math.round(f29), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(f28 += (float)n2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(f28), Math.round((float)canvas.getHeight() - f), paint);
                break;
            }
            case 1: {
                if (n2 == 0) {
                    float f30 = Math.round((float)(canvas.getWidth() - n3) * 0.5f);
                    float f31 = canvas.getHeight();
                    canvas.drawLine(f30, Math.round(f31 - (f *= 10.0f)), Math.round((float)(canvas.getWidth() + n3) * 0.5f), Math.round((float)canvas.getHeight() - f), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() - n3) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)(canvas.getWidth() - n3) * 0.5f), Math.round((float)canvas.getHeight() - f), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() + n3) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)(canvas.getWidth() + n3) * 0.5f), Math.round((float)canvas.getHeight() - f), paint);
                    break;
                }
                float f32 = f * 4.0f * 0.5f;
                canvas.drawLine(Math.round(f32), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)n3 + f32), Math.round((float)canvas.getHeight() * 0.5f), paint);
                float f33 = Math.round(f32);
                canvas.drawLine(f33, Math.round(f *= 10.0f), Math.round(f32), Math.round((float)canvas.getHeight() - f), paint);
                f33 = (float)n + f32;
                canvas.drawLine(Math.round(f33), Math.round(f), Math.round(f33), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(f32 += (float)n2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(f32), Math.round((float)canvas.getHeight() - f), paint);
            }
        }
    }

    private void drawScaleText(Canvas canvas, String string2, String string3, Paint paint, float f) {
        switch (1.$SwitchMap$org$oscim$scalebar$MapScaleBar$ScaleBarPosition[this.scaleBarPosition.ordinal()]) {
            default: {
                break;
            }
            case 6: {
                if (string3.length() == 0) {
                    float f2 = canvas.getWidth();
                    float f3 = 4.0f * f;
                    float f4 = 1.0f * f;
                    canvas.drawText(string2, Math.round(f2 - f3 - f4 - this.paintScaleTextStroke.getTextWidth(string2)), Math.round(f * 10.0f + f3 * 0.5f + f4 + this.paintScaleTextStroke.getTextHeight(string2)), paint);
                    break;
                }
                float f5 = canvas.getWidth();
                float f6 = 4.0f * f;
                f5 = Math.round(f5 - f6 - (f *= 1.0f) - this.paintScaleTextStroke.getTextWidth(string2));
                float f7 = canvas.getHeight();
                float f8 = f6 * 0.5f;
                canvas.drawText(string2, f5, Math.round(f7 * 0.5f - f8 - f), paint);
                canvas.drawText(string3, Math.round((float)canvas.getWidth() - f6 - f - this.paintScaleTextStroke.getTextWidth(string3)), Math.round((float)canvas.getHeight() * 0.5f + f8 + f + this.paintScaleTextStroke.getTextHeight(string3)), paint);
                break;
            }
            case 5: {
                if (string3.length() == 0) {
                    float f9 = 4.0f * f;
                    float f10 = 1.0f * f;
                    canvas.drawText(string2, Math.round(f9 + f10), Math.round(f * 10.0f + f9 * 0.5f + f10 + this.paintScaleTextStroke.getTextHeight(string2)), paint);
                    break;
                }
                float f11 = 4.0f * f;
                float f12 = f * 1.0f;
                float f13 = f11 + f12;
                f = Math.round(f13);
                float f14 = canvas.getHeight();
                canvas.drawText(string2, f, Math.round(f14 * 0.5f - (f11 *= 0.5f) - f12), paint);
                canvas.drawText(string3, Math.round(f13), Math.round((float)canvas.getHeight() * 0.5f + f11 + f12 + this.paintScaleTextStroke.getTextHeight(string3)), paint);
                break;
            }
            case 4: {
                if (string3.length() == 0) {
                    canvas.drawText(string2, Math.round(((float)canvas.getWidth() - this.paintScaleTextStroke.getTextWidth(string2)) * 0.5f), Math.round(10.0f * f + 4.0f * f * 0.5f + f * 1.0f + this.paintScaleTextStroke.getTextHeight(string2)), paint);
                    break;
                }
                float f15 = 4.0f * f;
                float f16 = f * 1.0f;
                f = f15 + f16;
                float f17 = Math.round(f);
                float f18 = canvas.getHeight();
                canvas.drawText(string2, f17, Math.round(f18 * 0.5f - (f15 *= 0.5f) - f16), paint);
                canvas.drawText(string3, Math.round(f), Math.round((float)canvas.getHeight() * 0.5f + f15 + f16 + this.paintScaleTextStroke.getTextHeight(string3)), paint);
                break;
            }
            case 3: {
                if (string3.length() == 0) {
                    float f19 = canvas.getWidth();
                    float f20 = 4.0f * f;
                    float f21 = 1.0f * f;
                    canvas.drawText(string2, Math.round(f19 - f20 - f21 - this.paintScaleTextStroke.getTextWidth(string2)), Math.round((float)canvas.getHeight() - f * 10.0f - f20 * 0.5f - f21), paint);
                    break;
                }
                float f22 = canvas.getWidth();
                float f23 = 4.0f * f;
                float f24 = Math.round(f22 - f23 - (f *= 1.0f) - this.paintScaleTextStroke.getTextWidth(string2));
                f22 = canvas.getHeight();
                float f25 = f23 * 0.5f;
                canvas.drawText(string2, f24, Math.round(f22 * 0.5f - f25 - f), paint);
                canvas.drawText(string3, Math.round((float)canvas.getWidth() - f23 - f - this.paintScaleTextStroke.getTextWidth(string3)), Math.round((float)canvas.getHeight() * 0.5f + f25 + f + this.paintScaleTextStroke.getTextHeight(string3)), paint);
                break;
            }
            case 2: {
                if (string3.length() == 0) {
                    float f26 = 4.0f * f;
                    float f27 = 1.0f * f;
                    canvas.drawText(string2, Math.round(f26 + f27), Math.round((float)canvas.getHeight() - f * 10.0f - f26 * 0.5f - f27), paint);
                    break;
                }
                float f28 = 4.0f * f;
                float f29 = f * 1.0f;
                f = f28 + f29;
                float f30 = Math.round(f);
                float f31 = canvas.getHeight();
                canvas.drawText(string2, f30, Math.round(f31 * 0.5f - (f28 *= 0.5f) - f29), paint);
                canvas.drawText(string3, Math.round(f), Math.round((float)canvas.getHeight() * 0.5f + f28 + f29 + this.paintScaleTextStroke.getTextHeight(string3)), paint);
                break;
            }
            case 1: {
                if (string3.length() == 0) {
                    canvas.drawText(string2, Math.round(((float)canvas.getWidth() - this.paintScaleTextStroke.getTextWidth(string2)) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * f - 4.0f * f * 0.5f - f * 1.0f), paint);
                    break;
                }
                float f32 = 4.0f * f;
                float f33 = f * 1.0f;
                float f34 = f32 + f33;
                float f35 = Math.round(f34);
                f = canvas.getHeight();
                canvas.drawText(string2, f35, Math.round(f * 0.5f - (f32 *= 0.5f) - f33), paint);
                canvas.drawText(string3, Math.round(f34), Math.round((float)canvas.getHeight() * 0.5f + f32 + f33 + this.paintScaleTextStroke.getTextHeight(string3)), paint);
            }
        }
    }

    public ScaleBarMode getScaleBarMode() {
        return this.scaleBarMode;
    }

    public DistanceUnitAdapter getSecondaryDistanceUnitAdapter() {
        return this.secondaryDistanceUnitAdapter;
    }

    @Override
    protected void redraw(Canvas canvas) {
        canvas.fillColor(0);
        Object object = this.calculateScaleBarLengthAndValue();
        Object object2 = this.scaleBarMode == ScaleBarMode.BOTH ? this.calculateScaleBarLengthAndValue(this.secondaryDistanceUnitAdapter) : new MapScaleBar.ScaleBarLengthAndValue(0, 0);
        this.drawScaleBar(canvas, ((MapScaleBar.ScaleBarLengthAndValue)object).scaleBarLength, ((MapScaleBar.ScaleBarLengthAndValue)object2).scaleBarLength, this.paintScaleBarStroke, this.scale);
        this.drawScaleBar(canvas, ((MapScaleBar.ScaleBarLengthAndValue)object).scaleBarLength, ((MapScaleBar.ScaleBarLengthAndValue)object2).scaleBarLength, this.paintScaleBar, this.scale);
        object = this.distanceUnitAdapter.getScaleText(((MapScaleBar.ScaleBarLengthAndValue)object).scaleBarValue);
        object2 = this.scaleBarMode == ScaleBarMode.BOTH ? this.secondaryDistanceUnitAdapter.getScaleText(((MapScaleBar.ScaleBarLengthAndValue)object2).scaleBarValue) : "";
        this.drawScaleText(canvas, (String)object, (String)object2, this.paintScaleTextStroke, this.scale);
        this.drawScaleText(canvas, (String)object, (String)object2, this.paintScaleText, this.scale);
    }

    public void setScaleBarMode(ScaleBarMode scaleBarMode) {
        this.scaleBarMode = scaleBarMode;
        this.redrawNeeded = true;
    }

    public void setSecondaryDistanceUnitAdapter(DistanceUnitAdapter distanceUnitAdapter) {
        if (distanceUnitAdapter != null) {
            this.secondaryDistanceUnitAdapter = distanceUnitAdapter;
            this.redrawNeeded = true;
            return;
        }
        throw new IllegalArgumentException("adapter must not be null");
    }

    public static final class ScaleBarMode
    extends Enum<ScaleBarMode> {
        private static final /* synthetic */ ScaleBarMode[] $VALUES;
        public static final /* enum */ ScaleBarMode BOTH;
        public static final /* enum */ ScaleBarMode SINGLE;

        static {
            ScaleBarMode scaleBarMode;
            ScaleBarMode scaleBarMode2;
            BOTH = scaleBarMode2 = new ScaleBarMode();
            SINGLE = scaleBarMode = new ScaleBarMode();
            $VALUES = new ScaleBarMode[]{scaleBarMode2, scaleBarMode};
        }

        public static ScaleBarMode valueOf(String string2) {
            return Enum.valueOf(ScaleBarMode.class, string2);
        }

        public static ScaleBarMode[] values() {
            return (ScaleBarMode[])$VALUES.clone();
        }
    }
}

