/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.scalebar;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.map.Map;
import org.oscim.scalebar.DistanceUnitAdapter;
import org.oscim.scalebar.MetricUnitAdapter;

public abstract class MapScaleBar {
    private static final ScaleBarPosition DEFAULT_SCALE_BAR_POSITION = ScaleBarPosition.BOTTOM_LEFT;
    private static final double LATITUDE_REDRAW_THRESHOLD = 0.2;
    private final MapPosition currentMapPosition = new MapPosition();
    protected DistanceUnitAdapter distanceUnitAdapter;
    protected final Map map;
    protected Bitmap mapScaleBitmap;
    protected Canvas mapScaleCanvas;
    private int marginHorizontal;
    private int marginVertical;
    private MapPosition prevMapPosition;
    protected boolean redrawNeeded;
    protected ScaleBarPosition scaleBarPosition;
    private boolean visible;

    public MapScaleBar(Map object, int n, int n2) {
        this.map = object;
        this.mapScaleBitmap = CanvasAdapter.newBitmap(n, n2, 0);
        this.scaleBarPosition = DEFAULT_SCALE_BAR_POSITION;
        this.mapScaleCanvas = object = CanvasAdapter.newCanvas();
        object.setBitmap(this.mapScaleBitmap);
        this.distanceUnitAdapter = MetricUnitAdapter.INSTANCE;
        this.visible = true;
        this.redrawNeeded = true;
    }

    private int calculatePositionLeft(int n, int n2, int n3) {
        switch (1.$SwitchMap$org$oscim$scalebar$MapScaleBar$ScaleBarPosition[this.scaleBarPosition.ordinal()]) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("unknown horizontal position: ");
                stringBuilder.append((Object)this.scaleBarPosition);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            case 5: 
            case 6: {
                return n2 - n - n3 - this.marginHorizontal;
            }
            case 3: 
            case 4: {
                return (n2 - n - n3) / 2;
            }
            case 1: 
            case 2: 
        }
        return this.marginHorizontal;
    }

    private int calculatePositionTop(int n, int n2, int n3) {
        switch (1.$SwitchMap$org$oscim$scalebar$MapScaleBar$ScaleBarPosition[this.scaleBarPosition.ordinal()]) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("unknown vertical position: ");
                stringBuilder.append((Object)this.scaleBarPosition);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            case 2: 
            case 4: 
            case 6: {
                return this.marginVertical;
            }
            case 1: 
            case 3: 
            case 5: 
        }
        return n2 - n - n3 - this.marginVertical;
    }

    protected ScaleBarLengthAndValue calculateScaleBarLengthAndValue() {
        return this.calculateScaleBarLengthAndValue(this.distanceUnitAdapter);
    }

    protected ScaleBarLengthAndValue calculateScaleBarLengthAndValue(DistanceUnitAdapter object) {
        Object object2;
        MapPosition mapPosition;
        this.prevMapPosition = mapPosition = this.map.getMapPosition();
        double d = (double)MercatorProjection.groundResolution(mapPosition) / object.getMeterRatio();
        object = object.getScaleBarValues();
        int n = ((Object)object).length;
        int n2 = 0;
        boolean n3 = false;
        for (int i = 0; i < n && (n2 = (int)((double)(object2 = object[i]) / d)) >= this.mapScaleBitmap.getWidth() - 10; ++i) {
        }
        return new ScaleBarLengthAndValue(n2, (int)object2);
    }

    public void destroy() {
        this.mapScaleBitmap.recycle();
        this.mapScaleBitmap = null;
        this.mapScaleCanvas = null;
    }

    public void draw(Canvas canvas) {
        if (!this.visible) {
            return;
        }
        if (this.map.getHeight() == 0) {
            return;
        }
        if (this.isRedrawNecessary()) {
            this.redraw(this.mapScaleCanvas);
            this.redrawNeeded = false;
        }
        int n = this.calculatePositionLeft(0, this.map.getWidth(), this.mapScaleBitmap.getWidth());
        int n2 = this.calculatePositionTop(0, this.map.getHeight(), this.mapScaleBitmap.getHeight());
        canvas.drawBitmap(this.mapScaleBitmap, n, n2);
    }

    public void drawScaleBar() {
        this.draw(this.mapScaleCanvas);
    }

    public DistanceUnitAdapter getDistanceUnitAdapter() {
        return this.distanceUnitAdapter;
    }

    public int getMarginHorizontal() {
        return this.marginHorizontal;
    }

    public int getMarginVertical() {
        return this.marginVertical;
    }

    public ScaleBarPosition getScaleBarPosition() {
        return this.scaleBarPosition;
    }

    protected boolean isRedrawNecessary() {
        boolean bl;
        boolean bl2 = this.redrawNeeded;
        boolean bl3 = bl = true;
        if (!bl2) {
            if (this.prevMapPosition == null) {
                bl3 = bl;
            } else {
                this.map.getMapPosition(this.currentMapPosition);
                if (this.currentMapPosition.getScale() != this.prevMapPosition.getScale()) {
                    return true;
                }
                bl3 = Math.abs(this.currentMapPosition.getLatitude() - this.prevMapPosition.getLatitude()) > 0.2 ? bl : false;
            }
        }
        return bl3;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract void redraw(Canvas var1);

    public void redrawScaleBar() {
        this.redrawNeeded = true;
    }

    public void setDistanceUnitAdapter(DistanceUnitAdapter distanceUnitAdapter) {
        if (distanceUnitAdapter != null) {
            this.distanceUnitAdapter = distanceUnitAdapter;
            this.redrawNeeded = true;
            return;
        }
        throw new IllegalArgumentException("adapter must not be null");
    }

    public void setMarginHorizontal(int n) {
        if (this.marginHorizontal != n) {
            this.marginHorizontal = n;
            this.redrawNeeded = true;
        }
    }

    public void setMarginVertical(int n) {
        if (this.marginVertical != n) {
            this.marginVertical = n;
            this.redrawNeeded = true;
        }
    }

    public void setScaleBarPosition(ScaleBarPosition scaleBarPosition) {
        if (this.scaleBarPosition != scaleBarPosition) {
            this.scaleBarPosition = scaleBarPosition;
            this.redrawNeeded = true;
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    protected static class ScaleBarLengthAndValue {
        public int scaleBarLength;
        public int scaleBarValue;

        public ScaleBarLengthAndValue(int n, int n2) {
            this.scaleBarLength = n;
            this.scaleBarValue = n2;
        }
    }

    public static final class ScaleBarPosition
    extends Enum<ScaleBarPosition> {
        private static final /* synthetic */ ScaleBarPosition[] $VALUES;
        public static final /* enum */ ScaleBarPosition BOTTOM_CENTER;
        public static final /* enum */ ScaleBarPosition BOTTOM_LEFT;
        public static final /* enum */ ScaleBarPosition BOTTOM_RIGHT;
        public static final /* enum */ ScaleBarPosition TOP_CENTER;
        public static final /* enum */ ScaleBarPosition TOP_LEFT;
        public static final /* enum */ ScaleBarPosition TOP_RIGHT;

        static {
            ScaleBarPosition scaleBarPosition;
            ScaleBarPosition scaleBarPosition2;
            ScaleBarPosition scaleBarPosition3;
            ScaleBarPosition scaleBarPosition4;
            ScaleBarPosition scaleBarPosition5;
            ScaleBarPosition scaleBarPosition6;
            BOTTOM_CENTER = scaleBarPosition6 = new ScaleBarPosition();
            BOTTOM_LEFT = scaleBarPosition5 = new ScaleBarPosition();
            BOTTOM_RIGHT = scaleBarPosition4 = new ScaleBarPosition();
            TOP_CENTER = scaleBarPosition3 = new ScaleBarPosition();
            TOP_LEFT = scaleBarPosition2 = new ScaleBarPosition();
            TOP_RIGHT = scaleBarPosition = new ScaleBarPosition();
            $VALUES = new ScaleBarPosition[]{scaleBarPosition6, scaleBarPosition5, scaleBarPosition4, scaleBarPosition3, scaleBarPosition2, scaleBarPosition};
        }

        public static ScaleBarPosition valueOf(String string2) {
            return Enum.valueOf(ScaleBarPosition.class, string2);
        }

        public static ScaleBarPosition[] values() {
            return (ScaleBarPosition[])$VALUES.clone();
        }
    }
}

