/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.ThemeUtils;
import org.oscim.theme.XmlRenderThemeMenuCallback;

public class ExternalRenderTheme
implements ThemeFile {
    private static final long serialVersionUID = 1L;
    private final long mFileModificationDate;
    private XmlRenderThemeMenuCallback mMenuCallback;
    private final String mPath;

    public ExternalRenderTheme(String string2) throws IRenderTheme.ThemeException {
        this(string2, null);
    }

    public ExternalRenderTheme(String charSequence, XmlRenderThemeMenuCallback object) throws IRenderTheme.ThemeException {
        File file = new File((String)charSequence);
        if (file.exists()) {
            if (file.isFile()) {
                if (file.canRead()) {
                    long l;
                    this.mFileModificationDate = l = file.lastModified();
                    if (l != 0L) {
                        this.mPath = charSequence;
                        this.mMenuCallback = object;
                        return;
                    }
                    throw new IRenderTheme.ThemeException("cannot read last modification time");
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("cannot read file: ");
                ((StringBuilder)object).append((String)charSequence);
                throw new IRenderTheme.ThemeException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("not a file: ");
            ((StringBuilder)object).append((String)charSequence);
            throw new IRenderTheme.ThemeException(((StringBuilder)object).toString());
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("file does not exist: ");
        ((StringBuilder)charSequence).append(file.getAbsolutePath());
        throw new IRenderTheme.ThemeException(((StringBuilder)charSequence).toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExternalRenderTheme)) {
            return false;
        }
        object = (ExternalRenderTheme)object;
        if (this.mFileModificationDate != ((ExternalRenderTheme)object).mFileModificationDate) {
            return false;
        }
        String string2 = this.mPath;
        if (string2 == null && ((ExternalRenderTheme)object).mPath != null) {
            return false;
        }
        return string2 == null || string2.equals(((ExternalRenderTheme)object).mPath);
    }

    @Override
    public XmlRenderThemeMenuCallback getMenuCallback() {
        return this.mMenuCallback;
    }

    @Override
    public String getRelativePathPrefix() {
        return new File(this.mPath).getParent();
    }

    @Override
    public InputStream getRenderThemeAsStream() throws IRenderTheme.ThemeException {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.mPath);
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IRenderTheme.ThemeException(fileNotFoundException.getMessage());
        }
    }

    @Override
    public boolean isMapsforgeTheme() {
        return ThemeUtils.isMapsforgeTheme(this);
    }

    @Override
    public void setMenuCallback(XmlRenderThemeMenuCallback xmlRenderThemeMenuCallback) {
        this.mMenuCallback = xmlRenderThemeMenuCallback;
    }
}

