/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.TagSet;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.MatchingCacheKey;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.utils.LRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderTheme
implements IRenderTheme {
    private static final int MATCHING_CACHE_SIZE = 512;
    static final Logger log = LoggerFactory.getLogger(RenderTheme.class);
    private final float mBaseTextSize;
    private final int mLevels;
    private final int mMapBackground;
    private final boolean mMapsforgeTheme;
    private final Rule[] mRules;
    private final RenderStyleCache[] mStyleCache;

    public RenderTheme(int n, float f, Rule[] ruleArray, int n2) {
        this(n, f, ruleArray, n2, false);
    }

    public RenderTheme(int n, float f, Rule[] objectArray, int n2, boolean bl) {
        if (objectArray != null) {
            this.mMapBackground = n;
            this.mBaseTextSize = f;
            this.mLevels = n2;
            this.mRules = objectArray;
            this.mMapsforgeTheme = bl;
            objectArray = new RenderStyleCache[3];
            this.mStyleCache = objectArray;
            objectArray[0] = new RenderStyleCache(1);
            objectArray[1] = new RenderStyleCache(2);
            objectArray[2] = new RenderStyleCache(4);
            return;
        }
        throw new IllegalArgumentException("rules missing");
    }

    @Override
    public void dispose() {
        int n;
        int n2 = 0;
        for (n = 0; n < 3; ++n) {
            this.mStyleCache[n].cache.clear();
        }
        Rule[] ruleArray = this.mRules;
        int n3 = ruleArray.length;
        for (n = n2; n < n3; ++n) {
            ruleArray[n].dispose();
        }
    }

    @Override
    public int getLevels() {
        return this.mLevels;
    }

    @Override
    public int getMapBackground() {
        return this.mMapBackground;
    }

    Rule[] getRules() {
        return this.mRules;
    }

    @Override
    public boolean isMapsforgeTheme() {
        return this.mMapsforgeTheme;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public RenderStyle[] matchElement(GeometryBuffer.GeometryType object, TagSet object2, int n) {
        Object object3;
        int n2;
        RenderStyleCache renderStyleCache;
        Object object4;
        int n3;
        block29: {
            block30: {
                block25: {
                    block28: {
                        block27: {
                            block26: {
                                n3 = ((GeometryBuffer.GeometryType)((Object)object)).nativeInt;
                                object4 = null;
                                if (n3 < 1 || n3 > 3) break block25;
                                renderStyleCache = this.mStyleCache[n3 - 1];
                                n2 = 1 << n;
                                // MONITORENTER : renderStyleCache
                                if (renderStyleCache.prevItem == null || (renderStyleCache.prevItem.zoom & n2) == 0) break block26;
                                if (!renderStyleCache.cacheKey.set((TagSet)object2, renderStyleCache.prevItem.key)) break block27;
                                object3 = renderStyleCache.prevItem;
                                break block28;
                            }
                            renderStyleCache.cacheKey.set((TagSet)object2, null);
                        }
                        object3 = null;
                    }
                    object = object4;
                    object2 = object3;
                    if (object3 != null) break block29;
                    break block30;
                }
                Logger logger = log;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("invalid geometry type for RenderTheme ");
                ((StringBuilder)object2).append(((Enum)object).name());
                logger.debug(((StringBuilder)object2).toString());
                return null;
            }
            object3 = object4 = renderStyleCache.getRenderInstructions();
            while (true) {
                object = object4;
                object2 = object3;
                if (object3 == null) break;
                if ((((RenderStyleItem)object3).zoom & n2) != 0) {
                    object = object4;
                    object2 = object3;
                    break;
                }
                object3 = ((RenderStyleItem)object3).next;
            }
        }
        object3 = object2;
        if (object2 == null) {
            int n4;
            object3 = renderStyleCache.instructionList;
            object3.clear();
            object2 = this.mRules;
            int n5 = ((Object)object2).length;
            for (n3 = 0; n3 < n5; ++n3) {
                ((Rule)object2[n3]).matchElement(renderStyleCache.matchType, renderStyleCache.cacheKey.mTags, n2, (List<RenderStyle>)object3);
            }
            n3 = n5 = object3.size();
            if (n5 > 1) {
                int n6 = 0;
                block9: while (true) {
                    n3 = n5;
                    if (n6 >= n5 - 1) break;
                    RenderStyle renderStyle = (RenderStyle)object3.get(n6);
                    n3 = n4 = n6 + 1;
                    int n7 = n5;
                    while (true) {
                        n5 = n7;
                        n6 = n4;
                        if (n3 >= n7) continue block9;
                        n5 = n7;
                        n6 = n3;
                        if (object3.get(n3) == renderStyle) {
                            object4 = log;
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("fix duplicate instruction! ");
                            ((StringBuilder)object2).append(Arrays.deepToString(renderStyleCache.cacheKey.mTags));
                            ((StringBuilder)object2).append(" zoom:");
                            ((StringBuilder)object2).append(n);
                            ((StringBuilder)object2).append(" ");
                            ((StringBuilder)object2).append(renderStyle.getClass().getName());
                            object4.debug(((StringBuilder)object2).toString());
                            object3.remove(n3);
                            n5 = n7 - 1;
                            n6 = n3 - 1;
                        }
                        n3 = n6 + 1;
                        n7 = n5;
                    }
                    break;
                }
            }
            object2 = object;
            while (object2 != null) {
                if (n3 == 0) {
                    if (((RenderStyleItem)object2).list == null) break;
                } else if (((RenderStyleItem)object2).list != null && ((RenderStyleItem)object2).list.length == n3) {
                    object4 = ((RenderStyleItem)object2).list;
                    n4 = ((RenderStyle[])object4).length;
                    n5 = 0;
                    for (n = 0; n < n4 && object4[n] == object3.get(n5); ++n5, ++n) {
                    }
                    if (n5 == n3) break;
                }
                object2 = ((RenderStyleItem)object2).next;
            }
            if (object2 != null) {
                ((RenderStyleItem)object2).zoom = n2 | ((RenderStyleItem)object2).zoom;
            } else {
                object2 = new RenderStyleItem();
                ((RenderStyleItem)object2).zoom = n2;
                if (n3 > 0) {
                    ((RenderStyleItem)object2).list = new RenderStyle[n3];
                    object3.toArray(((RenderStyleItem)object2).list);
                }
                if (object != null) {
                    ((RenderStyleItem)object2).next = ((RenderStyleItem)object).next;
                    ((RenderStyleItem)object2).key = ((RenderStyleItem)object).key;
                    ((RenderStyleItem)object).next = object2;
                } else {
                    ((RenderStyleItem)object2).key = object = new MatchingCacheKey(renderStyleCache.cacheKey);
                    renderStyleCache.cache.put(((RenderStyleItem)object2).key, (RenderStyleItem)object2);
                }
            }
            object3 = object2;
        }
        renderStyleCache.prevItem = object3;
        // MONITOREXIT : renderStyleCache
        return ((RenderStyleItem)object3).list;
    }

    @Override
    public void scaleTextSize(float f) {
        Rule[] ruleArray = this.mRules;
        int n = ruleArray.length;
        for (int i = 0; i < n; ++i) {
            ruleArray[i].scaleTextSize(this.mBaseTextSize * f);
        }
    }

    public void traverseRules(Rule.RuleVisitor ruleVisitor) {
        Rule[] ruleArray = this.mRules;
        int n = ruleArray.length;
        for (int i = 0; i < n; ++i) {
            ruleArray[i].apply(ruleVisitor);
        }
    }

    @Override
    public void updateStyles() {
        Rule[] ruleArray = this.mRules;
        int n = ruleArray.length;
        for (int i = 0; i < n; ++i) {
            ruleArray[i].updateStyles();
        }
    }

    class RenderStyleCache {
        final LRUCache<MatchingCacheKey, RenderStyleItem> cache = new LRUCache(512);
        final MatchingCacheKey cacheKey;
        final ArrayList<RenderStyle> instructionList = new ArrayList(4);
        final int matchType;
        RenderStyleItem prevItem;

        public RenderStyleCache(int n) {
            this.cacheKey = new MatchingCacheKey();
            this.matchType = n;
        }

        RenderStyleItem getRenderInstructions() {
            return (RenderStyleItem)this.cache.get(this.cacheKey);
        }
    }

    class RenderStyleItem {
        MatchingCacheKey key;
        RenderStyle[] list;
        RenderStyleItem next;
        int zoom;

        RenderStyleItem() {
        }
    }
}

