/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.ThemeUtils;
import org.oscim.theme.XmlRenderThemeMenuCallback;
import org.oscim.utils.Utils;

public class StreamRenderTheme
implements ThemeFile {
    private static final long serialVersionUID = 1L;
    private final InputStream mInputStream;
    private XmlRenderThemeMenuCallback mMenuCallback;
    private final String mRelativePathPrefix;

    public StreamRenderTheme(String string2, InputStream inputStream) {
        this(string2, inputStream, null);
    }

    public StreamRenderTheme(String object, InputStream inputStream, XmlRenderThemeMenuCallback xmlRenderThemeMenuCallback) {
        this.mRelativePathPrefix = object;
        this.mInputStream = object = new BufferedInputStream(inputStream);
        ((InputStream)object).mark(0);
        this.mMenuCallback = xmlRenderThemeMenuCallback;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StreamRenderTheme)) {
            return false;
        }
        object = (StreamRenderTheme)object;
        if (this.mInputStream != ((StreamRenderTheme)object).mInputStream) {
            return false;
        }
        return Utils.equals(this.mRelativePathPrefix, ((StreamRenderTheme)object).mRelativePathPrefix);
    }

    @Override
    public XmlRenderThemeMenuCallback getMenuCallback() {
        return this.mMenuCallback;
    }

    @Override
    public String getRelativePathPrefix() {
        return this.mRelativePathPrefix;
    }

    @Override
    public InputStream getRenderThemeAsStream() throws IRenderTheme.ThemeException {
        try {
            this.mInputStream.reset();
            return this.mInputStream;
        }
        catch (IOException iOException) {
            throw new IRenderTheme.ThemeException(iOException.getMessage());
        }
    }

    @Override
    public boolean isMapsforgeTheme() {
        return ThemeUtils.isMapsforgeTheme(this);
    }

    @Override
    public void setMenuCallback(XmlRenderThemeMenuCallback xmlRenderThemeMenuCallback) {
        this.mMenuCallback = xmlRenderThemeMenuCallback;
    }
}

