/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.util.concurrent.atomic.AtomicBoolean;
import org.oscim.backend.XMLReaderAdapter;
import org.oscim.theme.SAXTerminationException;
import org.oscim.theme.ThemeFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ThemeUtils {
    private static final Logger log = LoggerFactory.getLogger(ThemeUtils.class);

    private ThemeUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMapsforgeTheme(ThemeFile themeFile) {
        try {
            final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            try {
                XMLReaderAdapter xMLReaderAdapter = new XMLReaderAdapter();
                DefaultHandler defaultHandler = new DefaultHandler(){

                    @Override
                    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
                        if (!string3.equals("rendertheme")) {
                            return;
                        }
                        atomicBoolean.set(string2.equals("http://mapsforge.org/renderTheme"));
                        throw new SAXTerminationException();
                    }
                };
                xMLReaderAdapter.parse(defaultHandler, themeFile.getRenderThemeAsStream());
                return atomicBoolean.get();
            }
            catch (SAXTerminationException sAXTerminationException) {
                return atomicBoolean.get();
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), exception);
            return false;
        }
    }
}

