/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.Platform;
import org.oscim.backend.XMLReaderAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.theme.AtlasRenderTheme;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.RenderTheme;
import org.oscim.theme.ThemeCallback;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlThemeBuilder;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.utils.TextureAtlasUtils;
import org.xml.sax.helpers.DefaultHandler;

public class XmlAtlasThemeBuilder
extends XmlThemeBuilder {
    private final List<TextureAtlas> atlasList;
    private final Map<Object, Bitmap> bitmapMap = new HashMap<Object, Bitmap>();
    private final Map<Object, TextureRegion> regionMap;

    public XmlAtlasThemeBuilder(ThemeFile themeFile, Map<Object, TextureRegion> map, List<TextureAtlas> list) {
        this(themeFile, null, map, list);
    }

    public XmlAtlasThemeBuilder(ThemeFile themeFile, ThemeCallback themeCallback, Map<Object, TextureRegion> map, List<TextureAtlas> list) {
        super(themeFile, themeCallback);
        this.regionMap = map;
        this.atlasList = list;
    }

    public static IRenderTheme read(ThemeFile themeFile) throws IRenderTheme.ThemeException {
        return XmlAtlasThemeBuilder.read(themeFile, null);
    }

    public static IRenderTheme read(ThemeFile object, ThemeCallback object2) throws IRenderTheme.ThemeException {
        boolean bl;
        HashMap<Object, TextureRegion> hashMap = new HashMap<Object, TextureRegion>();
        ArrayList<TextureAtlas> arrayList = new ArrayList<TextureAtlas>();
        object2 = new XmlAtlasThemeBuilder((ThemeFile)object, (ThemeCallback)object2, hashMap, arrayList);
        try {
            XMLReaderAdapter xMLReaderAdapter = new XMLReaderAdapter();
            xMLReaderAdapter.parse((DefaultHandler)object2, object.getRenderThemeAsStream());
            object = ((XmlAtlasThemeBuilder)object2).bitmapMap;
            bl = CanvasAdapter.platform == Platform.IOS;
        }
        catch (Exception exception) {
            throw new IRenderTheme.ThemeException(exception.getMessage());
        }
        TextureAtlasUtils.createTextureRegions((Map<Object, Bitmap>)object, hashMap, arrayList, true, bl);
        return XmlAtlasThemeBuilder.replaceThemeSymbols(((XmlAtlasThemeBuilder)object2).mRenderTheme, hashMap);
    }

    private static void replaceRuleSymbols(Rule ruleArray, Map<Object, TextureRegion> map, SymbolStyle.SymbolBuilder<?> symbolBuilder) {
        int n;
        int n2 = ruleArray.styles.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            Object object = ruleArray.styles[n];
            if (!(object instanceof SymbolStyle) || (object = map.get(((SymbolStyle)object).hash)) == null) continue;
            Object obj = symbolBuilder.reset();
            ruleArray.styles[n] = ((SymbolStyle.SymbolBuilder)((SymbolStyle.SymbolBuilder)obj).texture((TextureRegion)object)).build();
        }
        ruleArray = ruleArray.subRules;
        n2 = ruleArray.length;
        for (n = n3; n < n2; ++n) {
            XmlAtlasThemeBuilder.replaceRuleSymbols(ruleArray[n], map, symbolBuilder);
        }
    }

    private static IRenderTheme replaceThemeSymbols(RenderTheme renderTheme, Map<Object, TextureRegion> map) {
        SymbolStyle.SymbolBuilder<?> symbolBuilder = SymbolStyle.builder();
        Rule[] ruleArray = renderTheme.getRules();
        int n = ruleArray.length;
        for (int i = 0; i < n; ++i) {
            XmlAtlasThemeBuilder.replaceRuleSymbols(ruleArray[i], map, symbolBuilder);
        }
        return renderTheme;
    }

    @Override
    SymbolStyle buildSymbol(SymbolStyle.SymbolBuilder<?> symbolBuilder, String string2, Bitmap bitmap) {
        string2 = CanvasAdapter.getAbsoluteFile(this.mTheme.getRelativePathPrefix(), string2).getAbsolutePath();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(symbolBuilder.symbolWidth);
        stringBuilder.append(symbolBuilder.symbolHeight);
        stringBuilder.append(symbolBuilder.symbolPercent);
        int n = stringBuilder.toString().hashCode();
        this.bitmapMap.put(n, bitmap);
        return ((SymbolStyle.SymbolBuilder)symbolBuilder.hash(n)).build();
    }

    @Override
    RenderTheme createTheme(Rule[] ruleArray) {
        return new AtlasRenderTheme(this.mMapBackground, this.mTextScale, ruleArray, this.mLevels, this.regionMap, this.atlasList);
    }
}

