/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.XMLReaderAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Color;
import org.oscim.backend.canvas.Paint;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.RenderTheme;
import org.oscim.theme.ThemeCallback;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlRenderThemeStyleLayer;
import org.oscim.theme.XmlRenderThemeStyleMenu;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.rule.RuleBuilder;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.CircleStyle;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;
import org.oscim.utils.FastMath;
import org.oscim.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlMapsforgeThemeBuilder
extends DefaultHandler {
    private static final String AREA_STYLE = "A";
    private static final int DEFAULT_PRIORITY = 0x3FFFFFFF;
    private static final String ELEMENT_NAME_MATCH = "rule";
    private static final String ELEMENT_NAME_RENDER_THEME = "rendertheme";
    private static final String ELEMENT_NAME_STYLE_MENU = "stylemenu";
    private static final String LINE_STYLE = "L";
    private static final String OUTLINE_STYLE = "O";
    private static final int RENDER_THEME_VERSION = 6;
    private static final String UNEXPECTED_ELEMENT = "unexpected element: ";
    private static final Logger log = LoggerFactory.getLogger(XmlMapsforgeThemeBuilder.class);
    private final AreaStyle.AreaBuilder<?> mAreaBuilder;
    private Set<String> mCategories;
    private final CircleStyle.CircleBuilder<?> mCircleBuilder;
    private XmlRenderThemeStyleLayer mCurrentLayer;
    private RuleBuilder mCurrentRule;
    private final Stack<Element> mElementStack;
    private final ExtrusionStyle.ExtrusionBuilder<?> mExtrusionBuilder;
    int mLevels = 0;
    private final LineStyle.LineBuilder<?> mLineBuilder;
    int mMapBackground = -1;
    RenderTheme mRenderTheme;
    private XmlRenderThemeStyleMenu mRenderThemeStyleMenu;
    private final Stack<RuleBuilder> mRuleStack;
    private final ArrayList<RuleBuilder> mRulesList = new ArrayList();
    private final float mScale;
    private final float mScale2;
    private float mStrokeScale = 1.0f;
    private final HashMap<String, RenderStyle> mStyles;
    private final SymbolStyle.SymbolBuilder<?> mSymbolBuilder;
    private final TextStyle.TextBuilder<?> mTextBuilder;
    float mTextScale = 1.0f;
    private final HashMap<String, TextStyle.TextBuilder<?>> mTextStyles;
    private TextureAtlas mTextureAtlas;
    final ThemeFile mTheme;
    private final ThemeCallback mThemeCallback;

    public XmlMapsforgeThemeBuilder(ThemeFile themeFile) {
        this(themeFile, null);
    }

    public XmlMapsforgeThemeBuilder(ThemeFile themeFile, ThemeCallback themeCallback) {
        this.mElementStack = new Stack();
        this.mRuleStack = new Stack();
        this.mStyles = new HashMap(10);
        this.mTextStyles = new HashMap(10);
        this.mAreaBuilder = AreaStyle.builder();
        this.mCircleBuilder = CircleStyle.builder();
        this.mExtrusionBuilder = ExtrusionStyle.builder();
        this.mLineBuilder = LineStyle.builder();
        this.mSymbolBuilder = SymbolStyle.builder();
        this.mTextBuilder = TextStyle.builder();
        this.mTheme = themeFile;
        this.mThemeCallback = themeCallback;
        this.mScale = CanvasAdapter.getScale();
        this.mScale2 = CanvasAdapter.getScale() * 0.5f;
    }

    private RuleBuilder buildingRule() {
        Object obj = this.mExtrusionBuilder.reset();
        int n = this.mLevels;
        this.mLevels = n + 1;
        ((RenderStyle.StyleBuilder)obj).level(n);
        ((RenderStyle.StyleBuilder)obj).themeCallback(this.mThemeCallback);
        ((ExtrusionStyle.ExtrusionBuilder)obj).colorLine(-2500394);
        ((ExtrusionStyle.ExtrusionBuilder)obj).colorSide(-353571863);
        ((ExtrusionStyle.ExtrusionBuilder)obj).colorTop(-352716554);
        RuleBuilder ruleBuilder = new RuleBuilder(RuleBuilder.RuleType.POSITIVE, new String[]{"building"}, new String[0]);
        ruleBuilder.element(6).zoom((byte)17, (byte)127).style(new RenderStyle.StyleBuilder[]{obj});
        return ruleBuilder;
    }

    private void checkElement(String charSequence, Element object) throws SAXException {
        switch (1.$SwitchMap$org$oscim$theme$XmlMapsforgeThemeBuilder$Element[((Enum)object).ordinal()]) {
            default: {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("unknown enum value: ");
                ((StringBuilder)charSequence).append(object);
                throw new SAXException(((StringBuilder)charSequence).toString());
            }
            case 6: {
                return;
            }
            case 5: {
                object = this.mElementStack.peek();
                if (object != Element.RENDER_THEME && object != Element.ATLAS) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(UNEXPECTED_ELEMENT);
                    ((StringBuilder)object).append((String)charSequence);
                    throw new SAXException(((StringBuilder)object).toString());
                }
                return;
            }
            case 4: {
                if (this.mElementStack.peek() == Element.RULE) {
                    return;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append(UNEXPECTED_ELEMENT);
                ((StringBuilder)object).append((String)charSequence);
                throw new SAXException(((StringBuilder)object).toString());
            }
            case 3: {
                if (this.mElementStack.peek() == Element.RENDER_THEME) {
                    return;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append(UNEXPECTED_ELEMENT);
                ((StringBuilder)object).append((String)charSequence);
                throw new SAXException(((StringBuilder)object).toString());
            }
            case 2: {
                object = this.mElementStack.peek();
                if (object != Element.RENDER_THEME && object != Element.RULE) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(UNEXPECTED_ELEMENT);
                    ((StringBuilder)object).append((String)charSequence);
                    throw new SAXException(((StringBuilder)object).toString());
                }
                return;
            }
            case 1: 
        }
        if (this.mElementStack.empty()) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(UNEXPECTED_ELEMENT);
        ((StringBuilder)object).append((String)charSequence);
        throw new SAXException(((StringBuilder)object).toString());
    }

    private void checkState(String string2, Element element) throws SAXException {
        this.checkElement(string2, element);
        this.mElementStack.push(element);
    }

    private AreaStyle createArea(AreaStyle object, String string2, Attributes attributes, int n) {
        Object obj = this.mAreaBuilder.set((AreaStyle)object);
        ((RenderStyle.StyleBuilder)obj).level(n);
        ((RenderStyle.StyleBuilder)obj).themeCallback(this.mThemeCallback);
        object = null;
        for (n = 0; n < attributes.getLength(); ++n) {
            String string3 = attributes.getLocalName(n);
            String string4 = attributes.getValue(n);
            if ("id".equals(string3)) {
                ((AreaStyle.AreaBuilder)obj).style = string4;
                continue;
            }
            if ("cat".equals(string3)) {
                ((RenderStyle.StyleBuilder)obj).cat(string4);
                continue;
            }
            if ("use".equals(string3)) continue;
            if ("src".equals(string3)) {
                object = string4;
                continue;
            }
            if ("fill".equals(string3)) {
                ((RenderStyle.StyleBuilder)obj).color(string4);
                continue;
            }
            if ("stroke".equals(string3)) {
                ((RenderStyle.StyleBuilder)obj).strokeColor(string4);
                continue;
            }
            if ("stroke-width".equals(string3)) {
                float f = Float.parseFloat(string4);
                XmlMapsforgeThemeBuilder.validateNonNegative("stroke-width", f);
                ((AreaStyle.AreaBuilder)obj).strokeWidth = f * this.mScale * this.mStrokeScale;
                continue;
            }
            if ("fade".equals(string3)) {
                ((AreaStyle.AreaBuilder)obj).fadeScale = Integer.parseInt(string4);
                continue;
            }
            if ("blend".equals(string3)) {
                ((AreaStyle.AreaBuilder)obj).blendScale = Integer.parseInt(string4);
                continue;
            }
            if ("blend-fill".equals(string3)) {
                ((AreaStyle.AreaBuilder)obj).blendColor(string4);
                continue;
            }
            if ("mesh".equals(string3)) {
                ((AreaStyle.AreaBuilder)obj).mesh(Boolean.parseBoolean(string4));
                continue;
            }
            if ("symbol-width".equals(string3)) {
                ((AreaStyle.AreaBuilder)obj).symbolWidth = (int)((float)Integer.parseInt(string4) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(string3)) {
                ((AreaStyle.AreaBuilder)obj).symbolHeight = (int)((float)Integer.parseInt(string4) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(string3)) {
                ((AreaStyle.AreaBuilder)obj).symbolPercent = Integer.parseInt(string4);
                continue;
            }
            if ("symbol-scaling".equals(string3)) continue;
            XmlMapsforgeThemeBuilder.logUnknownAttribute(string2, string3, string4, n);
        }
        ((AreaStyle.AreaBuilder)obj).texture = Utils.loadTexture(this.mTheme.getRelativePathPrefix(), (String)object, ((AreaStyle.AreaBuilder)obj).symbolWidth, ((AreaStyle.AreaBuilder)obj).symbolHeight, ((AreaStyle.AreaBuilder)obj).symbolPercent);
        return ((AreaStyle.AreaBuilder)obj).build();
    }

    private void createAtlas(String object, Attributes attributes) throws IOException {
        String string2 = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string3 = attributes.getLocalName(i);
            String string4 = attributes.getValue(i);
            if ("img".equals(string3)) {
                string2 = string4;
                continue;
            }
            XmlMapsforgeThemeBuilder.logUnknownAttribute((String)object, string3, string4, i);
        }
        XmlMapsforgeThemeBuilder.validateExists("img", string2, (String)object);
        object = CanvasAdapter.getBitmapAsset(this.mTheme.getRelativePathPrefix(), string2);
        if (object != null) {
            this.mTextureAtlas = new TextureAtlas((Bitmap)object);
        }
    }

    private CircleStyle createCircle(String string2, Attributes attributes, int n) {
        Object obj = this.mCircleBuilder.reset();
        ((RenderStyle.StyleBuilder)obj).level(n);
        ((RenderStyle.StyleBuilder)obj).themeCallback(this.mThemeCallback);
        for (n = 0; n < attributes.getLength(); ++n) {
            String string3 = attributes.getLocalName(n);
            String string4 = attributes.getValue(n);
            if (!"r".equals(string3) && !"radius".equals(string3)) {
                if ("cat".equals(string3)) {
                    ((RenderStyle.StyleBuilder)obj).cat(string4);
                    continue;
                }
                if ("scale-radius".equals(string3)) {
                    ((CircleStyle.CircleBuilder)obj).scaleRadius(Boolean.parseBoolean(string4));
                    continue;
                }
                if ("fill".equals(string3)) {
                    ((RenderStyle.StyleBuilder)obj).color(Color.parseColor(string4));
                    continue;
                }
                if ("stroke".equals(string3)) {
                    ((RenderStyle.StyleBuilder)obj).strokeColor(Color.parseColor(string4));
                    continue;
                }
                if ("stroke-width".equals(string3)) {
                    ((RenderStyle.StyleBuilder)obj).strokeWidth(Float.parseFloat(string4) * this.mScale * this.mStrokeScale);
                    continue;
                }
                XmlMapsforgeThemeBuilder.logUnknownAttribute(string2, string3, string4, n);
                continue;
            }
            ((CircleStyle.CircleBuilder)obj).radius(Float.parseFloat(string4) * this.mScale * this.mStrokeScale);
        }
        XmlMapsforgeThemeBuilder.validateExists("radius", Float.valueOf(((CircleStyle.CircleBuilder)obj).radius), string2);
        XmlMapsforgeThemeBuilder.validateNonNegative("radius", ((CircleStyle.CircleBuilder)obj).radius);
        XmlMapsforgeThemeBuilder.validateNonNegative("stroke-width", ((CircleStyle.CircleBuilder)obj).strokeWidth);
        return ((CircleStyle.CircleBuilder)obj).build();
    }

    private ExtrusionStyle createExtrusion(String string2, Attributes attributes, int n) {
        Object obj = this.mExtrusionBuilder.reset();
        ((RenderStyle.StyleBuilder)obj).level(n);
        ((RenderStyle.StyleBuilder)obj).themeCallback(this.mThemeCallback);
        for (n = 0; n < attributes.getLength(); ++n) {
            String string3 = attributes.getLocalName(n);
            String string4 = attributes.getValue(n);
            if ("cat".equals(string3)) {
                ((RenderStyle.StyleBuilder)obj).cat(string4);
                continue;
            }
            if ("side-color".equals(string3)) {
                ((ExtrusionStyle.ExtrusionBuilder)obj).colorSide(Color.parseColor(string4));
                continue;
            }
            if ("top-color".equals(string3)) {
                ((ExtrusionStyle.ExtrusionBuilder)obj).colorTop(Color.parseColor(string4));
                continue;
            }
            if ("line-color".equals(string3)) {
                ((ExtrusionStyle.ExtrusionBuilder)obj).colorLine(Color.parseColor(string4));
                continue;
            }
            if ("default-height".equals(string3)) {
                ((ExtrusionStyle.ExtrusionBuilder)obj).defaultHeight(Integer.parseInt(string4));
                continue;
            }
            XmlMapsforgeThemeBuilder.logUnknownAttribute(string2, string3, string4, n);
        }
        return ((ExtrusionStyle.ExtrusionBuilder)obj).build();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private LineStyle createLine(LineStyle var1_1, String var2_2, Attributes var3_3, int var4_4, boolean var5_5, boolean var6_6) {
        var7_7 = this.mLineBuilder.set((LineStyle)var1_1);
        var7_7.isOutline(var5_5);
        var7_7.level(var4_4);
        var7_7.themeCallback(this.mThemeCallback);
        var8_8 = null;
        for (var4_4 = 0; var4_4 < var3_3.getLength(); ++var4_4) {
            block19: {
                block22: {
                    block23: {
                        block30: {
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block29: {
                                                block28: {
                                                    block27: {
                                                        block26: {
                                                            block25: {
                                                                block24: {
                                                                    block21: {
                                                                        block20: {
                                                                            var9_9 = var3_3.getLocalName(var4_4);
                                                                            var10_10 = var3_3.getValue(var4_4);
                                                                            if ("id".equals(var9_9)) {
                                                                                var7_7.style = var10_10;
lbl14:
                                                                                // 18 sources

                                                                                while (true) {
                                                                                    var10_10 = var8_8;
                                                                                    break block19;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            if (!"cat".equals(var9_9)) break block20;
                                                                            var7_7.cat(var10_10);
                                                                            ** GOTO lbl14
                                                                        }
                                                                        if ("src".equals(var9_9)) break block19;
                                                                        if ("use".equals(var9_9) || "outline".equals(var9_9)) ** GOTO lbl14
                                                                        if (!"stroke".equals(var9_9)) break block21;
                                                                        var7_7.color(var10_10);
                                                                        ** GOTO lbl14
                                                                    }
                                                                    if ("width".equals(var9_9) || "stroke-width".equals(var9_9)) break block22;
                                                                    if ("cap".equals(var9_9) || "stroke-linecap".equals(var9_9)) break block23;
                                                                    if (!"fix".equals(var9_9)) break block24;
                                                                    var7_7.fixed = Boolean.parseBoolean(var10_10);
                                                                    ** GOTO lbl14
                                                                }
                                                                if (!"stipple".equals(var9_9)) break block25;
                                                                var7_7.stipple = Math.round((float)Integer.parseInt(var10_10) * this.mScale2 * this.mStrokeScale);
                                                                ** GOTO lbl14
                                                            }
                                                            if (!"stipple-stroke".equals(var9_9)) break block26;
                                                            var7_7.stippleColor(var10_10);
                                                            ** GOTO lbl14
                                                        }
                                                        if (!"stipple-width".equals(var9_9)) break block27;
                                                        var7_7.stippleWidth = Float.parseFloat(var10_10);
                                                        ** GOTO lbl14
                                                    }
                                                    if (!"fade".equals(var9_9)) break block28;
                                                    var7_7.fadeScale = Integer.parseInt(var10_10);
                                                    ** GOTO lbl14
                                                }
                                                if ("min".equals(var9_9)) ** GOTO lbl14
                                                if (!"blur".equals(var9_9)) break block29;
                                                var7_7.blur = Float.parseFloat(var10_10);
                                                ** GOTO lbl14
                                            }
                                            if ("style".equals(var9_9)) ** GOTO lbl14
                                            if ("dasharray".equals(var9_9) || "stroke-dasharray".equals(var9_9)) break block30;
                                            if (!"symbol-width".equals(var9_9)) break block31;
                                            var7_7.symbolWidth = (int)((float)Integer.parseInt(var10_10) * this.mScale);
                                            ** GOTO lbl14
                                        }
                                        if (!"symbol-height".equals(var9_9)) break block32;
                                        var7_7.symbolHeight = (int)((float)Integer.parseInt(var10_10) * this.mScale);
                                        ** GOTO lbl14
                                    }
                                    if (!"symbol-percent".equals(var9_9)) break block33;
                                    var7_7.symbolPercent = Integer.parseInt(var10_10);
                                    ** GOTO lbl14
                                }
                                if ("symbol-scaling".equals(var9_9)) ** GOTO lbl14
                                if (!"repeat-start".equals(var9_9)) break block34;
                                var7_7.repeatStart = Float.parseFloat(var10_10) * this.mScale;
                                ** GOTO lbl14
                            }
                            if ("repeat-gap".equals(var9_9)) {
                                var7_7.repeatGap = Float.parseFloat(var10_10) * this.mScale;
                                ** continue;
                            }
                            XmlMapsforgeThemeBuilder.logUnknownAttribute((String)var2_2, var9_9, var10_10, var4_4);
                            var10_10 = var8_8;
                            break block19;
                        }
                        var7_7.dashArray = XmlMapsforgeThemeBuilder.parseFloatArray(var10_10);
                        var11_11 = 0;
                        while (true) {
                            var10_10 = var8_8;
                            if (var11_11 < var7_7.dashArray.length) {
                                var7_7.dashArray[var11_11] = var7_7.dashArray[var11_11] * this.mScale * this.mStrokeScale;
                                ++var11_11;
                                continue;
                            }
                            break block19;
                            break;
                        }
                    }
                    var7_7.cap = Paint.Cap.valueOf(var10_10.toUpperCase(Locale.ENGLISH));
                    var10_10 = var8_8;
                    break block19;
                }
                var7_7.strokeWidth = Float.parseFloat(var10_10) * this.mScale2 * this.mStrokeScale;
                if (var1_1 == null) {
                    var10_10 = var8_8;
                    if (!var5_5) {
                        XmlMapsforgeThemeBuilder.validateNonNegative("width", var7_7.strokeWidth);
                        var10_10 = var8_8;
                    }
                } else {
                    var7_7.strokeWidth += var1_1.width;
                    var10_10 = var8_8;
                    if (var7_7.strokeWidth <= 0.0f) {
                        var7_7.strokeWidth = 1.0f;
                        var10_10 = var8_8;
                    }
                }
            }
            var8_8 = var10_10;
        }
        if (var7_7.dashArray != null) {
            if (var7_7.dashArray.length % 2 != 0) {
                var1_1 = new float[var7_7.dashArray.length * 2];
                System.arraycopy(var7_7.dashArray, 0, var1_1, 0, var7_7.dashArray.length);
                System.arraycopy(var7_7.dashArray, 0, var1_1, var7_7.dashArray.length, var7_7.dashArray.length);
                var7_7.dashArray = (float[])var1_1;
            }
            var4_4 = var11_11 = (int)var7_7.strokeWidth;
            if (var11_11 < 1) {
                var4_4 = 1;
            }
            var1_1 = var7_7.dashArray;
            var12_12 = ((Object)var1_1).length;
            var11_11 = 0;
            for (var13_13 = 0; var13_13 < var12_12; ++var13_13) {
                var15_15 /* !! */  = var14_14 /* !! */  = var1_1[var13_13];
                if (var14_14 /* !! */  < 1.0f) {
                    var15_15 /* !! */  = 1.0f;
                }
                var11_11 = (int)((float)var11_11 + var15_15 /* !! */ );
            }
            var3_3 = CanvasAdapter.newBitmap(var11_11, var4_4, 0);
            var2_2 = CanvasAdapter.newCanvas();
            var2_2.setBitmap((Bitmap)var3_3);
            var1_1 = var7_7.dashArray;
            var16_16 = ((Object)var1_1).length;
            var17_17 = 0;
            var13_13 = 0;
            for (var12_12 = 0; var12_12 < var16_16; ++var12_12) {
                var15_15 /* !! */  = var14_14 /* !! */  = var1_1[var12_12];
                if (var14_14 /* !! */  < 1.0f) {
                    var15_15 /* !! */  = 1.0f;
                }
                var14_14 /* !! */  = (float)var17_17;
                var18_18 = var4_4;
                var17_17 = var13_13 != 0 ? 0 : -1;
                var2_2.fillRectangle((float)var14_14 /* !! */ , 0.0f, (float)var15_15 /* !! */ , var18_18, var17_17);
                var17_17 = (int)(var14_14 /* !! */  + var15_15 /* !! */ );
                var13_13 ^= 1;
            }
            var7_7.texture = new TextureItem(Utils.potBitmap((Bitmap)var3_3));
            var7_7.texture.mipmap = true;
            var7_7.randomOffset = false;
            var7_7.stipple = var11_11;
            var7_7.stippleWidth = 1.0f;
            var7_7.stippleColor = var7_7.fillColor;
        } else {
            var7_7.texture = Utils.loadTexture(this.mTheme.getRelativePathPrefix(), var8_8, var7_7.symbolWidth, var7_7.symbolHeight, var7_7.symbolPercent);
            if (var6_6) {
                var4_4 = (int)((float)var7_7.texture.width + var7_7.repeatGap);
                var11_11 = var7_7.texture.height;
                var1_1 = CanvasAdapter.newBitmap(var4_4, var11_11, 0);
                var2_2 = CanvasAdapter.newCanvas();
                var2_2.setBitmap((Bitmap)var1_1);
                var2_2.drawBitmap(var7_7.texture.bitmap, var7_7.repeatStart, 0.0f);
                var7_7.texture = new TextureItem(Utils.potBitmap((Bitmap)var1_1));
                var7_7.texture.mipmap = true;
                var7_7.fixed = true;
                var7_7.randomOffset = false;
                var7_7.stipple = var4_4;
                var7_7.stippleWidth = 1.0f;
                var7_7.strokeWidth = (float)var11_11 * 0.5f;
                var7_7.stippleColor = -1;
            }
        }
        return var7_7.build();
    }

    private LineStyle createOutline(String object, Attributes object2) {
        Logger logger = null;
        if (object != null) {
            Object object3 = this.mStyles;
            CharSequence charSequence = new StringBuilder();
            charSequence.append(OUTLINE_STYLE);
            charSequence.append((String)object);
            object3 = (LineStyle)((HashMap)object3).get(charSequence.toString());
            if (object3 != null && ((LineStyle)object3).outline) {
                int n = 0;
                while (true) {
                    object = logger;
                    if (n >= object2.getLength()) break;
                    charSequence = object2.getLocalName(n);
                    object = object2.getValue(n);
                    if ("cat".equals(charSequence)) break;
                    ++n;
                }
                return (LineStyle)((RenderStyle)object3).setCat((String)object);
            }
        }
        logger = log;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("BUG not an outline style: ");
        ((StringBuilder)object2).append((String)object);
        logger.debug(((StringBuilder)object2).toString());
        return null;
    }

    private void createRenderTheme(String charSequence, Attributes attributes) {
        float f = 1.0f;
        Object object = null;
        float f2 = 1.0f;
        int n = -1;
        for (int i = 0; i < attributes.getLength(); ++i) {
            float f3;
            float f4;
            Object object2 = attributes.getLocalName(i);
            Object object3 = attributes.getValue(i);
            if ("schemaLocation".equals(object2)) {
                f4 = f;
                f3 = f2;
                object3 = object;
            } else if ("version".equals(object2)) {
                object3 = Integer.parseInt((String)object3);
                f4 = f;
                f3 = f2;
            } else if ("map-background".equals(object2)) {
                int n2 = Color.parseColor((String)object3);
                object2 = this.mThemeCallback;
                f4 = f;
                f3 = f2;
                object3 = object;
                n = n2;
                if (object2 != null) {
                    n = object2.getColor(n2);
                    f4 = f;
                    f3 = f2;
                    object3 = object;
                }
            } else if ("base-stroke-width".equals(object2)) {
                f4 = Float.parseFloat((String)object3);
                f3 = f2;
                object3 = object;
            } else if (!"base-text-scale".equals(object2) && !"base-text-size".equals(object2)) {
                XmlMapsforgeThemeBuilder.logUnknownAttribute((String)charSequence, (String)object2, (String)object3, i);
                f4 = f;
                f3 = f2;
                object3 = object;
            } else {
                f3 = Float.parseFloat((String)object3);
                object3 = object;
                f4 = f;
            }
            f = f4;
            f2 = f3;
            object = object3;
        }
        XmlMapsforgeThemeBuilder.validateExists("version", object, (String)charSequence);
        if ((Integer)object <= 6) {
            XmlMapsforgeThemeBuilder.validateNonNegative("base-stroke-width", f);
            XmlMapsforgeThemeBuilder.validateNonNegative("base-text-scale", f2);
            this.mMapBackground = n;
            this.mStrokeScale = f;
            this.mTextScale = f2;
            return;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("invalid render theme version:");
        ((StringBuilder)charSequence).append(object);
        throw new IRenderTheme.ThemeException(((StringBuilder)charSequence).toString());
    }

    /*
     * Unable to fully structure code
     */
    private RuleBuilder createRule(String var1_1, Attributes var2_2) {
        var6_6 = var5_5 = (var4_4 = null);
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = 7;
        var10_10 = 3;
        var12_12 = var11_11 = 127;
        var13_13 = var5_5;
        var14_14 = var7_7;
        for (var3_3 = 0; var3_3 < var2_2.getLength(); ++var3_3) {
            block11: {
                block19: {
                    block18: {
                        block17: {
                            block15: {
                                block16: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                var15_15 = var2_2.getLocalName(var3_3);
                                                var5_5 = var2_2.getValue(var3_3);
                                                if ("e".equals(var15_15)) {
                                                    if ("WAY".equals(var5_5 = var5_5.toUpperCase(Locale.ENGLISH))) {
                                                        var11_11 = 6;
                                                        var16_16 = var14_14;
                                                        var7_7 = var8_8;
                                                        var17_17 = var10_10;
                                                        var18_18 = var12_12;
                                                    } else {
                                                        var16_16 = var14_14;
                                                        var7_7 = var8_8;
                                                        var11_11 = var9_9;
                                                        var17_17 = var10_10;
                                                        var18_18 = var12_12;
                                                        if ("NODE".equals(var5_5)) {
                                                            var11_11 = 1;
                                                            var18_18 = var12_12;
                                                            var17_17 = var10_10;
                                                            var7_7 = var8_8;
                                                            var16_16 = var14_14;
                                                        }
                                                    }
lbl31:
                                                    // 13 sources

                                                    while (true) {
                                                        var8_8 = var7_7;
                                                        var5_5 = var6_6;
                                                        var9_9 = var11_11;
                                                        break block11;
                                                        break;
                                                    }
                                                }
                                                if (!"k".equals(var15_15)) break block12;
                                                var16_16 = var14_14;
                                                var7_7 = var8_8;
                                                var11_11 = var9_9;
                                                var17_17 = var10_10;
                                                var18_18 = var12_12;
                                                if ("*".equals(var5_5)) ** GOTO lbl31
                                                var16_16 = var14_14;
                                                var4_4 = var5_5;
                                                var5_5 = var6_6;
                                                var17_17 = var10_10;
                                                var18_18 = var12_12;
                                                break block11;
                                            }
                                            if (!"v".equals(var15_15)) break block13;
                                            var16_16 = var14_14;
                                            var7_7 = var8_8;
                                            var11_11 = var9_9;
                                            var17_17 = var10_10;
                                            var18_18 = var12_12;
                                            if ("*".equals(var5_5)) ** GOTO lbl31
                                            var16_16 = var14_14;
                                            var13_13 = var5_5;
                                            var5_5 = var6_6;
                                            var17_17 = var10_10;
                                            var18_18 = var12_12;
                                            break block11;
                                        }
                                        if (!"cat".equals(var15_15)) break block14;
                                        var16_16 = var14_14;
                                        var17_17 = var10_10;
                                        var18_18 = var12_12;
                                        break block11;
                                    }
                                    if (!"closed".equals(var15_15)) break block15;
                                    if (!"YES".equals(var5_5 = var5_5.toUpperCase(Locale.ENGLISH))) break block16;
                                    var17_17 = 2;
                                    var16_16 = var14_14;
                                    var7_7 = var8_8;
                                    var11_11 = var9_9;
                                    var18_18 = var12_12;
                                    ** GOTO lbl31
                                }
                                var16_16 = var14_14;
                                var7_7 = var8_8;
                                var11_11 = var9_9;
                                var17_17 = var10_10;
                                var18_18 = var12_12;
                                if (!"NO".equals(var5_5)) ** GOTO lbl31
                                var17_17 = 1;
                                var16_16 = var14_14;
                                var7_7 = var8_8;
                                var11_11 = var9_9;
                                var18_18 = var12_12;
                                ** GOTO lbl31
                            }
                            if (!"zoom-min".equals(var15_15)) break block17;
                            var16_16 = Byte.parseByte(var5_5);
                            var7_7 = var8_8;
                            var11_11 = var9_9;
                            var17_17 = var10_10;
                            var18_18 = var12_12;
                            ** GOTO lbl31
                        }
                        if (!"zoom-max".equals(var15_15)) break block18;
                        var18_18 = Byte.parseByte(var5_5);
                        var16_16 = var14_14;
                        var7_7 = var8_8;
                        var11_11 = var9_9;
                        var17_17 = var10_10;
                        ** GOTO lbl31
                    }
                    if (!"select".equals(var15_15)) break block19;
                    var19_19 = var8_8;
                    if ("first".equals(var5_5)) {
                        var19_19 = var8_8 | 1;
                    }
                    var16_16 = var14_14;
                    var7_7 = var19_19;
                    var11_11 = var9_9;
                    var17_17 = var10_10;
                    var18_18 = var12_12;
                    if (!"when-matched".equals(var5_5)) ** GOTO lbl31
                    var7_7 = var19_19 | 2;
                    var16_16 = var14_14;
                    var11_11 = var9_9;
                    var17_17 = var10_10;
                    var18_18 = var12_12;
                    ** continue;
                }
                XmlMapsforgeThemeBuilder.logUnknownAttribute((String)var1_1, var15_15, var5_5, var3_3);
                var18_18 = var12_12;
                var17_17 = var10_10;
                var5_5 = var6_6;
                var16_16 = var14_14;
            }
            var14_14 = var16_16;
            var6_6 = var5_5;
            var10_10 = var17_17;
            var12_12 = var18_18;
        }
        if (var10_10 == 2) {
            var9_9 = 4;
        } else if (var10_10 == 1) {
            var9_9 = 2;
        }
        XmlMapsforgeThemeBuilder.validateNonNegative("zoom-min", var14_14);
        XmlMapsforgeThemeBuilder.validateNonNegative("zoom-max", var12_12);
        if (var14_14 <= var12_12) {
            var1_1 = RuleBuilder.create(var4_4, var13_13);
            var1_1.cat(var6_6);
            var1_1.zoom((byte)var14_14, (byte)var12_12);
            var1_1.element(var9_9);
            var1_1.select(var8_8);
            return var1_1;
        }
        var1_1 = new StringBuilder();
        var1_1.append("zoom-min must be less or equal zoom-max: ");
        var1_1.append(var14_14);
        throw new IRenderTheme.ThemeException(var1_1.toString());
    }

    private SymbolStyle createSymbol(String object, Attributes attributes) {
        block10: {
            Object obj = this.mSymbolBuilder.reset();
            String string2 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string3 = attributes.getLocalName(i);
                String string4 = attributes.getValue(i);
                if ("src".equals(string3)) {
                    string2 = string4;
                    continue;
                }
                if ("cat".equals(string3)) {
                    ((RenderStyle.StyleBuilder)obj).cat(string4);
                    continue;
                }
                if ("symbol-width".equals(string3)) {
                    ((SymbolStyle.SymbolBuilder)obj).symbolWidth = (int)((float)Integer.parseInt(string4) * this.mScale);
                    continue;
                }
                if ("symbol-height".equals(string3)) {
                    ((SymbolStyle.SymbolBuilder)obj).symbolHeight = (int)((float)Integer.parseInt(string4) * this.mScale);
                    continue;
                }
                if ("symbol-percent".equals(string3)) {
                    ((SymbolStyle.SymbolBuilder)obj).symbolPercent = Integer.parseInt(string4);
                    continue;
                }
                if ("symbol-scaling".equals(string3)) continue;
                XmlMapsforgeThemeBuilder.logUnknownAttribute((String)object, string3, string4, i);
            }
            XmlMapsforgeThemeBuilder.validateExists("src", string2, (String)object);
            object = string2.toLowerCase(Locale.ENGLISH);
            if (!((String)object).endsWith(".png") && !((String)object).endsWith(".svg")) {
                return ((SymbolStyle.SymbolBuilder)((SymbolStyle.SymbolBuilder)obj).texture(this.getAtlasRegion(string2))).build();
            }
            object = CanvasAdapter.getBitmapAsset(this.mTheme.getRelativePathPrefix(), string2, ((SymbolStyle.SymbolBuilder)obj).symbolWidth, ((SymbolStyle.SymbolBuilder)obj).symbolHeight, ((SymbolStyle.SymbolBuilder)obj).symbolPercent);
            if (object == null) break block10;
            try {
                object = this.buildSymbol((SymbolStyle.SymbolBuilder<?>)obj, string2, (Bitmap)object);
                return object;
            }
            catch (Exception exception) {
                log.error("{}: {}", (Object)string2, (Object)exception.getMessage());
            }
        }
        return null;
    }

    private TextStyle.TextBuilder<?> createText(String string2, Attributes attributes, boolean bl, TextStyle.TextBuilder<?> textBuilder) {
        if (textBuilder == null) {
            textBuilder = this.mTextBuilder.reset();
            textBuilder.caption = bl;
        } else {
            textBuilder = this.mTextBuilder.from(textBuilder);
        }
        textBuilder.themeCallback(this.mThemeCallback);
        String string3 = null;
        textBuilder.priority = 0x3FFFFFFF;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getLocalName(i);
            String string5 = attributes.getValue(i);
            if ("id".equals(string4)) {
                textBuilder.style = string5;
                string4 = string3;
            } else if ("cat".equals(string4)) {
                textBuilder.cat(string5);
                string4 = string3;
            } else if ("k".equals(string4)) {
                textBuilder.textKey = string5.intern();
                string4 = string3;
            } else if ("font-family".equals(string4)) {
                textBuilder.fontFamily = Paint.FontFamily.valueOf(string5.toUpperCase(Locale.ENGLISH));
                string4 = string3;
            } else if (!"style".equals(string4) && !"font-style".equals(string4)) {
                if (!"size".equals(string4) && !"font-size".equals(string4)) {
                    if ("fill".equals(string4)) {
                        textBuilder.fillColor = Color.parseColor(string5);
                        string4 = string3;
                    } else if ("stroke".equals(string4)) {
                        textBuilder.strokeColor = Color.parseColor(string5);
                        string4 = string3;
                    } else if ("stroke-width".equals(string4)) {
                        textBuilder.strokeWidth = Float.parseFloat(string5) * this.mScale;
                        string4 = string3;
                    } else if ("caption".equals(string4)) {
                        textBuilder.caption = Boolean.parseBoolean(string5);
                        string4 = string3;
                    } else if ("priority".equals(string4)) {
                        textBuilder.priority = Integer.parseInt(string5);
                        textBuilder.priority = FastMath.clamp(0x3FFFFFFF - textBuilder.priority, 0, Integer.MAX_VALUE);
                        string4 = string3;
                    } else if ("area-size".equals(string4)) {
                        textBuilder.areaSize = Float.parseFloat(string5);
                        string4 = string3;
                    } else if ("dy".equals(string4)) {
                        textBuilder.dy = -Float.parseFloat(string5) * this.mScale;
                        string4 = string3;
                    } else if ("symbol".equals(string4)) {
                        string4 = string5;
                    } else if ("use".equals(string4)) {
                        string4 = string3;
                    } else if ("symbol-width".equals(string4)) {
                        textBuilder.symbolWidth = (int)((float)Integer.parseInt(string5) * this.mScale);
                        string4 = string3;
                    } else if ("symbol-height".equals(string4)) {
                        textBuilder.symbolHeight = (int)((float)Integer.parseInt(string5) * this.mScale);
                        string4 = string3;
                    } else if ("symbol-percent".equals(string4)) {
                        textBuilder.symbolPercent = Integer.parseInt(string5);
                        string4 = string3;
                    } else if ("symbol-scaling".equals(string4)) {
                        string4 = string3;
                    } else if ("position".equals(string4)) {
                        string4 = string3;
                        if (textBuilder.dy == 0.0f) {
                            string4 = "above".equals(string5) ? "20" : "-20";
                            textBuilder.dy = -Float.parseFloat(string4) * this.mScale;
                            string4 = string3;
                        }
                    } else {
                        XmlMapsforgeThemeBuilder.logUnknownAttribute(string2, string4, string5, i);
                        string4 = string3;
                    }
                } else {
                    textBuilder.fontSize = Float.parseFloat(string5);
                    string4 = string3;
                }
            } else {
                textBuilder.fontStyle = Paint.FontStyle.valueOf(string5.toUpperCase(Locale.ENGLISH));
                string4 = string3;
            }
            string3 = string4;
        }
        XmlMapsforgeThemeBuilder.validateExists("k", textBuilder.textKey, string2);
        XmlMapsforgeThemeBuilder.validateNonNegative("size", textBuilder.fontSize);
        XmlMapsforgeThemeBuilder.validateNonNegative("stroke-width", textBuilder.strokeWidth);
        if (string3 != null && string3.length() > 0) {
            string2 = string3.toLowerCase(Locale.ENGLISH);
            if (!string2.endsWith(".png") && !string2.endsWith(".svg")) {
                textBuilder.texture = this.getAtlasRegion(string3);
            } else {
                try {
                    textBuilder.bitmap = CanvasAdapter.getBitmapAsset(this.mTheme.getRelativePathPrefix(), string3, textBuilder.symbolWidth, textBuilder.symbolHeight, textBuilder.symbolPercent);
                }
                catch (Exception exception) {
                    log.error("{}: {}", (Object)string3, (Object)exception.getMessage());
                }
            }
        }
        return textBuilder;
    }

    private void createTextureRegion(String string2, Attributes attributes) {
        if (this.mTextureAtlas == null) {
            return;
        }
        int n = attributes.getLength();
        String string3 = null;
        TextureAtlas.Rect rect = null;
        for (int i = 0; i < n; ++i) {
            String[] stringArray = attributes.getLocalName(i);
            String string4 = attributes.getValue(i);
            if (!"id".equals(stringArray)) {
                if ("pos".equals(stringArray)) {
                    stringArray = string4.split(" ");
                    string4 = string3;
                    if (stringArray.length == 4) {
                        rect = new TextureAtlas.Rect(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
                        string4 = string3;
                    }
                } else {
                    XmlMapsforgeThemeBuilder.logUnknownAttribute(string2, (String)stringArray, string4, i);
                    string4 = string3;
                }
            }
            string3 = string4;
        }
        XmlMapsforgeThemeBuilder.validateExists("id", string3, string2);
        XmlMapsforgeThemeBuilder.validateExists("pos", rect, string2);
        this.mTextureAtlas.addTextureRegion(string3.intern(), rect);
    }

    private TextureRegion getAtlasRegion(String string2) {
        Object object = this.mTextureAtlas;
        if (object == null) {
            return null;
        }
        TextureRegion textureRegion = ((TextureAtlas)object).getTextureRegion(string2);
        if (textureRegion == null) {
            object = log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("missing texture atlas item '");
            stringBuilder.append(string2);
            stringBuilder.append("'");
            object.debug(stringBuilder.toString());
        }
        return textureRegion;
    }

    private String getStringAttribute(Attributes attributes, String string2) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getLocalName(i).equals(string2)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    private void handleAreaElement(String object, Attributes object2, boolean bl) throws SAXException {
        Object object3;
        String string2 = object2.getValue("use");
        if (string2 != null) {
            Object object4 = this.mStyles;
            object3 = new StringBuilder();
            ((StringBuilder)object3).append(AREA_STYLE);
            ((StringBuilder)object3).append(string2);
            object3 = object4 = (AreaStyle)((HashMap)object4).get(((StringBuilder)object3).toString());
            if (object4 == null) {
                object2 = log;
                object = new StringBuilder();
                ((StringBuilder)object).append("missing area style 'use': ");
                ((StringBuilder)object).append(string2);
                object2.debug(((StringBuilder)object).toString());
                return;
            }
        } else {
            object3 = null;
        }
        int n = this.mLevels;
        this.mLevels = n + 1;
        object = this.createArea((AreaStyle)object3, (String)object, (Attributes)object2, n);
        if (bl) {
            object2 = this.mStyles;
            object3 = new StringBuilder();
            ((StringBuilder)object3).append(AREA_STYLE);
            ((StringBuilder)object3).append(((AreaStyle)object).style);
            ((HashMap)object2).put(((StringBuilder)object3).toString(), object);
        } else if (this.isVisible((RenderStyle)object)) {
            this.mCurrentRule.addStyle((RenderStyle)object);
        }
    }

    private void handleLineElement(String object, Attributes object2, boolean bl, boolean bl2) throws SAXException {
        HashMap<String, RenderStyle> hashMap;
        String string2 = object2.getValue("use");
        if (string2 != null) {
            hashMap = this.mStyles;
            Object object3 = new StringBuilder();
            ((StringBuilder)object3).append(LINE_STYLE);
            ((StringBuilder)object3).append(string2);
            object3 = (LineStyle)hashMap.get(((StringBuilder)object3).toString());
            hashMap = object3;
            if (object3 == null) {
                object = log;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("missing line style 'use': ");
                ((StringBuilder)object2).append(string2);
                object.debug(((StringBuilder)object2).toString());
                return;
            }
        } else {
            hashMap = null;
        }
        int n = this.mLevels;
        this.mLevels = n + 1;
        object = this.createLine((LineStyle)((Object)hashMap), (String)object, (Attributes)object2, n, false, bl2);
        if (bl) {
            hashMap = this.mStyles;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(LINE_STYLE);
            ((StringBuilder)object2).append(((LineStyle)object).style);
            hashMap.put(((StringBuilder)object2).toString(), (RenderStyle)object);
        } else if (this.isVisible((RenderStyle)object)) {
            this.mCurrentRule.addStyle((RenderStyle)object);
            object = object2.getValue("outline");
            if (object != null && (object = this.createOutline((String)object, (Attributes)object2)) != null) {
                this.mCurrentRule.addStyle((RenderStyle)object);
            }
        }
    }

    private void handleTextElement(String object, Attributes object2, boolean bl, boolean bl2) throws SAXException {
        TextStyle.TextBuilder<?> textBuilder;
        String string2 = object2.getValue("use");
        if (string2 != null) {
            TextStyle.TextBuilder<?> textBuilder2;
            textBuilder = textBuilder2 = this.mTextStyles.get(string2);
            if (textBuilder2 == null) {
                object = log;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("missing text style: ");
                ((StringBuilder)object2).append(string2);
                object.debug(((StringBuilder)object2).toString());
                return;
            }
        } else {
            textBuilder = null;
        }
        object = this.createText((String)object, (Attributes)object2, bl2, textBuilder);
        if (bl) {
            log.debug("put style {}", (Object)((TextStyle.TextBuilder)object).style);
            this.mTextStyles.put(((TextStyle.TextBuilder)object).style, (TextStyle.TextBuilder<?>)TextStyle.builder().from((TextStyle.TextBuilder<?>)object));
        } else if (this.isVisible((RenderStyle)(object = ((TextStyle.TextBuilder)object).buildInternal()))) {
            this.mCurrentRule.addStyle((RenderStyle)object);
        }
    }

    private boolean isVisible(RuleBuilder ruleBuilder) {
        boolean bl = this.mCategories == null || ruleBuilder.cat == null || this.mCategories.contains(ruleBuilder.cat);
        return bl;
    }

    private boolean isVisible(RenderStyle renderStyle) {
        boolean bl = this.mCategories == null || renderStyle.cat == null || this.mCategories.contains(renderStyle.cat);
        return bl;
    }

    private static void logUnknownAttribute(String string2, String string3, String string4, int n) {
        log.debug("unknown attribute in element {} () : {} = {}", string2, n, string3, string4);
    }

    private static float[] parseFloatArray(String stringArray) {
        stringArray = stringArray.split(",");
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        return fArray;
    }

    public static IRenderTheme read(ThemeFile themeFile) throws IRenderTheme.ThemeException {
        return XmlMapsforgeThemeBuilder.read(themeFile, null);
    }

    public static IRenderTheme read(ThemeFile themeFile, ThemeCallback object) throws IRenderTheme.ThemeException {
        XmlMapsforgeThemeBuilder xmlMapsforgeThemeBuilder = new XmlMapsforgeThemeBuilder(themeFile, (ThemeCallback)object);
        try {
            object = new XMLReaderAdapter();
            ((XMLReaderAdapter)object).parse(xmlMapsforgeThemeBuilder, themeFile.getRenderThemeAsStream());
            return xmlMapsforgeThemeBuilder.mRenderTheme;
        }
        catch (Exception exception) {
            throw new IRenderTheme.ThemeException(exception.getMessage());
        }
    }

    private static void validateExists(String string2, Object object, String string3) {
        if (object != null) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("missing attribute ");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" for element: ");
        ((StringBuilder)object).append(string3);
        throw new IRenderTheme.ThemeException(((StringBuilder)object).toString());
    }

    private static void validateNonNegative(String string2, float f) {
        if (!(f < 0.0f)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" must not be negative: ");
        stringBuilder.append(f);
        throw new IRenderTheme.ThemeException(stringBuilder.toString());
    }

    SymbolStyle buildSymbol(SymbolStyle.SymbolBuilder<?> symbolBuilder, String string2, Bitmap bitmap) {
        return ((SymbolStyle.SymbolBuilder)symbolBuilder.bitmap(bitmap)).build();
    }

    RenderTheme createTheme(Rule[] ruleArray) {
        return new RenderTheme(this.mMapBackground, this.mTextScale, ruleArray, this.mLevels, true);
    }

    @Override
    public void endDocument() {
        this.mRulesList.add(this.buildingRule());
        int n = this.mRulesList.size();
        Rule[] ruleArray = new Rule[n];
        for (int i = 0; i < n; ++i) {
            ruleArray[i] = this.mRulesList.get(i).onComplete(new int[1]);
        }
        this.mRenderTheme = this.createTheme(ruleArray);
        this.mRulesList.clear();
        this.mStyles.clear();
        this.mRuleStack.clear();
        this.mElementStack.clear();
        this.mTextureAtlas = null;
    }

    @Override
    public void endElement(String string2, String string3, String string4) {
        this.mElementStack.pop();
        if (ELEMENT_NAME_MATCH.equals(string3)) {
            this.mRuleStack.pop();
            if (this.mRuleStack.empty()) {
                if (this.isVisible(this.mCurrentRule)) {
                    this.mRulesList.add(this.mCurrentRule);
                }
            } else {
                this.mCurrentRule = this.mRuleStack.peek();
            }
        } else if (ELEMENT_NAME_STYLE_MENU.equals(string3) && this.mTheme.getMenuCallback() != null) {
            this.mCategories = this.mTheme.getMenuCallback().getCategories(this.mRenderThemeStyleMenu);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        log.debug(sAXParseException.getMessage());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String object, String iterator2, String iterator3, Attributes attributes) throws IRenderTheme.ThemeException {
        try {
            Iterator<String> iterator4;
            void var4_20;
            Object object2;
            if (ELEMENT_NAME_RENDER_THEME.equals(object2)) {
                this.checkState((String)object2, Element.RENDER_THEME);
                this.createRenderTheme((String)object2, (Attributes)var4_20);
                return;
            }
            if (ELEMENT_NAME_MATCH.equals(object2)) {
                this.checkState((String)object2, Element.RULE);
                RuleBuilder ruleBuilder = this.createRule((String)object2, (Attributes)var4_20);
                if (!this.mRuleStack.empty() && this.isVisible(ruleBuilder)) {
                    this.mCurrentRule.addSubRule(ruleBuilder);
                }
                this.mCurrentRule = ruleBuilder;
                this.mRuleStack.push(ruleBuilder);
                return;
            }
            boolean bl = "style-text".equals(object2);
            boolean bl2 = false;
            if (bl) {
                this.checkState((String)object2, Element.STYLE);
                this.handleTextElement((String)object2, (Attributes)var4_20, true, false);
                return;
            }
            if ("style-area".equals(object2)) {
                this.checkState((String)object2, Element.STYLE);
                this.handleAreaElement((String)object2, (Attributes)var4_20, true);
                return;
            }
            if ("style-line".equals(object2)) {
                this.checkState((String)object2, Element.STYLE);
                this.handleLineElement((String)object2, (Attributes)var4_20, true, false);
                return;
            }
            if ("outline-layer".equals(object2)) {
                this.checkState((String)object2, Element.RENDERING_INSTRUCTION);
                int n = this.mLevels;
                this.mLevels = n + 1;
                iterator4 = this.createLine(null, (String)object2, (Attributes)var4_20, n, true, false);
                object2 = this.mStyles;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(OUTLINE_STYLE);
                stringBuilder.append(((LineStyle)((Object)iterator4)).style);
                ((HashMap)object2).put((String)stringBuilder.toString(), (RenderStyle)((Object)iterator4));
                return;
            }
            if ("area".equals(object2)) {
                this.checkState((String)object2, Element.RENDERING_INSTRUCTION);
                this.handleAreaElement((String)object2, (Attributes)var4_20, false);
                return;
            }
            if ("caption".equals(object2)) {
                this.checkState((String)object2, Element.RENDERING_INSTRUCTION);
                this.handleTextElement((String)object2, (Attributes)var4_20, false, true);
                return;
            }
            if ("circle".equals(object2)) {
                this.checkState((String)object2, Element.RENDERING_INSTRUCTION);
                int n = this.mLevels;
                this.mLevels = n + 1;
                CircleStyle circleStyle = this.createCircle((String)object2, (Attributes)var4_20, n);
                if (!this.isVisible(circleStyle)) return;
                this.mCurrentRule.addStyle(circleStyle);
                return;
            }
            if ("line".equals(object2)) {
                this.checkState((String)object2, Element.RENDERING_INSTRUCTION);
                this.handleLineElement((String)object2, (Attributes)var4_20, false, false);
                return;
            }
            if (!"text".equals(object2) && !"pathText".equals(object2)) {
                if ("symbol".equals(object2)) {
                    this.checkState((String)object2, Element.RENDERING_INSTRUCTION);
                    SymbolStyle symbolStyle = this.createSymbol((String)object2, (Attributes)var4_20);
                    if (symbolStyle == null) return;
                    if (!this.isVisible(symbolStyle)) return;
                    this.mCurrentRule.addStyle(symbolStyle);
                    return;
                }
                if ("outline".equals(object2)) {
                    this.checkState((String)object2, Element.RENDERING_INSTRUCTION);
                    LineStyle lineStyle = this.createOutline(var4_20.getValue("use"), (Attributes)var4_20);
                    if (lineStyle == null) return;
                    if (!this.isVisible(lineStyle)) return;
                    this.mCurrentRule.addStyle(lineStyle);
                    return;
                }
                if ("extrusion".equals(object2)) {
                    this.checkState((String)object2, Element.RENDERING_INSTRUCTION);
                    int n = this.mLevels;
                    this.mLevels = n + 1;
                    ExtrusionStyle extrusionStyle = this.createExtrusion((String)object2, (Attributes)var4_20, n);
                    if (!this.isVisible(extrusionStyle)) return;
                    this.mCurrentRule.addStyle(extrusionStyle);
                    return;
                }
                if ("lineSymbol".equals(object2)) {
                    this.checkState((String)object2, Element.RENDERING_INSTRUCTION);
                    this.handleLineElement((String)object2, (Attributes)var4_20, false, true);
                    return;
                }
                if ("atlas".equals(object2)) {
                    this.checkState((String)object2, Element.ATLAS);
                    this.createAtlas((String)object2, (Attributes)var4_20);
                    return;
                }
                if ("rect".equals(object2)) {
                    this.checkState((String)object2, Element.ATLAS);
                    this.createTextureRegion((String)object2, (Attributes)var4_20);
                    return;
                }
                bl = "cat".equals(object2);
                if (bl) {
                    this.checkState((String)((Object)iterator4), Element.RENDERING_STYLE);
                    this.mCurrentLayer.addCategory(this.getStringAttribute((Attributes)var4_20, "id"));
                    return;
                }
                if ("layer".equals(object2)) {
                    this.checkState((String)((Object)iterator4), Element.RENDERING_STYLE);
                    if (this.getStringAttribute((Attributes)var4_20, "enabled") != null) {
                        bl2 = Boolean.valueOf(this.getStringAttribute((Attributes)var4_20, "enabled"));
                    }
                    bl = Boolean.valueOf(this.getStringAttribute((Attributes)var4_20, "visible"));
                    this.mCurrentLayer = this.mRenderThemeStyleMenu.createLayer(this.getStringAttribute((Attributes)var4_20, "id"), bl, bl2);
                    String string2 = this.getStringAttribute((Attributes)var4_20, "parent");
                    if (string2 == null) return;
                    object2 = this.mRenderThemeStyleMenu.getLayer(string2);
                    if (object2 == null) return;
                    for (String string3 : ((XmlRenderThemeStyleLayer)object2).getCategories()) {
                        this.mCurrentLayer.addCategory(string3);
                    }
                    object2 = ((XmlRenderThemeStyleLayer)object2).getOverlays().iterator();
                    while (object2.hasNext()) {
                        XmlRenderThemeStyleLayer xmlRenderThemeStyleLayer = (XmlRenderThemeStyleLayer)object2.next();
                        this.mCurrentLayer.addOverlay(xmlRenderThemeStyleLayer);
                    }
                    return;
                }
                if ("name".equals(object2)) {
                    this.checkState((String)((Object)iterator4), Element.RENDERING_STYLE);
                    this.mCurrentLayer.addTranslation(this.getStringAttribute((Attributes)var4_20, "lang"), this.getStringAttribute((Attributes)var4_20, "value"));
                    return;
                }
                if ("overlay".equals(object2)) {
                    this.checkState((String)((Object)iterator4), Element.RENDERING_STYLE);
                    XmlRenderThemeStyleLayer xmlRenderThemeStyleLayer = this.mRenderThemeStyleMenu.getLayer(this.getStringAttribute((Attributes)var4_20, "id"));
                    if (xmlRenderThemeStyleLayer == null) return;
                    this.mCurrentLayer.addOverlay(xmlRenderThemeStyleLayer);
                    return;
                }
                if (ELEMENT_NAME_STYLE_MENU.equals(object2)) {
                    XmlRenderThemeStyleMenu xmlRenderThemeStyleMenu;
                    this.checkState((String)((Object)iterator4), Element.RENDERING_STYLE);
                    this.mRenderThemeStyleMenu = xmlRenderThemeStyleMenu = new XmlRenderThemeStyleMenu(this.getStringAttribute((Attributes)var4_20, "id"), this.getStringAttribute((Attributes)var4_20, "defaultlang"), this.getStringAttribute((Attributes)var4_20, "defaultvalue"));
                    return;
                }
                log.error("unknown element: {}", object2);
                iterator4 = new Iterator<String>();
                ((StringBuilder)((Object)iterator4)).append("unknown element: ");
                ((StringBuilder)((Object)iterator4)).append((String)object2);
                SAXException sAXException = new SAXException(((StringBuilder)((Object)iterator4)).toString());
                throw sAXException;
            }
            this.checkState((String)object2, Element.RENDERING_INSTRUCTION);
            this.handleTextElement((String)object2, (Attributes)var4_20, false, false);
            return;
        }
        catch (IOException iOException) {
            throw new IRenderTheme.ThemeException(iOException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IRenderTheme.ThemeException(sAXException.getMessage());
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        log.debug(sAXParseException.getMessage());
    }

    private static final class Element
    extends Enum<Element> {
        private static final /* synthetic */ Element[] $VALUES;
        public static final /* enum */ Element ATLAS;
        public static final /* enum */ Element RENDERING_INSTRUCTION;
        public static final /* enum */ Element RENDERING_STYLE;
        public static final /* enum */ Element RENDER_THEME;
        public static final /* enum */ Element RULE;
        public static final /* enum */ Element STYLE;

        static {
            Element element;
            Element element2;
            Element element3;
            Element element4;
            Element element5;
            Element element6;
            RENDER_THEME = element6 = new Element();
            RENDERING_INSTRUCTION = element5 = new Element();
            RULE = element4 = new Element();
            STYLE = element3 = new Element();
            ATLAS = element2 = new Element();
            RENDERING_STYLE = element = new Element();
            $VALUES = new Element[]{element6, element5, element4, element3, element2, element};
        }

        public static Element valueOf(String string2) {
            return Enum.valueOf(Element.class, string2);
        }

        public static Element[] values() {
            return (Element[])$VALUES.clone();
        }
    }
}

