/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.rule;

import java.util.List;
import org.oscim.core.Tag;
import org.oscim.theme.rule.RuleBuilder;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.utils.Utils;

public class Rule {
    public static final Rule[] EMPTY_RULES;
    public static final RenderStyle[] EMPTY_STYLE;
    public String cat;
    public final int element;
    public final boolean selectFirstMatch;
    public final boolean selectWhenMatched;
    public final RenderStyle[] styles;
    public final Rule[] subRules;
    public final int zoom;

    static {
        EMPTY_STYLE = new RenderStyle[0];
        EMPTY_RULES = new Rule[0];
    }

    Rule(int n, int n2, int n3, Rule[] objectArray, RenderStyle[] renderStyleArray) {
        this.element = n;
        this.zoom = n2;
        Rule[] ruleArray = objectArray;
        if (objectArray == null) {
            ruleArray = EMPTY_RULES;
        }
        this.subRules = ruleArray;
        objectArray = renderStyleArray;
        if (renderStyleArray == null) {
            objectArray = EMPTY_STYLE;
        }
        this.styles = objectArray;
        boolean bl = false;
        boolean bl2 = (n3 & 1) != 0;
        this.selectFirstMatch = bl2;
        bl2 = bl;
        if ((n3 & 2) != 0) {
            bl2 = true;
        }
        this.selectWhenMatched = bl2;
    }

    public static RuleBuilder builder() {
        return new RuleBuilder();
    }

    public void apply(RuleVisitor ruleVisitor) {
        ruleVisitor.apply(this);
    }

    public void dispose() {
        int n;
        Object[] objectArray = this.styles;
        int n2 = objectArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            objectArray[n].dispose();
        }
        objectArray = this.subRules;
        n2 = objectArray.length;
        for (n = n3; n < n2; ++n) {
            ((Rule)objectArray[n]).dispose();
        }
    }

    public boolean matchElement(int n, Tag[] objectArray, int n2, List<RenderStyle> list) {
        int n3 = this.element;
        int n4 = 0;
        if ((n3 & n) != 0 && (this.zoom & n2) != 0 && this.matchesTags((Tag[])objectArray)) {
            boolean bl;
            block11: {
                Rule[] ruleArray = this.subRules;
                if (ruleArray != EMPTY_RULES) {
                    Rule rule;
                    boolean bl2;
                    int n5;
                    if (this.selectFirstMatch) {
                        n5 = ruleArray.length;
                        n3 = 0;
                        bl2 = false;
                        while (true) {
                            bl = bl2;
                            if (n3 < n5) {
                                rule = ruleArray[n3];
                                if (!(rule.selectWhenMatched ^ bl2) && rule.matchElement(n, (Tag[])objectArray, n2, list)) {
                                    bl2 = true;
                                }
                                ++n3;
                                continue;
                            }
                            break block11;
                            break;
                        }
                    }
                    n5 = ruleArray.length;
                    n3 = 0;
                    bl2 = false;
                    while (true) {
                        bl = bl2;
                        if (n3 < n5) {
                            rule = ruleArray[n3];
                            if ((!rule.selectWhenMatched || bl2) && rule.matchElement(n, (Tag[])objectArray, n2, list)) {
                                bl2 = true;
                            }
                            ++n3;
                            continue;
                        }
                        break block11;
                        break;
                    }
                }
                bl = false;
            }
            if ((objectArray = this.styles) == EMPTY_STYLE) {
                return bl;
            }
            n2 = objectArray.length;
            for (n = n4; n < n2; ++n) {
                list.add((RenderStyle)objectArray[n]);
            }
            return true;
        }
        return false;
    }

    public boolean matchesTags(Tag[] tagArray) {
        return true;
    }

    public void scaleTextSize(float f) {
        int n;
        Object[] objectArray = this.styles;
        int n2 = objectArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            objectArray[n].scaleTextSize(f);
        }
        objectArray = this.subRules;
        n2 = objectArray.length;
        for (n = n3; n < n2; ++n) {
            ((Rule)objectArray[n]).scaleTextSize(f);
        }
    }

    public Rule setCat(String string2) {
        this.cat = string2;
        return this;
    }

    public void updateStyles() {
        int n;
        Object[] objectArray = this.styles;
        int n2 = objectArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            objectArray[n].update();
        }
        objectArray = this.subRules;
        n2 = objectArray.length;
        for (n = n3; n < n2; ++n) {
            ((Rule)objectArray[n]).updateStyles();
        }
    }

    public final class Closed {
        public static final int ANY = 3;
        public static final int NO = 1;
        public static final int YES = 2;
    }

    public final class Element {
        public static final int ANY = 7;
        public static final int LINE = 2;
        public static final int NODE = 1;
        public static final int POLY = 4;
        public static final int WAY = 6;
    }

    static class NegativeRule
    extends Rule {
        public final boolean exclusive;
        public final String[] keys;
        public final String[] values;

        NegativeRule(RuleBuilder.RuleType ruleType, int n, int n2, int n3, String[] stringArray, String[] stringArray2, Rule[] ruleArray, RenderStyle[] renderStyleArray) {
            super(n, n2, n3, ruleArray, renderStyleArray);
            this.keys = stringArray;
            this.values = stringArray2;
            boolean bl = ruleType == RuleBuilder.RuleType.EXCLUDE;
            this.exclusive = bl;
        }

        private boolean containsKeys(Tag[] tagArray) {
            for (Tag tag : tagArray) {
                String[] stringArray = this.keys;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!Utils.equals(stringArray[i], tag.key)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean matchesTags(Tag[] tagArray) {
            if (!this.containsKeys(tagArray)) {
                return true;
            }
            for (Tag tag : tagArray) {
                String[] stringArray = this.values;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!Utils.equals(stringArray[i], tag.value)) continue;
                    return this.exclusive ^ true;
                }
            }
            return this.exclusive;
        }
    }

    static class PositiveRuleK
    extends Rule {
        private final String mKey;

        PositiveRuleK(int n, int n2, int n3, String string2, Rule[] ruleArray, RenderStyle[] renderStyleArray) {
            super(n, n2, n3, ruleArray, renderStyleArray);
            this.mKey = string2;
        }

        @Override
        public boolean matchesTags(Tag[] tagArray) {
            for (Tag tag : tagArray) {
                if (!Utils.equals(this.mKey, tag.key)) continue;
                return true;
            }
            return false;
        }
    }

    static class PositiveRuleKV
    extends Rule {
        private final String mKey;
        private final String mValue;

        PositiveRuleKV(int n, int n2, int n3, String string2, String string3, Rule[] ruleArray, RenderStyle[] renderStyleArray) {
            super(n, n2, n3, ruleArray, renderStyleArray);
            this.mKey = string2;
            this.mValue = string3;
        }

        @Override
        public boolean matchesTags(Tag[] tagArray) {
            for (Tag tag : tagArray) {
                if (!Utils.equals(this.mKey, tag.key)) continue;
                return Utils.equals(this.mValue, tag.value);
            }
            return false;
        }
    }

    static class PositiveRuleMultiKV
    extends Rule {
        private final String[] mKeys;
        private final String[] mValues;

        PositiveRuleMultiKV(int n, int n2, int n3, String[] stringArray, String[] stringArray2, Rule[] ruleArray, RenderStyle[] renderStyleArray) {
            super(n, n2, n3, ruleArray, renderStyleArray);
            this.mKeys = stringArray.length == 0 ? null : stringArray;
            this.mValues = stringArray2.length == 0 ? null : stringArray2;
        }

        @Override
        public boolean matchesTags(Tag[] tagArray) {
            if (this.mKeys == null) {
                for (Tag tag : tagArray) {
                    String[] stringArray = this.mValues;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        if (!Utils.equals(stringArray[i], tag.value)) continue;
                        return true;
                    }
                }
                return false;
            }
            for (Tag tag : tagArray) {
                String[] stringArray = this.mKeys;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!Utils.equals(stringArray[i], tag.key)) continue;
                    String[] stringArray2 = this.mValues;
                    if (stringArray2 == null) {
                        return true;
                    }
                    int n2 = stringArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        if (!Utils.equals(stringArray2[j], tag.value)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    static class PositiveRuleV
    extends Rule {
        private final String mValue;

        PositiveRuleV(int n, int n2, int n3, String string2, Rule[] ruleArray, RenderStyle[] renderStyleArray) {
            super(n, n2, n3, ruleArray, renderStyleArray);
            this.mValue = string2;
        }

        @Override
        public boolean matchesTags(Tag[] tagArray) {
            for (Tag tag : tagArray) {
                if (!Utils.equals(this.mValue, tag.value)) continue;
                return true;
            }
            return false;
        }
    }

    public static class RuleVisitor {
        public void apply(Rule ruleArray) {
            ruleArray = ruleArray.subRules;
            int n = ruleArray.length;
            for (int i = 0; i < n; ++i) {
                this.apply(ruleArray[i]);
            }
        }
    }

    public final class Selector {
        public static final int ANY = 0;
        public static final int FIRST = 1;
        public static final int WHEN_MATCHED = 2;
    }

    public static class TextSizeVisitor
    extends RuleVisitor {
        float scaleFactor = 1.0f;

        @Override
        public void apply(Rule rule) {
            RenderStyle[] renderStyleArray = rule.styles;
            int n = renderStyleArray.length;
            for (int i = 0; i < n; ++i) {
                renderStyleArray[i].scaleTextSize(this.scaleFactor);
            }
            super.apply(rule);
        }

        public void setScaleFactor(float f) {
            this.scaleFactor = f;
        }
    }

    public static class UpdateVisitor
    extends RuleVisitor {
        @Override
        public void apply(Rule rule) {
            RenderStyle[] renderStyleArray = rule.styles;
            int n = renderStyleArray.length;
            for (int i = 0; i < n; ++i) {
                renderStyleArray[i].update();
            }
            super.apply(rule);
        }
    }
}

