/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.styles.RenderStyle;

public class RuleBuilder {
    private static final String[] EMPTY_KV = new String[0];
    private static final String SEPARATOR = "\\|";
    private static final String STRING_EXCLUSIVE = "-";
    private static final String STRING_NEGATION = "~";
    public String cat;
    int element;
    String[] keys;
    ArrayList<RenderStyle> renderStyles = new ArrayList(4);
    int selector;
    RenderStyle.StyleBuilder<?>[] styleBuilder;
    ArrayList<RuleBuilder> subRules = new ArrayList(4);
    RuleType type;
    String[] values;
    int zoom;

    public RuleBuilder() {
        this.type = RuleType.POSITIVE;
        this.element = 7;
        this.zoom = -1;
        String[] stringArray = EMPTY_KV;
        this.keys = stringArray;
        this.values = stringArray;
    }

    public RuleBuilder(RuleType ruleType, int n, int n2, int n3, String[] stringArray, String[] stringArray2) {
        this.type = ruleType;
        this.element = n;
        this.zoom = n2;
        this.selector = n3;
        this.keys = stringArray;
        this.values = stringArray2;
    }

    public RuleBuilder(RuleType ruleType, String[] stringArray, String[] stringArray2) {
        this.element = 7;
        this.zoom = -1;
        this.type = ruleType;
        this.keys = stringArray;
        this.values = stringArray2;
    }

    public static RuleBuilder create(String string2, String stringArray) {
        String[] stringArray2 = EMPTY_KV;
        RuleType ruleType = RuleType.POSITIVE;
        if (stringArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray = stringArray.split(SEPARATOR)));
            if (arrayList.remove(STRING_NEGATION)) {
                ruleType = RuleType.NEGATIVE;
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            } else if (arrayList.remove(STRING_EXCLUSIVE)) {
                ruleType = RuleType.EXCLUDE;
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
        } else {
            stringArray = stringArray2;
        }
        if (string2 != null) {
            stringArray2 = string2.split(SEPARATOR);
        }
        if (ruleType != RuleType.POSITIVE && (stringArray2 == null || stringArray2.length == 0)) {
            throw new IRenderTheme.ThemeException("negative rule requires key");
        }
        return new RuleBuilder(ruleType, stringArray2, stringArray);
    }

    public RuleBuilder addStyle(RenderStyle renderStyle) {
        this.renderStyles.add(renderStyle);
        return this;
    }

    public RuleBuilder addSubRule(RuleBuilder ruleBuilder) {
        this.subRules.add(ruleBuilder);
        return this;
    }

    public RuleBuilder cat(String string2) {
        this.cat = string2;
        return this;
    }

    public RuleBuilder element(int n) {
        this.element = n;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Rule onComplete(int[] objectArray) {
        void var5_8;
        int n;
        Object[] objectArray2 = this.styleBuilder;
        if (objectArray2 != null) {
            for (RenderStyle.StyleBuilder<?> ruleArray2 : objectArray2) {
                this.renderStyles.add(((RenderStyle.StyleBuilder)ruleArray2.level((int)objectArray[0])).build());
                objectArray[0] = objectArray[0] + 2;
            }
        }
        int n2 = this.renderStyles.size();
        Object var5_6 = null;
        if (n2 > 0) {
            objectArray2 = new RenderStyle[this.renderStyles.size()];
            this.renderStyles.toArray(objectArray2);
        } else {
            objectArray2 = null;
        }
        if (this.subRules.size() > 0) {
            n = this.subRules.size();
            Rule[] ruleArray = new Rule[n];
            for (n2 = 0; n2 < n; ++n2) {
                ruleArray[n2] = this.subRules.get(n2).onComplete((int[])objectArray);
            }
        }
        n = this.keys.length;
        int n3 = this.values.length;
        if (n == 0 && n3 == 0) {
            return new Rule(this.element, this.zoom, this.selector, (Rule[])var5_8, (RenderStyle[])objectArray2).setCat(this.cat);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray = this.values;
            objectArray[n2] = ((String)objectArray[n2]).intern();
        }
        for (n2 = 0; n2 < n; ++n2) {
            objectArray = this.keys;
            objectArray[n2] = ((String)objectArray[n2]).intern();
        }
        if (this.type != RuleType.POSITIVE) {
            return new Rule.NegativeRule(this.type, this.element, this.zoom, this.selector, this.keys, this.values, (Rule[])var5_8, (RenderStyle[])objectArray2).setCat(this.cat);
        }
        if (n == 1 && n3 == 0) {
            return new Rule.PositiveRuleK(this.element, this.zoom, this.selector, this.keys[0], (Rule[])var5_8, (RenderStyle[])objectArray2).setCat(this.cat);
        }
        if (n == 0 && n3 == 1) {
            return new Rule.PositiveRuleV(this.element, this.zoom, this.selector, this.values[0], (Rule[])var5_8, (RenderStyle[])objectArray2).setCat(this.cat);
        }
        if (n == 1 && n3 == 1) {
            return new Rule.PositiveRuleKV(this.element, this.zoom, this.selector, this.keys[0], this.values[0], (Rule[])var5_8, (RenderStyle[])objectArray2).setCat(this.cat);
        }
        return new Rule.PositiveRuleMultiKV(this.element, this.zoom, this.selector, this.keys, this.values, (Rule[])var5_8, (RenderStyle[])objectArray2).setCat(this.cat);
    }

    public RuleBuilder rules(RuleBuilder ... ruleBuilderArray) {
        Collections.addAll(this.subRules, ruleBuilderArray);
        return this;
    }

    public RuleBuilder select(int n) {
        this.selector = n;
        return this;
    }

    public RuleBuilder style(RenderStyle.StyleBuilder<?> ... styleBuilderArray) {
        this.styleBuilder = styleBuilderArray;
        return this;
    }

    public RuleBuilder zoom(byte by, byte by2) {
        this.zoom = 0;
        while (by <= by2 && by < 32) {
            this.zoom |= 1 << by;
            by = (byte)(by + 1);
        }
        return this;
    }

    public RuleBuilder zoom(int n) {
        this.zoom = n;
        return this;
    }

    public static final class RuleType
    extends Enum<RuleType> {
        private static final /* synthetic */ RuleType[] $VALUES;
        public static final /* enum */ RuleType EXCLUDE;
        public static final /* enum */ RuleType NEGATIVE;
        public static final /* enum */ RuleType POSITIVE;

        static {
            RuleType ruleType;
            RuleType ruleType2;
            RuleType ruleType3;
            POSITIVE = ruleType3 = new RuleType();
            NEGATIVE = ruleType2 = new RuleType();
            EXCLUDE = ruleType = new RuleType();
            $VALUES = new RuleType[]{ruleType3, ruleType2, ruleType};
        }

        public static RuleType valueOf(String string2) {
            return Enum.valueOf(RuleType.class, string2);
        }

        public static RuleType[] values() {
            return (RuleType[])$VALUES.clone();
        }
    }
}

