/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.canvas.Color;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.utils.FastMath;

public class AreaStyle
extends RenderStyle<AreaStyle> {
    private static final float FADE_START = 0.25f;
    public final int blendColor;
    public final int blendScale;
    public final int color;
    public final int fadeScale;
    public final float heightOffset;
    private final int level;
    public boolean mesh;
    public final int strokeColor;
    public final float strokeWidth;
    public final String style;
    public final int symbolHeight;
    public final int symbolPercent;
    public final int symbolWidth;
    public final TextureItem texture;

    public AreaStyle(int n) {
        this(0, n);
    }

    public AreaStyle(int n, int n2) {
        this.level = n;
        this.style = "";
        this.fadeScale = -1;
        this.blendColor = 0;
        this.blendScale = -1;
        this.color = n2;
        this.texture = null;
        this.strokeColor = n2;
        this.strokeWidth = 1.0f;
        this.mesh = false;
        this.heightOffset = 0.0f;
        this.symbolWidth = 0;
        this.symbolHeight = 0;
        this.symbolPercent = 100;
    }

    public AreaStyle(AreaBuilder<?> areaBuilder) {
        this.cat = areaBuilder.cat;
        this.level = areaBuilder.level;
        this.style = areaBuilder.style;
        this.fadeScale = areaBuilder.fadeScale;
        int n = areaBuilder.themeCallback != null ? areaBuilder.themeCallback.getColor(areaBuilder.blendColor) : areaBuilder.blendColor;
        this.blendColor = n;
        this.blendScale = areaBuilder.blendScale;
        n = areaBuilder.themeCallback != null ? areaBuilder.themeCallback.getColor(areaBuilder.fillColor) : areaBuilder.fillColor;
        this.color = n;
        this.texture = areaBuilder.texture;
        n = areaBuilder.themeCallback != null ? areaBuilder.themeCallback.getColor(areaBuilder.strokeColor) : areaBuilder.strokeColor;
        this.strokeColor = n;
        this.strokeWidth = areaBuilder.strokeWidth;
        this.mesh = areaBuilder.mesh;
        this.heightOffset = areaBuilder.heightOffset;
        this.symbolWidth = areaBuilder.symbolWidth;
        this.symbolHeight = areaBuilder.symbolHeight;
        this.symbolPercent = areaBuilder.symbolPercent;
    }

    public static AreaBuilder<?> builder() {
        return new AreaBuilder();
    }

    @Override
    public AreaStyle current() {
        return (AreaStyle)this.mCurrent;
    }

    public float getBlend(double d) {
        int n = this.blendScale;
        if (n < 0) {
            return 0.0f;
        }
        return FastMath.clamp((float)(d / (double)(1 << n)) - 1.0f, 0.0f, 1.0f);
    }

    public float getFade(double d) {
        int n = this.fadeScale;
        if (n < 0) {
            return 1.0f;
        }
        return FastMath.clamp((float)(d / (double)(1 << n)) - 1.0f, 0.25f, 1.0f);
    }

    public boolean hasAlpha(int n) {
        if (!Color.isOpaque(this.color)) {
            return true;
        }
        if (this.texture != null) {
            return true;
        }
        int n2 = this.blendScale;
        if (n2 < 0 && this.fadeScale < 0) {
            return false;
        }
        if (n >= n2 && !Color.isOpaque(this.blendColor)) {
            return true;
        }
        return this.fadeScale <= n;
    }

    @Override
    public void renderWay(RenderStyle.Callback callback) {
        callback.renderArea(this, this.level);
    }

    public static class AreaBuilder<T extends AreaBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public int blendColor;
        public int blendScale;
        public int fadeScale;
        public float heightOffset;
        public boolean mesh;
        public int symbolHeight;
        public int symbolPercent;
        public int symbolWidth;
        public TextureItem texture;

        public T blendColor(int n) {
            this.blendColor = n;
            return (T)((AreaBuilder)this.self());
        }

        public T blendColor(String string2) {
            this.blendColor = Color.parseColor(string2);
            return (T)((AreaBuilder)this.self());
        }

        public T blendScale(int n) {
            this.blendScale = n;
            return (T)((AreaBuilder)this.self());
        }

        @Override
        public AreaStyle build() {
            return new AreaStyle(this);
        }

        public T fadeScale(int n) {
            this.fadeScale = n;
            return (T)((AreaBuilder)this.self());
        }

        public T heightOffset(float f) {
            this.heightOffset = f;
            return (T)((AreaBuilder)this.self());
        }

        public T mesh(boolean bl) {
            this.mesh = bl;
            return (T)((AreaBuilder)this.self());
        }

        public T reset() {
            this.cat = null;
            this.level = -1;
            this.fillColor = -1;
            this.strokeColor = -16777216;
            this.strokeWidth = 0.0f;
            this.fadeScale = -1;
            this.blendScale = -1;
            this.blendColor = 0;
            this.style = null;
            this.texture = null;
            this.mesh = false;
            this.heightOffset = 0.0f;
            this.symbolWidth = 0;
            this.symbolHeight = 0;
            this.symbolPercent = 100;
            return (T)((AreaBuilder)this.self());
        }

        public T set(AreaStyle areaStyle) {
            if (areaStyle == null) {
                return this.reset();
            }
            this.cat = areaStyle.cat;
            this.level = areaStyle.level;
            this.style = areaStyle.style;
            this.fadeScale = areaStyle.fadeScale;
            int n = this.themeCallback != null ? this.themeCallback.getColor(areaStyle.blendColor) : areaStyle.blendColor;
            this.blendColor = n;
            this.blendScale = areaStyle.blendScale;
            n = this.themeCallback != null ? this.themeCallback.getColor(areaStyle.color) : areaStyle.color;
            this.fillColor = n;
            this.texture = areaStyle.texture;
            n = this.themeCallback != null ? this.themeCallback.getColor(areaStyle.strokeColor) : areaStyle.strokeColor;
            this.strokeColor = n;
            this.strokeWidth = areaStyle.strokeWidth;
            this.mesh = areaStyle.mesh;
            this.heightOffset = areaStyle.heightOffset;
            this.symbolWidth = areaStyle.symbolWidth;
            this.symbolHeight = areaStyle.symbolHeight;
            this.symbolPercent = areaStyle.symbolPercent;
            return (T)((AreaBuilder)this.self());
        }

        public T symbolHeight(int n) {
            this.symbolHeight = n;
            return (T)((AreaBuilder)this.self());
        }

        public T symbolPercent(int n) {
            this.symbolPercent = n;
            return (T)((AreaBuilder)this.self());
        }

        public T symbolWidth(int n) {
            this.symbolWidth = n;
            return (T)((AreaBuilder)this.self());
        }

        public T texture(TextureItem textureItem) {
            this.texture = textureItem;
            return (T)((AreaBuilder)this.self());
        }
    }
}

