/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.theme.styles.RenderStyle;

public final class CircleStyle
extends RenderStyle<CircleStyle> {
    public final int fillColor;
    private final int level;
    public final float radius;
    public final boolean scaleRadius;
    public final int strokeColor;
    public final float strokeWidth;

    public CircleStyle(float f, boolean bl, int n, int n2, float f2, int n3) {
        this.radius = f;
        this.scaleRadius = bl;
        this.fillColor = n;
        this.strokeColor = n2;
        this.strokeWidth = f2;
        this.level = n3;
    }

    public CircleStyle(CircleBuilder<?> circleBuilder) {
        this.cat = circleBuilder.cat;
        this.radius = circleBuilder.radius;
        this.scaleRadius = circleBuilder.scaleRadius;
        int n = circleBuilder.themeCallback != null ? circleBuilder.themeCallback.getColor(circleBuilder.fillColor) : circleBuilder.fillColor;
        this.fillColor = n;
        n = circleBuilder.themeCallback != null ? circleBuilder.themeCallback.getColor(circleBuilder.strokeColor) : circleBuilder.strokeColor;
        this.strokeColor = n;
        this.strokeWidth = circleBuilder.strokeWidth;
        this.level = circleBuilder.level;
    }

    public static CircleBuilder<?> builder() {
        return new CircleBuilder();
    }

    @Override
    public CircleStyle current() {
        return (CircleStyle)this.mCurrent;
    }

    @Override
    public void renderNode(RenderStyle.Callback callback) {
        callback.renderCircle(this, this.level);
    }

    public static class CircleBuilder<T extends CircleBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public float radius;
        public boolean scaleRadius;

        @Override
        public CircleStyle build() {
            return new CircleStyle(this);
        }

        public T radius(float f) {
            this.radius = f;
            return (T)((CircleBuilder)this.self());
        }

        public T reset() {
            this.cat = null;
            this.level = -1;
            this.radius = 0.0f;
            this.scaleRadius = false;
            this.fillColor = 0;
            this.strokeColor = 0;
            this.strokeWidth = 0.0f;
            return (T)((CircleBuilder)this.self());
        }

        public T scaleRadius(boolean bl) {
            this.scaleRadius = bl;
            return (T)((CircleBuilder)this.self());
        }

        public T set(CircleStyle circleStyle) {
            if (circleStyle == null) {
                return this.reset();
            }
            this.radius = circleStyle.radius;
            this.scaleRadius = circleStyle.scaleRadius;
            int n = this.themeCallback != null ? this.themeCallback.getColor(circleStyle.fillColor) : circleStyle.fillColor;
            this.fillColor = n;
            n = this.themeCallback != null ? this.themeCallback.getColor(circleStyle.strokeColor) : circleStyle.strokeColor;
            this.strokeColor = n;
            this.strokeWidth = circleStyle.strokeWidth;
            this.cat = circleStyle.cat;
            this.level = circleStyle.level;
            return (T)((CircleBuilder)this.self());
        }
    }
}

