/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.canvas.Color;
import org.oscim.theme.styles.RenderStyle;

public class ExtrusionStyle
extends RenderStyle<ExtrusionStyle> {
    public final int colorLine;
    public final int colorSide;
    public final int colorTop;
    public final float[] colors;
    public final int defaultHeight;
    private final int level;

    public ExtrusionStyle(int n, int n2, int n3, int n4, int n5) {
        this.level = n;
        this.colorSide = n2;
        this.colorTop = n3;
        this.colorLine = n4;
        float[] fArray = new float[16];
        this.colors = fArray;
        ExtrusionStyle.fillColors(n2, n3, n4, fArray);
        this.defaultHeight = n5;
    }

    public ExtrusionStyle(ExtrusionBuilder<?> extrusionBuilder) {
        this.cat = extrusionBuilder.cat;
        this.level = extrusionBuilder.level;
        int n = extrusionBuilder.themeCallback != null ? extrusionBuilder.themeCallback.getColor(extrusionBuilder.colorSide) : extrusionBuilder.colorSide;
        this.colorSide = n;
        int n2 = extrusionBuilder.themeCallback != null ? extrusionBuilder.themeCallback.getColor(extrusionBuilder.colorTop) : extrusionBuilder.colorTop;
        this.colorTop = n2;
        int n3 = extrusionBuilder.themeCallback != null ? extrusionBuilder.themeCallback.getColor(extrusionBuilder.colorLine) : extrusionBuilder.colorLine;
        this.colorLine = n3;
        float[] fArray = new float[16];
        this.colors = fArray;
        ExtrusionStyle.fillColors(n, n2, n3, fArray);
        this.defaultHeight = extrusionBuilder.defaultHeight;
    }

    public static ExtrusionBuilder<?> builder() {
        return new ExtrusionBuilder();
    }

    public static void fillColors(int n, int n2, int n3, float[] fArray) {
        float f = Color.aToFloat(n2);
        fArray[0] = Color.rToFloat(n2) * f;
        fArray[1] = Color.gToFloat(n2) * f;
        fArray[2] = Color.bToFloat(n2) * f;
        fArray[3] = f;
        f = Color.aToFloat(n);
        fArray[4] = Color.rToFloat(n) * f;
        fArray[5] = Color.gToFloat(n) * f;
        fArray[6] = Color.bToFloat(n) * f;
        fArray[7] = f;
        f = Color.aToFloat(n);
        fArray[8] = Color.rToFloat(n) * f;
        fArray[9] = Color.gToFloat(n) * f;
        fArray[10] = Color.bToFloat(n) * f;
        fArray[11] = f;
        f = Color.aToFloat(n3);
        fArray[12] = Color.rToFloat(n3) * f;
        fArray[13] = Color.gToFloat(n3) * f;
        fArray[14] = Color.bToFloat(n3) * f;
        fArray[15] = f;
    }

    @Override
    public ExtrusionStyle current() {
        return (ExtrusionStyle)this.mCurrent;
    }

    @Override
    public void renderWay(RenderStyle.Callback callback) {
        callback.renderExtrusion(this, this.level);
    }

    public static class ExtrusionBuilder<T extends ExtrusionBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public int colorLine;
        public int colorSide;
        public int colorTop;
        public int defaultHeight;

        @Override
        public ExtrusionStyle build() {
            return new ExtrusionStyle(this);
        }

        public T colorLine(int n) {
            this.colorLine = n;
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorLine(String string2) {
            this.colorLine = Color.parseColor(string2);
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorSide(int n) {
            this.colorSide = n;
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorSide(String string2) {
            this.colorSide = Color.parseColor(string2);
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorTop(int n) {
            this.colorTop = n;
            return (T)((ExtrusionBuilder)this.self());
        }

        public T colorTop(String string2) {
            this.colorTop = Color.parseColor(string2);
            return (T)((ExtrusionBuilder)this.self());
        }

        public T defaultHeight(int n) {
            this.defaultHeight = n;
            return (T)((ExtrusionBuilder)this.self());
        }

        public T reset() {
            this.cat = null;
            this.level = -1;
            this.colorSide = 0;
            this.colorTop = 0;
            this.colorLine = 0;
            this.defaultHeight = 12;
            return (T)((ExtrusionBuilder)this.self());
        }

        public T set(ExtrusionStyle extrusionStyle) {
            if (extrusionStyle == null) {
                return this.reset();
            }
            this.cat = extrusionStyle.cat;
            this.level = extrusionStyle.level;
            int n = this.themeCallback != null ? this.themeCallback.getColor(extrusionStyle.colorSide) : extrusionStyle.colorSide;
            this.colorSide = n;
            n = this.themeCallback != null ? this.themeCallback.getColor(extrusionStyle.colorTop) : extrusionStyle.colorTop;
            this.colorTop = n;
            n = this.themeCallback != null ? this.themeCallback.getColor(extrusionStyle.colorLine) : extrusionStyle.colorLine;
            this.colorLine = n;
            this.defaultHeight = extrusionStyle.defaultHeight;
            return (T)((ExtrusionBuilder)this.self());
        }
    }
}

