/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.canvas.Color;
import org.oscim.backend.canvas.Paint;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.theme.styles.RenderStyle;

public final class LineStyle
extends RenderStyle<LineStyle> {
    public static final float REPEAT_GAP_DEFAULT = 200.0f;
    public static final float REPEAT_START_DEFAULT = 30.0f;
    public final float blur;
    public final Paint.Cap cap;
    public final int color;
    public final float[] dashArray;
    public final int fadeScale;
    public final boolean fixed;
    public final float heightOffset;
    private final int level;
    public final boolean outline;
    public final boolean randomOffset;
    public final float repeatGap;
    public final float repeatStart;
    public final int stipple;
    public final int stippleColor;
    public final float stippleWidth;
    public final String style;
    public final int symbolHeight;
    public final int symbolPercent;
    public final int symbolWidth;
    public final TextureItem texture;
    public final float width;

    public LineStyle(int n, float f) {
        this(0, "", n, f, Paint.Cap.BUTT, true, 0, 0, 0.0f, -1, 0.0f, false, null, true, null, 30.0f, 200.0f);
    }

    public LineStyle(int n, float f, Paint.Cap cap) {
        this(0, "", n, f, cap, true, 0, 0, 0.0f, -1, 0.0f, false, null, true, null, 30.0f, 200.0f);
    }

    public LineStyle(int n, int n2, float f) {
        this(n, "", n2, f, Paint.Cap.BUTT, true, 0, 0, 0.0f, -1, 0.0f, false, null, true, null, 30.0f, 200.0f);
    }

    public LineStyle(int n, String string2, int n2, float f, Paint.Cap cap, boolean bl, int n3, int n4, float f2, int n5, float f3, boolean bl2, TextureItem textureItem, boolean bl3, float[] fArray, float f4, float f5) {
        this.level = n;
        this.style = string2;
        this.outline = bl2;
        this.cap = cap;
        this.color = n2;
        this.width = f;
        this.fixed = bl;
        this.stipple = n3;
        this.stippleColor = n4;
        this.stippleWidth = f2;
        this.texture = textureItem;
        this.blur = f3;
        this.fadeScale = n5;
        this.heightOffset = 0.0f;
        this.randomOffset = bl3;
        this.symbolWidth = 0;
        this.symbolHeight = 0;
        this.symbolPercent = 100;
        this.dashArray = fArray;
        this.repeatStart = f4;
        this.repeatGap = f5;
    }

    private LineStyle(LineBuilder<?> lineBuilder) {
        this.cat = lineBuilder.cat;
        this.level = lineBuilder.level;
        this.style = lineBuilder.style;
        this.width = lineBuilder.strokeWidth;
        int n = lineBuilder.themeCallback != null ? lineBuilder.themeCallback.getColor(lineBuilder.fillColor) : lineBuilder.fillColor;
        this.color = n;
        this.cap = lineBuilder.cap;
        this.outline = lineBuilder.outline;
        this.fixed = lineBuilder.fixed;
        this.fadeScale = lineBuilder.fadeScale;
        this.blur = lineBuilder.blur;
        this.stipple = lineBuilder.stipple;
        n = lineBuilder.themeCallback != null ? lineBuilder.themeCallback.getColor(lineBuilder.stippleColor) : lineBuilder.stippleColor;
        this.stippleColor = n;
        this.stippleWidth = lineBuilder.stippleWidth;
        this.texture = lineBuilder.texture;
        this.heightOffset = lineBuilder.heightOffset;
        this.randomOffset = lineBuilder.randomOffset;
        this.symbolWidth = lineBuilder.symbolWidth;
        this.symbolHeight = lineBuilder.symbolHeight;
        this.symbolPercent = lineBuilder.symbolPercent;
        this.dashArray = lineBuilder.dashArray;
        this.repeatStart = lineBuilder.repeatStart;
        this.repeatGap = lineBuilder.repeatGap;
    }

    public static LineBuilder<?> builder() {
        return new LineBuilder();
    }

    @Override
    public LineStyle current() {
        return (LineStyle)this.mCurrent;
    }

    @Override
    public void renderWay(RenderStyle.Callback callback) {
        callback.renderWay(this, this.level);
    }

    public static class LineBuilder<T extends LineBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public float blur;
        public Paint.Cap cap;
        public float[] dashArray;
        public int fadeScale;
        public boolean fixed;
        public float heightOffset;
        public boolean outline;
        public boolean randomOffset;
        public float repeatGap;
        public float repeatStart;
        public int stipple;
        public int stippleColor;
        public float stippleWidth;
        public int symbolHeight;
        public int symbolPercent;
        public int symbolWidth;
        public TextureItem texture;

        public T blur(float f) {
            this.blur = f;
            return (T)((LineBuilder)this.self());
        }

        @Override
        public LineStyle build() {
            return new LineStyle(this);
        }

        public T cap(Paint.Cap cap) {
            this.cap = cap;
            return (T)((LineBuilder)this.self());
        }

        public T dashArray(float[] fArray) {
            this.dashArray = fArray;
            return (T)((LineBuilder)this.self());
        }

        public T fadeScale(int n) {
            this.fadeScale = n;
            return (T)((LineBuilder)this.self());
        }

        public T fixed(boolean bl) {
            this.fixed = bl;
            return (T)((LineBuilder)this.self());
        }

        public T heightOffset(float f) {
            this.heightOffset = f;
            return (T)((LineBuilder)this.self());
        }

        public T isOutline(boolean bl) {
            this.outline = bl;
            return (T)((LineBuilder)this.self());
        }

        public T randomOffset(boolean bl) {
            this.randomOffset = bl;
            return (T)((LineBuilder)this.self());
        }

        public T repeatGap(float f) {
            this.repeatGap = f;
            return (T)((LineBuilder)this.self());
        }

        public T repeatStart(float f) {
            this.repeatStart = f;
            return (T)((LineBuilder)this.self());
        }

        public T reset() {
            this.cat = null;
            this.level = -1;
            this.style = null;
            this.fillColor = -16777216;
            this.cap = Paint.Cap.ROUND;
            this.outline = false;
            this.strokeWidth = 1.0f;
            this.fixed = false;
            this.fadeScale = -1;
            this.blur = 0.0f;
            this.stipple = 0;
            this.stippleWidth = 1.0f;
            this.stippleColor = -16777216;
            this.texture = null;
            this.heightOffset = 0.0f;
            this.randomOffset = true;
            this.symbolWidth = 0;
            this.symbolHeight = 0;
            this.symbolPercent = 100;
            this.dashArray = null;
            this.repeatStart = 30.0f;
            this.repeatGap = 200.0f;
            return (T)((LineBuilder)this.self());
        }

        public T set(LineStyle lineStyle) {
            if (lineStyle == null) {
                return this.reset();
            }
            this.cat = lineStyle.cat;
            this.level = lineStyle.level;
            this.style = lineStyle.style;
            this.strokeWidth = lineStyle.width;
            int n = this.themeCallback != null ? this.themeCallback.getColor(lineStyle.color) : lineStyle.color;
            this.fillColor = n;
            this.cap = lineStyle.cap;
            this.outline = lineStyle.outline;
            this.fixed = lineStyle.fixed;
            this.fadeScale = lineStyle.fadeScale;
            this.blur = lineStyle.blur;
            this.stipple = lineStyle.stipple;
            n = this.themeCallback != null ? this.themeCallback.getColor(lineStyle.stippleColor) : lineStyle.stippleColor;
            this.stippleColor = n;
            this.stippleWidth = lineStyle.stippleWidth;
            this.texture = lineStyle.texture;
            this.heightOffset = lineStyle.heightOffset;
            this.randomOffset = lineStyle.randomOffset;
            this.symbolWidth = lineStyle.symbolWidth;
            this.symbolHeight = lineStyle.symbolHeight;
            this.symbolPercent = lineStyle.symbolPercent;
            this.dashArray = lineStyle.dashArray;
            this.repeatStart = lineStyle.repeatStart;
            this.repeatGap = lineStyle.repeatGap;
            return (T)((LineBuilder)this.self());
        }

        public T stipple(int n) {
            this.stipple = n;
            return (T)((LineBuilder)this.self());
        }

        public T stippleColor(int n) {
            this.stippleColor = n;
            return (T)((LineBuilder)this.self());
        }

        public T stippleColor(String string2) {
            this.stippleColor = Color.parseColor(string2);
            return (T)((LineBuilder)this.self());
        }

        public T stippleWidth(float f) {
            this.stippleWidth = f;
            return (T)((LineBuilder)this.self());
        }

        public T symbolHeight(int n) {
            this.symbolHeight = n;
            return (T)((LineBuilder)this.self());
        }

        public T symbolPercent(int n) {
            this.symbolPercent = n;
            return (T)((LineBuilder)this.self());
        }

        public T symbolWidth(int n) {
            this.symbolWidth = n;
            return (T)((LineBuilder)this.self());
        }

        public T texture(TextureItem textureItem) {
            this.texture = textureItem;
            return (T)((LineBuilder)this.self());
        }
    }
}

