/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.canvas.Color;
import org.oscim.theme.ThemeCallback;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.CircleStyle;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;

public abstract class RenderStyle<T extends RenderStyle<T>> {
    public String cat = null;
    RenderStyle mCurrent = this;
    RenderStyle mNext;
    boolean update;

    public abstract RenderStyle current();

    public void dispose() {
    }

    public void renderNode(Callback callback) {
    }

    public void renderWay(Callback callback) {
    }

    public void scaleTextSize(float f) {
    }

    protected T self() {
        return (T)this;
    }

    public void set(RenderStyle renderStyle) {
        this.update = true;
        this.mNext = renderStyle;
    }

    public T setCat(String string2) {
        this.cat = string2;
        return this.self();
    }

    public void unsetOverride() {
        this.update = true;
        this.mNext = null;
    }

    public void update() {
        if (this.update) {
            this.update = false;
            this.mCurrent = this.mNext;
        }
    }

    public static interface Callback {
        public void renderArea(AreaStyle var1, int var2);

        public void renderCircle(CircleStyle var1, int var2);

        public void renderExtrusion(ExtrusionStyle var1, int var2);

        public void renderSymbol(SymbolStyle var1);

        public void renderText(TextStyle var1);

        public void renderWay(LineStyle var1, int var2);
    }

    public static abstract class StyleBuilder<T extends StyleBuilder<T>> {
        public String cat;
        public int fillColor;
        public int level;
        public int strokeColor;
        public float strokeWidth;
        public String style;
        public ThemeCallback themeCallback;

        public abstract RenderStyle build();

        public T cat(String string2) {
            this.cat = string2;
            return this.self();
        }

        public T color(int n) {
            this.fillColor = n;
            return this.self();
        }

        public T color(String string2) {
            this.fillColor = Color.parseColor(string2);
            return this.self();
        }

        public T level(int n) {
            this.level = n;
            return this.self();
        }

        public T outline(int n, float f) {
            this.strokeColor = n;
            this.strokeWidth = f;
            return this.self();
        }

        protected T self() {
            return (T)this;
        }

        public T strokeColor(int n) {
            this.strokeColor = n;
            return this.self();
        }

        public T strokeColor(String string2) {
            this.strokeColor = Color.parseColor(string2);
            return this.self();
        }

        public T strokeWidth(float f) {
            this.strokeWidth = f;
            return this.self();
        }

        public T style(String string2) {
            this.style = string2;
            return this.self();
        }

        public T themeCallback(ThemeCallback themeCallback) {
            this.themeCallback = themeCallback;
            return this.self();
        }
    }
}

