/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.theme.styles.RenderStyle;

public final class SymbolStyle
extends RenderStyle<SymbolStyle> {
    public final Bitmap bitmap;
    public final int hash;
    public final int symbolHeight;
    public final int symbolPercent;
    public final int symbolWidth;
    public final TextureRegion texture;

    public SymbolStyle(int n) {
        this(null, null, n);
    }

    public SymbolStyle(Bitmap bitmap) {
        this(bitmap, null, 0);
    }

    private SymbolStyle(Bitmap bitmap, TextureRegion textureRegion, int n) {
        this.bitmap = bitmap;
        this.texture = textureRegion;
        this.hash = n;
        this.symbolWidth = 0;
        this.symbolHeight = 0;
        this.symbolPercent = 100;
    }

    public SymbolStyle(TextureRegion textureRegion) {
        this(null, textureRegion, 0);
    }

    public SymbolStyle(SymbolBuilder<?> symbolBuilder) {
        this.cat = symbolBuilder.cat;
        this.bitmap = symbolBuilder.bitmap;
        this.texture = symbolBuilder.texture;
        this.hash = symbolBuilder.hash;
        this.symbolWidth = symbolBuilder.symbolWidth;
        this.symbolHeight = symbolBuilder.symbolHeight;
        this.symbolPercent = symbolBuilder.symbolPercent;
    }

    public static SymbolBuilder<?> builder() {
        return new SymbolBuilder();
    }

    @Override
    public SymbolStyle current() {
        return (SymbolStyle)this.mCurrent;
    }

    @Override
    public void dispose() {
        Bitmap bitmap = this.bitmap;
        if (bitmap != null) {
            bitmap.recycle();
        }
    }

    @Override
    public void renderNode(RenderStyle.Callback callback) {
        callback.renderSymbol(this);
    }

    @Override
    public void renderWay(RenderStyle.Callback callback) {
        callback.renderSymbol(this);
    }

    public static class SymbolBuilder<T extends SymbolBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public Bitmap bitmap;
        public int hash;
        public int symbolHeight;
        public int symbolPercent;
        public int symbolWidth;
        public TextureRegion texture;

        public T bitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
            return (T)((SymbolBuilder)this.self());
        }

        @Override
        public SymbolStyle build() {
            return new SymbolStyle(this);
        }

        public T hash(int n) {
            this.hash = n;
            return (T)((SymbolBuilder)this.self());
        }

        public T reset() {
            this.cat = null;
            this.bitmap = null;
            this.texture = null;
            this.hash = 0;
            this.symbolWidth = 0;
            this.symbolHeight = 0;
            this.symbolPercent = 100;
            return (T)((SymbolBuilder)this.self());
        }

        public T set(SymbolStyle symbolStyle) {
            if (symbolStyle == null) {
                return this.reset();
            }
            this.cat = symbolStyle.cat;
            this.bitmap = symbolStyle.bitmap;
            this.texture = symbolStyle.texture;
            this.hash = symbolStyle.hash;
            this.symbolWidth = symbolStyle.symbolWidth;
            this.symbolHeight = symbolStyle.symbolHeight;
            this.symbolPercent = symbolStyle.symbolPercent;
            return (T)((SymbolBuilder)this.self());
        }

        public T symbolHeight(int n) {
            this.symbolHeight = n;
            return (T)((SymbolBuilder)this.self());
        }

        public T symbolPercent(int n) {
            this.symbolPercent = n;
            return (T)((SymbolBuilder)this.self());
        }

        public T symbolWidth(int n) {
            this.symbolWidth = n;
            return (T)((SymbolBuilder)this.self());
        }

        public T texture(TextureRegion textureRegion) {
            this.texture = textureRegion;
            return (T)((SymbolBuilder)this.self());
        }
    }
}

