/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Paint;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.theme.styles.RenderStyle;

public final class TextStyle
extends RenderStyle<TextStyle> {
    public final float areaSize;
    public final Bitmap bitmap;
    public final boolean caption;
    public final float dy;
    public float fontDescent;
    public final Paint.FontFamily fontFamily;
    public float fontHeight;
    public float fontSize;
    public final Paint.FontStyle fontStyle;
    public final Paint paint;
    public final int priority;
    public final Paint stroke;
    public final String style;
    public final int symbolHeight;
    public final int symbolPercent;
    public final int symbolWidth;
    public final String textKey;
    public final TextureRegion texture;

    TextStyle(TextBuilder<?> textBuilder) {
        Paint paint;
        this.cat = textBuilder.cat;
        this.style = textBuilder.style;
        this.textKey = textBuilder.textKey;
        this.caption = textBuilder.caption;
        this.dy = textBuilder.dy;
        this.priority = textBuilder.priority;
        this.areaSize = textBuilder.areaSize;
        this.bitmap = textBuilder.bitmap;
        this.texture = textBuilder.texture;
        this.paint = paint = CanvasAdapter.newPaint();
        paint.setTypeface(textBuilder.fontFamily, textBuilder.fontStyle);
        int n = textBuilder.themeCallback != null ? textBuilder.themeCallback.getColor(textBuilder.fillColor) : textBuilder.fillColor;
        paint.setColor(n);
        paint.setTextSize(textBuilder.fontSize);
        if (textBuilder.strokeWidth > 0.0f) {
            this.stroke = paint = CanvasAdapter.newPaint();
            paint.setStyle(Paint.Style.STROKE);
            paint.setTypeface(textBuilder.fontFamily, textBuilder.fontStyle);
            n = textBuilder.themeCallback != null ? textBuilder.themeCallback.getColor(textBuilder.strokeColor) : textBuilder.strokeColor;
            paint.setColor(n);
            paint.setStrokeWidth(textBuilder.strokeWidth);
            paint.setTextSize(textBuilder.fontSize);
        } else {
            this.stroke = null;
        }
        this.fontFamily = textBuilder.fontFamily;
        this.fontStyle = textBuilder.fontStyle;
        this.fontSize = textBuilder.fontSize;
        this.symbolWidth = textBuilder.symbolWidth;
        this.symbolHeight = textBuilder.symbolHeight;
        this.symbolPercent = textBuilder.symbolPercent;
    }

    public static TextBuilder<?> builder() {
        return new TextBuilder();
    }

    @Override
    public TextStyle current() {
        return (TextStyle)this.mCurrent;
    }

    @Override
    public void dispose() {
        Bitmap bitmap = this.bitmap;
        if (bitmap != null) {
            bitmap.recycle();
        }
    }

    @Override
    public void renderNode(RenderStyle.Callback callback) {
        callback.renderText(this);
    }

    @Override
    public void renderWay(RenderStyle.Callback callback) {
        callback.renderText(this);
    }

    @Override
    public void scaleTextSize(float f) {
        this.fontSize = f = this.fontSize * f;
        this.paint.setTextSize(f);
        Paint paint = this.stroke;
        if (paint != null) {
            paint.setTextSize(this.fontSize);
        }
        this.fontHeight = this.paint.getFontHeight();
        this.fontDescent = this.paint.getFontDescent();
    }

    public static class TextBuilder<T extends TextBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public float areaSize;
        public Bitmap bitmap;
        public boolean caption;
        public float dy;
        public Paint.FontFamily fontFamily;
        public float fontSize;
        public Paint.FontStyle fontStyle;
        public int priority;
        public int symbolHeight;
        public int symbolPercent;
        public int symbolWidth;
        public String textKey;
        public TextureRegion texture;

        public TextBuilder() {
            this.reset();
        }

        public T areaSize(float f) {
            this.areaSize = f;
            return (T)((TextBuilder)this.self());
        }

        public T bitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
            return (T)((TextBuilder)this.self());
        }

        @Override
        public TextStyle build() {
            TextStyle textStyle = new TextStyle(this);
            textStyle.fontHeight = textStyle.paint.getFontHeight();
            textStyle.fontDescent = textStyle.paint.getFontDescent();
            return textStyle;
        }

        public TextStyle buildInternal() {
            return new TextStyle(this);
        }

        public T fontFamily(Paint.FontFamily fontFamily) {
            this.fontFamily = fontFamily;
            return (T)((TextBuilder)this.self());
        }

        public T fontSize(float f) {
            this.fontSize = f;
            return (T)((TextBuilder)this.self());
        }

        public T fontStyle(Paint.FontStyle fontStyle) {
            this.fontStyle = fontStyle;
            return (T)((TextBuilder)this.self());
        }

        public T from(TextBuilder<?> textBuilder) {
            this.cat = textBuilder.cat;
            this.fontFamily = textBuilder.fontFamily;
            this.fontStyle = textBuilder.fontStyle;
            this.style = textBuilder.style;
            this.textKey = textBuilder.textKey;
            this.fontSize = textBuilder.fontSize;
            this.caption = textBuilder.caption;
            this.priority = textBuilder.priority;
            this.areaSize = textBuilder.areaSize;
            this.bitmap = textBuilder.bitmap;
            this.texture = textBuilder.texture;
            this.fillColor = textBuilder.fillColor;
            this.strokeColor = textBuilder.strokeColor;
            this.strokeWidth = textBuilder.strokeWidth;
            this.dy = textBuilder.dy;
            this.symbolWidth = textBuilder.symbolWidth;
            this.symbolHeight = textBuilder.symbolHeight;
            this.symbolPercent = textBuilder.symbolPercent;
            return (T)((TextBuilder)this.self());
        }

        public T isCaption(boolean bl) {
            this.caption = bl;
            return (T)((TextBuilder)this.self());
        }

        public T offsetY(float f) {
            this.dy = f;
            return (T)((TextBuilder)this.self());
        }

        public T priority(int n) {
            this.priority = n;
            return (T)((TextBuilder)this.self());
        }

        public T reset() {
            this.cat = null;
            this.fontFamily = Paint.FontFamily.DEFAULT;
            this.fontStyle = Paint.FontStyle.NORMAL;
            this.style = null;
            this.textKey = null;
            this.fontSize = 0.0f;
            this.caption = false;
            this.priority = Integer.MAX_VALUE;
            this.areaSize = 0.0f;
            this.bitmap = null;
            this.texture = null;
            this.fillColor = -16777216;
            this.strokeColor = -16777216;
            this.strokeWidth = 0.0f;
            this.dy = 0.0f;
            this.symbolWidth = 0;
            this.symbolHeight = 0;
            this.symbolPercent = 100;
            return (T)((TextBuilder)this.self());
        }

        public TextBuilder<?> set(TextStyle textStyle) {
            if (textStyle == null) {
                return this.reset();
            }
            this.cat = textStyle.cat;
            this.style = textStyle.style;
            this.textKey = textStyle.textKey;
            this.caption = textStyle.caption;
            this.dy = textStyle.dy;
            this.priority = textStyle.priority;
            this.areaSize = textStyle.areaSize;
            this.bitmap = textStyle.bitmap;
            this.texture = textStyle.texture;
            int n = this.themeCallback != null ? this.themeCallback.getColor(textStyle.paint.getColor()) : textStyle.paint.getColor();
            this.fillColor = n;
            this.fontFamily = textStyle.fontFamily;
            this.fontStyle = textStyle.fontStyle;
            if (textStyle.stroke != null) {
                n = this.themeCallback != null ? this.themeCallback.getColor(textStyle.stroke.getColor()) : textStyle.stroke.getColor();
                this.strokeColor = n;
                this.strokeWidth = textStyle.stroke.getStrokeWidth();
            }
            this.fontSize = textStyle.fontSize;
            this.symbolWidth = textStyle.symbolWidth;
            this.symbolHeight = textStyle.symbolHeight;
            this.symbolPercent = textStyle.symbolPercent;
            return (TextBuilder)this.self();
        }

        public T symbolHeight(int n) {
            this.symbolHeight = n;
            return (T)((TextBuilder)this.self());
        }

        public T symbolPercent(int n) {
            this.symbolPercent = n;
            return (T)((TextBuilder)this.self());
        }

        public T symbolWidth(int n) {
            this.symbolWidth = n;
            return (T)((TextBuilder)this.self());
        }

        public T textKey(String string2) {
            this.textKey = string2;
            return (T)((TextBuilder)this.self());
        }

        public T texture(TextureRegion textureRegion) {
            this.texture = textureRegion;
            return (T)((TextBuilder)this.self());
        }
    }
}

