/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling;

import java.util.HashMap;
import org.oscim.layers.tile.bitmap.BitmapTileLayer;
import org.oscim.tiling.ITileCache;
import org.oscim.tiling.ITileDataSource;

public abstract class TileSource {
    private BitmapTileLayer.FadeStep[] mFadeSteps;
    protected String mName;
    protected int mTileSize = 256;
    protected int mZoomMax = 20;
    protected int mZoomMin = 0;
    protected final Options options = new Options();
    public ITileCache tileCache;

    protected TileSource() {
    }

    protected TileSource(int n, int n2) {
        this.mZoomMin = n;
        this.mZoomMax = n2;
    }

    public TileSource(Builder<?> builder) {
        this.mZoomMin = builder.zoomMin;
        this.mZoomMax = builder.zoomMax;
        this.mFadeSteps = builder.fadeSteps;
        this.mName = builder.name;
        this.mTileSize = builder.tileSize;
    }

    public abstract void close();

    public abstract ITileDataSource getDataSource();

    public BitmapTileLayer.FadeStep[] getFadeSteps() {
        return this.mFadeSteps;
    }

    public String getName() {
        return this.mName;
    }

    public String getOption(String string2) {
        return (String)this.options.get(string2);
    }

    public int getTileSize() {
        return this.mTileSize;
    }

    public int getZoomLevelMax() {
        return this.mZoomMax;
    }

    public int getZoomLevelMin() {
        return this.mZoomMin;
    }

    public abstract OpenResult open();

    public void setCache(ITileCache iTileCache) {
        this.tileCache = iTileCache;
    }

    public void setFadeSteps(BitmapTileLayer.FadeStep[] fadeStepArray) {
        this.mFadeSteps = fadeStepArray;
    }

    public TileSource setOption(String string2, String string3) {
        this.options.put(string2, string3);
        return this;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected BitmapTileLayer.FadeStep[] fadeSteps;
        protected String name;
        protected int tileSize;
        protected int zoomMax;
        protected int zoomMin;

        public abstract TileSource build();

        public T fadeSteps(BitmapTileLayer.FadeStep[] fadeStepArray) {
            this.fadeSteps = fadeStepArray;
            return this.self();
        }

        public T name(String string2) {
            this.name = string2;
            return this.self();
        }

        protected T self() {
            return (T)this;
        }

        public T tileSize(int n) {
            this.tileSize = n;
            return this.self();
        }

        public T zoomMax(int n) {
            this.zoomMax = n;
            return this.self();
        }

        public T zoomMin(int n) {
            this.zoomMin = n;
            return this.self();
        }
    }

    public static class OpenResult {
        public static final OpenResult SUCCESS = new OpenResult();
        private final String errorMessage;
        private final boolean success;

        public OpenResult() {
            this.success = true;
            this.errorMessage = null;
        }

        public OpenResult(String string2) {
            if (string2 != null) {
                this.success = false;
                this.errorMessage = string2;
                return;
            }
            throw new IllegalArgumentException("error message must not be null");
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FileOpenResult [success=");
            stringBuilder.append(this.success);
            stringBuilder.append(", errorMessage=");
            stringBuilder.append(this.errorMessage);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static class Options
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Options)) {
                return false;
            }
            return this.entrySet().equals(((Options)object).entrySet());
        }
    }
}

