/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.oscim.core.Tile;
import org.oscim.tiling.source.HttpEngine;
import org.oscim.tiling.source.UrlTileSource;
import org.oscim.utils.ArrayUtils;
import org.oscim.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwHttp
implements HttpEngine {
    private static final int BUFFER_SIZE = 8192;
    private static final int CONNECT_TIMEOUT = 15000;
    private static final byte[] HEADER_CONNECTION_CLOSE;
    private static final byte[] HEADER_CONTENT_LENGTH;
    private static final byte[] HEADER_ENCODING_GZIP;
    private static final byte[] HEADER_HTTP_OK;
    private static final int RESPONSE_EXPECTED_LIVES = 100;
    private static final long RESPONSE_TIMEOUT = 10000000000L;
    private static final int SOCKET_TIMEOUT = 8000;
    static final boolean dbg = false;
    static final Logger log;
    private final byte[] REQUEST_GET_END;
    private final byte[] REQUEST_GET_START;
    private final byte[] buffer = new byte[8192];
    private OutputStream mCommandStream;
    private final String mHost;
    private long mLastRequest = 0L;
    private int mMaxRequests = 0;
    private boolean mMustCloseConnection;
    private final int mPort;
    private final byte[] mRequestBuffer;
    private Buffer mResponseStream;
    private InetSocketAddress mSockAddr;
    private Socket mSocket;
    private final byte[][] mTilePath;
    private final UrlTileSource mTileSource;

    static {
        log = LoggerFactory.getLogger(LwHttp.class);
        HEADER_HTTP_OK = "200 OK".getBytes();
        HEADER_CONTENT_LENGTH = "Content-Length".getBytes();
        HEADER_CONNECTION_CLOSE = "Connection: close".getBytes();
        HEADER_ENCODING_GZIP = "Content-Encoding: gzip".getBytes();
    }

    private LwHttp(UrlTileSource object, byte[][] object2) {
        int n;
        this.mTilePath = (byte[][])object2;
        this.mTileSource = object;
        object2 = ((UrlTileSource)object).getUrl();
        int n2 = n = ((URL)object2).getPort();
        if (n < 0) {
            n2 = 80;
        }
        String string2 = ((URL)object2).getHost();
        this.mHost = string2;
        this.mPort = n2;
        String object32 = ((URL)object2).getPath();
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("GET ");
        ((StringBuilder)object2).append(object32);
        this.REQUEST_GET_START = ((StringBuilder)object2).toString().getBytes();
        object2 = new StringBuilder();
        ((StringBuilder)object2).append(" HTTP/1.1");
        ((StringBuilder)object2).append("\r\nUser-Agent: vtm/0.5.9");
        ((StringBuilder)object2).append("\r\nHost: ");
        ((StringBuilder)object2).append(string2);
        ((StringBuilder)object2).append("\r\nConnection: Keep-Alive");
        for (Map.Entry entry : ((UrlTileSource)object).getRequestHeader().entrySet()) {
            object = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            ((StringBuilder)object2).append("\r\n");
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append(": ");
            ((StringBuilder)object2).append(string3);
        }
        ((StringBuilder)object2).append("\r\n\r\n");
        this.REQUEST_GET_END = ((StringBuilder)object2).toString().getBytes();
        object = new byte[1024];
        this.mRequestBuffer = (byte[])object;
        object2 = this.REQUEST_GET_START;
        System.arraycopy(object2, 0, object, 0, ((Object)object2).length);
    }

    private static boolean check(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = byArray.length;
        if (n2 - n < n3) {
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (byArray2[n + n2] == byArray[n2]) continue;
            return false;
        }
        return true;
    }

    private void checkSocket() throws IOException {
        if (this.mSocket != null) {
            return;
        }
        throw new IOException("No Socket");
    }

    private int formatTilePath(Tile object, byte[] byArray, int n) {
        byte[][] byArray2 = this.mTilePath;
        if (byArray2 == null) {
            object = this.mTileSource.getUrlFormatter().formatTilePath(this.mTileSource, (Tile)object).getBytes();
            System.arraycopy(object, 0, byArray, n, ((Object)object).length);
            return n + ((Object)object).length;
        }
        for (byte[] byArray3 : byArray2) {
            if (byArray3.length == 1) {
                if (byArray3[0] == 47) {
                    byArray[n] = (byte)47;
                    ++n;
                    continue;
                }
                if (byArray3[0] == 88) {
                    n = LwHttp.writeInt(((Tile)object).tileX, n, byArray);
                    continue;
                }
                if (byArray3[0] == 89) {
                    n = LwHttp.writeInt(((Tile)object).tileY, n, byArray);
                    continue;
                }
                if (byArray3[0] == 90) {
                    n = LwHttp.writeInt(((Tile)object).zoomLevel, n, byArray);
                    continue;
                }
            }
            System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
            n += byArray3.length;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void lwHttpConnect() throws IOException {
        synchronized (this) {
            Object object = this.mSockAddr;
            if (object == null || ((InetSocketAddress)object).isUnresolved()) {
                this.mSockAddr = object = new InetSocketAddress(this.mHost, this.mPort);
                boolean bl = ((InetSocketAddress)object).isUnresolved();
                if (bl) {
                    object = new UnknownHostException(this.mHost);
                    throw object;
                }
            }
            try {
                this.mSocket = object = new Socket();
                ((Socket)object).setTcpNoDelay(true);
                this.mSocket.setSoTimeout(8000);
                this.mSocket.connect(this.mSockAddr, 15000);
                this.mCommandStream = this.mSocket.getOutputStream();
                this.mResponseStream = object = new Buffer(this.mSocket.getInputStream());
                this.mMustCloseConnection = false;
                return;
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
        }
    }

    private static int parseInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 = n3 * 10 + byArray[n] - 48;
            ++n;
        }
        return n3;
    }

    private static int writeInt(int n, int n2, byte[] byArray) {
        if (n == 0) {
            byArray[n2] = (byte)48;
            return n2 + 1;
        }
        int n3 = 0;
        while (n > 0) {
            byArray[n2 + n3] = (byte)(n % 10 + 48);
            n /= 10;
            ++n3;
        }
        n = n3 + n2;
        ArrayUtils.reverse(byArray, n2, n);
        return n;
    }

    private void writeRequest(int n) throws IOException {
        this.mCommandStream.write(this.mRequestBuffer, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        IOUtils.closeQuietly(this.mSocket);
        synchronized (this) {
            this.mSocket = null;
            this.mCommandStream = null;
            this.mResponseStream = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream read() throws IOException {
        synchronized (this) {
            this.checkSocket();
            Object object = this.mResponseStream;
            ((Buffer)object).mark(8192);
            ((Buffer)object).start(8192);
            byte[] byArray = this.buffer;
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            int n6 = 0;
            while (true) {
                int n7;
                int n8;
                int n9;
                int n10;
                block22: {
                    block20: {
                        block21: {
                            block19: {
                                if (n2 < n3) break block19;
                                n10 = n4;
                                if (n3 >= 8192) break block20;
                                n9 = ((Buffer)object).read(byArray, n3, 8192 - n3);
                                n10 = n4;
                                if (n9 < 0) break block20;
                                n10 = n9;
                                break block21;
                            }
                            n10 = 0;
                        }
                        n3 += n10;
                        for (n8 = n4; n8 < n3 && byArray[n8] != 10; ++n8) {
                        }
                        if (n8 == 8192) {
                            IOException iOException = new IOException("Header too large!");
                            throw iOException;
                        }
                        if (byArray[n8] != 10) {
                            n4 = n8;
                            continue;
                        }
                        n7 = n8 - n2;
                        if (n7 != 1) break block22;
                        n10 = n8 + 1;
                    }
                    ((Buffer)object).reset();
                    ((Buffer)object).mark(0);
                    ((Buffer)object).skip(n10);
                    ((Buffer)object).start(n);
                    if (n6 == 0) return object;
                    return new GZIPInputStream((InputStream)object);
                }
                if (n5 != 0) {
                    if (!LwHttp.check(HEADER_HTTP_OK, byArray, n2 + 9, n8)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("HTTP Error: ");
                        object = new String(byArray, n2, n7 - 1);
                        stringBuilder.append((String)object);
                        IOException iOException = new IOException(stringBuilder.toString());
                        throw iOException;
                    }
                    n10 = 0;
                    n4 = n;
                    n9 = n6;
                } else {
                    byte[] byArray2 = HEADER_CONTENT_LENGTH;
                    if (LwHttp.check(byArray2, byArray, n2, n8)) {
                        n4 = LwHttp.parseInt(byArray, byArray2.length + n2 + 2, n8 - 1);
                        n10 = n5;
                        n9 = n6;
                    } else if (LwHttp.check(HEADER_ENCODING_GZIP, byArray, n2, n8)) {
                        n9 = 1;
                        n4 = n;
                        n10 = n5;
                    } else {
                        n4 = n;
                        n10 = n5;
                        n9 = n6;
                        if (LwHttp.check(HEADER_CONNECTION_CLOSE, byArray, n2, n8)) {
                            this.mMustCloseConnection = true;
                            n9 = n6;
                            n10 = n5;
                            n4 = n;
                        }
                    }
                }
                n6 = n2 += n7 + 1;
                n = n4;
                n4 = n6;
                n5 = n10;
                n6 = n9;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean requestCompleted(boolean bl) {
        synchronized (this) {
            Socket socket = this.mSocket;
            if (socket == null) {
                return false;
            }
            this.mLastRequest = System.nanoTime();
            this.mResponseStream.setCache(null);
            if (!bl || this.mMustCloseConnection || !this.mResponseStream.finishedReading()) {
                this.close();
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendRequest(Tile tile) throws IOException {
        synchronized (this) {
            int n;
            if (this.mSocket != null) {
                this.mMaxRequests = n = this.mMaxRequests - 1;
                if (n < 0) {
                    this.close();
                } else if (System.nanoTime() - this.mLastRequest > 10000000000L) {
                    this.close();
                } else {
                    try {
                        n = this.mResponseStream.available();
                        if (n > 0) {
                            log.debug("left over bytes {} ", (Object)n);
                            this.close();
                        }
                    }
                    catch (IOException iOException) {
                        log.debug(iOException.getMessage());
                        this.close();
                    }
                }
            }
            if (this.mSocket == null) {
                this.lwHttpConnect();
                this.mMaxRequests = 100;
            }
            int n2 = this.REQUEST_GET_START.length;
            n = this.REQUEST_GET_END.length;
            n2 = this.formatTilePath(tile, this.mRequestBuffer, n2);
            System.arraycopy(this.REQUEST_GET_END, 0, this.mRequestBuffer, n2, n);
            n += n2;
            try {
                this.writeRequest(n);
            }
            catch (IOException iOException) {
                log.debug("recreate connection");
                this.close();
                this.lwHttpConnect();
                this.writeRequest(n);
            }
            return;
        }
    }

    @Override
    public void setCache(OutputStream outputStream) {
        synchronized (this) {
            block4: {
                Socket socket = this.mSocket;
                if (socket != null) break block4;
                return;
            }
            this.mResponseStream.setCache(outputStream);
            return;
        }
    }

    static final class Buffer
    extends BufferedInputStream {
        int bytesRead = 0;
        int bytesWrote;
        OutputStream cache;
        int contentLength;
        int marked = -1;

        public Buffer(InputStream inputStream) {
            super(inputStream, 8192);
        }

        @Override
        public void close() throws IOException {
        }

        public boolean finishedReading() {
            while (true) {
                try {
                    int n;
                    if (this.bytesRead >= this.contentLength || (n = this.read()) < 0) break;
                }
                catch (IOException iOException) {
                    log.debug(iOException.getMessage());
                    break;
                }
            }
            boolean bl = this.bytesRead == this.contentLength;
            return bl;
        }

        @Override
        public void mark(int n) {
            synchronized (this) {
                this.marked = this.bytesRead;
                super.mark(n);
                return;
            }
        }

        @Override
        public int read() throws IOException {
            int n;
            OutputStream outputStream;
            if (this.bytesRead >= this.contentLength) {
                return -1;
            }
            int n2 = super.read();
            if (n2 >= 0) {
                ++this.bytesRead;
            }
            if ((outputStream = this.cache) != null && (n = this.bytesRead) > this.bytesWrote) {
                this.bytesWrote = n;
                outputStream.write(n2);
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (this.bytesRead >= this.contentLength) {
                return -1;
            }
            int n4 = super.read(byArray, n, n2);
            if (n4 <= 0) {
                return n4;
            }
            this.bytesRead = n2 = this.bytesRead + n4;
            OutputStream outputStream = this.cache;
            if (outputStream != null && n2 > (n3 = this.bytesWrote)) {
                n3 = n2 - n3;
                this.bytesWrote = n2;
                outputStream.write(byArray, n + (n4 - n3), n3);
            }
            return n4;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void reset() throws IOException {
            synchronized (this) {
                int n = this.marked;
                if (n >= 0) {
                    this.bytesRead = n;
                }
                super.reset();
                return;
            }
        }

        public void setCache(OutputStream outputStream) {
            this.cache = outputStream;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long skip(long l) throws IOException {
            synchronized (this) {
                long l2 = 0L;
                while (l2 < l) {
                    long l3 = super.skip(l - l2);
                    if (l3 != 0L) {
                        l2 += l3;
                        continue;
                    }
                    if (this.read() < 0) break;
                    ++l2;
                    --this.bytesRead;
                }
                this.bytesRead = (int)((long)this.bytesRead + l2);
                return l2;
            }
        }

        public void start(int n) {
            this.bytesRead = 0;
            this.bytesWrote = 0;
            this.contentLength = n;
        }
    }

    public static class LwHttpFactory
    implements HttpEngine.Factory {
        private byte[][] mTilePath;

        @Override
        public HttpEngine create(UrlTileSource urlTileSource) {
            if (urlTileSource.getUrlFormatter() != UrlTileSource.URL_FORMATTER) {
                byte[][] byArray = null;
                return new LwHttp(urlTileSource, null);
            }
            if (this.mTilePath == null) {
                String[] stringArray = urlTileSource.getTilePath();
                this.mTilePath = new byte[stringArray.length][];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.mTilePath[i] = stringArray[i].getBytes();
                }
            }
            return new LwHttp(urlTileSource, this.mTilePath);
        }
    }
}

