/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source;

import java.io.IOException;
import java.io.InputStream;
import org.oscim.core.GeometryBuffer;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.utils.UTF8Decoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PbfDecoder
implements ITileDecoder {
    private static final int BUFFER_SIZE = 32768;
    protected static final ProtobufException INVALID_PACKED_SIZE;
    protected static final ProtobufException INVALID_VARINT;
    private static final int M1 = 127;
    private static final int M2 = 16383;
    private static final int M3 = 0x1FFFFF;
    private static final int M4 = 0xFFFFFFF;
    private static final int S1 = 7;
    private static final int S2 = 14;
    private static final int S3 = 21;
    private static final int S4 = 28;
    static final ProtobufException TRUNCATED_MSG;
    protected static final boolean debug = false;
    static final Logger log;
    protected byte[] buffer = new byte[32768];
    protected int bufferFill;
    protected int bufferPos;
    private int mBufferOffset;
    private InputStream mInputStream;
    private int mMsgPos;
    private final UTF8Decoder mStringDecoder = new UTF8Decoder();

    static {
        log = LoggerFactory.getLogger(PbfDecoder.class);
        TRUNCATED_MSG = new ProtobufException("truncated msg");
        INVALID_VARINT = new ProtobufException("invalid varint");
        INVALID_PACKED_SIZE = new ProtobufException("invalid message size");
    }

    protected static int deZigZag(int n) {
        return -(n & 1) ^ n >>> 1;
    }

    static int decodeInt(byte[] byArray, int n) {
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        byte by3 = byArray[n + 2];
        return byArray[n + 3] & 0xFF | (by << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8);
    }

    protected static int readUnsignedInt(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2;
        for (n = 0; n < 4 && (n2 = inputStream.read(byArray, n, 4 - n)) >= 0; n += n2) {
        }
        if (n < 4) {
            n2 = n;
            if (n < 0) {
                n2 = n * 10;
            }
            return n2;
        }
        return PbfDecoder.decodeInt(byArray, 0);
    }

    protected boolean decodeBool() throws IOException {
        int n = this.bufferPos;
        boolean bl = true;
        if (n + 1 > this.bufferFill) {
            this.fillBuffer(1);
        }
        byte[] byArray = this.buffer;
        n = this.bufferPos;
        this.bufferPos = n + 1;
        if (byArray[n] == 0) {
            bl = false;
        }
        return bl;
    }

    protected double decodeDouble() throws IOException {
        int n;
        if (this.bufferPos + 8 > this.bufferFill) {
            this.fillBuffer(8);
        }
        byte[] byArray = this.buffer;
        int n2 = this.bufferPos;
        this.bufferPos = n = n2 + 1;
        long l = byArray[n2];
        this.bufferPos = n2 = n + 1;
        long l2 = byArray[n];
        this.bufferPos = n = n2 + 1;
        long l3 = byArray[n2];
        this.bufferPos = n2 = n + 1;
        long l4 = byArray[n];
        this.bufferPos = n = n2 + 1;
        long l5 = byArray[n2];
        this.bufferPos = n2 = n + 1;
        long l6 = byArray[n];
        this.bufferPos = n = n2 + 1;
        long l7 = byArray[n2];
        this.bufferPos = n + 1;
        return Double.longBitsToDouble(l & 0xFFL | (l2 & 0xFFL) << 8 | (l3 & 0xFFL) << 16 | (l4 & 0xFFL) << 24 | (l5 & 0xFFL) << 32 | (l6 & 0xFFL) << 40 | (l7 & 0xFFL) << 48 | ((long)byArray[n] & 0xFFL) << 56);
    }

    protected float decodeFloat() throws IOException {
        int n;
        int n2;
        if (this.bufferPos + 4 > this.bufferFill) {
            this.fillBuffer(4);
        }
        byte[] byArray = this.buffer;
        int n3 = this.bufferPos;
        this.bufferPos = n2 = n3 + 1;
        n3 = byArray[n3];
        this.bufferPos = n = n2 + 1;
        byte by = byArray[n2];
        this.bufferPos = n2 = n + 1;
        n = byArray[n];
        this.bufferPos = n2 + 1;
        return Float.intBitsToFloat((byArray[n2] & 0xFF) << 24 | (n3 & 0xFF | (by & 0xFF) << 8 | (n & 0xFF) << 16));
    }

    protected int decodeInterleavedPoints(GeometryBuffer geometryBuffer, float f) throws IOException {
        float[] fArray = geometryBuffer.points;
        int n = this.decodeVarint32();
        this.fillBuffer(n);
        byte[] byArray = this.buffer;
        int n2 = this.bufferPos;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        int n7 = n2;
        while (n7 < n2 + n) {
            int n8;
            int n9 = n7 + 1;
            int n10 = n8 = byArray[n7];
            n7 = n9;
            if (n8 < 0) {
                int n11 = n9 + 1;
                byte by = byArray[n9];
                n10 = n9 = n8 & 0x7F | by << 7;
                n7 = n11;
                if (by < 0) {
                    n8 = n11 + 1;
                    n11 = byArray[n11];
                    n10 = n9 = n9 & 0x3FFF | n11 << 14;
                    n7 = n8;
                    if (n11 < 0) {
                        n11 = n8 + 1;
                        by = byArray[n8];
                        n10 = n8 = n9 & 0x1FFFFF | by << 21;
                        n7 = n11;
                        if (by < 0) {
                            n7 = n11 + 1;
                            n11 = byArray[n11];
                            n10 = n8 & 0xFFFFFFF | n11 << 28;
                            if (n11 < 0) {
                                throw INVALID_VARINT;
                            }
                        }
                    }
                }
            }
            n10 = -(n10 & 1) ^ n10 >>> 1;
            if (n6 != 0) {
                n6 = n4 + n10;
                fArray[n3] = (float)n6 / f;
                n4 = n3 + 1;
                n10 = 0;
            } else {
                fArray[n3] = (float)(n5 += n10) / f;
                n10 = 1;
                n6 = n4;
                n4 = ++n3;
            }
            n3 = n4;
            n4 = n6;
            n6 = n10;
        }
        if (n7 == this.bufferPos + n) {
            this.bufferPos = n7;
            geometryBuffer.pointNextPos = n3;
            return n3 >> 1;
        }
        throw INVALID_PACKED_SIZE;
    }

    protected int decodeInterleavedPoints3D(float[] fArray, float f) throws IOException {
        int n = this.decodeVarint32();
        this.fillBuffer(n);
        byte[] byArray = this.buffer;
        int n2 = this.bufferPos;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n2;
        while (n8 < n2 + n) {
            int n9;
            int n10 = n8 + 1;
            int n11 = n9 = byArray[n8];
            n8 = n10;
            if (n9 < 0) {
                int n12 = n10 + 1;
                byte by = byArray[n10];
                n11 = n10 = n9 & 0x7F | by << 7;
                n8 = n12;
                if (by < 0) {
                    n9 = n12 + 1;
                    n12 = byArray[n12];
                    n11 = n10 = n10 & 0x3FFF | n12 << 14;
                    n8 = n9;
                    if (n12 < 0) {
                        n12 = n9 + 1;
                        by = byArray[n9];
                        n11 = n9 = n10 & 0x1FFFFF | by << 21;
                        n8 = n12;
                        if (by < 0) {
                            n8 = n12 + 1;
                            n12 = byArray[n12];
                            n11 = n9 & 0xFFFFFFF | n12 << 28;
                            if (n12 < 0) {
                                throw INVALID_VARINT;
                            }
                        }
                    }
                }
            }
            n11 = -(n11 & 1) ^ n11 >>> 1;
            if (n7 == 0) {
                n4 += n11;
                n11 = n3 + 1;
                fArray[n3] = (float)n4 / f;
            } else if (n7 == 1) {
                n5 += n11;
                n11 = n3 + 1;
                fArray[n3] = (float)n5 / f;
            } else {
                n6 += n11;
                n11 = n3 + 1;
                fArray[n3] = (float)n6 / f;
            }
            n7 = (n7 + 1) % 3;
            n3 = n11;
        }
        if (n8 == this.bufferPos + n) {
            this.bufferPos = n8;
            return n3;
        }
        throw INVALID_PACKED_SIZE;
    }

    protected String decodeString() throws IOException {
        int n = this.decodeVarint32();
        this.fillBuffer(n);
        Object object = this.mStringDecoder;
        object = object == null ? new String(this.buffer, this.bufferPos, n, "UTF-8") : ((UTF8Decoder)object).decode(this.buffer, this.bufferPos, n);
        this.bufferPos += n;
        return object;
    }

    protected short[] decodeUnsignedVarintArray(short[] sArray) throws IOException {
        int n = this.decodeVarint32();
        int n2 = 32;
        if (sArray == null) {
            sArray = new short[32];
        } else {
            n2 = 0;
        }
        this.fillBuffer(n);
        byte[] byArray = this.buffer;
        int n3 = this.bufferPos;
        int n4 = 0;
        int n5 = n3;
        int n6 = n2;
        while (n5 < n3 + n) {
            int n7;
            int n8;
            int n9 = n5 + 1;
            n2 = n8 = byArray[n5];
            n5 = n9;
            if (n8 < 0) {
                n7 = n9 + 1;
                n9 = byArray[n9];
                n2 = n8 = n8 & 0x7F | n9 << 7;
                n5 = n7;
                if (n9 < 0) {
                    n9 = n7 + 1;
                    n7 = byArray[n7];
                    n2 = n8 = n8 & 0x3FFF | n7 << 14;
                    n5 = n9;
                    if (n7 < 0) {
                        n7 = n9 + 1;
                        byte by = byArray[n9];
                        n2 = n9 = n8 & 0x1FFFFF | by << 21;
                        n5 = n7;
                        if (by < 0) {
                            n5 = n7 + 1;
                            n7 = byArray[n7];
                            n2 = n9 & 0xFFFFFFF | n7 << 28;
                            if (n7 < 0) {
                                throw INVALID_VARINT;
                            }
                        }
                    }
                }
            }
            n7 = n6;
            short[] sArray2 = sArray;
            if (n6 <= n4) {
                n7 = n4 + 16;
                sArray2 = new short[n7];
                System.arraycopy(sArray, 0, sArray2, 0, n4);
            }
            sArray2[n4] = (short)n2;
            ++n4;
            n6 = n7;
            sArray = sArray2;
        }
        if (n5 == this.bufferPos + n) {
            this.bufferPos = n5;
            if (n6 > n4) {
                sArray[n4] = (short)-1;
            }
            return sArray;
        }
        throw INVALID_PACKED_SIZE;
    }

    protected int decodeVarint32() throws IOException {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 32; i += 7) {
            int n3 = n;
            if (n == 0) {
                n3 = this.fillBuffer(1);
            }
            byte[] byArray = this.buffer;
            n = this.bufferPos;
            this.bufferPos = n + 1;
            n = byArray[n];
            n2 |= (n & 0x7F) << i;
            if (n >= 0) {
                return n2;
            }
            n = n3 - 1;
        }
        throw INVALID_VARINT;
    }

    protected int decodeVarint32Filled() throws IOException {
        int n;
        byte[] byArray = this.buffer;
        int n2 = this.bufferPos;
        int n3 = n2 + 1;
        n2 = n = byArray[n2];
        int n4 = n3;
        if (n < 0) {
            int n5 = n3 + 1;
            n3 = byArray[n3];
            n2 = n = n & 0x7F | n3 << 7;
            n4 = n5;
            if (n3 < 0) {
                n3 = n5 + 1;
                n5 = byArray[n5];
                n2 = n = n & 0x3FFF | n5 << 14;
                n4 = n3;
                if (n5 < 0) {
                    n5 = n3 + 1;
                    byte by = byArray[n3];
                    n2 = n3 = n & 0x1FFFFF | by << 21;
                    n4 = n5;
                    if (by < 0) {
                        n4 = n5 + 1;
                        n5 = byArray[n5];
                        n2 = n3 & 0xFFFFFFF | n5 << 28;
                        if (n5 < 0) {
                            throw INVALID_VARINT;
                        }
                    }
                }
            }
        }
        this.bufferPos = n4;
        return n2;
    }

    protected long decodeVarint64() throws IOException {
        long l = 0L;
        int n = 0;
        for (int i = 0; i < 64; i += 7) {
            int n2 = n;
            if (n == 0) {
                n2 = this.fillBuffer(1);
            }
            byte[] byArray = this.buffer;
            n = this.bufferPos;
            this.bufferPos = n + 1;
            n = byArray[n];
            l |= (long)(n & 0x7F) << i;
            if (n >= 0) {
                return l;
            }
            n = n2 - 1;
        }
        throw INVALID_VARINT;
    }

    public void decodeVarintArray(int n, int[] object) throws IOException {
        int n2 = this.decodeVarint32();
        this.fillBuffer(n2);
        byte[] byArray = this.buffer;
        int n3 = this.bufferPos;
        int n4 = 0;
        int n5 = n3;
        while (n5 < n3 + n2) {
            if (n4 != n) {
                int n6;
                int n7 = n5 + 1;
                int n8 = n6 = byArray[n5];
                n5 = n7;
                if (n6 < 0) {
                    int n9 = n7 + 1;
                    byte by = byArray[n7];
                    n8 = n7 = n6 & 0x7F | by << 7;
                    n5 = n9;
                    if (by < 0) {
                        n6 = n9 + 1;
                        n9 = byArray[n9];
                        n8 = n7 = n7 & 0x3FFF | n9 << 14;
                        n5 = n6;
                        if (n9 < 0) {
                            n9 = n6 + 1;
                            by = byArray[n6];
                            n8 = n6 = n7 & 0x1FFFFF | by << 21;
                            n5 = n9;
                            if (by < 0) {
                                n5 = n9 + 1;
                                n9 = byArray[n9];
                                n8 = n6 & 0xFFFFFFF | n9 << 28;
                                if (n9 < 0) {
                                    throw INVALID_VARINT;
                                }
                            }
                        }
                    }
                }
                object[n4] = n8;
                ++n4;
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("invalid array size ");
            ((StringBuilder)object).append(n);
            throw new ProtobufException(((StringBuilder)object).toString());
        }
        if (n5 == this.bufferPos + n2) {
            this.bufferPos = n5;
            return;
        }
        throw INVALID_PACKED_SIZE;
    }

    protected void error(String string2) throws IOException {
        throw new ProtobufException(string2);
    }

    public int fillBuffer(int n) throws IOException {
        byte[] byArray;
        int n2 = this.bufferFill;
        int n3 = this.bufferPos;
        int n4 = n2 - n3;
        if (n4 >= n) {
            return n4;
        }
        byte[] byArray2 = this.buffer;
        int n5 = byArray2.length;
        if (n > n5) {
            byArray = new byte[n];
            this.buffer = byArray;
            System.arraycopy(byArray2, n3, byArray, 0, n4);
            this.mBufferOffset += this.bufferPos;
            this.bufferPos = 0;
            this.bufferFill = n4;
            n2 = n;
        } else if (n4 == 0) {
            this.mBufferOffset += n3;
            this.bufferPos = 0;
            this.bufferFill = 0;
            n2 = n5;
        } else {
            n2 = n5;
            if (n3 + n > n5) {
                System.arraycopy(byArray2, n3, byArray2, 0, n4);
                this.mBufferOffset += this.bufferPos;
                this.bufferPos = 0;
                this.bufferFill = n4;
                n2 = n5;
            }
        }
        while ((n5 = this.bufferFill) - (n3 = this.bufferPos) < n) {
            n3 = n2 - n5;
            if (n3 > 0) {
                if ((n5 = this.mInputStream.read(this.buffer, n5, n3)) < 0) {
                    byArray = this.buffer;
                    n = this.bufferFill;
                    byArray[n] = (byte)0;
                    return n - this.bufferPos;
                }
                this.mMsgPos += n5;
                this.bufferFill += n5;
                continue;
            }
            throw new IOException("burp");
        }
        return n5 - n3;
    }

    public boolean hasData() throws IOException {
        boolean bl = true;
        if (this.fillBuffer(1) <= 0) {
            bl = false;
        }
        return bl;
    }

    public int position() {
        return this.mBufferOffset + this.bufferPos;
    }

    public void setInputStream(InputStream inputStream) {
        this.mInputStream = inputStream;
        this.bufferFill = 0;
        this.bufferPos = 0;
        this.mBufferOffset = 0;
        this.mMsgPos = 0;
    }

    static class ProtobufException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ProtobufException(String string2) {
            super(string2);
        }
    }
}

