/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.oscim.core.Tile;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.HttpEngine;
import org.oscim.tiling.source.LwHttp;

public abstract class UrlTileSource
extends TileSource {
    public static final TileUrlFormatter URL_FORMATTER = new DefaultTileUrlFormatter();
    private String mApiKey;
    private HttpEngine.Factory mHttpFactory;
    private String mKeyName = "key";
    private Map<String, String> mRequestHeaders = Collections.emptyMap();
    private final String[] mTilePath;
    private TileUrlFormatter mTileUrlFormatter = URL_FORMATTER;
    private final URL mUrl;

    protected UrlTileSource(String string2, String string3) {
        this(string2, string3, 0, 17);
    }

    protected UrlTileSource(String string2, String string3, int n, int n2) {
        super(n, n2);
        this.mUrl = this.makeUrl(string2);
        this.mTilePath = this.makeTilePath(string3);
    }

    protected UrlTileSource(Builder<?> builder) {
        super(builder);
        this.mKeyName = ((Builder)builder).keyName;
        this.mApiKey = ((Builder)builder).apiKey;
        this.mUrl = this.makeUrl(builder.url);
        this.mTilePath = builder.tilePath.split("\\{|\\}");
        this.mHttpFactory = ((Builder)builder).engineFactory;
    }

    private String[] makeTilePath(String string2) {
        if (string2 != null) {
            return string2.split("\\{|\\}");
        }
        throw new IllegalArgumentException("tilePath cannot be null.");
    }

    private URL makeUrl(String object) {
        try {
            object = new URL((String)object);
            return object;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    @Override
    public void close() {
    }

    public HttpEngine getHttpEngine() {
        if (this.mHttpFactory == null) {
            this.mHttpFactory = new LwHttp.LwHttpFactory();
        }
        return this.mHttpFactory.create(this);
    }

    public Map<String, String> getRequestHeader() {
        return this.mRequestHeaders;
    }

    public String[] getTilePath() {
        return this.mTilePath;
    }

    public String getTileUrl(Tile tile) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mUrl);
        stringBuilder.append(this.mTileUrlFormatter.formatTilePath(this, tile));
        if (this.mApiKey != null) {
            stringBuilder.append("?");
            stringBuilder.append(this.mKeyName);
            stringBuilder.append("=");
            stringBuilder.append(this.mApiKey);
        }
        return stringBuilder.toString();
    }

    public URL getUrl() {
        return this.mUrl;
    }

    public TileUrlFormatter getUrlFormatter() {
        return this.mTileUrlFormatter;
    }

    @Override
    public TileSource.OpenResult open() {
        return TileSource.OpenResult.SUCCESS;
    }

    public void setApiKey(String string2) {
        this.mApiKey = string2;
    }

    public void setHttpEngine(HttpEngine.Factory factory) {
        this.mHttpFactory = factory;
    }

    public void setHttpRequestHeaders(Map<String, String> map) {
        this.mRequestHeaders = map;
    }

    public void setUrlFormatter(TileUrlFormatter tileUrlFormatter) {
        this.mTileUrlFormatter = tileUrlFormatter;
    }

    public int tileXToUrlX(int n) {
        return n;
    }

    public int tileYToUrlY(int n) {
        return n;
    }

    public int tileZToUrlZ(int n) {
        return n;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends TileSource.Builder<T> {
        private String apiKey;
        private HttpEngine.Factory engineFactory;
        private String keyName = "key";
        protected String tilePath;
        protected String url;

        protected Builder() {
        }

        protected Builder(String string2, String string3, int n, int n2) {
            this.url = string2;
            this.tilePath = string3;
            this.zoomMin = n;
            this.zoomMax = n2;
        }

        public T apiKey(String string2) {
            this.apiKey = string2;
            return (T)((Builder)this.self());
        }

        public T httpFactory(HttpEngine.Factory factory) {
            this.engineFactory = factory;
            return (T)((Builder)this.self());
        }

        public T keyName(String string2) {
            this.keyName = string2;
            return (T)((Builder)this.self());
        }

        public T tilePath(String string2) {
            this.tilePath = string2;
            return (T)((Builder)this.self());
        }

        public T url(String string2) {
            this.url = string2;
            return (T)((Builder)this.self());
        }
    }

    private static class DefaultTileUrlFormatter
    implements TileUrlFormatter {
        private DefaultTileUrlFormatter() {
        }

        @Override
        public String formatTilePath(UrlTileSource urlTileSource, Tile tile) {
            StringBuilder stringBuilder = new StringBuilder();
            block5: for (String string2 : urlTileSource.getTilePath()) {
                if (string2.length() == 1) {
                    switch (string2.charAt(0)) {
                        default: {
                            break;
                        }
                        case 'Z': {
                            stringBuilder.append(urlTileSource.tileZToUrlZ(tile.zoomLevel));
                            continue block5;
                        }
                        case 'Y': {
                            stringBuilder.append(urlTileSource.tileYToUrlY(tile.tileY));
                            continue block5;
                        }
                        case 'X': {
                            stringBuilder.append(urlTileSource.tileXToUrlX(tile.tileX));
                            continue block5;
                        }
                    }
                }
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
    }

    public static interface TileUrlFormatter {
        public String formatTilePath(UrlTileSource var1, Tile var2);
    }
}

