/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.bitmap;

import java.io.IOException;
import java.io.InputStream;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.tiling.source.LwHttp;
import org.oscim.tiling.source.UrlTileDataSource;
import org.oscim.tiling.source.UrlTileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapTileSource
extends UrlTileSource {
    static final Logger log = LoggerFactory.getLogger(LwHttp.class);

    public BitmapTileSource(String string2, int n, int n2) {
        this(string2, "/{Z}/{X}/{Y}.png", n, n2);
    }

    public BitmapTileSource(String string2, int n, int n2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/{Z}/{X}/{Y}");
        stringBuilder.append(string3);
        this(string2, stringBuilder.toString(), n, n2);
    }

    public BitmapTileSource(String string2, String string3, int n, int n2) {
        super((UrlTileSource.Builder)((Builder)((Builder)((Builder)BitmapTileSource.builder().url(string2)).tilePath(string3)).zoomMin(n)).zoomMax(n2));
    }

    protected BitmapTileSource(Builder<?> builder) {
        super((UrlTileSource.Builder<?>)builder);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    @Override
    public ITileDataSource getDataSource() {
        return new UrlTileDataSource(this, new BitmapTileDecoder(), this.getHttpEngine());
    }

    public class BitmapTileDecoder
    implements ITileDecoder {
        @Override
        public boolean decode(Tile tile, ITileDataSink iTileDataSink, InputStream object) throws IOException {
            if (!(object = CanvasAdapter.decodeBitmap((InputStream)object)).isValid()) {
                log.debug("{} invalid bitmap", (Object)tile);
                return false;
            }
            iTileDataSink.setTileImage((Bitmap)object);
            return true;
        }
    }

    public static class Builder<T extends Builder<T>>
    extends UrlTileSource.Builder<T> {
        public Builder() {
            super(null, "/{Z}/{X}/{Y}.png", 0, 17);
        }

        @Override
        public BitmapTileSource build() {
            return new BitmapTileSource(this);
        }
    }
}

