/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.oscim.tiling.source.mapfile.Deserializer;
import org.oscim.tiling.source.mapfile.IndexCacheEntryKey;
import org.oscim.tiling.source.mapfile.header.SubFileParameter;
import org.oscim.utils.LRUCache;

class IndexCache {
    private static final int INDEX_ENTRIES_PER_BLOCK = 128;
    private static final Logger LOG = Logger.getLogger(IndexCache.class.getName());
    private static final int SIZE_OF_INDEX_BLOCK = 640;
    private final Map<IndexCacheEntryKey, byte[]> map;
    private final RandomAccessFile randomAccessFile;

    IndexCache(RandomAccessFile randomAccessFile, int n) {
        this.randomAccessFile = randomAccessFile;
        this.map = Collections.synchronizedMap(new LRUCache(n));
    }

    void destroy() {
        this.map.clear();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getIndexEntry(SubFileParameter subFileParameter, long l) {
        synchronized (this) {
            Throwable throwable2222;
            block8: {
                long l2;
                block7: {
                    l2 = subFileParameter.numberOfBlocks;
                    if (l < l2) break block7;
                    return -1L;
                }
                try {
                    byte[] byArray;
                    l2 = l / 128L;
                    IndexCacheEntryKey indexCacheEntryKey = new IndexCacheEntryKey(subFileParameter, l2);
                    byte[] byArray2 = byArray = this.map.get(indexCacheEntryKey);
                    if (byArray != null) return Deserializer.getFiveBytesLong(byArray2, (int)(l % 128L * 5L));
                    l2 = subFileParameter.indexStartAddress + l2 * 640L;
                    int n = Math.min(640, (int)(subFileParameter.indexEndAddress - l2));
                    byArray2 = new byte[n];
                    this.randomAccessFile.seek(l2);
                    if (this.randomAccessFile.read(byArray2, 0, n) != n) {
                        LOG.warning("reading the current index block has failed");
                        return -1L;
                    }
                    this.map.put(indexCacheEntryKey, byArray2);
                    return Deserializer.getFiveBytesLong(byArray2, (int)(l % 128L * 5L));
                }
                catch (Throwable throwable2222) {
                    break block8;
                }
                catch (IOException iOException) {
                    LOG.log(Level.SEVERE, null, iOException);
                    return -1L;
                }
            }
            throw throwable2222;
        }
    }
}

