/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.oscim.backend.CanvasAdapter;
import org.oscim.core.BoundingBox;
import org.oscim.core.GeoPoint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tag;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.source.mapfile.MapFileTileSource;
import org.oscim.tiling.source.mapfile.MapReadResult;
import org.oscim.tiling.source.mapfile.OSMUtils;
import org.oscim.tiling.source.mapfile.PoiWayBundle;
import org.oscim.tiling.source.mapfile.PointOfInterest;
import org.oscim.tiling.source.mapfile.Projection;
import org.oscim.tiling.source.mapfile.QueryCalculations;
import org.oscim.tiling.source.mapfile.QueryParameters;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.Way;
import org.oscim.tiling.source.mapfile.header.SubFileParameter;
import org.oscim.utils.Parameters;
import org.oscim.utils.geom.TileClipper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDatabase
implements ITileDataSource {
    private static final long BITMASK_INDEX_OFFSET = 0x7FFFFFFFFFL;
    private static final long BITMASK_INDEX_WATER = 0x8000000000L;
    private static final String DEBUG_SIGNATURE_BLOCK = "block signature: ";
    private static final String DEBUG_SIGNATURE_WAY = "way signature: ";
    private static final String INVALID_FIRST_WAY_OFFSET = "invalid first way offset: ";
    private static final int POI_FEATURE_ELEVATION = 32;
    private static final int POI_FEATURE_HOUSE_NUMBER = 64;
    private static final int POI_FEATURE_NAME = 128;
    private static final int POI_LAYER_BITMASK = 240;
    private static final int POI_LAYER_SHIFT = 4;
    private static final int POI_NUMBER_OF_TAGS_BITMASK = 15;
    private static final byte SIGNATURE_LENGTH_BLOCK = 32;
    private static final byte SIGNATURE_LENGTH_POI = 32;
    private static final byte SIGNATURE_LENGTH_WAY = 32;
    private static final int WAY_FEATURE_DATA_BLOCKS_BYTE = 8;
    private static final int WAY_FEATURE_DOUBLE_DELTA_ENCODING = 4;
    private static final int WAY_FEATURE_HOUSE_NUMBER = 64;
    private static final int WAY_FEATURE_LABEL_POSITION = 16;
    private static final int WAY_FEATURE_NAME = 128;
    private static final int WAY_FEATURE_REF = 32;
    private static final int WAY_LAYER_BITMASK = 240;
    private static final int WAY_LAYER_SHIFT = 4;
    private static final int WAY_NUMBER_OF_TAGS_BITMASK = 15;
    static final Logger log = LoggerFactory.getLogger(MapDatabase.class);
    public static int wayFilterDistance;
    public static boolean wayFilterEnabled;
    private boolean mDebugFile;
    private final MapElement mElem = new MapElement();
    private long mFileSize;
    private RandomAccessFile mInputFile;
    private int[] mIntBuffer;
    private ReadBuffer mReadBuffer;
    private String mSignatureBlock;
    private String mSignaturePoi;
    private String mSignatureWay;
    private final TileClipper mTileClipper;
    private int mTileLatitude;
    private int mTileLongitude;
    private final TileProjection mTileProjection;
    private final MapFileTileSource mTileSource;
    private int minDeltaLat;
    private int minDeltaLon;
    private int stringOffset = -1;
    private int xmax;
    private int xmin;
    private int ymax;
    private int ymin;
    private int zoomLevelMax = 127;
    private int zoomLevelMin = 0;

    static {
        wayFilterEnabled = true;
        wayFilterDistance = 20;
    }

    public MapDatabase(MapFileTileSource object) throws IOException {
        this.mTileSource = object;
        try {
            RandomAccessFile randomAccessFile;
            this.mInputFile = randomAccessFile = new RandomAccessFile(((MapFileTileSource)object).mapFile, "r");
            this.mFileSize = randomAccessFile.length();
            this.mReadBuffer = object = new ReadBuffer(this.mInputFile);
            this.mTileProjection = new TileProjection();
            this.mTileClipper = new TileClipper(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage());
            this.dispose();
            throw new IOException();
        }
    }

    private int decodeWayNodes(boolean bl, MapElement mapElement, int n, boolean bl2) {
        int[] nArray = this.mIntBuffer;
        this.mReadBuffer.readSignedInt(nArray, n);
        float[] fArray = mapElement.ensurePointSize(mapElement.pointNextPos + n, true);
        int n2 = mapElement.pointNextPos;
        int n3 = this.mTileLatitude + nArray[0];
        int n4 = this.mTileLongitude + nArray[1];
        int n5 = n2 + 1;
        fArray[n2] = n4;
        n2 = n5 + 1;
        fArray[n5] = n3;
        int n6 = n3;
        int n7 = n4;
        n5 = 2;
        int n8 = 0;
        int n9 = 0;
        for (int i = 2; i < n; i += 2) {
            int n10;
            if (bl) {
                n10 = nArray[i];
                n9 = nArray[i + 1] + n9;
                n8 = n10 + n8;
            } else {
                n8 = nArray[i];
                n9 = nArray[i + 1];
            }
            int n11 = n6 + n8;
            int n12 = n7 + n9;
            if (i == n - 2) {
                n10 = !(bl2 || n12 != n4 && n11 != n3) ? 0 : 1;
                n6 = n2;
                n7 = n5;
                if (n10 != 0) {
                    n7 = n2 + 1;
                    fArray[n2] = n12;
                    n6 = n7 + 1;
                    fArray[n7] = n11;
                    n7 = n5 + 2;
                }
                n2 = n6;
                n5 = n7;
                if (mapElement.type == GeometryBuffer.GeometryType.NONE) {
                    GeometryBuffer.GeometryType geometryType = n10 != 0 ? GeometryBuffer.GeometryType.LINE : GeometryBuffer.GeometryType.POLY;
                    mapElement.type = geometryType;
                    n2 = n6;
                    n5 = n7;
                }
            } else {
                n7 = n2 + 1;
                fArray[n2] = n12;
                fArray[n7] = n11;
                n5 += 2;
                n2 = n7 + 1;
            }
            n6 = n11;
            n7 = n12;
        }
        mapElement.pointNextPos = n2;
        return n5;
    }

    private void logDebugSignatures() {
        if (this.mDebugFile) {
            Logger logger = log;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(DEBUG_SIGNATURE_WAY);
            stringBuilder.append(this.mSignatureWay);
            logger.warn(stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append(DEBUG_SIGNATURE_BLOCK);
            stringBuilder.append(this.mSignatureBlock);
            logger.warn(stringBuilder.toString());
        }
    }

    private void processBlock(QueryParameters object, SubFileParameter object2, ITileDataSink iTileDataSink, BoundingBox boundingBox, Selector selector, MapReadResult mapReadResult) {
        if (!this.processBlockSignature()) {
            return;
        }
        Object object3 = this.readZoomTable((SubFileParameter)object2);
        if (object3 == null) {
            return;
        }
        int n = ((QueryParameters)object).queryZoomLevel - ((SubFileParameter)object2).zoomLevelMin;
        int n2 = object3[n][0];
        n = object3[n][1];
        int n3 = this.mReadBuffer.readUnsignedInt();
        if (n3 < 0) {
            object = log;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(INVALID_FIRST_WAY_OFFSET);
            ((StringBuilder)object2).append(n3);
            object.warn(((StringBuilder)object2).toString());
            if (this.mDebugFile) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(DEBUG_SIGNATURE_BLOCK);
                ((StringBuilder)object2).append(this.mSignatureBlock);
                object.warn(((StringBuilder)object2).toString());
            }
            return;
        }
        n3 = this.mReadBuffer.getBufferPosition() + n3;
        if (n3 > this.mReadBuffer.getBufferSize()) {
            object = log;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(INVALID_FIRST_WAY_OFFSET);
            ((StringBuilder)object2).append(n3);
            object.warn(((StringBuilder)object2).toString());
            if (this.mDebugFile) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(DEBUG_SIGNATURE_BLOCK);
                ((StringBuilder)object2).append(this.mSignatureBlock);
                object.warn(((StringBuilder)object2).toString());
            }
            return;
        }
        boolean bl = ((QueryParameters)object).queryZoomLevel > ((SubFileParameter)object2).baseZoomLevel;
        Object var12_12 = null;
        object3 = mapReadResult != null ? (Object)new ArrayList() : null;
        if (!this.processPOIs(iTileDataSink, n2, boundingBox, bl, (List<PointOfInterest>)object3)) {
            return;
        }
        if (this.mReadBuffer.getBufferPosition() > n3) {
            object = log;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("invalid buffer position: ");
            ((StringBuilder)object2).append(this.mReadBuffer.getBufferPosition());
            object.warn(((StringBuilder)object2).toString());
            if (this.mDebugFile) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(DEBUG_SIGNATURE_BLOCK);
                ((StringBuilder)object2).append(this.mSignatureBlock);
                object.warn(((StringBuilder)object2).toString());
            }
            return;
        }
        this.mReadBuffer.setBufferPosition(n3);
        object2 = var12_12;
        if (mapReadResult != null) {
            object2 = var12_12;
            if (Selector.POIS != selector) {
                object2 = new ArrayList<Way>();
            }
        }
        if (!this.processWays((QueryParameters)object, iTileDataSink, n, boundingBox, bl, selector, (List<Way>)object2)) {
            return;
        }
        if (mapReadResult != null) {
            if (Selector.POIS == selector) {
                object2 = Collections.emptyList();
            }
            mapReadResult.add(new PoiWayBundle((List<PointOfInterest>)object3, (List<Way>)object2));
        }
    }

    private boolean processBlockSignature() {
        if (this.mDebugFile) {
            Object object = this.mReadBuffer.readUTF8EncodedString(32);
            this.mSignatureBlock = object;
            if (!((String)object).startsWith("###TileStart")) {
                object = log;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("invalid block signature: ");
                stringBuilder.append(this.mSignatureBlock);
                object.warn(stringBuilder.toString());
                return false;
            }
        }
        return true;
    }

    private void processBlocks(ITileDataSink iTileDataSink, QueryParameters queryParameters, SubFileParameter subFileParameter) throws IOException {
        this.processBlocks(iTileDataSink, queryParameters, subFileParameter, null, null, null);
    }

    private void processBlocks(ITileDataSink object, QueryParameters object2, SubFileParameter subFileParameter, BoundingBox boundingBox, Selector selector, MapReadResult mapReadResult) throws IOException {
        for (long i = ((QueryParameters)object2).fromBlockY; i <= ((QueryParameters)object2).toBlockY; ++i) {
            for (long j = ((QueryParameters)object2).fromBlockX; j <= ((QueryParameters)object2).toBlockX; ++j) {
                long l;
                block9: {
                    long l2;
                    block12: {
                        long l3;
                        block11: {
                            block10: {
                                this.setTileClipping((QueryParameters)object2, i - ((QueryParameters)object2).fromBlockY, j - ((QueryParameters)object2).fromBlockX);
                                l3 = subFileParameter.blocksWidth * i + j;
                                l = this.mTileSource.databaseIndexCache.getIndexEntry(subFileParameter, l3) & 0x7FFFFFFFFFL;
                                if (l < 1L || l > subFileParameter.subFileSize) break block9;
                                if (++l3 != subFileParameter.numberOfBlocks) break block10;
                                l3 = subFileParameter.subFileSize;
                                break block11;
                            }
                            l2 = this.mTileSource.databaseIndexCache.getIndexEntry(subFileParameter, l3) & 0x7FFFFFFFFFL;
                            if (l2 < 1L) break block12;
                            l3 = l2;
                            if (l2 > subFileParameter.subFileSize) break block12;
                        }
                        int n = (int)(l3 - l);
                        if (n < 0) {
                            object2 = log;
                            object = new StringBuilder();
                            ((StringBuilder)object).append("current block size must not be negative: ");
                            ((StringBuilder)object).append(n);
                            object2.warn(((StringBuilder)object).toString());
                            return;
                        }
                        if (n == 0) continue;
                        if (n > Parameters.MAXIMUM_BUFFER_SIZE) {
                            Logger logger = log;
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("current block size too large: ");
                            stringBuilder.append(n);
                            logger.warn(stringBuilder.toString());
                            continue;
                        }
                        if ((long)n + l > this.mFileSize) {
                            object2 = log;
                            object = new StringBuilder();
                            ((StringBuilder)object).append("current block larger than file size: ");
                            ((StringBuilder)object).append(n);
                            object2.warn(((StringBuilder)object).toString());
                            return;
                        }
                        this.mInputFile.seek(subFileParameter.startAddress + l);
                        if (!this.mReadBuffer.readFromFile(n)) {
                            object2 = log;
                            object = new StringBuilder();
                            ((StringBuilder)object).append("reading current block has failed: ");
                            ((StringBuilder)object).append(n);
                            object2.warn(((StringBuilder)object).toString());
                            return;
                        }
                        double d = Projection.tileYToLatitude(subFileParameter.boundaryTileTop + i, subFileParameter.baseZoomLevel);
                        double d2 = Projection.tileXToLongitude(subFileParameter.boundaryTileLeft + j, subFileParameter.baseZoomLevel);
                        this.mTileLatitude = (int)(d * 1000000.0);
                        this.mTileLongitude = (int)(d2 * 1000000.0);
                        this.processBlock((QueryParameters)object2, subFileParameter, (ITileDataSink)object, boundingBox, selector, mapReadResult);
                        continue;
                    }
                    object = log;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("invalid next block pointer: ");
                    ((StringBuilder)object2).append(l2);
                    object.warn(((StringBuilder)object2).toString());
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("sub-file size: ");
                    ((StringBuilder)object2).append(subFileParameter.subFileSize);
                    object.warn(((StringBuilder)object2).toString());
                    return;
                }
                object = log;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("invalid current block pointer: ");
                ((StringBuilder)object2).append(l);
                object.warn(((StringBuilder)object2).toString());
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("subFileSize: ");
                ((StringBuilder)object2).append(subFileParameter.subFileSize);
                object.warn(((StringBuilder)object2).toString());
                return;
            }
        }
    }

    private void processBlocks(QueryParameters queryParameters, SubFileParameter subFileParameter, BoundingBox boundingBox, Selector selector, MapReadResult mapReadResult) throws IOException {
        this.processBlocks(null, queryParameters, subFileParameter, boundingBox, selector, mapReadResult);
    }

    private boolean processPOIs(ITileDataSink object, int n, BoundingBox object2, boolean bl, List<PointOfInterest> list) {
        Tag[] tagArray = this.mTileSource.fileInfo.poiTags;
        MapElement mapElement = this.mElem;
        while (n != 0) {
            Object object3;
            mapElement.tags.clear();
            boolean bl2 = this.mDebugFile;
            int n2 = 0;
            if (bl2) {
                object3 = this.mReadBuffer.readUTF8EncodedString(32);
                this.mSignaturePoi = object3;
                if (!((String)object3).startsWith("***POIStart")) {
                    object = log;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("invalid POI signature: ");
                    ((StringBuilder)object2).append(this.mSignaturePoi);
                    object.warn(((StringBuilder)object2).toString());
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(DEBUG_SIGNATURE_BLOCK);
                    ((StringBuilder)object2).append(this.mSignatureBlock);
                    object.warn(((StringBuilder)object2).toString());
                    return false;
                }
            }
            int n3 = this.mTileLatitude + this.mReadBuffer.readSignedInt();
            int n4 = this.mTileLongitude + this.mReadBuffer.readSignedInt();
            byte by = this.mReadBuffer.readByte();
            byte by2 = (byte)((by & 0xF0) >>> 4);
            byte by3 = (byte)(by & 0xF);
            if (by3 != 0 && !this.mReadBuffer.readTags(mapElement.tags, tagArray, by3)) {
                return false;
            }
            by = this.mReadBuffer.readByte();
            if ((by & 0x80) != 0) {
                object3 = this.mTileSource.extractLocalized(this.mReadBuffer.readUTF8EncodedString());
                mapElement.tags.add(new Tag("name", (String)object3, false));
            }
            if ((by & 0x40) != 0) {
                object3 = this.mReadBuffer.readUTF8EncodedString();
                mapElement.tags.add(new Tag("addr:housenumber", (String)object3, false));
            }
            if ((by & 0x20) != 0) {
                object3 = Integer.toString(this.mReadBuffer.readSignedInt());
                mapElement.tags.add(new Tag("ele", (String)object3, false));
            }
            this.mTileProjection.projectPoint(n3, n4, mapElement);
            mapElement.setLayer(by2);
            if (list != null) {
                object3 = new ArrayList();
                while (n2 < mapElement.tags.size()) {
                    object3.add(mapElement.tags.get(n2));
                    ++n2;
                }
                GeoPoint geoPoint = new GeoPoint(n3, n4);
                if (!bl || ((BoundingBox)object2).contains(geoPoint)) {
                    list.add(new PointOfInterest(by2, (List<Tag>)object3, geoPoint));
                }
            }
            if (object != null) {
                object.process(mapElement);
            }
            --n;
        }
        return true;
    }

    private boolean processWayDataBlock(MapElement object, boolean bl, boolean bl2, List<GeoPoint[]> object2) {
        int n = this.mReadBuffer.readUnsignedInt();
        if (n >= 1 && n <= Short.MAX_VALUE) {
            int[] nArray = ((GeometryBuffer)object).ensureIndexSize(n, false);
            if (nArray.length > n) {
                nArray[n] = -1;
            }
            for (int i = 0; i < n; ++i) {
                int n2 = this.mReadBuffer.readUnsignedInt();
                if (n2 >= 2 && n2 <= Short.MAX_VALUE) {
                    nArray[i] = this.decodeWayNodes(bl, (MapElement)object, n2 * 2, bl2);
                    if (object2 == null) continue;
                    GeoPoint[] geoPointArray = new GeoPoint[((GeometryBuffer)object).getNumPoints()];
                    for (n2 = 0; n2 < ((GeometryBuffer)object).getNumPoints(); ++n2) {
                        geoPointArray[n2] = new GeoPoint((double)((GeometryBuffer)object).getPointY(n2) / 1000000.0, (double)((GeometryBuffer)object).getPointX(n2) / 1000000.0);
                    }
                    object2.add(geoPointArray);
                    continue;
                }
                object2 = log;
                object = new StringBuilder();
                ((StringBuilder)object).append("invalid number of way nodes: ");
                ((StringBuilder)object).append(n2);
                object2.warn(((StringBuilder)object).toString());
                this.logDebugSignatures();
                return false;
            }
            return true;
        }
        object2 = log;
        object = new StringBuilder();
        ((StringBuilder)object).append("invalid number of way coordinate blocks: ");
        ((StringBuilder)object).append(n);
        object2.warn(((StringBuilder)object).toString());
        return false;
    }

    private boolean processWays(QueryParameters object, ITileDataSink object2, int n, BoundingBox boundingBox, boolean bl, Selector selector, List<Way> list) {
        int n2;
        Tag[] tagArray = this;
        Object object3 = tagArray.mTileSource.fileInfo.wayTags;
        MapElement mapElement = tagArray.mElem;
        tagArray.stringOffset = 0;
        if (tagArray.mTileSource.experimental) {
            n2 = tagArray.mReadBuffer.readUnsignedInt();
            tagArray.stringOffset = tagArray.mReadBuffer.getBufferPosition();
            tagArray.mReadBuffer.skipBytes(n2);
        }
        tagArray = object3;
        while (true) {
            int n3;
            byte by;
            Tag[] tagArray2;
            object3 = object;
            Object object4 = this;
            if (n == 0) break;
            mapElement.tags.clear();
            if (((MapDatabase)object4).mDebugFile) {
                tagArray2 = ((MapDatabase)object4).mReadBuffer.readUTF8EncodedString(32);
                ((MapDatabase)object4).mSignatureWay = tagArray2;
                if (!tagArray2.startsWith("---WayStart")) {
                    object = log;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("invalid way signature: ");
                    ((StringBuilder)object2).append(((MapDatabase)object4).mSignatureWay);
                    object.warn(((StringBuilder)object2).toString());
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(DEBUG_SIGNATURE_BLOCK);
                    ((StringBuilder)object2).append(((MapDatabase)object4).mSignatureBlock);
                    object.warn(((StringBuilder)object2).toString());
                    return false;
                }
            }
            if (object3.useTileBitmask) {
                if ((n = ((MapDatabase)object4).mReadBuffer.skipWays(object3.queryTileBitmask, n)) == 0) {
                    return true;
                }
                if (n < 0) {
                    return false;
                }
                n2 = n;
                if (((MapDatabase)object4).mTileSource.experimental) {
                    n2 = n;
                    if (((MapDatabase)object4).mReadBuffer.lastTagPosition > 0) {
                        n2 = ((MapDatabase)object4).mReadBuffer.getBufferPosition();
                        object3 = ((MapDatabase)object4).mReadBuffer;
                        object3.setBufferPosition(object3.lastTagPosition);
                        by = (byte)(((MapDatabase)object4).mReadBuffer.readByte() & 0xF);
                        if (!((MapDatabase)object4).mReadBuffer.readTags(mapElement.tags, tagArray, by)) {
                            return false;
                        }
                        ((MapDatabase)object4).mReadBuffer.setBufferPosition(n2);
                        n2 = n;
                    }
                }
            } else {
                n2 = ((MapDatabase)object4).mReadBuffer.readUnsignedInt();
                if (n2 < 0) {
                    object = log;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("invalid way data size: ");
                    ((StringBuilder)object2).append(n2);
                    object.warn(((StringBuilder)object2).toString());
                    if (((MapDatabase)object4).mDebugFile) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append(DEBUG_SIGNATURE_BLOCK);
                        ((StringBuilder)object2).append(((MapDatabase)object4).mSignatureBlock);
                        object.warn(((StringBuilder)object2).toString());
                    }
                    object.error("BUG way 2");
                    return false;
                }
                ((MapDatabase)object4).mReadBuffer.skipBytes(2);
                n2 = n;
            }
            n = ((MapDatabase)object4).mReadBuffer.readByte();
            byte by2 = (byte)((n & 0xF0) >>> 4);
            by = (byte)(n & 0xF);
            if (by != 0 && !((MapDatabase)object4).mReadBuffer.readTags(mapElement.tags, tagArray, by)) {
                return false;
            }
            n = ((MapDatabase)object4).mReadBuffer.readByte();
            boolean bl2 = (n & 4) != 0;
            boolean bl3 = (n & 0x80) != 0;
            boolean bl4 = (n & 0x40) != 0;
            boolean bl5 = (n & 0x20) != 0;
            if (((MapDatabase)object4).mTileSource.experimental) {
                if (bl3) {
                    n3 = ((MapDatabase)object4).mReadBuffer.readUnsignedInt();
                    object3 = ((MapDatabase)object4).mTileSource.extractLocalized(((MapDatabase)object4).mReadBuffer.readUTF8EncodedStringAt(((MapDatabase)object4).stringOffset + n3));
                    mapElement.tags.add(new Tag("name", (String)object3, false));
                }
                if (bl4) {
                    n3 = ((MapDatabase)object4).mReadBuffer.readUnsignedInt();
                    object3 = ((MapDatabase)object4).mReadBuffer.readUTF8EncodedStringAt(((MapDatabase)object4).stringOffset + n3);
                    mapElement.tags.add(new Tag("addr:housenumber", (String)object3, false));
                }
                if (bl5) {
                    n3 = ((MapDatabase)object4).mReadBuffer.readUnsignedInt();
                    object3 = ((MapDatabase)object4).mReadBuffer.readUTF8EncodedStringAt(((MapDatabase)object4).stringOffset + n3);
                    mapElement.tags.add(new Tag("ref", (String)object3, false));
                }
            } else {
                if (bl3) {
                    object3 = ((MapDatabase)object4).mTileSource.extractLocalized(((MapDatabase)object4).mReadBuffer.readUTF8EncodedString());
                    mapElement.tags.add(new Tag("name", (String)object3, false));
                }
                if (bl4) {
                    object3 = ((MapDatabase)object4).mReadBuffer.readUTF8EncodedString();
                    mapElement.tags.add(new Tag("addr:housenumber", (String)object3, false));
                }
                if (bl5) {
                    object3 = ((MapDatabase)object4).mReadBuffer.readUTF8EncodedString();
                    mapElement.tags.add(new Tag("ref", (String)object3, false));
                }
            }
            object3 = (n & 0x10) != 0 ? (Object)super.readOptionalLabelPosition() : null;
            if ((n & 8) != 0) {
                n = n3 = ((MapDatabase)object4).mReadBuffer.readUnsignedInt();
                if (n3 < 1) {
                    object = log;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("invalid number of way data blocks: ");
                    ((StringBuilder)object2).append(n3);
                    object.warn(((StringBuilder)object2).toString());
                    super.logDebugSignatures();
                    return false;
                }
            } else {
                n = 1;
            }
            boolean bl6 = OSMUtils.isArea(mapElement) ^ true;
            n3 = 0;
            while (true) {
                tagArray2 = this;
                if (n3 >= n) break;
                mapElement.clear();
                object4 = list != null ? new ArrayList() : null;
                if (!super.processWayDataBlock(mapElement, bl2, bl6, (List<GeoPoint[]>)object4)) {
                    return false;
                }
                if (!mapElement.isPoly() || mapElement.index[0] >= 6) {
                    if (object3 != null && n3 == 0) {
                        mapElement.setLabelPosition(mapElement.points[0] + (float)object3[0], mapElement.points[1] + (float)object3[1]);
                    }
                    tagArray2.mTileProjection.project(mapElement);
                    if ((mapElement.tags.containsKey("building") || mapElement.tags.containsKey("building:part")) && ((QueryParameters)object).queryZoomLevel <= 17 || tagArray2.mTileClipper.clip(mapElement)) {
                        mapElement.simplify(1.0f, true);
                        mapElement.setLayer(by2);
                        if (list != null) {
                            Object object5 = boundingBox.extendMeters(wayFilterDistance);
                            GeoPoint[][] geoPointArray = (GeoPoint[][])object4.toArray((T[])new GeoPoint[object4.size()][]);
                            if (!bl || !wayFilterEnabled || ((BoundingBox)object5).intersectsArea(geoPointArray)) {
                                object5 = new ArrayList();
                                for (int i = 0; i < mapElement.tags.size(); ++i) {
                                    object5.add(mapElement.tags.get(i));
                                }
                                if (Selector.ALL == selector || bl3 || bl4 || bl5 || tagArray2.wayAsLabelTagFilter((List<Tag>)object5)) {
                                    object4 = mapElement.labelPosition != null ? new GeoPoint((double)mapElement.labelPosition.y / 1000000.0, (double)mapElement.labelPosition.x / 1000000.0) : null;
                                    list.add(new Way(by2, (List<Tag>)object5, geoPointArray, (GeoPoint)object4, mapElement.type));
                                }
                            }
                        }
                        if (object2 != null) {
                            object2.process(mapElement);
                        }
                    }
                }
                ++n3;
            }
            n = n2 - 1;
        }
        return true;
    }

    private MapReadResult readMapData(Tile object, Tile object2, Selector selector) {
        SubFileParameter subFileParameter;
        QueryParameters queryParameters;
        MapReadResult mapReadResult;
        block6: {
            if (this.mTileSource.fileHeader == null) {
                return null;
            }
            mapReadResult = new MapReadResult();
            if (this.mIntBuffer == null) {
                this.mIntBuffer = new int[65534];
            }
            try {
                this.mTileProjection.setTile((Tile)object);
                queryParameters = new QueryParameters();
                queryParameters.queryZoomLevel = this.mTileSource.fileHeader.getQueryZoomLevel(((Tile)object).zoomLevel);
                subFileParameter = this.mTileSource.fileHeader.getSubFileParameter(queryParameters.queryZoomLevel);
                if (subFileParameter != null) break block6;
            }
            catch (IOException iOException) {
                log.error(iOException.getMessage());
                return null;
            }
            object = log;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("no sub-file for zoom level: ");
            ((StringBuilder)object2).append(queryParameters.queryZoomLevel);
            object.warn(((StringBuilder)object2).toString());
            return null;
        }
        QueryCalculations.calculateBaseTiles(queryParameters, (Tile)object, (Tile)object2, subFileParameter);
        QueryCalculations.calculateBlocks(queryParameters, subFileParameter);
        this.processBlocks(queryParameters, subFileParameter, Tile.getBoundingBox((Tile)object, (Tile)object2), selector, mapReadResult);
        return mapReadResult;
    }

    private int[] readOptionalLabelPosition() {
        int n = this.mReadBuffer.readSignedInt();
        return new int[]{this.mReadBuffer.readSignedInt(), n};
    }

    private int[][] readZoomTable(SubFileParameter object) {
        int n = ((SubFileParameter)object).zoomLevelMax - ((SubFileParameter)object).zoomLevelMin + 1;
        object = new int[n][2];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            object[i][0] = n2 += this.mReadBuffer.readUnsignedInt();
            object[i][1] = n3 += this.mReadBuffer.readUnsignedInt();
        }
        return object;
    }

    private void setTileClipping(QueryParameters queryParameters, long l, long l2) {
        int n;
        long l3 = queryParameters.toBlockY - queryParameters.fromBlockY;
        long l4 = queryParameters.toBlockX - queryParameters.fromBlockX;
        int n2 = queryParameters.queryZoomLevel > 17 ? Tile.SIZE / 2 : (int)(CanvasAdapter.getScale() * 16.0f + 0.5f);
        this.xmin = n = -n2;
        this.ymin = n;
        this.xmax = Tile.SIZE + n2;
        this.ymax = Tile.SIZE + n2;
        if (l3 > 0L) {
            n = (int)((long)Tile.SIZE / (l4 + 1L));
            n2 = (int)((long)Tile.SIZE / (1L + l3));
            if (l2 > 0L) {
                this.xmin = (int)((long)n * l2);
            }
            if (l2 < l4) {
                l4 = n;
                this.xmax = (int)(l2 * l4 + l4);
            }
            if (l > 0L) {
                this.ymin = (int)((long)n2 * l);
            }
            if (l < l3) {
                l2 = n2;
                this.ymax = (int)(l * l2 + l2);
            }
        }
        this.mTileClipper.setRect(this.xmin, this.ymin, this.xmax, this.ymax);
    }

    @Override
    public void cancel() {
    }

    @Override
    public void dispose() {
        this.mReadBuffer = null;
        RandomAccessFile randomAccessFile = this.mInputFile;
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
                this.mInputFile = null;
            }
            catch (IOException iOException) {
                log.error(iOException.getMessage());
            }
        }
    }

    public MapFileTileSource getTileSource() {
        return this.mTileSource;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void query(MapTile object, ITileDataSink iTileDataSink) {
        int n;
        byte by;
        if (this.mTileSource.fileHeader == null) {
            iTileDataSink.completed(QueryResult.FAILED);
            return;
        }
        if (this.mIntBuffer == null) {
            this.mIntBuffer = new int[65534];
        }
        try {
            this.mTileProjection.setTile((Tile)object);
            by = ((MapTile)object).zoomLevel;
            n = 1;
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage());
            iTileDataSink.completed(QueryResult.FAILED);
            return;
        }
        double d = 1.0 / (double)(1 << by);
        {
            if (((MapTile)object).zoomLevel <= 11) {
                n = 2;
            }
            n = Tile.SIZE / n;
            this.minDeltaLat = (int)(Math.abs(MercatorProjection.toLatitude(((MapTile)object).y + d) - MercatorProjection.toLatitude(((MapTile)object).y)) * 1000000.0) / n;
            this.minDeltaLon = (int)(Math.abs(MercatorProjection.toLongitude(((MapTile)object).x + d) - MercatorProjection.toLongitude(((MapTile)object).x)) * 1000000.0) / n;
            QueryParameters queryParameters = new QueryParameters();
            queryParameters.queryZoomLevel = this.mTileSource.fileHeader.getQueryZoomLevel(((MapTile)object).zoomLevel);
            Object object2 = this.mTileSource.fileHeader.getSubFileParameter(queryParameters.queryZoomLevel);
            if (object2 == null) {
                object = log;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("no sub-file for zoom level: ");
                ((StringBuilder)object2).append(queryParameters.queryZoomLevel);
                object.warn(((StringBuilder)object2).toString());
                iTileDataSink.completed(QueryResult.FAILED);
                return;
            }
            QueryCalculations.calculateBaseTiles(queryParameters, (Tile)object, (SubFileParameter)object2);
            QueryCalculations.calculateBlocks(queryParameters, (SubFileParameter)object2);
            this.processBlocks(iTileDataSink, queryParameters, (SubFileParameter)object2);
            iTileDataSink.completed(QueryResult.SUCCESS);
            return;
        }
    }

    public MapReadResult readLabels(Tile tile) {
        return this.readMapData(tile, tile, Selector.LABELS);
    }

    public MapReadResult readLabels(Tile tile, Tile tile2) {
        return this.readMapData(tile, tile2, Selector.LABELS);
    }

    public MapReadResult readMapData(Tile tile) {
        return this.readMapData(tile, tile, Selector.ALL);
    }

    public MapReadResult readMapData(Tile tile, Tile tile2) {
        return this.readMapData(tile, tile2, Selector.ALL);
    }

    public MapReadResult readPoiData(Tile tile) {
        return this.readMapData(tile, tile, Selector.POIS);
    }

    public MapReadResult readPoiData(Tile tile, Tile tile2) {
        return this.readMapData(tile, tile2, Selector.POIS);
    }

    public void restrictToZoomRange(int n, int n2) {
        this.zoomLevelMax = n2;
        this.zoomLevelMin = n;
    }

    public boolean supportsTile(Tile tile) {
        boolean bl = tile.getBoundingBox().intersects(this.mTileSource.getMapInfo().boundingBox) && tile.zoomLevel >= this.zoomLevelMin && tile.zoomLevel <= this.zoomLevelMax;
        return bl;
    }

    public boolean wayAsLabelTagFilter(List<Tag> list) {
        return false;
    }

    private static final class Selector
    extends Enum<Selector> {
        private static final /* synthetic */ Selector[] $VALUES;
        public static final /* enum */ Selector ALL;
        public static final /* enum */ Selector LABELS;
        public static final /* enum */ Selector POIS;

        static {
            Selector selector;
            Selector selector2;
            Selector selector3;
            ALL = selector3 = new Selector();
            POIS = selector2 = new Selector();
            LABELS = selector = new Selector();
            $VALUES = new Selector[]{selector3, selector2, selector};
        }

        public static Selector valueOf(String string2) {
            return Enum.valueOf(Selector.class, string2);
        }

        public static Selector[] values() {
            return (Selector[])$VALUES.clone();
        }
    }

    static class TileProjection {
        private static final double COORD_SCALE = 1000000.0;
        double divx;
        double divy;
        long dx;
        long dy;

        TileProjection() {
        }

        void project(MapElement mapElement) {
            float[] fArray = mapElement.points;
            int[] nArray = mapElement.index;
            boolean bl = mapElement.isPoly();
            int n = nArray.length;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                int n4;
                int n5 = nArray[i];
                if (n5 == 0) continue;
                if (n5 < 0) break;
                float f = 0.0f;
                int n6 = n2;
                float f2 = 0.0f;
                int n7 = 0;
                for (n4 = n3; n4 < n5 + n3; n4 += 2) {
                    float f3 = this.projectLon(fArray[n4]);
                    float f4 = this.projectLat(fArray[n4 + 1]);
                    if (n7 != 0 && f4 == f2 && f3 == f) {
                        f4 = f2;
                    } else {
                        int n8 = n6 + 1;
                        fArray[n6] = f3;
                        n6 = n8 + 1;
                        fArray[n8] = f4;
                        n7 += 2;
                        f = f2 = f3;
                    }
                    f2 = f4;
                }
                if (bl && fArray[n2] == f && fArray[n2 + 1] == f2) {
                    nArray[i] = (short)(n7 - 2);
                    n2 = n6 - 2;
                    n3 = n4;
                    continue;
                }
                nArray[i] = (short)n7;
                n2 = n6;
                n3 = n4;
            }
            if (mapElement.labelPosition != null) {
                mapElement.labelPosition.x = this.projectLon(mapElement.labelPosition.x);
                mapElement.labelPosition.y = this.projectLat(mapElement.labelPosition.y);
            }
        }

        public float projectLat(double d) {
            d = Math.sin(d * 1.7453292519943295E-8);
            d = Math.log((d + 1.0) / (1.0 - d));
            return (float)Tile.SIZE - (float)(d / this.divy + (double)this.dy);
        }

        public float projectLon(double d) {
            return (float)(d / this.divx - (double)this.dx);
        }

        public void projectPoint(int n, int n2, MapElement mapElement) {
            mapElement.clear();
            mapElement.startPoints();
            mapElement.addPoint(this.projectLon(n2), this.projectLat(n));
        }

        void setTile(Tile tile) {
            long l = tile.tileX * Tile.SIZE;
            long l2 = tile.tileY * Tile.SIZE + Tile.SIZE;
            long l3 = (long)(Tile.SIZE << tile.zoomLevel) >> 1;
            this.dx = l - l3;
            this.dy = l2 - l3;
            double d = l3;
            this.divx = 1.8E8 / d;
            this.divy = Math.PI * 2 / d;
        }
    }
}

