/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.IMapFileTileSource;
import org.oscim.tiling.source.mapfile.IndexCache;
import org.oscim.tiling.source.mapfile.MapDatabase;
import org.oscim.tiling.source.mapfile.MapFileUtils;
import org.oscim.tiling.source.mapfile.MapInfo;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.header.MapFileHeader;
import org.oscim.tiling.source.mapfile.header.MapFileInfo;
import org.oscim.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapFileTileSource
extends TileSource
implements IMapFileTileSource {
    private static final int INDEX_CACHE_SIZE = 64;
    static final int MAX_ZOOM_LEVEL = 17;
    private static final String READ_ONLY_MODE = "r";
    private static final Logger log = LoggerFactory.getLogger(MapFileTileSource.class);
    private Callback callback;
    IndexCache databaseIndexCache;
    boolean experimental;
    MapFileHeader fileHeader;
    MapFileInfo fileInfo;
    private RandomAccessFile mInputFile;
    File mapFile;
    private String preferredLanguage;

    public MapFileTileSource() {
        this(0, 17);
    }

    public MapFileTileSource(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.mInputFile);
        this.mInputFile = null;
        this.fileHeader = null;
        this.fileInfo = null;
        this.mapFile = null;
        IndexCache indexCache = this.databaseIndexCache;
        if (indexCache != null) {
            indexCache.destroy();
            this.databaseIndexCache = null;
        }
    }

    String extractLocalized(String string2) {
        Callback callback = this.callback;
        if (callback != null) {
            return callback.extractLocalized(string2);
        }
        return MapFileUtils.extract(string2, this.preferredLanguage);
    }

    @Override
    public ITileDataSource getDataSource() {
        try {
            MapDatabase mapDatabase = new MapDatabase(this);
            return mapDatabase;
        }
        catch (IOException iOException) {
            log.debug(iOException.getMessage());
            return null;
        }
    }

    public MapInfo getMapInfo() {
        return this.fileInfo;
    }

    @Override
    public TileSource.OpenResult open() {
        Object object;
        Object object2;
        block7: {
            if (!this.options.containsKey("file")) {
                return new TileSource.OpenResult("no map file set");
            }
            try {
                MapFileHeader mapFileHeader;
                object2 = new File((String)this.options.get("file"));
                if (!((File)object2).exists()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("file does not exist: ");
                    stringBuilder.append(object2);
                    return new TileSource.OpenResult(stringBuilder.toString());
                }
                if (!((File)object2).isFile()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("not a file: ");
                    stringBuilder.append(object2);
                    return new TileSource.OpenResult(stringBuilder.toString());
                }
                if (!((File)object2).canRead()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("cannot read file: ");
                    stringBuilder.append(object2);
                    return new TileSource.OpenResult(stringBuilder.toString());
                }
                object = new RandomAccessFile((File)object2, READ_ONLY_MODE);
                this.mInputFile = object;
                long l = ((RandomAccessFile)object).length();
                object = new ReadBuffer(this.mInputFile);
                this.fileHeader = mapFileHeader = new MapFileHeader();
                if (((TileSource.OpenResult)(object = mapFileHeader.readHeader((ReadBuffer)object, l))).isSuccess()) break block7;
                this.close();
                return object;
            }
            catch (IOException iOException) {
                log.error(iOException.getMessage());
                this.close();
                return new TileSource.OpenResult(iOException.getMessage());
            }
        }
        this.fileInfo = this.fileHeader.getMapFileInfo();
        this.mapFile = object2;
        this.databaseIndexCache = object2 = new IndexCache(this.mInputFile, 64);
        object = log;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("File version: ");
        ((StringBuilder)object2).append(this.fileInfo.fileVersion);
        object.debug(((StringBuilder)object2).toString());
        object2 = TileSource.OpenResult.SUCCESS;
        return object2;
    }

    @Override
    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public boolean setMapFile(String object) {
        this.setOption("file", (String)object);
        object = new File((String)object);
        if (!((File)object).exists()) {
            return false;
        }
        if (!((File)object).isFile()) {
            return false;
        }
        return ((File)object).canRead();
    }

    @Override
    public void setPreferredLanguage(String string2) {
        this.preferredLanguage = string2;
    }

    public static interface Callback {
        public String extractLocalized(String var1);
    }
}

