/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.source.mapfile.MapDatabase;
import org.oscim.tiling.source.mapfile.MapReadResult;
import org.oscim.tiling.source.mapfile.MultiMapDataSink;
import org.oscim.tiling.source.mapfile.MultiMapFileTileSource;

public class MultiMapDatabase
implements ITileDataSource {
    private final List<MapDatabase> mapDatabases = new ArrayList<MapDatabase>();
    private final MultiMapFileTileSource tileSource;

    public MultiMapDatabase(MultiMapFileTileSource multiMapFileTileSource) {
        this.tileSource = multiMapFileTileSource;
    }

    public boolean add(MapDatabase mapDatabase) {
        if (!this.mapDatabases.contains(mapDatabase)) {
            return this.mapDatabases.add(mapDatabase);
        }
        throw new IllegalArgumentException("Duplicate map database");
    }

    @Override
    public void cancel() {
        Iterator<MapDatabase> iterator2 = this.mapDatabases.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().cancel();
        }
    }

    @Override
    public void dispose() {
        Iterator<MapDatabase> iterator2 = this.mapDatabases.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().dispose();
        }
    }

    @Override
    public void query(MapTile mapTile, ITileDataSink iTileDataSink) {
        MultiMapDataSink multiMapDataSink = new MultiMapDataSink(iTileDataSink);
        for (MapDatabase mapDatabase : this.mapDatabases) {
            if (!mapDatabase.supportsTile(mapTile)) continue;
            mapDatabase.query(mapTile, multiMapDataSink);
        }
        iTileDataSink.completed(multiMapDataSink.getResult());
    }

    public MapReadResult readLabels(Tile tile) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mapDatabase : this.mapDatabases) {
            MapReadResult mapReadResult2;
            if (!mapDatabase.supportsTile(tile) || (mapReadResult2 = mapDatabase.readLabels(tile)) == null) continue;
            mapReadResult.isWater &= mapReadResult2.isWater;
            mapReadResult.add(mapReadResult2, false);
        }
        return mapReadResult;
    }

    public MapReadResult readLabels(Tile tile, Tile tile2) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mapDatabase : this.mapDatabases) {
            MapReadResult mapReadResult2;
            if (!mapDatabase.supportsTile(tile) || (mapReadResult2 = mapDatabase.readLabels(tile, tile2)) == null) continue;
            mapReadResult.isWater &= mapReadResult2.isWater;
            mapReadResult.add(mapReadResult2, false);
        }
        return mapReadResult;
    }

    public MapReadResult readMapData(Tile tile) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mapDatabase : this.mapDatabases) {
            MapReadResult mapReadResult2;
            if (!mapDatabase.supportsTile(tile) || (mapReadResult2 = mapDatabase.readMapData(tile)) == null) continue;
            mapReadResult.isWater &= mapReadResult2.isWater;
            mapReadResult.add(mapReadResult2, false);
        }
        return mapReadResult;
    }

    public MapReadResult readMapData(Tile tile, Tile tile2) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mapDatabase : this.mapDatabases) {
            MapReadResult mapReadResult2;
            if (!mapDatabase.supportsTile(tile) || (mapReadResult2 = mapDatabase.readMapData(tile, tile2)) == null) continue;
            mapReadResult.isWater &= mapReadResult2.isWater;
            mapReadResult.add(mapReadResult2, false);
        }
        return mapReadResult;
    }

    public MapReadResult readPoiData(Tile tile) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mapDatabase : this.mapDatabases) {
            MapReadResult mapReadResult2;
            if (!mapDatabase.supportsTile(tile) || (mapReadResult2 = mapDatabase.readPoiData(tile)) == null) continue;
            mapReadResult.isWater &= mapReadResult2.isWater;
            mapReadResult.add(mapReadResult2, false);
        }
        return mapReadResult;
    }

    public MapReadResult readPoiData(Tile tile, Tile tile2) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDatabase mapDatabase : this.mapDatabases) {
            MapReadResult mapReadResult2;
            if (!mapDatabase.supportsTile(tile) || (mapReadResult2 = mapDatabase.readPoiData(tile, tile2)) == null) continue;
            mapReadResult.isWater &= mapReadResult2.isWater;
            mapReadResult.add(mapReadResult2, false);
        }
        return mapReadResult;
    }

    public boolean supportsTile(Tile tile) {
        Iterator<MapDatabase> iterator2 = this.mapDatabases.iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().supportsTile(tile)) continue;
            return true;
        }
        return false;
    }
}

