/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.oscim.core.BoundingBox;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.IMapFileTileSource;
import org.oscim.tiling.source.mapfile.MapDatabase;
import org.oscim.tiling.source.mapfile.MapFileTileSource;
import org.oscim.tiling.source.mapfile.MultiMapDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiMapFileTileSource
extends TileSource
implements IMapFileTileSource {
    private static final Logger log = LoggerFactory.getLogger(MultiMapFileTileSource.class);
    private final List<MapFileTileSource> mapFileTileSources = new ArrayList<MapFileTileSource>();
    private final Map<MapFileTileSource, int[]> zoomsByTileSource = new HashMap<MapFileTileSource, int[]>();

    public MultiMapFileTileSource() {
        this(0, 17);
    }

    public MultiMapFileTileSource(int n, int n2) {
        super(n, n2);
    }

    public boolean add(MapFileTileSource mapFileTileSource) {
        if (!this.mapFileTileSources.contains(mapFileTileSource)) {
            return this.mapFileTileSources.add(mapFileTileSource);
        }
        throw new IllegalArgumentException("Duplicate map file tile source");
    }

    public boolean add(MapFileTileSource mapFileTileSource, int n, int n2) {
        boolean bl = this.add(mapFileTileSource);
        if (bl) {
            this.zoomsByTileSource.put(mapFileTileSource, new int[]{n, n2});
        }
        return bl;
    }

    @Override
    public void close() {
        Iterator<MapFileTileSource> iterator2 = this.mapFileTileSources.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().close();
        }
    }

    public BoundingBox getBoundingBox() {
        Iterator<MapFileTileSource> iterator2 = this.mapFileTileSources.iterator();
        BoundingBox boundingBox = null;
        while (iterator2.hasNext()) {
            MapFileTileSource mapFileTileSource = iterator2.next();
            if (boundingBox == null) {
                boundingBox = mapFileTileSource.getMapInfo().boundingBox;
                continue;
            }
            boundingBox = boundingBox.extendBoundingBox(mapFileTileSource.getMapInfo().boundingBox);
        }
        return boundingBox;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ITileDataSource getDataSource() {
        MultiMapDatabase multiMapDatabase = new MultiMapDatabase(this);
        Iterator<MapFileTileSource> iterator2 = this.mapFileTileSources.iterator();
        while (iterator2.hasNext()) {
            MapFileTileSource mapFileTileSource = iterator2.next();
            try {
                MapDatabase mapDatabase = new MapDatabase(mapFileTileSource);
                int[] nArray = this.zoomsByTileSource.get(mapFileTileSource);
                if (nArray != null) {
                    mapDatabase.restrictToZoomRange(nArray[0], nArray[1]);
                }
                multiMapDatabase.add(mapDatabase);
            }
            catch (IOException iOException) {
                log.debug(iOException.getMessage());
                continue;
            }
            break;
        }
        return multiMapDatabase;
    }

    @Override
    public TileSource.OpenResult open() {
        TileSource.OpenResult openResult = TileSource.OpenResult.SUCCESS;
        Iterator<MapFileTileSource> iterator2 = this.mapFileTileSources.iterator();
        while (iterator2.hasNext()) {
            TileSource.OpenResult openResult2 = iterator2.next().open();
            if (openResult2 == TileSource.OpenResult.SUCCESS) continue;
            openResult = openResult2;
        }
        return openResult;
    }

    @Override
    public void setCallback(MapFileTileSource.Callback callback) {
        Iterator<MapFileTileSource> iterator2 = this.mapFileTileSources.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().setCallback(callback);
        }
    }

    @Override
    public void setPreferredLanguage(String string2) {
        Iterator<MapFileTileSource> iterator2 = this.mapFileTileSources.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().setPreferredLanguage(string2);
        }
    }
}

