/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import org.oscim.core.Tile;

public class Projection {
    private Projection() {
    }

    public static double latitudeToPixelY(double d, int n) {
        d = Math.sin(d * (Math.PI / 180));
        return (0.5 - Math.log((d + 1.0) / (1.0 - d)) / (Math.PI * 4)) * (double)((long)Tile.SIZE << n);
    }

    public static long latitudeToTileY(double d, int n) {
        return Projection.pixelYToTileY(Projection.latitudeToPixelY(d, n), n);
    }

    public static double longitudeToPixelX(double d, int n) {
        return (d + 180.0) / 360.0 * (double)((long)Tile.SIZE << n);
    }

    public static long longitudeToTileX(double d, int n) {
        return Projection.pixelXToTileX(Projection.longitudeToPixelX(d, n), n);
    }

    public static double pixelXToLongitude(double d, int n) {
        return (d / (double)((long)Tile.SIZE << n) - 0.5) * 360.0;
    }

    public static int pixelXToTileX(double d, int n) {
        return (int)Math.min(Math.max(d / (double)Tile.SIZE, 0.0), Math.pow(2.0, n) - 1.0);
    }

    public static double pixelYToLatitude(double d, int n) {
        return 90.0 - Math.atan(Math.exp(-(0.5 - d / (double)((long)Tile.SIZE << n)) * (Math.PI * 2))) * 360.0 / Math.PI;
    }

    public static int pixelYToTileY(double d, int n) {
        return (int)Math.min(Math.max(d / (double)Tile.SIZE, 0.0), Math.pow(2.0, n) - 1.0);
    }

    public static double tileXToLongitude(long l, int n) {
        return Projection.pixelXToLongitude(l * (long)Tile.SIZE, n);
    }

    public static double tileYToLatitude(long l, int n) {
        return Projection.pixelYToLatitude(l * (long)Tile.SIZE, n);
    }
}

