/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import org.oscim.core.Tile;
import org.oscim.tiling.source.mapfile.QueryParameters;
import org.oscim.tiling.source.mapfile.header.SubFileParameter;

final class QueryCalculations {
    private QueryCalculations() {
        throw new IllegalStateException();
    }

    static void calculateBaseTiles(QueryParameters queryParameters, Tile tile, Tile tile2, SubFileParameter subFileParameter) {
        if (tile.zoomLevel < subFileParameter.baseZoomLevel) {
            int n = subFileParameter.baseZoomLevel - tile.zoomLevel;
            queryParameters.fromBaseTileX = tile.tileX << n;
            queryParameters.fromBaseTileY = tile.tileY << n;
            int n2 = tile2.tileX;
            int n3 = 1 << n;
            queryParameters.toBaseTileX = (n2 << n) + n3 - 1;
            queryParameters.toBaseTileY = (tile2.tileY << n) + n3 - 1;
            queryParameters.useTileBitmask = false;
        } else if (tile.zoomLevel > subFileParameter.baseZoomLevel) {
            int n = tile.zoomLevel - subFileParameter.baseZoomLevel;
            queryParameters.fromBaseTileX = tile.tileX >>> n;
            queryParameters.fromBaseTileY = tile.tileY >>> n;
            queryParameters.toBaseTileX = tile2.tileX >>> n;
            queryParameters.toBaseTileY = tile2.tileY >>> n;
            queryParameters.useTileBitmask = true;
            queryParameters.queryTileBitmask = QueryCalculations.calculateTileBitmask(tile, tile2, n);
        } else {
            queryParameters.fromBaseTileX = tile.tileX;
            queryParameters.fromBaseTileY = tile.tileY;
            queryParameters.toBaseTileX = tile2.tileX;
            queryParameters.toBaseTileY = tile2.tileY;
            queryParameters.useTileBitmask = false;
        }
    }

    static void calculateBaseTiles(QueryParameters queryParameters, Tile tile, SubFileParameter subFileParameter) {
        if (tile.zoomLevel < subFileParameter.baseZoomLevel) {
            int n = subFileParameter.baseZoomLevel - tile.zoomLevel;
            queryParameters.fromBaseTileX = tile.tileX << n;
            queryParameters.fromBaseTileY = tile.tileY << n;
            long l = queryParameters.fromBaseTileX;
            long l2 = 1 << n;
            queryParameters.toBaseTileX = l + l2 - 1L;
            queryParameters.toBaseTileY = queryParameters.fromBaseTileY + l2 - 1L;
            queryParameters.useTileBitmask = false;
        } else if (tile.zoomLevel > subFileParameter.baseZoomLevel) {
            int n = tile.zoomLevel - subFileParameter.baseZoomLevel;
            queryParameters.fromBaseTileX = tile.tileX >>> n;
            queryParameters.fromBaseTileY = tile.tileY >>> n;
            queryParameters.toBaseTileX = queryParameters.fromBaseTileX;
            queryParameters.toBaseTileY = queryParameters.fromBaseTileY;
            queryParameters.useTileBitmask = true;
            queryParameters.queryTileBitmask = QueryCalculations.calculateTileBitmask(tile, n);
        } else {
            queryParameters.fromBaseTileX = tile.tileX;
            queryParameters.fromBaseTileY = tile.tileY;
            queryParameters.toBaseTileX = queryParameters.fromBaseTileX;
            queryParameters.toBaseTileY = queryParameters.fromBaseTileY;
            queryParameters.useTileBitmask = false;
        }
    }

    static void calculateBlocks(QueryParameters queryParameters, SubFileParameter subFileParameter) {
        queryParameters.fromBlockX = Math.max(queryParameters.fromBaseTileX - subFileParameter.boundaryTileLeft, 0L);
        queryParameters.fromBlockY = Math.max(queryParameters.fromBaseTileY - subFileParameter.boundaryTileTop, 0L);
        queryParameters.toBlockX = Math.min(queryParameters.toBaseTileX - subFileParameter.boundaryTileLeft, subFileParameter.blocksWidth - 1L);
        queryParameters.toBlockY = Math.min(queryParameters.toBaseTileY - subFileParameter.boundaryTileTop, subFileParameter.blocksHeight - 1L);
    }

    static int calculateTileBitmask(Tile tile, int n) {
        if (n == 1) {
            return QueryCalculations.getFirstLevelTileBitmask(tile);
        }
        int n2 = tile.tileX;
        long l = n2 >>> (n -= 2);
        long l2 = tile.tileY >>> n;
        long l3 = l2 >>> 1;
        long l4 = (l >>> 1) % 2L;
        long l5 = l4 - 0L;
        n = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
        if (n == 0 && l3 % 2L == 0L) {
            return QueryCalculations.getSecondLevelTileBitmaskUpperLeft(l, l2);
        }
        if (l4 == 1L && l3 % 2L == 0L) {
            return QueryCalculations.getSecondLevelTileBitmaskUpperRight(l, l2);
        }
        if (n == 0 && l3 % 2L == 1L) {
            return QueryCalculations.getSecondLevelTileBitmaskLowerLeft(l, l2);
        }
        return QueryCalculations.getSecondLevelTileBitmaskLowerRight(l, l2);
    }

    static int calculateTileBitmask(Tile tile, Tile tile2, int n) {
        int n2 = 0;
        for (int i = tile.tileX; i <= tile2.tileX; ++i) {
            for (int j = tile.tileY; j <= tile2.tileY; ++j) {
                n2 |= QueryCalculations.calculateTileBitmask(new Tile(i, j, tile.zoomLevel), n);
            }
        }
        return n2;
    }

    private static int getFirstLevelTileBitmask(Tile tile) {
        if (tile.tileX % 2 == 0 && tile.tileY % 2 == 0) {
            return 52224;
        }
        if ((tile.tileX & 1) == 1 && tile.tileY % 2 == 0) {
            return 13056;
        }
        if (tile.tileX % 2 == 0 && (tile.tileY & 1) == 1) {
            return 204;
        }
        return 51;
    }

    private static int getSecondLevelTileBitmaskLowerLeft(long l, long l2) {
        long l3 = (l %= 2L) - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        if (l4 == false && l2 % 2L == 0L) {
            return 128;
        }
        if (l == 1L && l2 % 2L == 0L) {
            return 64;
        }
        if (l4 == false && l2 % 2L == 1L) {
            return 8;
        }
        return 4;
    }

    private static int getSecondLevelTileBitmaskLowerRight(long l, long l2) {
        long l3 = (l %= 2L) - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        if (l4 == false && l2 % 2L == 0L) {
            return 32;
        }
        if (l == 1L && l2 % 2L == 0L) {
            return 16;
        }
        if (l4 == false && l2 % 2L == 1L) {
            return 2;
        }
        return 1;
    }

    private static int getSecondLevelTileBitmaskUpperLeft(long l, long l2) {
        long l3 = (l %= 2L) - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        if (l4 == false && l2 % 2L == 0L) {
            return 32768;
        }
        if (l == 1L && l2 % 2L == 0L) {
            return 16384;
        }
        if (l4 == false && l2 % 2L == 1L) {
            return 2048;
        }
        return 1024;
    }

    private static int getSecondLevelTileBitmaskUpperRight(long l, long l2) {
        long l3 = (l %= 2L) - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        if (l4 == false && l2 % 2L == 0L) {
            return 8192;
        }
        if (l == 1L && l2 % 2L == 0L) {
            return 4096;
        }
        if (l4 == false && l2 % 2L == 1L) {
            return 512;
        }
        return 256;
    }
}

